<?php
class DetailV3Action extends wtActions
{
    public function execute()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        
        $this->block      = $this->getRequestParameter( 'block' );
        $this->i_Id       = $this->getRequestParameter( 'i_Id' );
        $this->s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        $this->s_IdRango  = $this->getRequestParameter( 'IdRango' );
        if( !$this->getRequestParameter( 'IdRango' ) )
        {
            $this->s_IdRango = "1";
        }
        
        $this->s_Titulo = "Editar Lista de Precios";

        $this->IdItem       = $this->getRequestParameter( 'IdItem' );
        $this->IdLinea      = $this->getRequestParameter( 'IdLinea' );
        $this->IdFamilia    = $this->getRequestParameter( 'IdFamilia' );
        
        $o_DefaultFN = new MST_ListaPrecioCabeceraFN();
        $o_DefaultFN->setIdListaPreciCab( $this->i_Id );
        $this->o_DefaultBN = $o_DefaultFN->selectByPK();

        $this->IdCompania = $this->o_DefaultBN->getIdCompania();
        $this->IdSucursal = $this->o_DefaultBN->getIdSucursal();
        
        $this->a_ALM_ItemMast = array();
        
        $o_ALM_ItemMastFN = new ALM_ItemMastFN();
        //$o_ALM_ItemMastFN->setDebug( 1 );
        $o_ALM_ItemMastFN->setEstado( "A" );
        $o_ALM_ItemMastFN->addCondition( ALM_ItemMastFN::IdItemTipo, "NOT IN", "('02')", false );
        $o_ALM_ItemMastFN->addCondition( ALM_ItemMastFN::IdItem, "NOT IN", "('ZZDSCTO')", false );
        $o_ALM_ItemMastFN->addOrderBy( ALM_ItemMastFN::DescripcionCompleta );

        //se agrega mas filtron
        $o_MST_PersonaMastFN = new MST_PersonaMastFN();
        $o_MST_PersonaMastFN->setEsProveedor( "SI" );
        $o_MST_PersonaMastFN->setEstado( "A" );
        $o_MST_PersonaMastFN->addOrderBy( MST_PersonaMastFN::NombreCompleto );
        $o_MST_PersonaMastFN->addOrderBy( MST_PersonaMastFN::Nombres );
        $this->a_MST_PersonaMast = $o_MST_PersonaMastFN->select();

        $o_MST_ReferenciaProductoFN = new MST_ReferenciaProductoFN();
        $o_MST_ReferenciaProductoFN->setEstado( MST_ReferenciaProductoFN::ESTADO_COMPLETO );
        //$o_MST_ReferenciaProductoFN->setIdProveedor( $this->IdProveedor );
        $this->a_MST_ReferenciaProducto = $o_MST_ReferenciaProductoFN->select();

        $o_MST_ColorFN = new MST_ColorFN();
        $o_MST_ColorFN->setEstado( MST_ColorBN::ESTADO_ACTIVO );
        $o_MST_ColorFN->addOrderBy( "substr(Codigo,1,1)" );
        $o_MST_ColorFN->addOrderBy( "cast(substr(Codigo,2,10) as UNSIGNED)" );
        $this->a_MST_Color = $o_MST_ColorFN->select();

        $o_MST_CategoriaTallaFN = new MST_CategoriaTallaFN();
        //$o_MST_CategoriaTallaFN->setIdProveedor( $this->IdProveedor );
        $o_MST_CategoriaTallaFN->setEstado( MST_CategoriaTallaBN::ESTADO_ACTIVO );
        $this->a_MST_CategoriaTalla = $o_MST_CategoriaTallaFN->select();

        if( $this->IdItem )
        {
            $o_ALM_ItemMastFN->setIdItem( $this->IdItem );
            
            $o_TMP_ALM_ItemMastFN = new ALM_ItemMastFN();
            $o_TMP_ALM_ItemMastBN = $o_TMP_ALM_ItemMastFN->selectByPK( $this->IdItem );
            if( $o_TMP_ALM_ItemMastBN )
            {
                if( $this->o_DefaultBN->getIdTipoLista() == 1 )
                {
                    if( $o_TMP_ALM_ItemMastBN->getEsParaVenta() == "SI" )
                    {
                        $this->s_IdRango = $o_TMP_ALM_ItemMastBN->getIdRangoVenta();
                    }
                }
                if( $this->o_DefaultBN->getIdTipoLista() == 2 )
                {
                    if( $o_TMP_ALM_ItemMastBN->getEsParaAlquiler() == "SI" )
                    {
                        $this->s_IdRango = $o_TMP_ALM_ItemMastBN->getIdRangoAlquiler();
                    }
                }
            }
        }

        $this->ParametrosLista = "";
        if( $this->getRequestParameter( "ParametrosLista" ) )
        {
            $this->ParametrosLista = $this->getRequestParameter( "ParametrosLista" );
            switch( $this->getRequestParameter( "ParametrosLista" ) )
            {
                case "SIN-PRECIO":

                    if( !$this->getRequestParameter( 'IdRango' ) )
                    {
                        pr( "Para buscar productos sin precio, es necesario que seleccione el Rango." );
                    }
                    $o_ALM_ItemMastFN->addCondition( "coalesce(( SELECT PrecioVentaIGV FROM MST_ListaPrecioDetalle WHERE IdItem=ALM_ItemMast.IdItem AND IdRango='".$this->s_IdRango."' and IdSucursal=".$this->IdSucursal." ),0)", "<=", "0" );

                break;

                case "CON-STOCK":

                    $o_ALM_ItemMastFN->addCondition( "( select StockDisponible from ALM_ItemAlmacenStock where ALM_ItemAlmacenStock.IdItem=ALM_ItemMast.IdItem and IdSucursal=".$this->IdSucursal.")", ">", "0" );

                break;
            }
        }
        
        $o_MST_ClaseLineaFN = new MST_ClaseLineaFN();
        $o_MST_ClaseLineaFN->setEstado( "A" );
        $o_MST_ClaseLineaFN->addOrderBy( MST_ClaseLineaFN::Descripcion );
        $this->a_MST_ClaseLinea = $o_MST_ClaseLineaFN->select();
        
        $this->a_MST_ClaseFamilia = array();
        if( $this->IdLinea )
        {
            $o_MST_ClaseFamiliaFN = new MST_ClaseFamiliaFN();
            $o_MST_ClaseFamiliaFN->setIdLinea( $this->IdLinea );
            $o_MST_ClaseFamiliaFN->setEstado( "A" );
            $this->a_MST_ClaseFamilia = $o_MST_ClaseFamiliaFN->select();
            
            $o_ALM_ItemMastFN->setIdLinea( $this->IdLinea );
        }
        
        if( $this->IdFamilia )
        {
            $o_ALM_ItemMastFN->setIdFamilia( $this->IdFamilia );
        }
        
        $this->a_MST_Rango = array();
        $o_MST_RangoFN = new MST_RangoFN();
        $o_MST_RangoFN->setFlagEncofrado( "0" );
        if( $this->o_DefaultBN->getIdTipoLista() == 1 )
        {
            $o_MST_RangoFN->setFlagVenta( 1 );
            $o_ALM_ItemMastFN->setEsParaVenta( "SI" );
            if( $this->s_IdRango )
            {
                $o_ALM_ItemMastFN->setIdRangoVenta( $this->s_IdRango );
            }
        }
        if( $this->o_DefaultBN->getIdTipoLista() == 2 )
        {
            $o_MST_RangoFN->setFlagAlquiler( 1 );
            $o_ALM_ItemMastFN->setEsParaAlquiler( 'SI' );
            if( $this->s_IdRango )
            {
                $o_ALM_ItemMastFN->setIdRangoAlquiler( $this->s_IdRango );
            }
        }
        if( $this->o_DefaultBN->getIdTipoLista() == 1 || $this->o_DefaultBN->getIdTipoLista() == 2 )
        {
            $this->a_MST_Rango = $o_MST_RangoFN->select();
        }
        else
        {
            $o_ALM_ItemMastFN->setEsParaAlquiler( "NO" );
            $o_ALM_ItemMastFN->setEsParaVenta( "NO" );
        }
        
        $this->a_MST_RangoDetalle = array();
        if( $this->s_IdRango )
        {
            $o_MST_RangoDetalleFN = new MST_RangoDetalleFN();
            $o_MST_RangoDetalleFN->setIdRango( $this->s_IdRango );
            $o_MST_RangoDetalleFN->addOrderBy( MST_RangoDetalleFN::Minimo );
            $this->a_MST_RangoDetalle = $o_MST_RangoDetalleFN->select();
        }

        $this->IdProveedor  = "";
        $this->DescripcionReferencia = "";
        $this->IdColor      = "";
        $this->IdCatTalla   = "";
        $this->IdTalla      = "";

        if( $this->getRequestParameter( 'Control' ) )
        {
            $this->IdProveedor  = $this->getRequestParameter( "IdProveedor" );
            $this->DescripcionReferencia = $this->getRequestParameter( "DescripcionReferencia" );
            $this->IdColor      = $this->getRequestParameter( "IdColor" );
            $this->IdCatTalla   = $this->getRequestParameter( "IdCatTalla" );
            $this->IdTalla      = $this->getRequestParameter( "IdTalla" );

            if( $this->getRequestParameter( "IdProveedor" ) )
            {
                $o_ALM_ItemMastFN->addCondition( "IdItem", "IN", "( SELECT IdItem FROM MST_RelacionReferenciaProducto where IdProveedor=".$this->getRequestParameter( "IdProveedor" )." )", false );
            }
            if( $this->getRequestParameter( "DescripcionReferencia" ) )
            {
                $o_ALM_ItemMastFN->addCondition( "IdItem", "IN", "( SELECT IdItem FROM MST_RelacionReferenciaProducto where IdReferencia in ( SELECT IdReferencia FROM MST_ReferenciaProducto WHERE Descripcion LIKE '%".$this->getRequestParameter( "DescripcionReferencia" )."%' ) )", false );
            }
            if( $this->getRequestParameter( "IdColor" ) )
            {
                $o_ALM_ItemMastFN->addCondition( "IdItem", "IN", "( SELECT IdItem FROM MST_RelacionReferenciaProducto where IdColor=".$this->getRequestParameter( "IdColor" )." )", false );
            }
            if( $this->getRequestParameter( "IdCatTalla" ) )
            {
                $o_ALM_ItemMastFN->addCondition( "IdItem", "IN", "( SELECT IdItem FROM MST_RelacionReferenciaProducto where IdCatTalla=".$this->getRequestParameter( "IdCatTalla" )." )", false );
            }
            if( $this->getRequestParameter( "IdTalla" ) )
            {
                $o_ALM_ItemMastFN->addCondition( "IdItem", "IN", "( SELECT IdItem FROM MST_RelacionReferenciaProducto where IdTalla IN ( SELECT IdTalla FROM MST_Talla where Descripcion like '%".$this->getRequestParameter( "IdTalla" )."%' ) )", false );
            }

            $this->a_ALM_ItemMast = $o_ALM_ItemMastFN->select();
        }
        else
        {
            $this->ParametrosLista = "CON-STOCK";
            $this->a_ALM_ItemMast = array();
        }
    }
}