<?php
class listofertasActions extends wtActions
{
    public function executeRequest()
    {
        try 
        {
            $s_IdPrGrupo = $this->getRequestParameter( 'IdPrGrupo' );
            $TipoProc    = $this->getRequestParameter( 'TipoProc' );
            
            $a_Result = array( "error" => false );
            
            switch ( $TipoProc )
            {
                case "AgregarPromoDet":
                    $s_IdItem    = $this->getRequestParameter( 'IdItem' );
                    
                    $o_ALM_ItemMastFN = new ALM_ItemMastFN();
                    $o_ALM_ItemMastBN = $o_ALM_ItemMastFN->selectByPK( $s_IdItem );
                    
                    $o_PR_GrupoFN = new PR_GrupoFN();
                    $o_PR_GrupoBN = $o_PR_GrupoFN->selectByPK( $s_IdPrGrupo );
                    $o_PR_GrupoBN->setObjectItemMastBN( $o_ALM_ItemMastBN );
                    
                    $o_GrupoPromocionBL = new GrupoPromocionBL();
                    $b_Result = $o_GrupoPromocionBL->agregarItemConPromocion( $o_PR_GrupoBN );
                    $a_Result["result"] = $b_Result;
                break;
                case "EliminarPromoDet":
                    $i_IdPrListaItem = ( int ) $this->getRequestParameter( 'IdPrListaItem' );
                    
                    $o_PR_ListaItemDP = new PR_ListaItemDP();
                    $o_PR_ListaItemDP->setIdPrGrupo( $s_IdPrGrupo );
                    $o_PR_ListaItemDP->setIdPrListaItem( $i_IdPrListaItem );
                    $b_Result = $o_PR_ListaItemDP->delete();
                    $a_Result["result"] = $b_Result;
                break;
                case "PublicarPromocion":
                    $o_PR_GrupoBN = new PR_GrupoBN();
                    $o_PR_GrupoBN->setIdPrGrupo( $s_IdPrGrupo );
                    
                    $o_GrupoPromocionBL = new GrupoPromocionBL();
                    $b_Result = $o_GrupoPromocionBL->publicarPromocion( $o_PR_GrupoBN );
                    $a_Result["result"] = $b_Result;
                break;
                case "AnularPromocion":
                    $o_PR_GrupoBN = new PR_GrupoBN();
                    $o_PR_GrupoBN->setIdPrGrupo( $s_IdPrGrupo );
                
                    $o_GrupoPromocionBL = new GrupoPromocionBL();
                    $b_Result = $o_GrupoPromocionBL->anularPromocion( $o_PR_GrupoBN );
                    $a_Result["result"] = $b_Result;
                break;
                case "ReAbrirPromocion":
                    $o_PR_GrupoBN = new PR_GrupoBN();
                    $o_PR_GrupoBN->setIdPrGrupo( $s_IdPrGrupo );
                    
                    $o_GrupoPromocionBL = new GrupoPromocionBL();
                    $b_Result = $o_GrupoPromocionBL->reAbrirPromocion( $o_PR_GrupoBN );
                    $a_Result["result"] = $b_Result;
                break;
            }
        }
        catch ( Exception $o_Exception )
        {
            $a_Result["error"] = true;
            $a_Result["mensaje_error"] = $o_Exception->getMessage();
        }
        echo json_encode( $a_Result );
        return ViewResponse::NONE;
    }
    
    public function executeList()
    {
        $o_GSS_SucursalFN = new GSS_SucursalFN();
        $o_GSS_SucursalFN->setIdCompania( myUser::getUser()->getIdBusiness() );
        $this->a_GSS_Sucursal = $o_GSS_SucursalFN->select();
        
        $this->a_Estados = PR_GrupoBN::getArrayEstados();
    }
    
    public function executeGrid()
    {
        $block = $this->getRequestParameter( 'block' );
        $page  = $this->getRequestParameter( 'page' );
        
        //*set_header_utf8();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $o_GridAction = new GridAction();
        $o_GridAction->setClassFind( new PR_GrupoFN() );
        
        $o_GridAction->addMethodDefault( "IdCompania", myUser::getUser()->getIdBusiness() );
        
        //$o_GridAction->addAssignFilter( "IdPersona" );
        $o_GridAction->addAssignFilter( "IdSucursal" );
        $o_GridAction->addAssignFilter( "Estado" );
        //$o_GridAction->addConditionFilter( "Descripcion", GSS_ImpuestoFN::Descripcion, "LIKE", "%%s%" );
        
        //$o_GridAction->addOrder( "Descripcion", GSS_ImpuestoFN::Descripcion );
        //$o_GridAction->addOrder( "Codigo",      GSS_ImpuestoFN::Codigo );
        
        $o_GridAction->addOrderDefault( PR_GrupoFN::FechaCreacion , false );
        
        $o_GridAction->addRowsToShow( "IdPrGrupo", "SucursalDesc", "Estado", "DescripcionPromo", "FechaCreacion", 'EstadoDesc', "FechaInicio", "FechaExpiracion" );
        
        $o_GridAction->setNumberRecordsShow( 15 );
        
        $o_GridAction->initialize();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $a_ResultJson['page']    = $o_GridAction->getPage();
        $a_ResultJson['total']   = $o_GridAction->getTotalPage();
        $a_ResultJson['records'] = $o_GridAction->getTotalRecords();
        $a_ResultJson['rows']    = $o_GridAction->getResultArray();
        //pr( $a_ResultJson );
        echo json_encode( $a_ResultJson );
        
        return ViewResponse::NONE;
    }
    
    public function executeAddedit()
    {
        $this->block      = $this->getRequestParameter( 'block' );
        $this->i_Id       = $this->getRequestParameter( 'i_Id' );
        $this->s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        
        $this->s_Titulo = "Nuevo Promoción";
        
        /************/
        
        $o_DefaultBN = new PR_GrupoBN();
        $o_DefaultBN->setEstado( PR_GrupoBN::ESTADO_PENDIENTE );
        $o_DefaultBN->setIdPrTipoId( "PR" );
        $this->o_DefaultBN = $o_DefaultBN;
        
        /*************/
        if( $this->s_TipoProc == "upd" )
        {
            $this->s_Titulo = "Editar Promoción";
            $o_DefaultFN = new PR_GrupoFN();
            $this->o_DefaultBN = $o_DefaultFN->selectByPK( $this->i_Id );
        }
    }
    
    public function executeSaveAddEdit()
    {
        $i_Id       = $this->getRequestParameter( 'i_Id' );
        $s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        
        $s_IdPrTipoId       = $this->getRequestParameter( 'IdPrTipoId' );
        $s_DescripcionPromo = $this->getRequestParameter( 'DescripcionPromo' );
        $i_IdSucursal       = ( int ) $this->getRequestParameter( 'IdSucursal' );
        $s_FechaInicio      = $this->getRequestParameter( 'FechaInicio' );
        $s_FechaExpiracion  = $this->getRequestParameter( 'FechaExpiracion' );
        $i_IdLinea          = $this->getRequestParameter( 'IdLinea' );
        $i_IdFamilia        = $this->getRequestParameter( 'IdFamilia' );
        $s_Valor            = $this->getRequestParameter( 'Valor' );
        $Estado             = $this->getRequestParameter( 'Estado' );
        try
        {
            $o_DefaultBN = new PR_GrupoBN();
            $o_DefaultBN->setIdCompania( myUser::getUser()->getIdBusiness() );
            $o_DefaultBN->setIdSucursal( $i_IdSucursal );
            $o_DefaultBN->setIdPrTipoId( $s_IdPrTipoId );
            $o_DefaultBN->setFechaInicio( $s_FechaInicio );
            $o_DefaultBN->setFechaExpiracion( $s_FechaExpiracion );
            $o_DefaultBN->setDescripcionPromo( $s_DescripcionPromo );
            $o_DefaultBN->setIdLinea( $i_IdLinea );
            $o_DefaultBN->setIdFamilia( $i_IdFamilia );
            $o_DefaultBN->setValor( $s_Valor );
            $o_DefaultBN->setEstado( $Estado );
            if( $s_TipoProc != "nvo" )
            {
                $o_DefaultBN->setIdPrGrupo( $i_Id );
            }
            
            $o_GrupoPromocionBL = new GrupoPromocionBL();
            $b_Result = $o_GrupoPromocionBL->guardarPromocion( $o_DefaultBN );
            
            $a_Rs['id']     = $o_DefaultBN->getIdPrGrupo();
            $a_Rs['result'] = $b_Result;
            $a_Rs['error']  = false;
        }
        catch ( Exception $o_Exception )
        {
            $a_Rs['error']         = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }
        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }
    
    public function executeDetail()
    {
        $this->block      = $this->getRequestParameter( 'block' );
        $this->i_Id       = $this->getRequestParameter( 'i_Id' );
        $this->s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        
        $this->IdLinea      = $this->getRequestParameter( 'IdLinea' );
        $this->IdFamilia    = $this->getRequestParameter( 'IdFamilia' );
        $this->CodigoBarras = $this->getRequestParameter( 'CodigoBarras' );
        $this->DescripcionCompleta = $this->getRequestParameter( 'DescripcionCompleta' );
        
        $this->s_Titulo = "Editar Promoción";
        $o_DefaultFN = new PR_GrupoFN();
        $this->o_DefaultBN = $o_DefaultFN->selectByPK( $this->i_Id );
        
        $o_PR_ListaItemFN = new PR_ListaItemFN();
        $o_PR_ListaItemFN->setIdPrGrupo( $this->i_Id );
        $o_PR_ListaItemFN->addOrderBy( "( SELECT DescripcionCompleta FROM ALM_ItemMast WHERE IdItem=PR_ListaItem.IdItem )" );
        $this->a_PR_ListaItem = $o_PR_ListaItemFN->select();
    }

    public function executeViewdel()
    {
        $this->block      = $this->getRequestParameter( 'block' );
        $this->i_Id       = $this->getRequestParameter( 'i_Id' );
        $this->s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        
        $o_DefaultFN = new PR_GrupoFN();
        $this->o_DefaultBN = $o_DefaultFN->selectByPK( $this->i_Id );
    }
}