<?php
class itemActions extends wtActions
{
    public function executeIndex()
    {
        
    }

    public function executeMostrarImagen()
    {
        $s_UrlImagen = Constantes::ROOT_DIR_IMG;
        $s_IdItem   = $this->getRequestParameter( 'id_item' );
        $o_ALM_ItemMastFN = new ALM_ItemMastFN();
        $o_ALM_ItemMastBN = $o_ALM_ItemMastFN->selectByPK( $s_IdItem );
        $this->s_ItemImagenUrl = $s_UrlImagen."img_no_disponible.jpg";
        if ( file_exists( $o_ALM_ItemMastBN->getUbicacionFisica() ) )
        {
            if( $o_ALM_ItemMastBN->getUbicacionURL() )
            {
                $this->s_ItemImagenUrl = $o_ALM_ItemMastBN->getUbicacionURL();
            }
        }
    }

    public function executeAddStockMin()
    {
        $s_IdItem   = $this->getRequestParameter( 'id_item' );
        $f_StockMin = floatval( $this->getRequestParameter( 'stock' ) );
        $s_Value = $this->getRequestParameter( 'value' );

        $a_Rs = array( "error" => false );

        $con = Conexion::getConexion();
        $con->begin();
        try 
        {
            $o_ALM_ItemMastFN = new ALM_ItemMastFN();
            $o_ALM_ItemMastBN = $o_ALM_ItemMastFN->selectByPK( $s_IdItem );
            if( $this->getRequestParameter( 'convert' ) ) //se valida para identificar de que se trata de una update
            {
                if( $o_ALM_ItemMastBN->getCantidadUnidad() > 1 )
                {
                    $f_StockMin = $f_StockMin * $o_ALM_ItemMastBN->getCantidadUnidad();
                }
            }

            $o_ALM_ItemMastDP = new ALM_ItemMastDP();
            $o_ALM_ItemMastDP->setIdItem( $s_IdItem );
            $o_ALM_ItemMastDP->setStockMinFlag( $s_Value );
            $o_ALM_ItemMastDP->setStockMinimo( $f_StockMin );
            $o_ALM_ItemMastDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
            $o_ALM_ItemMastDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
            $o_ALM_ItemMastDP->update();

            $con->commit();
        }
        catch ( Exception $o_Exception )
        {
            $con->rollback();
            $a_Rs['error']        = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }

        echo json_encode( $a_Rs );

        return ViewResponse::NONE;
    }

    public function executeListStkMin()
    {
        //SE RECUPERA LOS PROVEEDORES
        $o_MST_PersonaMastFN = new MST_PersonaMastFN();
        $o_MST_PersonaMastFN->setEsProveedor( 'SI' );
        $o_MST_PersonaMastFN->setIdCompania( myUser::getUser()->getIdBusiness() );
        $o_MST_PersonaMastFN->setEstado( 'A' );
        $o_MST_PersonaMastFN->addOrderBy( MST_PersonaMastFN::NombreCompleto );
        $this->a_MST_PersonaMast = $o_MST_PersonaMastFN->select();

        $o_ALM_MarcaFN = new ALM_MarcaFN();
        $o_ALM_MarcaFN->setEstado( "A" );
        $o_ALM_MarcaFN->addOrderBy( ALM_MarcaFN::DescripcionLocal );
        $this->a_ALM_Marca = $o_ALM_MarcaFN->select();
    }

    public function executeGridStkMin()
    {
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $o_GridAction = new GridAction();
        $o_GridAction->setClassFind( new ALM_ItemMastFN() );
        
        //$o_GridAction->addMethodDefault( "Eliminado", -1 );
        $o_GridAction->addAssignFilter( "IdItemTipo" );
        $o_GridAction->addAssignFilter( "IdLinea" );
        $o_GridAction->addAssignFilter( "IdFamilia" );
        $o_GridAction->addAssignFilter( "IdMarca" );
        $o_GridAction->addAssignFilter( "IdPersona" );
        $o_GridAction->addAssignFilter( "Estado" );
        
        $IdAlmacen = GSS_SucursalFN::recuperarIdAlmacen( myUser::getUser()->getIdSucursal() );
        $o_GridAction->addMethodDefault( ALM_ItemAlmacenStockFN::IdAlmacen, $IdAlmacen );
        $o_GridAction->addMethodDefault( ALM_ItemMastFN::StockMinFlag, "Y" );

        $o_GridAction->addConditionFilter( "Codigo", ALM_ItemMastFN::IdItem, "LIKE", "%%s%" );
        $o_GridAction->addConditionFilter( "DescripcionCompleta", ALM_ItemMastFN::DescripcionCompleta, "LIKE", "%%s%" );

        if( !$this->getRequestParameter( 'mostrar_todos' ) )
        {
            $o_GridAction->addMethodDefault( ALM_ItemMastFN::StockMinimo, array( 'Condition'=>'>=', 'Value'=>"( SELECT COALESCE( SUM(StockFisico), 0 ) FROM ALM_ItemAlmacenStock WHERE IdItem=ALM_ItemMast.IdItem and StockFisico>0  AND ALM_ItemAlmacenStock.IdAlmacen = '$IdAlmacen' )" ) );
        }
        
        $o_GridAction->addOrder( "DescripcionCompleta", ALM_ItemMastFN::DescripcionCompleta );
        $o_GridAction->addOrder( "IdItem",              ALM_ItemMastFN::IdItem );
        
        
        $o_GridAction->addOrderDefault( ALM_ItemMastFN::DescripcionCompleta, true );

        
        $o_GridAction->addRowsToShow
        ( 
            "IdItem", "CodigoInterno", "IdItemTipo", "DescripcionCompleta", "Estado", "IdLinea", "IdMarca", "DescripcionMarca", "DescripcionFamilia", "CodigoBarras",
            "CantidadUnidad", "CantidadxCaja", "CantidadxUnidad", "DescripcionLinea", "IdPersona", "ProveedorDesc", "UniMedVentaDesc",
            "StockDisponible", "StockReservado", "StockFisico", "StockMinimo"
        );
        
        $o_GridAction->setNumberRecordsShow( 50 );
        
        //$o_GridAction->setControlArray( false );
        
        $o_GridAction->setMethodSelectCustomRs( "selectdos" ); //FUNCION PERSONALIZADO PARA BUSQUEDA
        
        $o_GridAction->initialize();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        
        $a_ResultJson['page']    = $o_GridAction->getPage();
        $a_ResultJson['total']   = $o_GridAction->getTotalPage();
        $a_ResultJson['records'] = $o_GridAction->getTotalRecords();
        $a_ResultJson['rows']    = $o_GridAction->getResultArray();
        //pr( $a_ResultJson );
        echo json_encode( $a_ResultJson );

        return ViewResponse::NONE;
    }
    
    public function executeList()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        
        $this->b_Externo = $this->getRequestParameter( 'externo' ) ? true : false;
        
        //$o_ALM_ItemTipoFN = new ALM_ItemTipoFN();
        //$o_ALM_ItemTipoFN->addCondition(ALM_ItemTipoFN::Estado ,"<>","I");
        //$this->a_ALM_ItemTipo = $o_ALM_ItemTipoFN->select();
        
        //SE RECUPERA LOS PROVEEDORES
        $o_MST_PersonaMastFN = new MST_PersonaMastFN();
        $o_MST_PersonaMastFN->setEsProveedor( 'SI' );
        $o_MST_PersonaMastFN->setIdCompania( myUser::getUser()->getIdBusiness() );
        $o_MST_PersonaMastFN->setEstado( 'A' );
        $o_MST_PersonaMastFN->addOrderBy( MST_PersonaMastFN::NombreCompleto );
        $this->a_MST_PersonaMast = $o_MST_PersonaMastFN->select();
        
        $o_MST_ClaseLineaFN = new MST_ClaseLineaFN();
        $o_MST_ClaseLineaFN->addOrderBy( MST_ClaseLineaFN::Descripcion );
        $o_MST_ClaseLineaFN->setEstado( "A" );
        $this->a_MST_ClaseLinea = $o_MST_ClaseLineaFN->select();

        $o_MST_ClaseFamiliaFN = new MST_ClaseFamiliaFN();
        $o_MST_ClaseFamiliaFN->addOrderBy( MST_ClaseFamiliaFN::Descripcion );
        $o_MST_ClaseFamiliaFN->setEstado( "A" );
        $this->a_MST_ClaseFamilia = $o_MST_ClaseFamiliaFN->select();
        
        $o_ALM_MarcaFN = new ALM_MarcaFN();
        $o_ALM_MarcaFN->setEstado( "A" );
        $o_ALM_MarcaFN->addOrderBy( ALM_MarcaFN::DescripcionLocal );
        $this->a_ALM_Marca = $o_ALM_MarcaFN->select();
        
        $this->hola = "hola";
        
        //$this->redirect( 'addemp/grid', 'block='.$this->block );
    }
    
    public function executeGrid()
    {
        set_header_utf8();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $o_GridAction = new GridAction();
        $o_GridAction->setClassFind( new ALM_ItemMastFN() );

        $IdAlmacen    = GSS_SucursalFN::recuperarIdAlmacen( myUser::getUser()->getIdSucursal() );
        $s_IdSucursal = myUser::getUser()->getIdSucursal();
        
        //$o_GridAction->addMethodDefault( "Eliminado", -1 );
        $o_GridAction->addAssignFilter( "IdItemTipo" );
        $o_GridAction->addAssignFilter( "IdLinea" );
        $o_GridAction->addAssignFilter( "IdFamilia" );
        $o_GridAction->addAssignFilter( "IdSubFamilia" );
        $o_GridAction->addAssignFilter( "IdMarca" );
        $o_GridAction->addAssignFilter( "IdPersona" );
        $o_GridAction->addAssignFilter( "Estado" );
        //$o_GridAction->addAssignFilter( "IdAlmacen" );
        //$o_GridAction->addMethodDefault( "IdAlmacen", $IdAlmacen );
        
        //$o_GridAction->addConditionFilter( "CodigoInterno", ALM_ItemMastFN::CodigoInterno, "LIKE", "%%s%" );
        //$o_GridAction->addMethodDefault( ALM_ItemMastFN::Estado, array( 'Condition'=>'IN', 'Value'=>"('CE')" ) );


        ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        //cambios por los hoteles 2019-12-04
        //condicion especial para no mostrar los hoteles
        //solo se muestran todos los registros que se pueden registrar en transacciones
        //$o_GridAction->addMethodDefault( "ALM_ItemTipo.TransacciondelSistemaFlag", array( 'Condition'=>'=', 'Value'=>"1" ) ); 
        ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        
        $o_GridAction->addConditionFilter( "Codigo", ALM_ItemMastFN::IdItem, "LIKE", "%%s%" );
        $o_GridAction->addConditionFilter( "DescripcionCompleta", ALM_ItemMastFN::DescripcionCompleta, "LIKE", "%%s%" );
        
        $o_GridAction->addOrder( "DescripcionCompleta", ALM_ItemMastFN::DescripcionCompleta );
        $o_GridAction->addOrder( "IdItem",              ALM_ItemMastFN::IdItem );
        //$o_GridAction->addOrder( "IdItemTipo",          ALM_ItemMastFN::IdItemTipo );
        //$o_GridAction->addOrder( "CodigoInterno",       ALM_ItemMastFN::CodigoInterno  );

        if( $this->getRequestParameter( 'TieneCodBarra' ) == "SI" )
        {
            $o_GridAction->addMethodDefault( ALM_ItemMastFN::CodigoBarrasFabricante, array( 'Condition'=>'<>', 'Value'=>"''" ) );
        }
        if( $this->getRequestParameter( 'TieneCodBarra' ) == "NO" )
        {
            $o_GridAction->addMethodDefault( ALM_ItemMastFN::CodigoBarrasFabricante, array( 'Condition'=>'=', 'Value'=>"TRIM('')" ) );
        }
        
        
        $o_GridAction->addOrderDefault( ALM_ItemMastFN::DescripcionCompleta, true );
        //$o_GridAction->addOrder( ALM_ItemMastFN::IdItem );
        
        /*$o_GridAction->addRowsToShow
        ( 
            "IdItem", "CodigoInterno", "IdItemTipo", "DescripcionCompleta", "Estado", "IdLinea", "IdFamilia", "DescripcionMarca", "DescripcionFamilia", "CodigoBarras", "UnidadVentaDesc",
            "PrecioConIGV", "CantidadUnidad", "StockAlmacenActual", "DescripcionLinea", "IdPersona", "ProveedorDesc", "StockFisicoTotal", "StockDisponibleTotal", "NumeroDeParte",
            "UnidadVenta"
        );*/
        
        $o_GridAction->setNumberRecordsShow( 100 );

        $o_GridAction->setControlArray( false );

        $o_GridAction->setMethodSelectCustomRs( "selectdos" ); //FUNCION PERSONALIZADO PARA BUSQUEDA

        $o_GridAction->initialize();
        //pr( $o_GridAction ); exit;
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

        $a_ResultJson['page']    = $o_GridAction->getPage();
        $a_ResultJson['total']   = $o_GridAction->getTotalPage();
        $a_ResultJson['records'] = $o_GridAction->getTotalRecords();
        //$a_ResultJson['rows']    = $o_GridAction->getResultArray();
        $a_ResultSelect    = $o_GridAction->getResultSelect();

        $a_Rs = array();
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $o_MST_ListaPrecioCabeceraFN = new MST_ListaPrecioCabeceraFN();
        $o_MST_ListaPrecioCabeceraBN = $o_MST_ListaPrecioCabeceraFN->selectByPK( myUser::getUser()->getIdBusiness(), myUser::getUser()->getIdSucursal() );
        if( !$o_MST_ListaPrecioCabeceraBN )
        {
            $o_MST_ListaPrecioCabeceraBN = $o_MST_ListaPrecioCabeceraFN->buscaListaPrecioAlternativo();
        }
        $o_MST_ListaPrecioDetalleBN = null;
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        ///

        foreach ( $a_ResultSelect as $iKey => $o_ObjClassBN )
        {
            $o_ObjClassBN->setIdCompania( myUser::getUser()->getIdBusiness() );
            //$o_ObjClassBN->setIdAlmacen( $IdAlmacen );
            $o_ObjClassBN->setIdSucursal( $s_IdSucursal );

            $a_Rs[] = array
            (
                "IdItem"               => ( $o_ObjClassBN->getIdItem() ),
                "IdLote"               => $o_ObjClassBN->getIdLote(),
                //"ConcatLoteFecV"      => $o_ObjClassBN->getConcatLoteFecV(),
                "DescripcionCompleta"  => ( $o_ObjClassBN->getDescripcionCompleta() ),

                "DescripcionLinea"     => $o_ObjClassBN->getDescripcionLinea(),
                "DescripcionFamilia"   => $o_ObjClassBN->getDescripcionFamilia(),
                "DescripcionSubFamilia"   => $o_ObjClassBN->getDescripcionSubFamilia(),
                "DescripcionMarca"     => $o_ObjClassBN->getIdMarca(),
                "UnidadVentaDesc"      => $o_ObjClassBN->getUniMedVentaDesc(),

                "StockDisponibleTotal" => number_format( $o_ObjClassBN->getStockDisponible(), 2 ),
                "StockFisicoTotal"     => number_format( $o_ObjClassBN->getStockFisico(), 2 ),
                //"StockFisicoActual"     => number_format( $o_ObjClassBN->getStockFisicoActual(), 2 ),

                //"PrecioConIGV"         => $o_ObjClassBN->getPrecioConIGV(),
                //"PrecioConIGVFra"      => $o_ObjClassBN->getPrecioConIGVFra(),
                "Estado"               => $o_ObjClassBN->getEstadoDesc(),
                    
                "CodigoSunat"          => $o_ObjClassBN->getCodigoSunat(),
                "PesoGramos"          => $o_ObjClassBN->getPesoGramos(),

                //////////////////////////////////////////////////////////////////////////////////////////
                //se agrega por el tipo de item - 2019-10-16
                "DescripcionTipoItem"  => $o_ObjClassBN->getDescripcionTipoItem(),
                //////////////////////////////////////////////////////////////////////////////////////////

                "CodigoBarrasFabricante"  => $o_ObjClassBN->getCodigoBarrasFabricante(),

                //"PrecioxCaja"         => $PrecioFinal,
                //"PrecioxUni"          => "",
                
                //"IdUniMedVenta"       => $o_ObjClassBN->getIdUniMedVenta(),
                //"CantUniMedVenta"     => round( $o_ObjClassBN->getCantUniMedVenta(), 2 ),

                //"CantidadxCaja"       => $o_ObjClassBN->getCantidadxCaja(),
                //"CantidadxUnidad"     => $o_ObjClassBN->getUniMedVentaDesc(),
                //"CantUniMedVentaTexto" => !$o_ObjClassBN->getCantUniMedVentaTexto()?'0':$o_ObjClassBN->getCantUniMedVentaTexto(),

                //"Marca"               => $o_ObjClassBN->getIdMarca(),
            );
        }

        $a_ResultJson['rows'] = $a_Rs;

        echo json_encode( $a_ResultJson );

        return ViewResponse::NONE;
    }
    
    public function executeAddedit()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        
        $this->block      = $this->getRequestParameter( 'block' );
        $this->i_Id       = $this->getRequestParameter( 'i_Id' );
        $this->s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        
        $o_MST_ClaseLineaFN = new MST_ClaseLineaFN();
        $o_MST_ClaseLineaFN->addOrderBy( MST_ClaseLineaFN::Descripcion, true );
        $this->a_MST_ClaseLinea = $o_MST_ClaseLineaFN->select();
        
        $this->a_MST_ClaseFamilia  = array();
        $this->a_MST_ClaseSubFamilia     = array();
        
        $o_ALM_ItemTipoFN = new ALM_ItemTipoFN();
        $o_ALM_ItemTipoFN->setEstado( "A" );
        $o_ALM_ItemTipoFN->addOrderBy( ALM_ItemTipoFN::DescripcionLocal, true );
        $this->a_ALM_ItemTipo = $o_ALM_ItemTipoFN->select();
        
        $o_MST_UnidadMastFN = new MST_UnidadMastFN();
        $o_MST_UnidadMastFN->setEstado( "A" );
        $this->a_UnidadCompra = $o_MST_UnidadMastFN->select();
        $this->a_UnidadVenta = $this->a_UnidadCompra;
        $this->a_UnidadAlmacenaje = $this->a_UnidadCompra;
        
        $o_ALM_MarcaFN = new ALM_MarcaFN();
        $o_ALM_MarcaFN->addOrderBy( ALM_MarcaFN::DescripcionLocal, true );
        $o_ALM_MarcaFN->setEstado( "A" );
        $this->a_ALM_Marca = $o_ALM_MarcaFN->select();
        
        $o_MST_ItemProcedenciaFN = new MST_ItemProcedenciaFN();
        $o_MST_ItemProcedenciaFN->setEstado( "A" );
        $o_MST_ItemProcedenciaFN->addOrderBy( MST_ItemProcedenciaFN::Descripcion, true );
        $this->a_MST_ItemProcedencia = $o_MST_ItemProcedenciaFN->select();
        
        //SE RECUPERA LOS PROVEEDORES
        $o_MST_PersonaMastFN = new MST_PersonaMastFN();
        $o_MST_PersonaMastFN->setEsProveedor( 'SI' );
        $o_MST_PersonaMastFN->setIdCompania( myUser::getUser()->getIdBusiness() );
        $o_MST_PersonaMastFN->setEstado( 'A' );
        $o_MST_PersonaMastFN->addOrderBy( MST_PersonaMastFN::NombreCompleto );
        $this->a_MST_PersonaMast = $o_MST_PersonaMastFN->select();
        
        $this->s_Titulo = "Nuevo Producto";
        $o_ALM_ItemMastBN = new ALM_ItemMastBN();
        $o_ALM_ItemMastBN->setEstado('A');
        $o_ALM_ItemMastBN->setIdProcedencia( "LOC" );
        $o_ALM_ItemMastBN->setTipoGarantiaId( 18 );
        
        $o_MST_DiaSemanaFN = new MST_DiaSemanaFN();
        $this->a_MST_DiaSemana = $o_MST_DiaSemanaFN->select();

        $this->o_MST_ItemUbicacionBN = new MST_ItemUbicacionBN();
        $this->s_IdCategoria     = "";
        $this->s_HoraHabitacion  = "";
        $this->s_IdTipoUbicacion = "";
                
        $this->o_ALM_ItemMastBN = $o_ALM_ItemMastBN;
        
        //se agrega el rango para venta
        $o_MST_RangoFN = new MST_RangoFN();
        $o_MST_RangoFN->setEstado( "A" );
        $o_MST_RangoFN->setFlagVenta( 1 );
        $o_MST_RangoFN->setFlagEncofrado( 0 );
        $this->a_MST_RangoVta = $o_MST_RangoFN->select();
        
        //se agrega el rango para alquiler
        $o_MST_RangoFN = new MST_RangoFN();
        $o_MST_RangoFN->setEstado( "A" );
        $o_MST_RangoFN->setFlagAlquiler( 1 );
        $o_MST_RangoFN->setFlagEncofrado( 0 );
        $this->a_MST_RangoAlq = $o_MST_RangoFN->select();

        if( $this->s_TipoProc == "upd" )
        {
            $this->s_Titulo = "Editar Producto";
            $o_ALM_ItemMastFN = new ALM_ItemMastFN();
            $this->o_ALM_ItemMastBN = $o_ALM_ItemMastFN->selectByPK( $this->i_Id );
            
            $o_MST_ClaseFamiliaFN = new MST_ClaseFamiliaFN();
            $o_MST_ClaseFamiliaFN->setIdLinea( $this->o_ALM_ItemMastBN->getIdLinea() );
            $this->a_MST_ClaseFamilia = $o_MST_ClaseFamiliaFN->select();
            if( !$this->a_MST_ClaseFamilia )
            {
                $this->a_MST_ClaseFamilia = array();
            }

            $o_MST_ItemUbicacionFN = new MST_ItemUbicacionFN();
            $this->o_MST_ItemUbicacionBN = $o_MST_ItemUbicacionFN->selectByPK( $this->i_Id );

            if( $this->o_MST_ItemUbicacionBN )
            {
                $this->s_HoraHabitacion  = $this->o_MST_ItemUbicacionBN->getHoraHabitacion();
                $this->s_IdTipoUbicacion = $this->o_MST_ItemUbicacionBN->getIdTipoUbicacion();
                $this->s_IdCategoria     = $this->o_MST_ItemUbicacionBN->getIdCategoria();
            }
        }
    }
    
    public function executeRequest()
    {
        $block      = $this->getRequestParameter( 'block' );
        $TipoProc   = $this->getRequestParameter( 'TipoProc' );
        
        $IdLinea    = $this->getRequestParameter( 'IdLinea' );
        $IdFamilia  = $this->getRequestParameter( 'IdFamilia' );
        
        $a_lst = array();
        
        switch ( $TipoProc )
        {
            case "getAlmacen":
                $s_IdSucursal = $this->getRequestParameter( 'IdSucursal' );
                
                $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
                $o_ALM_AlmacenMastFN->setIdSucursal( $s_IdSucursal );
                $a_Result = $o_ALM_AlmacenMastFN->select();
                
                $s_NameId  = "getIdAlmacen";
                $s_NameDes = "getDescripcionLocal";
            break;
            case "GetRango":
                $s_Param = $this->getRequestParameter( 'Parametro' );
                
                $o_MST_RangoFN = new MST_RangoFN();
                $o_MST_RangoFN->setEstado( "A" );
                if( $s_Param == "IdRangoVenta" )
                {
                    $o_MST_RangoFN->setFlagVenta( 1 );
                }
                if( $s_Param == "IdRangoAlquiler" )
                {
                    $o_MST_RangoFN->setFlagAlquiler( 1 );
                }
                $a_Result = $o_MST_RangoFN->select();
                $s_NameId  = "getIdRango";
                $s_NameDes = "getDescripcion";
            break;
            case "Familia":
                $o_MST_ClaseFamiliaFN = new MST_ClaseFamiliaFN();
                $o_MST_ClaseFamiliaFN->setIdLinea( $IdLinea );
                $o_MST_ClaseFamiliaFN->setEstado( "A" );
                $o_MST_ClaseFamiliaFN->addOrderBy( MST_ClaseFamiliaFN::Codigo );
                $a_Result  = $o_MST_ClaseFamiliaFN->select();
                $s_NameId  = "getIdFamilia";
                $s_NameDes = "getDescripcion";
            break;
            case "SubFamilia":
                $o_MST_ClaseSubFamiliaFN = new MST_ClaseSubFamiliaFN();
                $o_MST_ClaseSubFamiliaFN->setEstado( "A" );
                $o_MST_ClaseSubFamiliaFN->setIdFamilia( $IdFamilia );
                $o_MST_ClaseSubFamiliaFN->setIdLinea( $IdLinea );
                $o_MST_ClaseSubFamiliaFN->addOrderBy( MST_ClaseSubFamiliaFN::Codigo );
                $a_Result  = $o_MST_ClaseSubFamiliaFN->select();
                $s_NameId  = "getIdSubFamilia";
                $s_NameDes = "getDescripcion";
            break;
            case "UnidadMedida":
                $IdUnidad = $this->getRequestParameter( 'id_unidad' );

                $o_MST_UnidadMastBN = MST_UnidadMastFN::select_one( $IdUnidad );
                
                $a_Result = array();
                $a_lst['error'] = false;
                $a_lst['activar'] = false;

                if( $o_MST_UnidadMastBN->getUnidadEquivalenteFlag() && $o_MST_UnidadMastBN->getUsoFraccionFlag() )
                {
                    $a_lst['activar'] = true;
                }
            break;
            case "BuscarUbicacion":

                $a_Result = array();

                $s_IdTipoUbicacion = $this->getRequestParameter( 'IdTipoUbicacion' );

                $o_MST_UbicacionFN = new MST_UbicacionFN();
                $o_MST_UbicacionFN->setIdTipoUbicacion( $s_IdTipoUbicacion );
                $o_MST_UbicacionFN->addCondition( MST_UbicacionFN::IdUbicacionPertenece, "<>", 0, false );
                $o_MST_UbicacionFN->addOrderBy( MST_UbicacionFN::Nombre );
                $a_MST_Ubicacion = $o_MST_UbicacionFN->select();

                foreach ( $a_MST_Ubicacion as $o_MST_UbicacionBN ) 
                {
                    $o_UbicacionPisoBN = $o_MST_UbicacionBN->getObjectPiso();
                    $o_MST_UbicacionBN->setNombre( $o_UbicacionPisoBN->getNombre()." - ".$o_MST_UbicacionBN->getNombre() );

                    $a_Result[] = $o_MST_UbicacionBN;
                }

                $s_NameId  = "getIdUbicacion";
                $s_NameDes = "getNombre";
                
            break;
            case "info_item":
                $s_IdItem = $this->getRequestParameter( 'IdItem' );
                $a_lst["error"] = false;
                
                $o_ALM_ItemMastFN = new ALM_ItemMastFN();
                $o_ALM_ItemMastBN = $o_ALM_ItemMastFN->selectByPK( $s_IdItem );
                $a_lst = $o_ALM_ItemMastBN->getJsonSerialize();

                //ahora se necesita el costo y el precio
                $o_MST_ListaPrecioDetalleBN = MST_ListaPrecioDetalleFN::buscarPrecioGeneral( $s_IdItem );
                if( $o_MST_ListaPrecioDetalleBN )
                {
                    $a_lst['Costo']        = $o_MST_ListaPrecioDetalleBN->getPrecioCosto();
                    $a_lst['CostoConIGV']  = $o_MST_ListaPrecioDetalleBN->getPrecioCostoIGV();
                    $a_lst['Precio']       = $o_MST_ListaPrecioDetalleBN->getPrecioVenta();
                    $a_lst['MontoIGV']     = $o_MST_ListaPrecioDetalleBN->getMontoIGV();
                    $a_lst['PrecioConIGV'] = $o_MST_ListaPrecioDetalleBN->getPrecioVentaIGV();
                }
                else
                {
                    $a_lst['Costo']        = 0;
                    $a_lst['CostoConIGV']  = 0;
                    $a_lst['Precio']       = 0;
                    $a_lst['MontoIGV']     = 0;
                    $a_lst['PrecioConIGV'] = 0;
                }
                
                $a_Result = array();
            break;
        }
        foreach ( $a_Result as $i_Key => $o_ObjectBN )
        {
            $a_lst[$o_ObjectBN->$s_NameId()] = strtoupper( $o_ObjectBN->$s_NameDes() );
        }
        echo json_encode( $a_lst );
        return ViewResponse::NONE;
    }
    
    public function executeGuardarImagen()
    {
        $a_Result = array( "error" =>  false, "mensaje" => "" );
        
        //pr( $_REQUEST );
        //pr( $_FILES );
        
        $phpFileUploadErrors = array
        (
                0 => 'There is no error, the file uploaded with success',
                1 => 'El fichero subido excede la directiva upload_max_filesize de php.ini.',
                2 => 'El fichero subido excede la directiva MAX_FILE_SIZE especificada en el formulario HTML.',
                3 => 'El fichero fue sólo parcialmente subido.',
                4 => 'No se subió ningún fichero.',
                6 => 'Falta la carpeta temporal.',
                7 => 'No se pudo escribir el fichero en el disco.',
                8 => 'Una extensión de PHP detuvo la subida de ficheros. PHP no proporciona una forma de determinar la extensión que causó la parada de la subida de ficheros; el examen de la lista de extensiones cargadas con phpinfo() puede ayudar.',
        );
        
        try 
        {
            
            $s_IdItem   = $this->getRequestParameter( 'i_Id' );
            $s_TipoProc = $this->getRequestParameter( 'TypeSubForm2' );
            
            $PATH_UPLOAD_IMAGES_ROUTE    = $_SERVER['DOCUMENT_ROOT'].Constantes::ROOT_DIR_IMG."productos/";
            
            if( $s_TipoProc == "add_img" )
            {
                if ( isset( $_FILES['img_producto'] ) )
                {
                    if ( $_FILES['img_producto']['error'] )
                    {
                        throw new Exception( $phpFileUploadErrors[$_FILES['file_upload']['error']] );
                    }
                    
                    $fileTmpPath   = $_FILES['img_producto']['tmp_name'];
                    $fileName      = $_FILES['img_producto']['name'];
                    $fileSize      = $_FILES['img_producto']['size'];
                    $fileType      = $_FILES['img_producto']['type'];
                    $fileNameCmps  = explode( ".", $fileName );
                    $fileExtension = strtolower( end( $fileNameCmps ) );
                    
                    $newFileName   = $s_IdItem.".".$fileExtension;
                    
                    $uploadFileDir = $PATH_UPLOAD_IMAGES_ROUTE;
                    $dest_path     = $uploadFileDir . $newFileName;
                    $s_DestinoUrl  = Constantes::ROOT_DIR_IMG."productos/".$newFileName;
                }
                else
                {
                    throw new Exception( "Tiene que seleccionar una imagen." );
                }
            }
            
            if( $s_TipoProc == "del_img" )
            {
                $newFileName   = $s_IdItem.".jpg";
                $fileTmpPath  = $_SERVER['DOCUMENT_ROOT'].Constantes::ROOT_DIR_IMG."img_no_disponible.jpg";
                $dest_path    = $PATH_UPLOAD_IMAGES_ROUTE.$newFileName;
                $s_DestinoUrl = Constantes::ROOT_DIR_IMG."productos/".$newFileName;
            }
            
            //pr( $dest_path );
            //pr( $s_DestinoUrl );
            
            if ( copy( $fileTmpPath, $dest_path ) )
            {
                //$message ='File is successfully uploaded.';
                //aqui se atualiza la url de la imagen
                $o_ALM_ItemMastDP = new ALM_ItemMastDP();
                $o_ALM_ItemMastDP->setIdItem( $s_IdItem );
                $o_ALM_ItemMastDP->setNombreArchivo( $newFileName );
                $o_ALM_ItemMastDP->setUbicacionURL( $s_DestinoUrl );
                $o_ALM_ItemMastDP->setUbicacionFisica( $dest_path );
                $o_ALM_ItemMastDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $o_ALM_ItemMastDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $o_ALM_ItemMastDP->update();
            }
            else
            {
            }
                
            
        }
        catch ( Exception $e )
        {
            $a_Result = array( "error" =>  true, "mensaje" => $e->getMessage() );
        }
        
        echo json_encode( $a_Result );
        
        return ViewResponse::NONE;
    }
    
    public function executeSaveItem()
    {
        $block      = $this->getRequestParameter( 'block' );
        $i_Id       = $this->getRequestParameter( 'i_Id' );
        $s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        $TypeSub    = $this->getRequestParameter( 'TypeSub' );
        
        $IdSubFamilia        = $this->getRequestParameter( 'IdSubFamilia' );
        $IdFamilia           = $this->getRequestParameter( 'IdFamilia' );
        $IdLinea             = $this->getRequestParameter( 'IdLinea' );
        $IdProcedencia       = $this->getRequestParameter( 'IdProcedencia' );
        $IdMarca             = $this->getRequestParameter( 'IdMarca' );
        $TipoGarantiaId      = $this->getRequestParameter( 'TipoGarantiaId' );
        
        //$IdItem              = $this->getRequestParameter( 'IdItem' );
        //$CodigoInterno       = $this->getRequestParameter( 'CodigoInterno' );
        $IdItemTipo          = $this->getRequestParameter( 'IdItemTipo' );
        //$IdTipoAlimento      = $this->getRequestParameter( 'IdTipoAlimento' );
        $DescripcionCompleta = ( $this->getRequestParameter( 'DescripcionCompleta' ) );
        $DescripcionLarga    = ( $this->getRequestParameter( 'DescripcionLarga' ) );
        $UnidadCompra        = $this->getRequestParameter( 'UnidadCompra' );
        $UnidadVenta         = $this->getRequestParameter( 'UnidadVenta' );
        $UnidadAlmacenaje    = $this->getRequestParameter( 'UnidadAlmacenaje' );
        $Estado              = $this->getRequestParameter( 'Estado' );

        $NoAfectoImpuestoVentasFlag = is_null( $this->getRequestParameter( 'NoAfectoImpuestoVentasFlag' ) ) ? "N" : "S";
        //$AfectoDetraccionFlag       = is_null( $this->getRequestParameter( 'AfectoDetraccionFlag' ) ) ? "NO" : "SI";
        //$IdDetraccion               = is_null( $this->getRequestParameter( 'IdDetraccion' ) ) ? "" : $this->getRequestParameter( 'IdDetraccion' );
        
        //$IdEstadio           = $this->getRequestParameter( 'IdEstadio' );
        
        $IdPersona              = $this->getRequestParameter( 'IdPersona' );
        $CantidadUnidad         = $this->getRequestParameter( 'CantidadUnidad' );
        $CantidadUnidadCompra   = $this->getRequestParameter( 'CantidadUnidadCompra' );

        //$StockMinimo            = $this->getRequestParameter( 'StockMinimo' );
        //$StockMaximo            = $this->getRequestParameter( 'StockMaximo' );
        //$CodigoBarras           = $this->getRequestParameter( 'CodigoBarras' );
        $CodigoBarrasFabricante = $this->getRequestParameter( 'CodigoBarrasFabricante' );

        $ManejoxLoteFlag        = is_null( $this->getRequestParameter( 'ManejoxLoteFlag' ) ) ? "N" : "S";
        $FusionarLoteFlag       = is_null( $this->getRequestParameter( 'FusionarLoteFlag' ) ) ? "N" : "S";
        $ManejoxSerieFlag       = is_null( $this->getRequestParameter( 'ManejoxSerieFlag' ) ) ? "N" : "S";
        $UsarDisponibleStock    = is_null( $this->getRequestParameter( 'UsarDisponibleStock' ) ) ? "N" : "S";
        $UsarResevableStock     = is_null( $this->getRequestParameter( 'UsarResevableStock' ) ) ? "N" : "S";
        
        $EsParaVenta            = is_null( $this->getRequestParameter( 'EsParaVenta' ) ) ? "NO"    : "SI";
        $EsParaAlquiler         = is_null( $this->getRequestParameter( 'EsParaAlquiler' ) ) ? "NO" : "SI";
        $IdRangoAlquiler        = $this->getRequestParameter( 'IdRangoAlquiler' );
        $IdRangoVenta           = $this->getRequestParameter( 'IdRangoVenta' );
        
        $PesoGramos             = floatval( $this->getRequestParameter( 'PesoGramos' ) );
        
        $StockMinimo            = floatval( $this->getRequestParameter( 'StockMinimo' ) );
        $StockMaximo            = floatval( $this->getRequestParameter( 'StockMaximo' ) );
        
        //$PrecioCosto            = floatval( $this->getRequestParameter( 'PrecioCosto' ) );
        //$UtilidadPorcentaje     = floatval( $this->getRequestParameter( 'UtilidadPorcentaje' ) );
        //$PrecioVenta            = floatval( $this->getRequestParameter( 'PrecioVenta' ) );
        $IdTipoOperatividad     = $this->getRequestParameter( 'IdTipoOperatividad' );
        
        $IdItemFiscal           = $this->getRequestParameter( 'IdItemFiscal' );
        $CodigoFiscal           = "";
        if( $IdItemFiscal )
        {
            $o_MST_ItemFiscalFN = new MST_ItemFiscalFN();
            $o_MST_ItemFiscalBN = $o_MST_ItemFiscalFN->selectByPK( $IdItemFiscal );
            $CodigoFiscal           = $o_MST_ItemFiscalBN->getCodigoFiscal();
        }
        
        $NumeroDeParte          = $this->getRequestParameter( 'NumeroDeParte' );
        //$CodigoBarras2          = $this->getRequestParameter( 'CodigoBarras2' );

        $EsInventariableFlag = $this->getRequestParameter( 'EsInventariableFlag' );
        $DiaSemanaFlag       = is_null( $this->getRequestParameter( 'DiaSemana' ) ) ? "N" : "S";

        $a_Rs = array();
        $con = Conexion::getConexion();
        $con->begin();
        try 
        {
            myUser::getUser()->validar_session();
            /////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //validaciones:
            //El codigo de fabricante no debe de repetir en los registros
            if( trim( $CodigoBarrasFabricante ) != "" )
            {
                $o_ALM_ItemMastFN = new ALM_ItemMastFN();
                $o_ALM_ItemMastFN->setCodigoBarrasFabricante( $CodigoBarrasFabricante );
                if( $s_TipoProc != "nvo" )
                {
                    $o_ALM_ItemMastFN->addCondition( ALM_ItemMastFN::IdItem, "NOT IN", "('$i_Id')", false );
                }
                $a_ALM_ItemMast = $o_ALM_ItemMastFN->select();
                if( $a_ALM_ItemMast )
                {
                    throw new Exception( "El Codigo de Barras ya se encuentra registrado al Codigo [".$a_ALM_ItemMast[0]->getIdItem()." - ".$a_ALM_ItemMast[0]->getDescripcionCompleta()."] " );
                }
            }
            /////////////////////////////////////////////////////////////////////////////////////////////////////////////
            $search  = array( '"', '+', "'", '\\', "<BR>", "<br>", "," );
            $replace = array( '',  '',  '',  '', '', "", "" );

            $DescripcionCompleta = str_replace( $search, $replace, $DescripcionCompleta );
            $DescripcionLarga    = str_replace( $search, $replace, $DescripcionLarga );

            $DescripcionCompleta = addslashes( $DescripcionCompleta );
            $DescripcionLarga    = addslashes( $DescripcionLarga );
            /////////////////////////////////////////////////////////////////////////////////////////////////////////////
            $o_ALM_ItemMastDP = new ALM_ItemMastDP();
            $o_ALM_ItemMastDP->setIdSubFamilia( ( int ) $IdSubFamilia );
            $o_ALM_ItemMastDP->setIdFamilia( ( int ) $IdFamilia );
            $o_ALM_ItemMastDP->setIdLinea( ( int ) $IdLinea );
            $o_ALM_ItemMastDP->setIdProcedencia( $IdProcedencia );
            $o_ALM_ItemMastDP->setIdMarca( $IdMarca );
            $o_ALM_ItemMastDP->setTipoGarantiaId( $TipoGarantiaId );
            $o_ALM_ItemMastDP->setIdCompania( myUser::getUser()->getIdBusiness() );
            $o_ALM_ItemMastDP->setIdTipoOperatividad( $IdTipoOperatividad );
            
            $o_ALM_ItemMastDP->setEstado( $Estado );
            
            $o_ALM_ItemMastDP->setIdItemTipo( $IdItemTipo );
            //$o_ALM_ItemMastDP->setIdTipoAlimento( ( int ) $IdTipoAlimento );
            $o_ALM_ItemMastDP->setDescripcionCompleta( $DescripcionCompleta );
            $o_ALM_ItemMastDP->setDescripcionLarga( $DescripcionLarga );
            $o_ALM_ItemMastDP->setUnidadCompra( $UnidadCompra );
            $o_ALM_ItemMastDP->setUnidadVenta( $UnidadVenta );
            $o_ALM_ItemMastDP->setUnidadAlmacenaje( $UnidadAlmacenaje );
            $o_ALM_ItemMastDP->setCantidadUnidad( floatval( $CantidadUnidad ) );
            $o_ALM_ItemMastDP->setCantidadUnidadCompra( floatval( $CantidadUnidadCompra ) );
            //$o_ALM_ItemMastDP->setEstadioFlag( $EstadioFlag );
            //$o_ALM_ItemMastDP->setIdEstadio( $IdEstadio );
            $o_ALM_ItemMastDP->setNoAfectoImpuestoVentasFlag( $NoAfectoImpuestoVentasFlag );
            //$o_ALM_ItemMastDP->setAfectoDetraccionFlag( $AfectoDetraccionFlag );
            //$o_ALM_ItemMastDP->setIdDetraccion( ( int ) $IdDetraccion );
            
            $o_ALM_ItemMastDP->setPesoGramos( $PesoGramos);
            
            $o_ALM_ItemMastDP->setStockMinimo( $StockMinimo );
            $o_ALM_ItemMastDP->setStockMaximo( $StockMaximo );
            
            $o_ALM_ItemMastDP->setIdPersona( ( int ) $IdPersona );
            //$o_ALM_ItemMastDP->setStockMinimo( floatval( $StockMinimo ) );
            //$o_ALM_ItemMastDP->setStockMaximo( floatval( $StockMaximo ) );
            //$o_ALM_ItemMastDP->setCodigoBarras( $CodigoBarras );
            $o_ALM_ItemMastDP->setCodigoBarrasFabricante( $CodigoBarrasFabricante );
            $o_ALM_ItemMastDP->setManejoxLoteFlag( $ManejoxLoteFlag );
            $o_ALM_ItemMastDP->setFusionarLoteFlag( $FusionarLoteFlag );
            $o_ALM_ItemMastDP->setManejoxSerieFlag( $ManejoxSerieFlag );
            $o_ALM_ItemMastDP->setEsInventariableFlag( $EsInventariableFlag );
            $o_ALM_ItemMastDP->setUsarDisponibleStock( $UsarDisponibleStock );
            $o_ALM_ItemMastDP->setUsarResevableStock( $UsarResevableStock );
            
            $o_ALM_ItemMastDP->setEsParaVenta( $EsParaVenta );
            $o_ALM_ItemMastDP->setEsParaAlquiler( $EsParaAlquiler );
            $o_ALM_ItemMastDP->setIdRangoAlquiler( ( int ) $IdRangoAlquiler );
            $o_ALM_ItemMastDP->setIdRangoVenta( ( int ) $IdRangoVenta );
            
            $o_ALM_ItemMastDP->setPesoGramos( $PesoGramos );
            
            //$o_ALM_ItemMastDP->setPrecioCosto( $PrecioCosto );
            //$o_ALM_ItemMastDP->setPrecioUnitarioLocal( $PrecioCosto );
            //$o_ALM_ItemMastDP->setUtilidadPorcentaje( $UtilidadPorcentaje );
            //$o_ALM_ItemMastDP->setPrecioVenta( $PrecioVenta );

            $o_ALM_ItemMastDP->setNumeroDeParte( $NumeroDeParte );
            $o_ALM_ItemMastDP->setIdItemFiscal( ( int ) $IdItemFiscal );
            $o_ALM_ItemMastDP->setCodigoSunat( $CodigoFiscal );
            //$o_ALM_ItemMastDP->setCodigoBarras2( $CodigoBarras2 );
            
            if( $s_TipoProc == "nvo" )
            {
                //SE RECUPERA CORRELATIVO ITEM
                $IdItem = ALM_ItemMastFN::recuperarId( $IdLinea );
                $CodigoInterno = ALM_ItemMastDP::recuperarCodigoInterno();
                
                //INSERT
                $o_ALM_ItemMastDP->setCodigoInterno( ( string ) $CodigoInterno );
                $o_ALM_ItemMastDP->setIdItem( $IdItem );
                //$o_ALM_ItemMastDP->setCodigoBarras( $IdItem );
                $o_ALM_ItemMastDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                $o_ALM_ItemMastDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                $o_ALM_ItemMastDP->setEstado( "A" ); //por defecto

                $b_Result = $o_ALM_ItemMastDP->save();
                $i_Id = $IdItem;
            }
            else 
            {
                //UPDATE
                $o_ALM_ItemMastDP->setIdItem( $i_Id );
                $o_ALM_ItemMastDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $o_ALM_ItemMastDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $b_Result = $o_ALM_ItemMastDP->update();
            }
            
            if( $b_Result )
            {
                //aqui ahora se asocia con dia de semana seleccionada
                //primero limpiamos
                MST_ItemDiaSemanaDP::limpiarDiaSemanaPorIdItem( $i_Id );

                $a_DiaSemana = is_null( $this->getRequestParameter( 'DiaSemana' ) ) ? array() : $this->getRequestParameter( 'DiaSemana' );
                foreach ( $a_DiaSemana as $i_Key => $s_Value ) 
                {
                    $a_Values = explode( "_", $s_Value );
                    list( $s_IdDiaSem, $s_DiaNumero ) = $a_Values;
                    
                    $o_MST_ItemDiaSemanaDP = new MST_ItemDiaSemanaDP();
                    $o_MST_ItemDiaSemanaDP->setIdDiaSem( ( int ) $s_IdDiaSem );
                    $o_MST_ItemDiaSemanaDP->setIdItem( $i_Id );
                    $o_MST_ItemDiaSemanaDP->setDiaNumero( ( int ) $s_DiaNumero );
                    $o_MST_ItemDiaSemanaDP->save();
                }

                //AHORA ASOCIAMOS LA UBICACION DE LA HABITACION
                //primero limpiamos
                $s_IdCategoria     = $this->getRequestParameter( 'IdCategoria' );
                $s_IdTipoUbicacion = $this->getRequestParameter( 'IdTipoUbicacion' );
                $s_HoraHabitacion  = $this->getRequestParameter( 'HoraHabitacion' );

                MST_ItemUbicacionDP::limpiarPorIdItem( $i_Id );
                $o_MST_ItemUbicacionDP = new MST_ItemUbicacionDP();
                $o_MST_ItemUbicacionDP->setIdCategoria( ( int ) $s_IdCategoria );
                $o_MST_ItemUbicacionDP->setIdItem( $i_Id );
                $o_MST_ItemUbicacionDP->setIdTipoUbicacion( ( int ) $s_IdTipoUbicacion );
                $o_MST_ItemUbicacionDP->setHoraHabitacion( ( int ) $s_HoraHabitacion );
                $o_MST_ItemUbicacionDP->save();

                ////////////////////////////////////////////////////////////////////

                if( myUser::getUser()->getIdBusiness() )
                {
                    $o_ALM_ItemMastBN = new ALM_ItemMastBN();
                    $o_ALM_ItemMastBN->setIdCompania( myUser::getUser()->getIdBusiness() );
                    if( myUser::getUser()->getIdSucursal() )
                    {
                        $o_ALM_ItemMastBN->setIdSucursal( myUser::getUser()->getIdSucursal() );
                    }
                    $o_ALM_ItemMastBN->setIdItem( $i_Id );
                    //$o_ALM_ItemMastBN->setPrecioCosto( $PrecioCosto );
                    //$o_ALM_ItemMastBN->setUtilidadPorcentaje( $UtilidadPorcentaje );
                    //$o_ALM_ItemMastBN->setPrecioVenta( $PrecioVenta );
                    
                    /*
                    if( !$s_Version )
                    {
                        $o_ValidacionxItemBL = new ValidacionxItemBL();
                        $o_ValidacionxItemBL->iniciarCambioPrecio( $o_ALM_ItemMastBN );
                    }*/
                    
                    //AHORA SE CARGA EN ITEM_ALMACEN_STOCK, DE TODOS LOS ALMACENES
                    $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
                    $o_ALM_AlmacenMastFN->setIdCompania( myUser::getUser()->getIdBusiness() );
                    $o_ALM_AlmacenMastFN->setEstado( "A" );
                    $a_ALM_AlmacenMast = $o_ALM_AlmacenMastFN->select();
                    if( $a_ALM_AlmacenMast )
                    {
                        $o_TmpALM_ItemMastBN = clone $o_ALM_ItemMastBN;
                        foreach ( $a_ALM_AlmacenMast as $i_Key => $o_ALM_AlmacenMastBN )
                        {
                            $o_TmpALM_ItemMastBN->setIdAlmacen( $o_ALM_AlmacenMastBN->getIdAlmacen() );
                            $o_ValidacionxItemBL = new ValidacionxItemBL();
                            $b_Result = $o_ValidacionxItemBL->iniciarValidacionAlmacenStock( $o_TmpALM_ItemMastBN ); //MEJOR SE PREGUNTA DESDE LA CREACION DEL ITEM
                        }
                    }
                }
            }
            
            $a_Rs['type_sub'] = $TypeSub;
            $a_Rs['error']    = false;
            $a_Rs['id']       = $i_Id;
            
            $con->commit();
        }
        catch ( Exception $o_Exception )
        {
            //pr( $o_Exception );
            $con->rollback();
            $a_Rs['error']        = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }
        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }
    
    public function executeAudi()
    {
        $block      = $this->getRequestParameter( 'block' );
        $i_Id       = $this->getRequestParameter( 'i_Id' );
        
        $this->s_Topico = "Item";
        $o_ALM_ItemMastFN = new ALM_ItemMastFN();
        $this->o_ALM_ItemMastBN = $o_ALM_ItemMastFN->selectByPK( $i_Id );
    }
    
    public function executeViewdel()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        
        $this->block      = $this->getRequestParameter( 'block' );
        $this->i_Id       = $this->getRequestParameter( 'i_Id' );
        $this->s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        
        $o_ALM_ItemMastFN = new ALM_ItemMastFN();
        $this->o_ALM_ItemMastBN = $o_ALM_ItemMastFN->selectByPK( $this->i_Id );
        
        $o_MST_ClaseLineaFN = new MST_ClaseLineaFN();
        $o_MST_ClaseLineaFN->addOrderBy( MST_ClaseLineaFN::Descripcion, true );
        $this->a_MST_ClaseLinea = $o_MST_ClaseLineaFN->select();
        
        $o_ALM_ItemTipoFN = new ALM_ItemTipoFN();
        $o_ALM_ItemTipoFN->setEstado( "A" );
        $o_ALM_ItemTipoFN->addOrderBy( ALM_ItemTipoFN::DescripcionLocal, true );
        $this->a_ALM_ItemTipo = $o_ALM_ItemTipoFN->select();
        
        $o_MST_UnidadMastFN = new MST_UnidadMastFN();
        $this->a_UnidadCompra       = $o_MST_UnidadMastFN->select();
        $this->a_UnidadVenta        = $this->a_UnidadCompra;
        $this->a_UnidadAlmacenaje   = $this->a_UnidadCompra;
        
        //SE RECUPERA LOS PROVEEDORES
        $o_MST_PersonaMastFN = new MST_PersonaMastFN();
        $o_MST_PersonaMastFN->setEsProveedor( 'SI' );
        $o_MST_PersonaMastFN->setIdCompania( myUser::getUser()->getIdBusiness() );
        $o_MST_PersonaMastFN->setEstado( 'A' );
        $this->a_MST_PersonaMast = $o_MST_PersonaMastFN->select();
        
        $o_MST_ItemProcedenciaFN = new MST_ItemProcedenciaFN();
        $o_MST_ItemProcedenciaFN->setEstado( "A" );
        $o_MST_ItemProcedenciaFN->addOrderBy( MST_ItemProcedenciaFN::Descripcion, true );
        $this->a_MST_ItemProcedencia = $o_MST_ItemProcedenciaFN->select();
        
        $o_ALM_MarcaFN = new ALM_MarcaFN();
        $o_ALM_MarcaFN->addOrderBy( ALM_MarcaFN::DescripcionLocal, true );
        $o_ALM_MarcaFN->setEstado( "A" );
        $this->a_ALM_Marca = $o_ALM_MarcaFN->select();
    
        $o_MST_ClaseLineaFN = new MST_ClaseLineaFN();
        $o_MST_ClaseLineaFN->setEstado( "A" );
        $o_MST_ClaseLineaFN->addOrderBy( MST_ClaseLineaFN::Descripcion, true );
        $this->a_MST_ClaseLinea = $o_MST_ClaseLineaFN->select();
    
        $o_MST_ClaseFamiliaFN = new MST_ClaseFamiliaFN();
        $o_MST_ClaseFamiliaFN->setEstado( "A" );
        $o_MST_ClaseFamiliaFN->addOrderBy( MST_ClaseFamiliaFN::Descripcion, true );
        $o_MST_ClaseFamiliaFN->setIdLinea( $this->o_ALM_ItemMastBN->getIdLinea() );
        $this->a_MST_ClaseFamilia = $o_MST_ClaseFamiliaFN->select();
        if( !$this->a_MST_ClaseFamilia )
        {
            $this->a_MST_ClaseFamilia = array();
        }
    }
    
    public function executeDeleteRow()
    {
        $block      = $this->getRequestParameter( 'block' );
        $i_Id       = $this->getRequestParameter( 'i_Id' );
        $s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        try 
        {
            $o_ALM_ItemMastDP = new ALM_ItemMastDP();
            $o_ALM_ItemMastDP->setIdItem( $i_Id );
            $o_ALM_ItemMastDP->setEstado( "I" );
            $o_ALM_ItemMastDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
            $o_ALM_ItemMastDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
            $o_ALM_ItemMastDP->update();
            //$b_Result = $o_ALM_ItemMastDP->delete();

            $a_Rs['error']   = false;
            $a_Rs['id']      = $i_Id;
        }
        catch ( Exception $o_Exception )
        {
            $a_Rs['error']   = true;
            $a_Rs['mensaje_error_ex'] = $o_Exception->getMessage();
            $a_Rs['mensaje_error'] = "No se pudo eliminar el registro.";
        }
        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }
    
    public function executeShowItemAlm()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();

        $block      = $this->getRequestParameter( 'block' );
        $this->i_Id = $this->getRequestParameter( 'i_Id' );
        
        $o_ALM_ItemMastFN = new ALM_ItemMastFN();
        $this->o_ALM_ItemMastBN = $o_ALM_ItemMastFN->selectByPK( $this->i_Id );
    }
    
    public function executeGridShowItemAlm() 
    {
        set_header_utf8();
        
        $i_Id = $this->getRequestParameter( 'i_Id' );
        
        $b_Control = true;

        $o_GridAction = new GridAction();
        if( $this->getRequestParameter( 'ResumenAlmacen' ) )
        {
            $o_GridAction->setClassFind( new ALM_ItemMastFN() );
            
            //$o_GridAction->addMethodDefault( "IdAlmacen", GSS_SucursalFN::recuperarIdAlmacen( myUser::getUser()->getIdSucursal() ) );
            $o_GridAction->setMethodSelectCustomRs( "selectdos" ); //FUNCION PERSONALIZADO PARA BUSQUEDA
            
            ALM_ItemMastFN::setGroupByAlmacen( 1 );
            $b_Control = false;
        }
        else
        {
            //$o_GridAction->setClassFind( new ALM_ItemAlmacenStockFN() );
            $o_GridAction->setClassFind( new ALM_ItemMastFN() );
            
            //$o_GridAction->addMethodDefault( "IdAlmacen", GSS_SucursalFN::recuperarIdAlmacen( myUser::getUser()->getIdSucursal() ) );
            $o_GridAction->setMethodSelectCustomRs( "selectdos" ); //FUNCION PERSONALIZADO PARA BUSQUEDA
            
            ALM_ItemMastFN::setGroupByAlmacen( 1 );
            ALM_ItemMastFN::setGroupByLote( 1 );
        }
        
        //$o_GridAction->addMethodDefault( ALM_ItemAlmacenStockFN::IdCompania, myUser::getUser()->getIdBusiness() );
        $o_GridAction->addMethodDefault( ALM_ItemAlmacenStockFN::IdItem, $i_Id );
        
        $o_GridAction->addAssignFilter( "IdCompania" );
        $o_GridAction->addAssignFilter( "IdItem" );
        //$o_GridAction->addAssignFilter( "IdAlmacen" );
        
        if( $this->getRequestParameter( 'ConStock' ) )
        {
            $o_GridAction->addMethodDefault( ALM_ItemAlmacenStockFN::StockDisponible, array( 'Condition'=>'>=', 'Value'=>"1" ) );
            //$o_GridAction->addConditionFilter( "ConStock", ALM_ItemAlmacenStockFN::StockDisponible, ">=", 0 );
        }

        //$o_GridAction->addOrderDefault( ALM_ItemAlmacenStockFN::IdItem, true );
        $o_GridAction->addOrderDefault( ALM_ItemAlmacenStockFN::IdAlmacen, true );
        $o_GridAction->addOrderDefault( "ALM_ItemAlmacenStock.StockDisponible", false );
        
        /*$o_GridAction->addRowsToShow
        ( 
            "IdAlmacen", "IdLote", "FechaVencimiento", "IdItem", "DescripcionItem", "StockDisponible"
        );*/
        
        $o_GridAction->addInnerJoin( new ALM_AlmacenMastFN(), "IdAlmacen", "DescripcionLocal" );
        
        $o_GridAction->setNumberRecordsShow( 15 );
        
        $o_GridAction->setControlArray( false );

        $o_GridAction->initialize();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        
        $a_ResultJson['page']    = $o_GridAction->getPage();
        $a_ResultJson['total']   = $o_GridAction->getTotalPage();
        $a_ResultJson['records'] = $o_GridAction->getTotalRecords();
        //$a_ResultJson['rows']    = $o_GridAction->getResultArray();
        $a_ResultSelect          = $o_GridAction->getResultSelect();
        $a_Rs = array();

        foreach ( $a_ResultSelect as $iKey => $o_ObjClassBN )
        {
            if( $o_ObjClassBN->getIdUniMedVenta() == "58" )
            {
                $s_Stock = number_format( $o_ObjClassBN->getCantidadxUnidad(), 0 );
            }
            else
            {
                $s_Stock = number_format( $o_ObjClassBN->getCantidadxCaja(), 2 );
            }

            if( !$b_Control )
            {
                $o_ObjClassBN->setIdLote( "" );
                $o_ObjClassBN->setFechaVencimientoLote( "" );
            }

            if( ( $this->getRequestParameter( 'EnUnidades' ) ) )
            {
                $s_Stock = number_format( $o_ObjClassBN->getCantidadxUnidad(), 0 );
            }

            $a_Rs[] = array
            (
                "IdItem"               => ( $o_ObjClassBN->getIdItem() ),
                "IdAlmacen"            => $o_ObjClassBN->getIdAlmacen(),
                "DescripcionAlmacen"   => $o_ObjClassBN->getDescripcionAlmacen(),
                "IdLote"               => $o_ObjClassBN->getIdLote(),
                "FechaVencimientoLote" => $o_ObjClassBN->getFechaVencimientoLote(),
                "DescripcionItem"      => ( $o_ObjClassBN->getDescripcionCompleta() ),
                //"Stock"                => $s_Stock,
                "Stock"                => $o_ObjClassBN->getStockDisponible(),
                "IdUniMedVenta"        => $o_ObjClassBN->getIdUniMedVenta(),
                //"CantUniMedVenta"     => round( $o_ObjClassBN->getCantUniMedVenta(), 2 ),
                //"CantidadxCaja"       => $o_ObjClassBN->getCantidadxCaja(),
                //"CantidadxUnidad"     => $o_ObjClassBN->getCantidadxUnidad(),
                "Marca"                => $o_ObjClassBN->getIdMarca(),
            );
        }

        $a_ResultJson['rows'] = $a_Rs;

        echo json_encode( $a_ResultJson );
        
        return ViewResponse::NONE;
    }
}