<?php
class GuardarPromocionAction extends wtActions
{
    public function execute()
    {
        $s_Id       = $this->getRequestParameter( 'Id' );
        $s_TipoProc = $this->getRequestParameter( 'TipoProc' );

        $s_DescripcionPromo  = $this->getRequestParameter( 'DescripcionPromo' );
        $s_FechaInicio       = $this->getRequestParameter( 'FechaInicio' );
        $s_FechaFin          = $this->getRequestParameter( 'FechaFin' );
        $i_CantidadPromo     = intval( $this->getRequestParameter( 'CantidadPromo' ) );
        $f_PrecioPromo       = floatval( $this->getRequestParameter( 'PrecioPromo' ) );
        $f_SumaMontoSubTotal = floatval( $this->getRequestParameter( 'SumaMontoSubTotal' ) );
        $f_SumaMontoIGV      = floatval( $this->getRequestParameter( 'SumaMontoIGV' ) );
        $f_SumaMontoTotal    = floatval( $this->getRequestParameter( 'SumaMontoTotal' ) );

        //$IdAlmacen = GSS_SucursalFN::recuperarIdAlmacen( myUser::getUser()->getIdSucursal() );
        $s_IdAlmacen    = $this->getRequestParameter( 'IdAlmacen' );
        
        $s_IdItemTipo   = $this->getRequestParameter( 'IdItemTipo' );

        try 
        {
            myUser::getUser()->validar_session();

            $o_MKT_PromocionCabDP = new MKT_PromocionCabDP();
            $o_MKT_PromocionCabDP->setDescripcionPromo( $s_DescripcionPromo );
            $o_MKT_PromocionCabDP->setFechaInicio( $s_FechaInicio );
            $o_MKT_PromocionCabDP->setFechaFin( $s_FechaFin );
            
            $o_MKT_PromocionCabDP->setCantidadPromo( $i_CantidadPromo );
            $o_MKT_PromocionCabDP->setCantidadFacturado( 0 );
            $o_MKT_PromocionCabDP->setPrecioSinIGVPromo( $f_SumaMontoSubTotal );
            $o_MKT_PromocionCabDP->setMontoIGVPromo( $f_SumaMontoIGV );
            $o_MKT_PromocionCabDP->setPrecioConIGVPromo( $f_PrecioPromo );

            $o_MKT_PromocionCabDP->setIdItemTipo( $s_IdItemTipo );

            if( $s_TipoProc == "nvo" )
            {
                $i_IdPromo  = MKT_PromocionCabDP::recuperarId();

                //$s_ChrFijo = "#"; //SE DESCARTO POR NO RESOLVER EL PASAR POR URL
                $s_ChrFijo = "";
                //SE RECUPERA EL PREFIJO DEL TIPO DE ITEM
                $o_ALM_ItemTipoFN = new ALM_ItemTipoFN();
                $o_ALM_ItemTipoBN = $o_ALM_ItemTipoFN->selectByPK( $s_IdItemTipo );
                if( !$o_ALM_ItemTipoBN )
                {
                    throw new Exception( "No se encontro el tipo de configuracion." );
                }
                $s_Prefijo = $o_ALM_ItemTipoBN->getDescripcionIngles();
                $s_Prefijo = $s_ChrFijo.$s_Prefijo;
                
                $s_CodPromo = $s_Prefijo.str_pad( $i_IdPromo, 4, "0", STR_PAD_LEFT );

                $o_MKT_PromocionCabDP->setIdPromoCab( $i_IdPromo );
                $o_MKT_PromocionCabDP->setIdCompania( myUser::getUser()->getIdBusiness() );
                $o_MKT_PromocionCabDP->setIdSucursal( myUser::getUser()->getIdSucursal() );
                $o_MKT_PromocionCabDP->setIdAlmacen( $s_IdAlmacen );
                $o_MKT_PromocionCabDP->setCodigoPromo( $s_CodPromo );
                $o_MKT_PromocionCabDP->setEstadoPromo( "PE" ); //PEndiente - PUblicado - CAncelado - TERMINADO
                $o_MKT_PromocionCabDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                $o_MKT_PromocionCabDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                $o_MKT_PromocionCabDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $o_MKT_PromocionCabDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $o_MKT_PromocionCabDP->save();
                $i_Id = $i_IdPromo;
            }
            else
            {
                $i_Id = intval( $s_Id );

                if( $this->getRequestParameter( 'EstadoPromo' ) )
                {
                    $o_MKT_PromocionCabDP->setEstadoPromo( $this->getRequestParameter( 'EstadoPromo' ) );
                }

                $o_MKT_PromocionCabDP->setIdPromoCab( $i_Id );
                $o_MKT_PromocionCabDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $o_MKT_PromocionCabDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $o_MKT_PromocionCabDP->update();

                $o_MKT_ItemPromocionDP = new MKT_ItemPromocionDP();
                $o_MKT_ItemPromocionDP->setIdPromoCab( $i_Id );
                $o_MKT_ItemPromocionDP->deleteDet();
            }

            //ahora los detalles
            $a_IdItem       = $this->getRequestParameter( 'IdItem' );
            $a_Descripcion  = $this->getRequestParameter( 'Descripcion' );
            $a_CostoConIGV  = $this->getRequestParameter( 'CostoConIGV' );
            $a_CostoSinIGV  = $this->getRequestParameter( 'CostoSinIGV' );
            $a_PrecioConIGV = $this->getRequestParameter( 'PrecioConIGV' );
            $a_PrecioSinIGV = $this->getRequestParameter( 'PrecioSinIGV' );
            $a_Cantidad     = $this->getRequestParameter( 'Cantidad' );
            $a_MontoIGV     = $this->getRequestParameter( 'MontoIGV' );

            //$f_CostoTotalRef = 0;
            $f_CostoTotalRef = round( ( $f_SumaMontoSubTotal / 2 ), 2 );

            foreach ( $a_IdItem as $i_Key => $s_ItemId ) 
            {
                $s_TipoDetalle = VTA_DocumentoDetalleBN::TIPO_DETALLE;
                if( trim( $s_ItemId ) != "" )
                {
                    $o_ALM_ItemMastBN = ALM_ItemMastFN::getObjectItem( $s_ItemId );
                    if( !$o_ALM_ItemMastBN )
                    {
                        throw new Exception( "El Codigo de Item [$s_ItemId] no existe en el Inventario." );
                    }
                    $a_Descripcion[$i_Key] = $o_ALM_ItemMastBN->getDescripcionCompleta();
                }
                else
                {
                    if( trim( $a_Descripcion[$i_Key] ) == "" )
                    {
                        throw new Exception( "Se encontro una linea vacia." );
                    }
                    $s_TipoDetalle = VTA_DocumentoDetalleBN::TIPO_DETALLE_COMENTARIO;
                }

                $f_CostoConIGV  = floatval( $a_CostoConIGV[$i_Key] );
                $f_CostoSinIGV  = floatval( $a_CostoSinIGV[$i_Key] );
                $f_PrecioConIGV = floatval( $a_PrecioConIGV[$i_Key] );
                $f_PrecioSinIGV = floatval( $a_PrecioSinIGV[$i_Key] );
                $f_MontoIGV     = floatval( $a_MontoIGV[$i_Key] );
                $f_Cantidad     = floatval( $a_Cantidad[$i_Key] );

                //$f_CostoTotalRef = $f_CostoTotalRef + $f_CostoSinIGV;

                $i_IdPromoDet  = MKT_PromocionCabDP::recuperarId();
                $o_MKT_ItemPromocionDP = new MKT_ItemPromocionDP();
                $o_MKT_ItemPromocionDP->setIdItemPromo( $i_IdPromoDet );
                $o_MKT_ItemPromocionDP->setIdItem( $s_ItemId );
                $o_MKT_ItemPromocionDP->setIdPromoCab( $i_Id );
                $o_MKT_ItemPromocionDP->setTipoDetalle( $s_TipoDetalle );
                $o_MKT_ItemPromocionDP->setDescripcionItem( $a_Descripcion[$i_Key] );
                $o_MKT_ItemPromocionDP->setCostoSinIGV( $f_CostoSinIGV );
                $o_MKT_ItemPromocionDP->setCostoConIGV( $f_CostoConIGV );
                $o_MKT_ItemPromocionDP->setPrecioSinIGV( $f_PrecioSinIGV );
                $o_MKT_ItemPromocionDP->setMontoIGV( $f_MontoIGV );
                $o_MKT_ItemPromocionDP->setPrecioConIGV( $f_PrecioConIGV );
                $o_MKT_ItemPromocionDP->setCantidad( $f_Cantidad );
                $o_MKT_ItemPromocionDP->save();
            }
            
            //ahora, si el estado es publicados, se tiene que crear un registro en la tabla maesta de items
            if( $this->getRequestParameter( 'EstadoPromo' ) )
            {
                if( $this->getRequestParameter( 'EstadoPromo' ) == "PU" ) //publicado
                {
                    $o_MKT_PromocionCabFN = new MKT_PromocionCabFN();
                    $o_MKT_PromocionCabBN = $o_MKT_PromocionCabFN->selectByPK( $i_Id );
                    if( !$o_MKT_PromocionCabBN )
                    {
                        throw new Exception( "No se encontro la promocion." );
                    }

                    //aqui se busca si existe el item
                    $o_ALM_ItemMastFN = new ALM_ItemMastFN();
                    $o_ALM_ItemMastBN = $o_ALM_ItemMastFN->selectByPK( $o_MKT_PromocionCabBN->getCodigoPromo() );

                    if( !$o_ALM_ItemMastBN )
                    {
                        //se crea un nuevo item
                        $o_ALM_ItemMastDP = new ALM_ItemMastDP();
                        $o_ALM_ItemMastDP->setIdItem( $o_MKT_PromocionCabBN->getCodigoPromo() );
                        $o_ALM_ItemMastDP->setIdMarca( "00000" );
                        $o_ALM_ItemMastDP->setIdLinea( 0 );
                        $o_ALM_ItemMastDP->setIdFamilia( 0 );
                        $o_ALM_ItemMastDP->setIdItemTipo( $s_IdItemTipo );
                        $o_ALM_ItemMastDP->setDescripcionCompleta( $o_MKT_PromocionCabBN->getDescripcionPromo() );
                        $o_ALM_ItemMastDP->setUnidadCompra( "58" );
                        $o_ALM_ItemMastDP->setUnidadVenta( "58" );
                        $o_ALM_ItemMastDP->setPrecioCosto( $f_CostoTotalRef );
                        $o_ALM_ItemMastDP->setPrecioUnitarioLocal( $f_CostoTotalRef );
                        $o_ALM_ItemMastDP->setPrecioUnitarioDolares( $f_CostoTotalRef );
                        $o_ALM_ItemMastDP->setEstado( "I" );
                        $o_ALM_ItemMastDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                        $o_ALM_ItemMastDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                        $o_ALM_ItemMastDP->setEsInventariableFlag( "N" );
                        $o_ALM_ItemMastDP->setFusionarLoteFlag( "N" );
                        $o_ALM_ItemMastDP->setEsServicioConDias( "N" );
                        $o_ALM_ItemMastDP->setUsarDisponibleStock( "N" );
                        //$o_ALM_ItemMastDP->setUsarReservableStock( "N" );
                        $o_ALM_ItemMastDP->setUsarResevableStock( "N" );
                        $o_ALM_ItemMastDP->save();
                    }
                    else
                    {
                        $o_ALM_ItemMastDP = new ALM_ItemMastDP();
                        $o_ALM_ItemMastDP->setIdItem( $o_MKT_PromocionCabBN->getCodigoPromo() );
                        $o_ALM_ItemMastDP->setPrecioCosto( $f_CostoTotalRef );
                        $o_ALM_ItemMastDP->setPrecioUnitarioLocal( $f_CostoTotalRef );
                        $o_ALM_ItemMastDP->setPrecioUnitarioDolares( $f_CostoTotalRef );
                        $o_ALM_ItemMastDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                        $o_ALM_ItemMastDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                        $o_ALM_ItemMastDP->update();
                    }
                }
            }

            $a_Rs['error']    = false;
            $a_Rs['id']       = $i_Id;
        }
        catch ( Exception $o_Exception )
        {
            //pr( $o_Exception );
            $a_Rs['error']         = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }

        echo json_encode( $a_Rs );

        return ViewResponse::NONE;
    }
}