<?php
class familiaActions extends wtActions
{
    public function executeIndex()
    {
        
    }
    
    public function executeList()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        
    	$this->block = $this->getRequestParameter( 'block' );
    	
    	$o_MST_ClaseLineaFN = new MST_ClaseLineaFN();
        $o_MST_ClaseLineaFN->addOrderBy( MST_ClaseLineaFN::Descripcion, true );
        $this->a_MST_ClaseLineaBN = $o_MST_ClaseLineaFN->select();
    }
    
    public function executeGrid()
    {
        $block = $this->getRequestParameter( 'block' );
        $page  = $this->getRequestParameter( 'page' );
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $o_GridAction = new GridAction();
        $o_GridAction->setClassFind( new MST_ClaseFamiliaFN() );
        
        $o_GridAction->addAssignFilter( "IdLinea" );
        $o_GridAction->addAssignFilter( "Estado" );
        
        $o_GridAction->addConditionFilter( "Descripcion", MST_ClaseFamiliaFN::Descripcion, "LIKE", "%%s%" );
        
        $o_GridAction->addOrder( "IdLinea", MST_ClaseFamiliaFN::IdLinea );
        //$o_GridAction->addOrder( "Estado", MST_ClaseFamiliaFN::Estado );
        
        $o_GridAction->addOrderDefault( MST_ClaseFamiliaFN::IdLinea , true );
        
        $o_GridAction->addRowsToShow( "IdFamilia", "IdLinea", "LineaDesc", "Descripcion", "Codigo", "Estado" );
        
        //$o_GridAction->addInnerJoin( new MST_ClaseLineaFN(), "IdLinea", "Descripcion" );
        
        $o_GridAction->setNumberRecordsShow( 100 );
        
        $o_GridAction->initialize();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $a_ResultJson['page']    = $o_GridAction->getPage();
        $a_ResultJson['total']   = $o_GridAction->getTotalPage();
        $a_ResultJson['records'] = $o_GridAction->getTotalRecords();
        $a_ResultJson['rows']    = $o_GridAction->getResultArray();
        //pr( $a_ResultJson );
        echo json_encode( $a_ResultJson );
        
        return ViewResponse::NONE;   
    }

    public function executeAddedit()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        
        $this->block      = $this->getRequestParameter( 'block' );
        $this->i_Id       = $this->getRequestParameter( 'i_Id' );
        $this->s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        
        $this->s_Titulo = "Nueva Familia";
        $o_MST_ClaseFamiliaBN = new MST_ClaseFamiliaBN();
        $o_MST_ClaseFamiliaBN->setEstado( 'A' );
        $this->o_MST_ClaseFamiliaBN = $o_MST_ClaseFamiliaBN;
        
        if( $this->s_TipoProc == "upd" )
        {
            $this->s_Titulo = "Editar Familia";
            
            $o_MST_ClaseFamiliaFN= new MST_ClaseFamiliaFN();
            $this->o_MST_ClaseFamiliaBN = $o_MST_ClaseFamiliaFN->selectByPK( $this->i_Id );
        }
    }
   
    public function executeSaveAddEdit()
    {
        $block      = $this->getRequestParameter( 'block' );
        $i_Id       = $this->getRequestParameter( 'i_Id' );
        $s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        $TypeSub    = $this->getRequestParameter( 'TypeSub' );
        
        $IdLinea   = $this->getRequestParameter( 'IdLinea' );
        
        $Descripcion = trim( $this->getRequestParameter( 'Descripcion' ) );
        $Codigo      = trim( $this->getRequestParameter( 'Codigo' ) );
        $Estado      = $this->getRequestParameter( 'Estado' );
        try 
        {
            $o_MST_ClaseFamiliaDP = new MST_ClaseFamiliaDP();
            
            $o_MST_ClaseFamiliaDP->setIdLinea( (int) $IdLinea );
            $o_MST_ClaseFamiliaDP->setDescripcion( $Descripcion );
            $o_MST_ClaseFamiliaDP->setEstado( $Estado );

            if( $s_TipoProc == "nvo" )
            {
                //NUEVO
                $IdFamilia = MST_ClaseFamiliaFN::recuperarIdFamilia( $IdLinea );

                $Codigo = substr( $Descripcion, 0, 2 ).$IdFamilia;
                $o_MST_ClaseFamiliaDP->setCodigo( $Codigo );

                $o_MST_ClaseFamiliaDP->setIdLinea( ( int ) $IdLinea );
                $o_MST_ClaseFamiliaDP->setIdFamilia( ( int ) $IdFamilia );
                $o_MST_ClaseFamiliaDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                $o_MST_ClaseFamiliaDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                $o_MST_ClaseFamiliaDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $o_MST_ClaseFamiliaDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $b_Result = $o_MST_ClaseFamiliaDP->save();
                $i_Id = $IdFamilia;
            }
            else 
            {
                //UPDATE
                $o_MST_ClaseFamiliaDP->setIdFamilia( ( int ) $i_Id );
                $o_MST_ClaseFamiliaDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $o_MST_ClaseFamiliaDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $b_Result = $o_MST_ClaseFamiliaDP->update();
            }
            $a_Rs['type_sub'] = $TypeSub;
            $a_Rs['error']    = false;
            $a_Rs['id']       = $i_Id;
        }
        catch ( Exception $o_Exception )
        {
            $a_Rs['error']         = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }
        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }
    
    public function executeAudi()
    {
        $block          = $this->getRequestParameter( 'block' );
        $i_Id           = $this->getRequestParameter( 'i_Id' );
        $this->s_Topico = "Familia";
        
        $o_MST_ClaseFamiliaFN = new MST_ClaseFamiliaFN();
        $this->o_ObjectBN = $o_MST_ClaseFamiliaFN->selectByPK( $i_Id );
    }
    
    public function executeViewdel()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        
        $this->block      = $this->getRequestParameter( 'block' );
        $this->i_Id       = $this->getRequestParameter( 'i_Id' );
        $this->s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        
        $o_MST_ClaseFamiliaFN = new MST_ClaseFamiliaFN();
        $this->o_MST_ClaseFamiliaBN = $o_MST_ClaseFamiliaFN->selectByPK( $this->i_Id );
    }
    
    public function executeDeleteRow()
    {
        $block      = $this->getRequestParameter( 'block' );
        $i_Id       = $this->getRequestParameter( 'i_Id' );
        $s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        try 
        {
            
            $o_MST_ClaseFamiliaDP = new MST_ClaseFamiliaDP();
            $o_MST_ClaseFamiliaDP->setIdFamilia( ( int ) $i_Id );
            $o_MST_ClaseFamiliaDP->setEstado( "I" );
            $o_MST_ClaseFamiliaDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
            $o_MST_ClaseFamiliaDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
            $o_MST_ClaseFamiliaDP->update();

            $a_Rs['error']   = false;
            $a_Rs['id']      = $i_Id;
        }
        catch ( Exception $o_Exception )
        {
            $a_Rs['error']   = true;
            $a_Rs['mensaje_error_ex'] = $o_Exception->getMessage();
            $a_Rs['mensaje_error'] = "No se pudo eliminar el registro.".$o_Exception->getMessage();
        }
        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }
}