<?php
class catetallaActions extends wtActions
{
    public function executeIndex()
    {
    }

    public function executeList()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();

        $this->s_Titulo   = "Listado Categoria Talla";

        $o_MST_PersonaMastFN = new MST_PersonaMastFN();
        $o_MST_PersonaMastFN->setEsProveedor( "SI" );
        $o_MST_PersonaMastFN->setEstado( "A" );
        $this->a_MST_PersonaMast = $o_MST_PersonaMastFN->select();


    }

    public function executeGrid()
    {
        $block = $this->getRequestParameter( 'block' );
        $page  = $this->getRequestParameter( 'page' );

        //*set_header_utf8();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $o_GridAction = new GridAction();
        $o_GridAction->setClassFind( new MST_CategoriaTallaFN() );

        //$o_GridAction->addAssignFilter( "IdCompania" );
        $o_GridAction->addAssignFilter( "IdProveedor" );
        $o_GridAction->addAssignFilter( "Estado" );
        $o_GridAction->addConditionFilter( "Descripcion", MST_CategoriaTallaFN::Descripcion, "LIKE", "%%s%" );
        $o_GridAction->addConditionFilter( "TallaDesc", MST_CategoriaTallaFN::IdCatTalla, "IN", "( SELECT IdCatTalla FROM MST_CategoriaTallaRelacion where IdTalla IN ( SELECT IdTalla FROM MST_Talla where Descripcion like '%".$this->getRequestParameter( 'TallaDesc' )."%' ) )" );

        $o_GridAction->addOrderDefault( MST_CategoriaTallaFN::IdCatTalla, true );

        $o_GridAction->addRowsToShow( "IdCatTalla", "ProveedorDesc", "Descripcion", "Tallas", "Estado", "EstadoDesc" );

        $o_GridAction->setNumberRecordsShow( 100 );

        $o_GridAction->initialize();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $a_ResultJson['page']    = $o_GridAction->getPage();
        $a_ResultJson['total']   = $o_GridAction->getTotalPage();
        $a_ResultJson['records'] = $o_GridAction->getTotalRecords();
        $a_ResultJson['rows']    = $o_GridAction->getResultArray();
        //pr( $a_ResultJson );
        echo json_encode( $a_ResultJson );

        return ViewResponse::NONE;
    }

    public function executeAdd()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();

        $this->s_Titulo   = "Nueva Categoria Talla";
        $this->s_TipoProc = "nvo";

        $o_MST_PersonaMastFN = new MST_PersonaMastFN();
        $o_MST_PersonaMastFN->setEsProveedor( "SI" );
        $o_MST_PersonaMastFN->setEstado( "A" );
        $o_MST_PersonaMastFN->addOrderBy( MST_PersonaMastFN::NombreCompleto );
        $this->a_MST_PersonaMast = $o_MST_PersonaMastFN->select();

        $o_MST_TallaFN = new MST_TallaFN();
        $o_MST_TallaFN->setEstado( "A" );
        $this->a_MST_Talla = $o_MST_TallaFN->select();
    }

    public function executeEdit()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();

        $this->s_Titulo = "Editar Categoria Talla";
        $this->i_Id       = $this->getRequestParameter( 'id' );
        $this->s_TipoProc = "edit";

        $o_MST_PersonaMastFN = new MST_PersonaMastFN();
        $o_MST_PersonaMastFN->setEsProveedor( "SI" );
        $o_MST_PersonaMastFN->setEstado( "A" );
        $o_MST_PersonaMastFN->addOrderBy( MST_PersonaMastFN::NombreCompleto );
        $this->a_MST_PersonaMast = $o_MST_PersonaMastFN->select();

        $o_MST_TallaFN = new MST_TallaFN();
        $o_MST_TallaFN->setEstado( "A" );
        $this->a_MST_Talla = $o_MST_TallaFN->select();

        $o_MST_CategoriaTallaRelacionFN = new MST_CategoriaTallaRelacionFN();
        $o_MST_CategoriaTallaRelacionFN->setIdCatTalla( $this->i_Id );
        $a_MST_CategoriaTallaRelacion = $o_MST_CategoriaTallaRelacionFN->select();
        $this->a_CategoriaRelacion = array();
        foreach ( $a_MST_CategoriaTallaRelacion as $o_MST_CategoriaTallaRelacionBN )
        {
            $this->a_CategoriaRelacion[] = $o_MST_CategoriaTallaRelacionBN->getIdTalla();
        }

        $o_DefaultFN = new MST_CategoriaTallaFN();
        $this->o_DefaultBN = $o_DefaultFN->selectByPK( $this->i_Id );
        if( !$this->o_DefaultBN )
        {
            $this->o_DefaultBN = new MST_CategoriaTallaBN();
        }
    }

    public function executeSaveAddEdit()
    {
        $s_TipoProc    = $this->getRequestParameter( 'tipoProc' );

        $i_IdProveedor = intval( $this->getRequestParameter( 'IdProveedor' ) );
        $s_Descripcion = $this->getRequestParameter( 'Descripcion' );
        $s_Estado      = $this->getRequestParameter( 'Estado' );
        $a_IdTallas    = $this->getRequestParameter( 'IdTallas' );

        $i_IdCompania  = intval( myUser::getUser()->getIdCompania() );
        $i_IdSucursal  = intval( myUser::getUser()->getIdSucursal() );

        try
        {
            $o_DefaultDP = new MST_CategoriaTallaDP();

            $o_DefaultDP->setIdProveedor( $i_IdProveedor );
            $o_DefaultDP->setDescripcion( $s_Descripcion );
            $o_DefaultDP->setEstado( $s_Estado );

            if( $s_TipoProc == "nvo" )
            {
                //NUEVO
                $i_Id = MST_CategoriaTallaDP::recuperarId();
                $o_DefaultDP->setIdCatTalla( $i_Id );
                $o_DefaultDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                $o_DefaultDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                $o_DefaultDP->save();
            }
            else
            {
                //UPDATE
                $i_Id = intval( $this->getRequestParameter( 'id' ) );
                $o_DefaultDP->setIdCatTalla( $i_Id );
                $o_DefaultDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $o_DefaultDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $o_DefaultDP->update();

                MST_CategoriaTallaRelacionDP::eliminarPorCatTalla( $i_Id );
            }

            foreach ( $a_IdTallas as $s_IdTalla )
            {
                $i_IdTalla = intval( $s_IdTalla );

                $o_MST_CategoriaTallaRelacionDP = new MST_CategoriaTallaRelacionDP();
                $o_MST_CategoriaTallaRelacionDP->setIdCatTalla( $i_Id );
                $o_MST_CategoriaTallaRelacionDP->setIdTalla( $i_IdTalla );
                $o_MST_CategoriaTallaRelacionDP->save();
            }

            $a_Rs['error']    = false;
            $a_Rs['id']       = $i_Id;
        }
        catch ( Exception $o_Exception )
        {
            $a_Rs['error']         = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }

        echo json_encode( $a_Rs );

        return ViewResponse::NONE;
    }

    public function executeView()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();

        $this->s_Titulo   = "Mostrar Categoria Tallas";
        $this->i_Id       = $this->getRequestParameter( 'id' );
        $this->s_TipoProc = $this->getRequestParameter( 'tipoProc' );

        $o_MST_PersonaMastFN = new MST_PersonaMastFN();
        $o_MST_PersonaMastFN->setEsProveedor( "SI" );
        $o_MST_PersonaMastFN->setEstado( "A" );
        $this->a_MST_PersonaMast = $o_MST_PersonaMastFN->select();

        $o_MST_TallaFN = new MST_TallaFN();
        $o_MST_TallaFN->setEstado( "A" );
        $this->a_MST_Talla = $o_MST_TallaFN->select();

        $o_MST_CategoriaTallaRelacionFN = new MST_CategoriaTallaRelacionFN();
        $o_MST_CategoriaTallaRelacionFN->setIdCatTalla( $this->i_Id );
        $a_MST_CategoriaTallaRelacion = $o_MST_CategoriaTallaRelacionFN->select();
        $this->a_CategoriaRelacion = array();
        foreach ( $a_MST_CategoriaTallaRelacion as $o_MST_CategoriaTallaRelacionBN )
        {
            $this->a_CategoriaRelacion[] = $o_MST_CategoriaTallaRelacionBN->getIdTalla();
        }

        $o_DefaultFN = new MST_CategoriaTallaFN();
        $this->o_DefaultBN = $o_DefaultFN->selectByPK( $this->i_Id );
        if( !$this->o_DefaultBN )
        {
            $this->o_DefaultBN = new MST_CategoriaTallaBN();
        }
    }
}