<?php
class almacenActions extends wtActions
{
    public function executeIndex()
    {
        
    }
    
    public function executeList()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        $this->block = $this->getRequestParameter( 'block' );
    }
    
    public function executeGrid()
    {
        $block = $this->getRequestParameter( 'block' );
        $page  = $this->getRequestParameter( 'page' );
        
        set_header_utf8();
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $o_GridAction = new GridAction();
        $o_GridAction->setClassFind( new ALM_AlmacenMastFN() );
        
        //$o_GridAction->addMethodDefault( "IdCompania", myUser::getUser()->getIdBusiness() );
        //$o_GridAction->addMethodDefault( "IdSucursal", myUser::getUser()->getIdSucursal() );
        $o_GridAction->addAssignFilter( "IdCompania" );
        $o_GridAction->addAssignFilter( "IdSucursal" );

        $o_GridAction->addConditionFilter( "DescripcionLocal", ALM_AlmacenMastFN::DescripcionLocal, "LIKE", "%%s%" );
        
        $o_GridAction->addOrder( "DescripcionLocal", ALM_AlmacenMastFN::DescripcionLocal);
        $o_GridAction->addOrder( "Estado", ALM_AlmacenMastFN::Estado );
        $o_GridAction->addOrder( "IdCompania", ALM_AlmacenMastFN::IdCompania );
        $o_GridAction->addOrderDefault( ALM_AlmacenMastFN::IdAlmacen , true );
        $o_GridAction->setNumberRecordsShow( 15 );
        $o_GridAction->setControlArray( false );
        
        $o_GridAction->initialize();
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $a_ResultJson['page']    = $o_GridAction->getPage();
        $a_ResultJson['total']   = $o_GridAction->getTotalPage();
        $a_ResultJson['records'] = $o_GridAction->getTotalRecords();
        $a_ResultJson['rows']    = $o_GridAction->getResultArray();
        
        $a_ResultSelect = $o_GridAction->getResultSelect();
        $a_Rs = array();
        
        foreach ( $a_ResultSelect as $iKey => $o_ObjClassBN )
        {
            $o_GSS_CompaniaFN = new GSS_CompaniaFN();
            $o_GSS_CompaniaBN = $o_GSS_CompaniaFN->selectByPK( $o_ObjClassBN->getIdCompania() );
                   
            $o_ALM_AlmacenGrupoFN = new ALM_AlmacenGrupoFN();
            $o_ALM_AlmacenGrupoBN = $o_ALM_AlmacenGrupoFN->selectByPK( $o_ObjClassBN->getIdAlmacenGrupo() );
            
            if(!is_object($o_ALM_AlmacenGrupoBN)) $o_ALM_AlmacenGrupoBN = new ALM_AlmacenGrupoBN();
            if(!is_object($o_GSS_CompaniaBN)) $o_GSS_CompaniaBN = new GSS_CompaniaBN();
            
            $a_Rs[] = array(  
                                "IdAlmacen"             => utf8_encode( $o_ObjClassBN->getIdAlmacen()),
                                "CompaniaDesc"          => utf8_encode( $o_GSS_CompaniaBN->getDescripcionCorta() ),
                                "IdAlmacenGrupo"        => utf8_encode( $o_ALM_AlmacenGrupoBN->getDescripcion() ),
                                "DescripcionLocal"      => utf8_encode( $o_ObjClassBN->getDescripcionLocal() ),
                                "AlmacenVentaFlag"      => utf8_encode( $o_ObjClassBN->getAlmacenVentaFlag() ),
                                "AlmacenProduccionFlag" => $o_ObjClassBN->getAlmacenProduccionFlag(),
                                "Estado"                => $o_ObjClassBN->getEstado(),
                                "DescripcionSucursal"   => $o_ObjClassBN->getDescripcionSucursal()
                           );
        }
        $a_ResultJson['rows'] = $a_Rs;
        //pr( $a_ResultJson );
        echo json_encode( $a_ResultJson );

        return ViewResponse::NONE;   
    }
    
    public function executeAddedit()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        $this->block      = $this->getRequestParameter( 'block' );
        $this->i_Id       = $this->getRequestParameter( 'i_Id' );
        $this->s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        
        $o_GSS_CompaniaFN = new GSS_CompaniaFN();
        $o_GSS_CompaniaFN->setEstado( 'A' );
        $o_GSS_CompaniaFN->addOrderBy( GSS_CompaniaFN::IdCompania, true );
        $a_GSS_Compania = $o_GSS_CompaniaFN->select();
        
        $o_ALM_AlmacenGrupoFN = new ALM_AlmacenGrupoFN();
        $o_ALM_AlmacenGrupoFN->addCondition( ALM_AlmacenGrupoFN::Estado ,"<>","I" );
        //$o_ALM_AlmacenGrupoFN->setIdCompania( myUser::getUser()->getIdBusiness() );
        $a_Result  = $o_ALM_AlmacenGrupoFN->select();
        
        $this->a_GSS_Compania = $a_GSS_Compania;
        $this->a_GrupoAlmacen = $a_Result;
        
        //SE RECUPERA SUCURSAL
        $o_GSS_SucursalFN = new GSS_SucursalFN();
        //$o_GSS_SucursalFN->setIdCompania( myUser::getUser()->getIdBusiness() );
        //$this->a_GSS_Sucursal = $o_GSS_SucursalFN->select();
        $this->a_GSS_Sucursal = array();
        
        $this->s_Titulo = "Nuevo Almacén";
        
        //$i_IdSucursalSel = myUser::getUser()->getIdSucursal();
        //$s_IdConcat      = str_pad( ALM_AlmacenMastFN::recuperarId( myUser::getUser()->getIdBusiness(), myUser::getUser()->getIdSucursal() ), 2, "0", STR_PAD_LEFT); //SOLO HASTA 99 ALMACENES

        $o_ALM_AlmacenMastBN = new ALM_AlmacenMastBN();
        $o_ALM_AlmacenMastBN->setEstado('A');
        $o_ALM_AlmacenMastBN->setIdAlmacen( "ALM000" );
        
        $this->o_ALM_AlmacenMastBN = $o_ALM_AlmacenMastBN;

        if( $this->s_TipoProc == "upd" )
        {
            $this->s_Titulo = "Editar Almacén";

            $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
            $o_ALM_AlmacenMastBN = $o_ALM_AlmacenMastFN->selectByPK( $this->i_Id );
            //$s_IdUnidadProduccion = $o_ALM_AlmacenMastBN->getIdUnidadProduccion();
            $this->o_ALM_AlmacenMastBN = $o_ALM_AlmacenMastBN;
            
            //SE RECUPERA SUCURSAL
            $o_GSS_SucursalFN = new GSS_SucursalFN();
            $o_GSS_SucursalFN->setIdCompania( $this->o_ALM_AlmacenMastBN->getIdCompania() );
            $this->a_GSS_Sucursal = $o_GSS_SucursalFN->select();
                       
            $o_ALM_AlmacenGrupoFN = new ALM_AlmacenGrupoFN();
            $o_ALM_AlmacenGrupoFN->setEstado('A');
            $o_ALM_AlmacenGrupoFN->setIdCompania( $this->o_ALM_AlmacenMastBN->getIdCompania() );
            $this->a_GrupoAlmacen = $o_ALM_AlmacenGrupoFN->select();
        }
    }
    
    public function executeRequest()
    {
        $block      = $this->getRequestParameter( 'block' );
        $IdCompania = $this->getRequestParameter( 'IdCompania' );
        $IdUnidadProduccion = $this->getRequestParameter( 'IdUnidadProduccion' );
        $TipoProc   = $this->getRequestParameter( 'TipoProc' );
        
        switch ( $TipoProc )
        {
            case "LoadGrupo":
                $o_ALM_AlmacenGrupoFN = new ALM_AlmacenGrupoFN();
                $o_ALM_AlmacenGrupoFN->setIdCompania( $IdCompania );
                $a_Result  = $o_ALM_AlmacenGrupoFN->select();
                $s_NameId  = "getIdAlmacenGrupo";
                $s_NameDes = "getDescripcion";
            break;
            case "LoadSucursal":
                $o_GSS_SucursalFN = new GSS_SucursalFN();
                $o_GSS_SucursalFN->setIdCompania( $IdCompania );
                $a_Result  = $o_GSS_SucursalFN->select();
                $s_NameId  = "getIdSucursal";
                $s_NameDes = "getDescripcion";
            break;
        }
        foreach ( $a_Result as $i_Key => $o_ObjectBN )
        {
            $a_lst[$o_ObjectBN->$s_NameId()] = $o_ObjectBN->$s_NameDes();
        }
        echo json_encode( $a_lst );
        return ViewResponse::NONE;
    }
    
    public function executeSaveAddEdit()
    {
        $block      = $this->getRequestParameter( 'block' );
        $i_Id       = $this->getRequestParameter( 'i_Id' );
        $s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        $TypeSub    = $this->getRequestParameter( 'TypeSub' );
        
        $IdAlmacen        = $this->getRequestParameter( 'Codigo' );
        $IdCompania       = $this->getRequestParameter( 'IdCompania' );
        $IdGrupoAlmacen   = $this->getRequestParameter( 'IdGrupoAlmacen' );
        $DescripcionLocal = $this->getRequestParameter( 'DescripcionLocal' );
        $Direccion        = $this->getRequestParameter( 'Direccion' );
        $AlmacenVentaFlag = is_null( $this->getRequestParameter( 'AlmacenVentaFlag' ) ) ? "N" : $this->getRequestParameter( 'AlmacenVentaFlag' );
        $Estado           = $this->getRequestParameter( 'Estado' );
        $IdSucursal       = $this->getRequestParameter( 'IdSucursal' );
        $Codigo           = $this->getRequestParameter( 'Codigo' );
       
        try 
        {
            myUser::getUser()->validar_session();

            $o_ALM_AlmacenMastDP = new ALM_AlmacenMastDP();
            $o_ALM_AlmacenMastDP->setIdCompania( ( int ) $IdCompania );
            $o_ALM_AlmacenMastDP->setIdSucursal( ( int ) $IdSucursal );
            $o_ALM_AlmacenMastDP->setIdAlmacenGrupo($IdGrupoAlmacen);
            $o_ALM_AlmacenMastDP->setDescripcionLocal( $DescripcionLocal );
            $o_ALM_AlmacenMastDP->setDireccion( $Direccion );
            $o_ALM_AlmacenMastDP->setCodigo( $Codigo );
            $o_ALM_AlmacenMastDP->setAlmacenVentaFlag( $AlmacenVentaFlag );
            $o_ALM_AlmacenMastDP->setEstado( $Estado );
            
            if( $s_TipoProc == "nvo" )
            {
                //NUEVO
                $s_IdConcat = str_pad( ALM_AlmacenMastFN::recuperarId( myUser::getUser()->getIdBusiness(), $IdSucursal ), 2, "0", STR_PAD_LEFT ); //SOLO HASTA 99 ALMACENES
                $IdAlmacen  = "A".$IdCompania.$IdSucursal.$s_IdConcat;

                //if( !$Codigo ){ $o_ALM_AlmacenMastDP->setCodigo( $IdAlmacen ); }
                $o_ALM_AlmacenMastDP->setCodigo( $IdAlmacen );

                $o_ALM_AlmacenMastDP->setIdAlmacen( $IdAlmacen );
                $o_ALM_AlmacenMastDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                $o_ALM_AlmacenMastDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                $b_Result = $o_ALM_AlmacenMastDP->save();
                $i_Id = $IdAlmacen;
            }
            else 
            {
                //UPDATE
                $o_ALM_AlmacenMastDP->setIdAlmacen( $i_Id );
                $o_ALM_AlmacenMastDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $o_ALM_AlmacenMastDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $b_Result = $o_ALM_AlmacenMastDP->update();
            }
            
            $a_Rs['type_sub'] = $TypeSub;
            $a_Rs['error']    = false;
            $a_Rs['id']       = $i_Id;
        }
        catch ( Exception $o_Exception )
        {
            $a_Rs['error']         = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }
        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }
    
    public function executeAudi()
    {
        $block          = $this->getRequestParameter( 'block' );
        $i_Id           = $this->getRequestParameter( 'i_Id' );
        $this->s_Topico = "Almacen";
        $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
        $this->o_ObjectBN = $o_ALM_AlmacenMastFN->selectByPK( $i_Id );
    }
    
    public function executeViewdel()
    {
        $this->block      = $this->getRequestParameter( 'block' );
        $this->i_Id       = $this->getRequestParameter( 'i_Id' );
        $this->s_TipoProc = $this->getRequestParameter( 's_TipoProc' );

        $o_GSS_CompaniaFN = new GSS_CompaniaFN();
        $o_GSS_CompaniaFN->setEstado( 'A' );
        $o_GSS_CompaniaFN->addOrderBy( GSS_CompaniaFN::IdCompania, true );
        $this->a_GSS_Compania = $o_GSS_CompaniaFN->select();

        $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
        $o_ALM_AlmacenMastBN = $o_ALM_AlmacenMastFN->selectByPK( $this->i_Id );
        //$s_IdUnidadProduccion = $o_ALM_AlmacenMastBN->getIdUnidadProduccion();  
        
        $o_ALM_AlmacenGrupoFN = new ALM_AlmacenGrupoFN();
        //$o_ALM_AlmacenGrupoFN->setIdCompania( myUser::getUser()->getIdBusiness() );
        $this->a_GrupoAlmacen  = $o_ALM_AlmacenGrupoFN->select();
        
        //SE RECUPERA SUCURSAL
        $o_GSS_SucursalFN = new GSS_SucursalFN();
        $o_GSS_SucursalFN->setIdCompania( $o_ALM_AlmacenMastBN->getIdCompania() );
        $this->a_GSS_Sucursal = $o_GSS_SucursalFN->select();
       
        $this->o_ALM_AlmacenMastBN = $o_ALM_AlmacenMastBN;
    }
    
    public function executeDeleteRow()
    {
        $block      = $this->getRequestParameter( 'block' );
        $i_Id       = $this->getRequestParameter( 'i_Id' );
        $s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        try 
        {
            $o_ALM_AlmacenMastDP = new ALM_AlmacenMastDP();
            $o_ALM_AlmacenMastDP->setIdCompania( myUser::getUser()->getIdBusiness() );
            $o_ALM_AlmacenMastDP->setIdAlmacen( $i_Id );
            $o_ALM_AlmacenMastDP->setEstado( "I" );
            $o_ALM_AlmacenMastDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
            $o_ALM_AlmacenMastDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
            $b_Result = $o_ALM_AlmacenMastDP->update();
            //$o_ALM_AlmacenMastDP->delete();

            $a_Rs['error']   = false;
            $a_Rs['id']      = $i_Id;
        }
        catch ( Exception $o_Exception )
        {
            $a_Rs['error']   = true;
            $a_Rs['mensaje_error_ex'] = $o_Exception->getMessage();
            $a_Rs['mensaje_error'] = "No se pudo eliminar el registro.";
        }
        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }
}