<?php use_helper( 'UrlFunctions' ); ?>
<?php use_helper( 'UtilFunctions' ); ?>
<?php use_helper( 'IncludePartial' ); ?>

<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
    <meta name="description" content="" />
    <meta name="author" content="" />
    <title>AdHoc</title>
    <!-- Favicon-->
    <link rel="icon" type="image/x-icon" href="assets/favicon.ico" />
    <!-- Bootstrap Icons-->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.5.0/font/bootstrap-icons.css" rel="stylesheet" />
    <!-- Google fonts-->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@100;400;600;700&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css?family=Merriweather+Sans:400,700" rel="stylesheet" />
    <link href="https://fonts.googleapis.com/css?family=Merriweather:400,300,300italic,400italic,700,700italic" rel="stylesheet" type="text/css" />
    <!-- SimpleLightbox plugin CSS-->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/SimpleLightbox/2.1.0/simpleLightbox.min.css" rel="stylesheet" />
    <!-- Core theme CSS (includes Bootstrap)-->
    <link href="" rel="stylesheet" />
    <link rel="stylesheet" type="text/css" href="<?=Constantes::ROOT_DIR_APP?>web/lib/bootstrap/css/styles_login.css" />
</head>

<style type="text/css">
    header.masthead {
        padding-top: 10rem;
        padding-bottom: calc(10rem - 4.5rem);
        background: linear-gradient(to bottom, rgba(0, 0, 0, 0.1) 0%, rgba(0, 0, 0, 0.1) 100%), url( "<?=Constantes::ROOT_DIR_IMG?>login/fondo.jpg" );
        background-position: center;
        background-repeat: no-repeat;
        background-attachment: scroll;
        background-size: cover;
    }
</style>

<body id="page-top">
<!-- Masthead-->
<header class="masthead">
    <div class="container h-100">
        <div class="h-100 cont_col_ig align-items-center justify-content-center text-center">
            <div class="row cont_col_ d-flex">
                <div class="col-12 col-md-4 cont_log_ad p-0">
                    <img class="img-fluid" src="<?=Constantes::ROOT_DIR_IMG?>login/logo-kullky-sistema-3.png" alt="">
                </div>
                <div class="col-12 col-md-5 p-0 bg_wh">
                    <div class="cont-login_">
                        <img class="img-logo m-auto" src="<?=Constantes::ROOT_DIR_IMG?>login/password.png" alt="" width="80">
                        <h3 class="txt_contr text-center mb-3 mt-3">
                            INGRESO AL SISTEMA
                        </h3>

                        <form id="contactForm" class="form-signin login100-form" style="" method="POST" action="" >
                            <input type="hidden" name="Control" id="Control" value="ok">

                            <!-- Name input-->
                            <div class="form-floating mb-3">
                                <input class="form-control" id="nickname" name="nickname" type="text" placeholder="Usuario" autocomplete="off" onkeyup="activePlaceholder();" onblur="findCompany( this.value );" />
                                <label for="usuario">Usuario</label>
                                <div class="invalid-feedback" data-sb-feedback="usuario:required">Usuario is required.</div>
                            </div>
                            <!-- Email address input-->
                            <div class="form-floating mb-1">
                                <input class="form-control" id="password" name="password" type="password" placeholder="name@example.com" />
                                <label for="password">Contraseña</label>
                                <div class="invalid-feedback" data-sb-feedback="password:required">An email is required.</div>
                                <div class="invalid-feedback" data-sb-feedback="password:password">Su contraseña no es válida</div>
                            </div>
                            <div id="content_company" class="mb-3" style="text-align: left;">
                                <span class="txt1 p-b-11">Empresa</span>
                                <div class="form-label-group">
                                    <select class="form-control" id="IdCompania" name="IdCompania" required>
                                        <!--<option value="1"> DROINSUR EIRL - EMP </option>
                                        <option value="2"> DISDROFAR S.A.C. - EMP </option>
                                        <option value="3"> DISUR EIRL - EMP </option>-->
                                    </select>
                                </div>

                                <span class="txt1 p-b-11">Sucursal</span>
                                <div class="form-label-group">
                                    <select class="form-control" id="IdSucursal" name="IdSucursal" required>
                                        <!--<option value="1"> SUC DROGUERIA DROINSUR E.I.R.L. </option>-->
                                    </select>
                                </div>
                            </div>

                            <!-- Submit Button-->
                            <div class="row cont_txt_bt">
                                <div class="col-12 col-md-8 pr-0">
                                    <p class="text-danger">
                                        <?php if( $message_error ){ ?>
                                            <?=$message_error?>
                                        <?php } ?>
                                    </p>
                                </div>
                                <div class="col-12 col-md-4">
                                    <button class="btn btn-primary btn-lg btn_lgg" id="" type="submit">ENVIAR</button>
                                    <div id="submitSuccessMessage"></div>
                                    <div id="submitErrorMessage"></div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="col cont_log_inf d-flex">
                    <div class="barra_v"></div>
                    <p class="adoc">
                        alikullky.com
                    </p>
                </div>
                <div class="row cont_info">
                    <div class="cont_1 col-md-6">
                        <img src="<?=Constantes::ROOT_DIR_IMG?>login/info.png" alt="" width="40" height="40">
                        <a href="javascript:void(0)" class="txt_info">
                            ¿Cómo usar el sistema de seguimiento de expedientes?
                        </a>
                    </div>
                    <div class="cont_2 col-md-6">
                        <p class="creditos">
                            SISTEMA PROPIEDAD DE ALIKULLKY
                        </p>
                    </div>

                </div>
            </div>

        </div>
    </div>
</header>


<!-- Bootstrap core JS-->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.bundle.min.js"></script>
<!-- SimpleLightbox plugin JS-->
<script src="https://cdnjs.cloudflare.com/ajax/libs/SimpleLightbox/2.1.0/simpleLightbox.min.js"></script>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<!-- Core theme JS-->
<script src="<?=Constantes::ROOT_DIR_APP?>web/lib/bootstrap/js/scripts_login.js"></script>

<script type="text/javascript" src="<?=Constantes::ROOT_DIR_APP?>web/js/jquery/default/index.js"></script>
<script type="text/javascript" src="<?=Constantes::ROOT_DIR_APP?>web/js/jquery/default/php.js"></script>
<!-- * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *-->
<!-- * *                               SB Forms JS                               * *-->
<!-- * * Activate your form at https://startbootstrap.com/solution/contact-forms * *-->
<!-- * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *-->

<script type="text/javascript">
    function ajustar() {
        var tamano_height = jQuery('.cont_log_ad').height();
        jQuery('.bg_wh').height(tamano_height);
    }
    /*jQuery(window).load
     (
     function()
     {
     jQuery(window).resize
     (
     function()
     {
     if (jQuery(window).width() >= 1024)
     {
     ajustar();
     }
     else
     {
     jQuery('.bg_wh').height(330);
     }
     }
     );
     }
     );*/
    ajustar();
</script>

<script type="text/javascript">
    activePlaceholder = function( eve, elm )
    {
        elm = document.getElementById( "nickname" );
        if( $( elm ).val() != "" )
        {
            $( "label[for='"+elm.id+"']" ).addClass( "placeholder-shown" );
        }
        else
        {
            $( "label[for='"+elm.id+"']" ).removeClass( "placeholder-shown" );
        }

        elm = document.getElementById( "password" );
        if( $( elm ).val() != "" )
        {
            $( "label[for='"+elm.id+"']" ).addClass( "placeholder-shown" );
        }
        else
        {
            $( "label[for='"+elm.id+"']" ).removeClass( "placeholder-shown" );
        }
    }
    findCompany = function( value )
    {
        if( trim( value ) != "" )
        {
            $( '#IdCompania' )[0].options.length=0;
            executeAjaxUpdater
            (
                'content_company',
                '<?php echo buildUrl( 'user/findCompany' ) ?>',
                'nickname=' + value,
                function()
                {
                    console.log( "Request: OK" );
                }
            );
        }
    }
    showAlertBootStrap = function( elm_id_content, class_default, message_alert )
    {
        var html_alert = '<div class="alert ' + class_default + ' alert-dismissible fade show" role="alert"> ' +
            '' + message_alert +
            '<button type="button" class="close" data-dismiss="alert" aria-label="Close">' +
            '<span aria-hidden="true">&times;</span>' +
            '</button>' +
            '</div>';
        $( "#" + elm_id_content ).append( html_alert );
    }
</script>

</body>

</html>