<?php
class centrocostoActions extends wtActions
{
    public function executeList()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
    }
    
    public function executeGrid()
    {
        $page  = $this->getRequestParameter( 'page' );
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $o_GridAction = new GridAction();
        $o_GridAction->setClassFind( new GSS_CentroCostosFN() );
        
        $o_GridAction->addConditionFilter( "Descripcion", GSS_CentroCostosFN::Descripcion, "LIKE", "%%s%" );
        
        $o_GridAction->addOrderDefault( GSS_CentroCostosFN::IdCeCostos , true );
        
        $o_GridAction->addRowsToShow( "IdCeCostos", "Codigo", "Descripcion", "Estado" );
        
        $o_GridAction->setNumberRecordsShow( 15 );
        
        $o_GridAction->initialize();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $a_ResultJson['page']    = $o_GridAction->getPage();
        $a_ResultJson['total']   = $o_GridAction->getTotalPage();
        $a_ResultJson['records'] = $o_GridAction->getTotalRecords();
        $a_ResultJson['rows']    = $o_GridAction->getResultArray();
        //pr( $a_ResultJson );
        echo json_encode( $a_ResultJson );
        
        return ViewResponse::NONE; 
    }
    
    public function executeAddedit()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        
        $this->i_Id       = $this->getRequestParameter( 'i_Id' );
        $this->s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        
        $this->s_Titulo = "Nuevo Centro de Costos";
        $o_DefaultBN = new GSS_CentroCostosFN();
        $o_DefaultBN->setEstado('A');
        $this->o_DefaultBN = $o_DefaultBN;
        if( $this->s_TipoProc == "upd" )
        {
            $this->s_Titulo = "Editar Centro de Costos";
            $o_DefaultFN = new GSS_CentroCostosFN();
            $this->o_DefaultBN = $o_DefaultFN->selectByPK( $this->i_Id );
        }
    }
    
    public function executeSaveAddEdit()
    {
        $i_Id       = $this->getRequestParameter( 'i_Id' );
        $s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        $TypeSub    = $this->getRequestParameter( 'TypeSub' );
        
        $s_Descripcion = $this->getRequestParameter( 'Descripcion' );
        $s_Codigo      = $this->getRequestParameter( 'Codigo' );
        $s_Estado      = $this->getRequestParameter( 'Estado' );
        try
        {
            $o_DefaultDP = new GSS_CentroCostosDP();
            
            $o_DefaultDP->setDescripcion( $s_Descripcion );
            $o_DefaultDP->setEstado( $s_Estado );
            if( $s_TipoProc == "nvo" )
            {
                //NUEVO
                $i_Id = GSS_CentroCostosDP::recuperarId();
                
                $o_DefaultDP->setIdCeCostos( $i_Id );
                $o_DefaultDP->setCodigo( str_pad( $i_Id, 4, "0", STR_PAD_LEFT ) );                
                $o_DefaultDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                $o_DefaultDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                $o_DefaultDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $o_DefaultDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $b_Result = $o_DefaultDP->save();
            }
            else
            {
                //UPDATE
                $i_Id = ( int ) $this->getRequestParameter( 'i_Id' );
                $o_DefaultDP->setIdCeCostos( $i_Id );
                $o_DefaultDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $o_DefaultDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $b_Result = $o_DefaultDP->update();
            }
            $a_Rs['type_sub'] = $TypeSub;
            $a_Rs['error']    = false;
            $a_Rs['id']       = $i_Id;
        }
        catch ( Exception $o_Exception )
        {
            $a_Rs['error']         = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }
        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }
    
    public function executeViewdel()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        
        $this->i_Id       = $this->getRequestParameter( 'i_Id' );
        $this->s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        
        $this->s_Titulo = "Centro de Costos";
        
        $o_DefaultFN = new GSS_CentroCostosFN();
        $this->o_DefaultBN = $o_DefaultFN->selectByPK( $this->i_Id );
    }
}