<?php use_helper( 'UrlFunctions' ); ?>
<?php use_helper( 'IncludePartial' ); ?>
<?php use_helper( 'UtilFunctions' ); ?>

<link rel="stylesheet" type="text/css" media="screen" href="https://cdn.datatables.net/responsive/2.2.5/css/responsive.bootstrap4.min.css" />
<link rel="stylesheet" type="text/css" media="screen" href="https://cdn.datatables.net/1.10.21/css/dataTables.bootstrap4.min.css" />
<link rel="stylesheet" type="text/css" media="screen" href="https://cdn.datatables.net/fixedheader/3.1.7/css/fixedHeader.dataTables.min.css" />

<!--<link rel="stylesheet" type="text/css" media="screen" href="https://cdn.datatables.net/1.10.21/css/jquery.dataTables.min.css" />-->

<script type="text/javascript" src="https://cdn.datatables.net/1.10.21/js/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/1.10.21/js/dataTables.bootstrap4.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/responsive/2.2.5/js/dataTables.responsive.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/responsive/2.2.5/js/responsive.bootstrap4.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/fixedheader/3.1.7/js/dataTables.fixedHeader.min.js"></script>

<script type="text/javascript">
crearArchivoParaImprimirGuia = function()
{
    if ( !$( '#SerieDocumentoFiscal' ).val() ) 
    {
         alert( "Debe de ingresar la Serie." );
         return false;
    }
    if ( !$( '#NumeroDocumentoFiscal' ).val() ) 
    {
         alert( "Debe de ingresar el Numero de Guia." );
         return false;
    }
    x = confirm( "Esta seguro que desea imprimir la Guia?" );
    if( x )
    {
        blockContent( "form1" );
        
        var strFormSerialize = $( 'form' ).serialize();
        strFormSerialize += "&TipoProc=CrearArchivoPrintGuia";
        
        executeAjaxJson
        ( 
            "<?php echo buildUrl( 'transporte/request' ) ?>", 
            strFormSerialize,
            function( o_json )
            {
                console.log( o_json );
                unBlockContent( "form1" );
                if( o_json.error )
                {
                    mostrarMensajeError( o_json.mensaje_error );
                    return false;
                }
                actualizarDocumentoFiscalGuiaRem();
                imprimirEnLocalhost( o_json.nombre_archivo );

                parent.buscarRutaAsignada();
                parent.closeWindow();
            } 
        );
    }
}
imprimirEnLocalhost = function( nombre_archivo )
{
    blockContent( "form1" );
    
    var strFormSerialize = $( 'form' ).serialize();
    strFormSerialize += "&nombre_archivo=" + nombre_archivo;
    
    console.log( JSON.stringify( strFormSerialize ) );
    
    /*
    executeAjaxJson
    ( 
        "http://localhost/print_doc/imprimir_guia.php", 
        strFormSerialize,
        function( o_json )
        {
            console.log( o_json );
            unBlockContent( "form1" );
            ocultarCargaImg();
            if( o_json.error )
            {
                mostrarMensajeError( o_json.mensaje_error );
                return false;
            }
            actualizarDocumentoFiscalGuiaRem();
        } 
    );
    */
    $.ajax
    (
        {
            url: "http://localhost/print_doc/imprimir_guia.php",
            type: "POST",
            crossDomain: true,
            //data: JSON.stringify( strFormSerialize ),
            data: strFormSerialize,
            dataType: "json",
            success: function ( o_json ) 
            {
                console.log( o_json );
                unBlockContent( "form1" );
                if( o_json.error )
                {
                    mostrarMensajeError( o_json.mensaje_error );
                    return false;
                }
                //actualizarDocumentoFiscalGuiaRem();
            },
            error: function ( xhr, status ) 
            {
                alert("error");
            }
        }
    );
}
actualizarDocumentoFiscalGuiaRem = function()
{
    blockContent( "form1" );
    
    var strFormSerialize = $( 'form' ).serialize();
    strFormSerialize += "&TipoProc=actualizarGuiaRemision";
    
    executeAjaxJson
    ( 
        "<?php echo buildUrl( 'transporte/request' ) ?>", 
        strFormSerialize,
        function( o_json )
        {
            console.log( o_json );
            unBlockContent( "form1" );
            if( o_json.error )
            {
                //mostrarMensajeError( o_json.mensaje_error );
                return false;
            }
        } 
    );
}
ImprimirGuiaFormatoPDF = function()
{
    //validacion
    pr( "ingresa" );
	var elms = $( "#content_grid" ).find( ":input[type=text]" );

    var b_Control = true;
    var f_SumaCantidad = 0;
    
    $.each
    (
        elms, function( index, elm )
        {
            if( $( elm ).val().trim() != "" )
            {
            	var s_IdItem      = $( elm ).attr( "iditem" );
            	var f_StockFisico = parseFloat( $( elm ).attr( "stockfis" ) );
                var f_Cantidad    = parseFloat( $( elm ).val() );
                
                if( f_Cantidad > 0 )
                {
                    if( f_Cantidad > f_StockFisico )
                    {
                    	showAlertBootStrap( 'content_alert', 'alert-danger', "La cantidad ingresa para el producto ["+s_IdItem+"] es mayor al Stock Fisico." );
                    	b_Control = false;
                    }
                    f_SumaCantidad = f_SumaCantidad + f_Cantidad;
                }
            }
            pr( f_StockFisico + " - " + f_Cantidad );
        }
    );

    if( f_SumaCantidad <= 0 )
    {
    	showAlertBootStrap( 'content_alert', 'alert-danger', "Para generar Guia de Remision es necesario ingresar una cantidad." );
    	b_Control = false;
    }

    if( b_Control )
    {
        x = confirm( "Esta seguro de imprimir la Guia?" );
        if( x )
        {
        	blockContent( 'form1' );
            var strFormSerialize = $( '#form1' ).serialize();
            //window.open('<?=buildUrl( 'transporte/generarGuiaRem' )?>?' + strFormSerialize, '_blank', '');
            executeAjaxJson
            ( 
                "<?php echo buildUrl( 'transporte/generarGuiaRem' ) ?>", 
                strFormSerialize,
                function( o_json )
                {
                    unBlockContent( "form1" );
                    if( o_json.error )
                    {
                    	showAlertBootStrap( 'content_alert', 'alert-danger', o_json.mensaje_error );
                        //mostrarMensajeError(  );
                        return false;
                    }
                    window.open( o_json.enlace_pdf, '_blank', '' );
                    parent.realizarNuevaBusqueda();
                    parent.closeWindow();
                } 
            );
        }
    }
    return false;
}
</script>

<style type="text/css">
/*
#example_wrapper .row
{
    margin-right: 0;
    margin-left: 0;
}
table.dataTable tbody tr:hover 
{
   background-color: #DAE6FE !important;;
}
*/
.table td, .table th 
{
    /*padding: 8px;*/
    font-size: 13px;
}
th { white-space: nowrap; }

fieldset.scheduler-border 
{
    border: 1px solid #ccc !important;
    padding: 0 0.5em 0.5em 0.5em !important;
    margin: 0 0 0.5em 0 !important;
    -webkit-box-shadow: 0px 0px 0px 0px #000;
    box-shadow: 0px 0px 0px 0px #000;
}

legend.scheduler-border 
{
    font-size: 1em !important;
    font-weight: bold !important;
    text-align: left !important;
    width: auto;
    padding: 0 5px;
    border-bottom: none;
    margin-bottom: 0;    
}

</style>

<div class="marco">
    <div class="table-responsive">
        <table class="table table-borderless" style="margin-bottom: 0px; line-height: 0.5; padding: .50rem; ">
            <tbody>
                <tr>
                    <th class="text-nowrap" scope="row">Nro Documento:</th>
                    <td class="text-nowrap" style="color: #fc6d00;"><?=$o_VTA_DocumentoBN->getDocumentoTipoSerieNumero()  ?></td>
                    <th class="text-nowrap" scope="row">Fecha:</th>
                    <td class="text-nowrap"><?=str_pad( $o_VTA_DocumentoBN->getFechaDocumento(), 10, "0", STR_PAD_LEFT )?></td>
                    <th class="text-nowrap" scope="row">Cliente:</th>
                    <td class="text-nowrap" ><?=$o_VTA_DocumentoBN->getClienteNombre();?></td>
                    <th class="text-nowrap" scope="row">Cliente Documento:</th>
                    <td class="text-nowrap" ><?=$o_VTA_DocumentoBN->getClienteTipoDoc();?> <?=$o_VTA_DocumentoBN->getClienteRUC();?></td> 
                </tr>
                <tr>
                    <th class="text-nowrap" scope="row">Proyecto:</th>
                    <td class="text-nowrap" style="color: #fc6d00;"><?=$o_VTA_PrsProyectosBN->getNombreProyecto()  ?></td>
                    <th class="text-nowrap" scope="row">Cotizaci&oacute;n:</th>
                    <td class="text-nowrap" style="color: #fc6d00;" ><?=$o_VTA_OrdenBN->getOrdenNum();?></td>
                    <th class="text-nowrap" scope="row">Tipo Comp:</th>
                    <td class="text-nowrap" style="color: #fc6d00;"><?=$o_VTA_OrdenBN->getTipoOrdenComercialDesc()?> - <?=$o_VTA_OrdenBN->getTipoClasificacionDesc()?></td>
                    <th class="text-nowrap" scope="row">Almacen Despacho:</th>
                    <td class="text-nowrap" ><?=$o_VTA_OrdenBN->getObjectAlmacenDespacho()->getDescripcionLocal()?></td>
                </tr>
                <tr>
                    <th class="text-nowrap" scope="row">Direcci&oacute;n Origen:</th>
                    <td class="text-nowrap" colspan="3"><?=$o_GSS_SucursalBN->getDireccion();?></td>
                    <th class="text-nowrap" scope="row">Direcci&oacute;n Destino:</th>
                    <td class="text-nowrap" colspan="3"><?=$o_VTA_DocumentoBN->getClienteDireccion();?></td>
                </tr>
            </tbody>
        </table>
    </div>
</div>

<div class="dropdown-divider"></div>
<div id="content_alert" style=""></div>

<?php
$f_CantidadControl = 0;
?>

<script type="text/javascript">
calcularPesoTotal = function()
{
    var a_elm = $( "#form1" ).find( "input[name='Cantidad[]']" );
    var SumaPesoTotal = 0;
    $.each
    (
        a_elm, function( index, item )
        {
            var IdItem            = $( item ).attr( "iditem" );
            var CantidadTotal     = parseFloat( $( item ).val() );
            var PesoUnitario      = parseFloat( $( item ).attr( "peso" ) );
            var CantidadRecibido  = parseFloat( $( item ).attr( "cantrec" ) );
            
            if( CantidadTotal > CantidadRecibido )
            {
                $( item ).val( CantidadRecibido );
                CantidadTotal = CantidadRecibido;
                showAlertBootStrap( 'content_alert', 'alert-danger', "La cantidad ingresa para el producto ["+IdItem+"] es mayor a lo permitido." );
            }
            
            SumaPesoTotal = SumaPesoTotal + redondear( CantidadTotal * PesoUnitario, 2 );
        }
    );
    $( "#SumaPesoTotal" ).val( number_format( SumaPesoTotal, 2 ) );
}
</script>

<form id="form1" name="form1" method="POST" onsubmit="return ImprimirGuiaFormatoPDF();"  enctype="multipart/form-data">
    <input type="hidden" name="TipoProceso" value="<?=$s_TipoProceso?>"/>
    <input type="hidden" name="IdRuta" value="<?=$s_IdRuta?>"/>
    <input type="hidden" name="IdRutaLinea" value="<?=$s_IdRutaLinea?>"/>
    <input type="hidden" name="IdMovimientoSerie" value="<?=$s_IdMovimientoSerie?>"/>
    <input type="hidden" name="IdTransferencia" value="<?=$s_IdTransferencia?>"/>
    
    <input type="hidden" name="ControlProdFinal" value="<?=$b_ControlProdFinal?>"/>
    
    <div id="content_grid">
    
    <?php if( !$b_ControlProdFinal ){ ?>
    
    <div class="table-responsive">
        <!-- <table class="table table-striped table-bordered" style="width:100%" id="example" > -->
        <table class="table table-sm table-bordered table-hover" id="example">
            <thead id="">
                <tr class="table-primary">
                    <th width="1%"  align="center" ><b>No</b></th>
                    <th width="8%" align="center" ><b>C&oacute;digo</b></th>
                    <th width="35%" align="left"><b>Descripci&oacute;n</b></th>
                    <th width="8%" align="center" ><b>Stock</b></th>
                    <th width="8%"  style="text-align: center;" scope="col" nowrap=""><b>Peso Unit</b></th>
                    <th width="8%"  style="text-align: center;" scope="col" nowrap=""><b>Peso Total</b></th>
                    <th width="15%" align="center" ><b>Cantidad Pedida</b></th>
                    <th width="15%" align="center" ><b>Cantidad Entregada</b></th>
                    <th width="15%" align="center" ><b>Cantidad a Entregar</b></th>
                </tr>
            </thead>
            
            <tbody id="content_all_row">
                <?php $f_MontoTotal = 0.00 ?>
                <?php foreach ( $a_VTA_DocumentoDetalle as $i_Key => $o_VTA_DocumentoDetalleBN ){ ?>
                    <?php
                    if( $o_VTA_DocumentoDetalleBN->getTipoDetalle() != VTA_DocumentoDetalleBN::TIPO_DETALLE )
                    {
                        continue;
                    }
                    $s_IdItem = $o_VTA_DocumentoDetalleBN->getItemCodigo();
                    $s_InputId = "input_".$i_Key;
                    $f_CantidadControl = $f_CantidadControl + ( $o_VTA_DocumentoDetalleBN->getCantidadPedida() - $o_VTA_DocumentoDetalleBN->getCantidadRecibida() );
                    $f_PesoUnitario = $o_VTA_DocumentoDetalleBN->getObjectItem()->getPesoGramos();
                    $f_StockFisico = $o_VTA_DocumentoDetalleBN->getStockFisico();
                    ?>
                <tr class="content_row">
                    <td align="center"><?=( $i_Key + 1 )?></td>
                    <td align="center"><?=$s_IdItem?></td>
                    <td align="left"><?=$o_VTA_DocumentoDetalleBN->getDescripcion()?></td>
                    <td align="center" <?php if( !$f_StockFisico ){ ?> style="color: red;"<?php } ?> ><b><?=$f_StockFisico?></b></td>
                    <td align="center"><?= number_format( $f_PesoUnitario, 2 )?></td>
                    <td align="center"><?=number_format( $f_PesoUnitario * $o_VTA_DocumentoDetalleBN->getCantidadPedida(), 2 )?></td>
                    <td align="center"><?=$o_VTA_DocumentoDetalleBN->getCantidadPedida()?></td>
                    <td align="center"><?=$o_VTA_DocumentoDetalleBN->getCantidadRecibida()?></td>
                    <td align="center"> 
                        <input type="hidden" name="Secuencia[]" value="<?=$o_VTA_DocumentoDetalleBN->getSecuencia()?>">
                        <input type="hidden" name="ProFinalId[]" value="0">
                        <input type="hidden" name="ProFinalDetId[]" value="0">
                        <input type="hidden" name="IdUnidad[]" value="<?=$o_VTA_DocumentoDetalleBN->getIdUnidad()?>">
                        <input type="hidden" name="IdItem[]" value="<?=$s_IdItem?>">
                        <input type="text" class="form-control form-control-sm text-center" name="Cantidad[]" id="<?=$s_InputId?>" onfocus="this.select();" autocomplete="off" onblur="calcularPesoTotal();"
                            value="<?=( $o_VTA_DocumentoDetalleBN->getCantidadPedida() - $o_VTA_DocumentoDetalleBN->getCantidadRecibida() )?>" peso="<?=$o_VTA_DocumentoDetalleBN->getObjectItem()->getPesoGramos()?>" 
                            cantrec="<?=( $o_VTA_DocumentoDetalleBN->getCantidadPedida() - $o_VTA_DocumentoDetalleBN->getCantidadRecibida() )?>" iditem="<?=$o_VTA_DocumentoDetalleBN->getItemCodigo()?>"
                            stockfis="<?=$f_StockFisico?>" iditem="<?=$s_IdItem?>"
                            > 
                    </td>
                </tr>
                <?php } ?>
            </tbody>
        </table>
    </div>
    
    <?php }else{ ?>
    
        <?php foreach ( $o_VTA_OrdenBN->getArrayDetallesFinal() as $i_Key => $o_VTA_ProductoFinalBN ){ ?>
        
     <div class="dropdown-divider"></div>
     
     <div class="card" style="width: 17rem; border-bottom: 0px;">
        <div class="card-header" style="border-bottom: 0px;"><?=$o_VTA_ProductoFinalBN->getItemTipoClase()==1?"ENCOFRADO":"ANDAMIO"?></div>
    </div>
    <div class="table-responsive">
        <table class="table table-sm table-bordered table-hover">
            <thead class="thead-light">
                <tr>
                    <th width="2%"  style="text-align: center;" scope="col"><b>No</b></th>
                    <th width="8%"  style="text-align: center;" scope="col"><b>C&oacute;digo</b></th>
                    <th width="25%" align="" scope="col"><b>Descripci&oacute;n</b></th>
                    <th width="8%"  style="text-align: center;" scope="col"><b>Cant</b></th>
                    <th width="4%"  align="center" scope="col">&nbsp;</th>
                </tr>
            </thead>
            
            <tbody id="">
                <tr>
                    <th style="text-align: center;" scope="row"><?=$o_VTA_ProductoFinalBN->getSecuencia()?></th>
                    <td align="center"><?=$o_VTA_ProductoFinalBN->getIdItem()?></td>
                    <td align="" id=""><?=$o_VTA_ProductoFinalBN->getDetalleDescripcion()?></td>
                    <td align="center"><?=$o_VTA_ProductoFinalBN->getCantidad()?></td>
                    <td align="center" nowrap="nowrap">&nbsp;</td>
                </tr>
                <tr>
                    <td colspan=""> &nbsp; </td>
                    <td colspan="7">
                         <table class="table table-sm table-bordered table-hover">
                            <thead class="thead-light">
                                <tr>
                                    <th width="2%"  style="text-align: center;" scope="col"><b>No</b></th>
                                    <th width="8%"  style="text-align: center;" scope="col"><b>C&oacute;digo</b></th>
                                    <th width="25%" align="left" ><b>Descripci&oacute;n</b></th>
                                    <th width="8%"  style="text-align: center;" scope="col" nowrap=""><b>Stock</b></th>
                                    <th width="8%"  style="text-align: center;" scope="col" nowrap=""><b>Peso Unit</b></th>
                                    <th width="8%"  style="text-align: center;" scope="col" nowrap=""><b>Peso Total</b></th>
                                    <th width="10%" style="text-align: center;" ><b>Cantidad Pedida</b></th>
                                    <th width="10%" style="text-align: center;" ><b>Cantidad Entregada</b></th>
                                    <th width="4%"  align="center" scope="col">&nbsp;</th>
                                </tr>
                            </thead>
                            <tbody id="">
                            <?php foreach ( VTA_ProductoFinalDetFN::selectAll( $o_VTA_ProductoFinalBN->getProFinalId() ) as $i_Key => $o_VTA_ProductoFinalDetBN ){ ?>
                                <?php
                                $s_InputId = "input_".$i_Key;
                                $f_CantidadControl = $f_CantidadControl + ( $o_VTA_ProductoFinalDetBN->getCantidad() - $o_VTA_ProductoFinalDetBN->getCantidadRecibida() );
                                $f_StockFisico = $o_VTA_ProductoFinalDetBN->getStockFisico();
                                ?>
                                <tr>
                                    <th style="text-align: center;" scope="row"><?=$o_VTA_ProductoFinalDetBN->getSecuencia()?></th>
                                    <td align="center"><?=$o_VTA_ProductoFinalDetBN->getIdItem()?></td>
                                    <td align="" id=""><?=$o_VTA_ProductoFinalDetBN->getDetalleDescripcion()?></td>
                                    <td align="center" <?php if( !$f_StockFisico ){ ?> style="color: red;"<?php } ?> ><b><?=$f_StockFisico?></b></td>
                                    <td align="center"><?=number_format( $o_VTA_ProductoFinalDetBN->getPesoUnitario(), 2 )?></td>
                                    <td align="center"><?=number_format( $o_VTA_ProductoFinalDetBN->getPesoTotal(), 2 )?></td>
                                    <td align="center"><?=$o_VTA_ProductoFinalDetBN->getCantidad()?></td>
                                    <td align="center"><?=$o_VTA_ProductoFinalDetBN->getCantidadRecibida()?></td>
                                    <td align="center">
                                        <input type="hidden" name="Secuencia[]" value="<?=$o_VTA_ProductoFinalDetBN->getSecuencia()?>">
                                        <input type="hidden" name="ProFinalId[]" value="<?=$o_VTA_ProductoFinalDetBN->getProFinalId()?>">
                                        <input type="hidden" name="ProFinalDetId[]" value="<?=$o_VTA_ProductoFinalDetBN->getProFinalDetId()?>">
                                        <input type="hidden" name="IdUnidad[]" value="<?=$o_VTA_ProductoFinalDetBN->getIdUnidad()?>">
                                        <input type="hidden" name="IdItem[]" value="<?=$o_VTA_ProductoFinalDetBN->getIdItem()?>">
                                        <input type="text" class="form-control form-control-sm text-center" name="Cantidad[]" id="<?=$s_InputId?>" onfocus="this.select();" autocomplete="off" onblur="calcularPesoTotal();"
                                            value="<?=( $o_VTA_ProductoFinalDetBN->getCantidad() - $o_VTA_ProductoFinalDetBN->getCantidadRecibida() )?>" peso="<?=$o_VTA_ProductoFinalDetBN->getPesoUnitario()?>"
                                            cantrec="<?=( $o_VTA_ProductoFinalDetBN->getCantidad() - $o_VTA_ProductoFinalDetBN->getCantidadRecibida() )?>" iditem="<?=$o_VTA_ProductoFinalDetBN->getIdItem()?>"
                                            stockfis="<?=$f_StockFisico?>"
                                            > 
                                    </td>
                                </tr>
                            <?php } ?>
                            </tbody>
                         </table>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>
        
        <?php } ?>
        
    <?php } ?>
    
    </div>
    
    <fieldset class="scheduler-border">
        <legend class="scheduler-border">Gu&iacute;a de Remisi&oacute;n</legend>
        
        <input type="hidden" name="TipoDocumentoFiscal" id="TipoDocumentoFiscal" value="GR">
        
        <div class="form-row mx-0">
            <div class="col-md-4 mb-1">
                <label class="col-form-label font-weight-bold" for="SerieDocumentoFiscal">Serie</label>
                <input type="text" class="form-control text-center" name="SerieDocumentoFiscal" id="SerieDocumentoFiscal" placeholder="Serie" maxlength="4" 
                    onfocus="this.select();" onkeypress="return NumCheckEntero( event, this );" value="<?=$s_Serie?>" required
                    >
            </div>
            <div class="col-md-4 mb-1">
                <label class="col-form-label font-weight-bold" for="NumeroDocumentoFiscal">Numero</label>
                <input type="text" class="form-control text-center" name="NumeroDocumentoFiscal" id="NumeroDocumentoFiscal" placeholder="Numero" maxlength="10" 
                    onfocus="this.select();" onkeypress="return NumCheckEntero( event, this );" value="<?=$s_Numero?>" required
                    >
            </div>
            <div class="col-md-4 mb-1">
                <label class="col-form-label font-weight-bold" for="FechaIniTraslado">Fecha Traslado</label>
                <input type="text" class="form-control text-center" name="FechaIniTraslado" id="FechaIniTraslado" placeholder="" maxlength="10" onfocus="this.select();" autocomplete="off" required>
                <script type="text/javascript">
                    $( "#FechaIniTraslado" ).datepicker( { dateFormat: "yy-mm-dd", changeYear:true, yearRange: "-0:+1", changeMonth: true, onClose: function ( fec_sel, obj_sel ){  } } );
                </script>
            </div>
        </div>
    </fieldset>
    
    <div class="dropdown-divider"></div>
    
    <fieldset class="scheduler-border">
        <legend class="scheduler-border">Peso Acumulado</legend>
        <div class="form-row mx-0">
            <div class="col-md-6 mb-1 text-right">
                <label class="col-form-label font-weight-bold" for="SumaPesoTotal">Peso Total</label>
            </div>
            <div class="col-md-6 mb-1">
                <input type="text" class="form-control text-center" name="SumaPesoTotal" id="SumaPesoTotal"  
                    onfocus="this.select();" readonly="readonly"
                    >
            </div>
        </div>
    </fieldset>
    
    <div class="dropdown-divider"></div>

<script type="text/javascript">
actualizarFechaAlquiler = function( fecha_alq )
{
    if( fecha_alq.trim() != "" )
    {
        blockContent( 'form1' );
        param_url = 'OrdenId=<?=$o_VTA_OrdenBN->getOrdenId()?>&TipoProc=actualizarFechaAlquiler&NoUpdate=1&FechaInicioAlquiler=' + fecha_alq;
        executeAjaxJson
        ( 
            "<?php echo buildUrlComplet( 'vta.php/cot/requestOrden' ) ?>", 
            param_url,
            function( o_json )
            {
            	unBlockContent( 'form1' );
                if( o_json.error )
                {
                    showAlertBootStrap( 'content_alert', 'alert-danger', o_json.mensaje_error );
                    return false;
                }
                pr( o_json );
                $( "#FechaFinAlq" ).val( o_json.FechaFinAlquiler );
            } 
        );
    }
}
</script>
    <?php if( $o_VTA_OrdenBN->getOrdenTipoComercialId() == VTA_OrdenBN::TIPO_COMERCIAL_ALQUILER ){ ?>
    <fieldset class="scheduler-border">
        <legend class="scheduler-border">Fecha de Alquiler</legend>
        <div class="form-row mx-0">
            <div class="col-md-6 mb-1">
                <label class="col-form-label font-weight-bold" for="FechaInicioAlq">Inicio</label>
                <input type="text" class="form-control text-center" name="FechaInicioAlq" id="FechaInicioAlq" maxlength="10" value="" autocomplete="off" required>
                <script type="text/javascript">
                $( "#FechaInicioAlq" ).datepicker( { dateFormat: "yy-mm-dd", changeYear:true, yearRange: "-0:+1", changeMonth: true, onClose: function ( fec_sel, obj_sel ){ actualizarFechaAlquiler( fec_sel ); } } );
                </script>
            </div>
            <div class="col-md-6 mb-1">
                <label class="col-form-label font-weight-bold" for="FechaFinAlq">Fin</label>
                <input type="text" class="form-control text-center" name="FechaFinAlq" id="FechaFinAlq" maxlength="10" onfocus="" value="" readonly="readonly" required>
            </div>
        </div>
    </fieldset>
    
    <div class="dropdown-divider"></div>
    <?php } ?>
    
    <fieldset class="scheduler-border">
        <legend class="scheduler-border">Direcci&oacute;n de Origen</legend>
        
        <div class="form-row mx-0">
            <div class="col-md-4 mb-1">
                <label class="col-form-label" for="DepartamentoOrigen">Departamento</label>
                <select class="form-control" name="DepartamentoOrigen" id="DepartamentoOrigen" 
                        onchange="$('#ProvinciaOrigen')[0].options.length=1; $('#DistritoOrigen')[0].options.length=1; publicForSelectAjaxJSON('<?php echo buildUrl( 'transporte/request' ) ?>', 'TipoProc=Provincia&Departamento='+this.value, 'ProvinciaOrigen');"
                        >
                    <option value=""> - SELECCIONE - </option>
                    <?php foreach ( $a_DptMST_Ubigeo as $i_Key => $o_DptMST_UbigeoBN ){ ?>
                    <option value="<?=$o_DptMST_UbigeoBN->getIdUbigeo()?>" <?php if( "XXX"==$o_DptMST_UbigeoBN->getIdUbigeo() ){ echo "SELECTED"; } ?>> <?=$o_DptMST_UbigeoBN->getDescripcion()?> </option>
                    <?php } ?>
                </select>
            </div>
            <div class="col-md-4 mb-1">
                <label class="col-form-label" for="ProvinciaOrigen">Provincia</label>
                <select class="form-control" name="ProvinciaOrigen" id="ProvinciaOrigen"
                        onchange="$('#DistritoOrigen')[0].options.length = 1; publicForSelectAjaxJSON('<?php echo buildUrl( 'transporte/request' ) ?>', 'TipoProc=Distrito&Provincia='+this.value, 'DistritoOrigen');"
                        >
                    <option value=""> - SELECCIONE - </option>
                </select>
            </div>
            <div class="col-md-4 mb-1">
                <label class="col-form-label" for="DistritoOrigen">Distrito</label>
                <select class="form-control" name="DistritoOrigen" id="DistritoOrigen">
                    <option value=""> - SELECCIONE - </option>
                </select>
            </div>
        </div>
        
        <div class="form-group m-1">
            <label for="DireccionOrigen" class="col-form-label">Direcci&oacute;n:</label>
            <textarea class="form-control" id="DireccionOrigen" name="DireccionOrigen" rows="1" ></textarea>
        </div>
    </fieldset>
    
    <div class="dropdown-divider"></div>
    
    <fieldset class="scheduler-border">
        <legend class="scheduler-border">Direcci&oacute;n de Destino</legend>
        
        <div class="form-row mx-0">
            <div class="col-md-4 mb-1">
                <label class="col-form-label" for="DepartamentoDestino">Departamento</label>
                <select class="form-control" name="DepartamentoDestino" id="DepartamentoDestino" 
                        onchange="$('#ProvinciaDestino')[0].options.length=1; $('#DistritoDestino')[0].options.length=1; publicForSelectAjaxJSON('<?php echo buildUrl( 'transporte/request' ) ?>', 'TipoProc=Provincia&Departamento='+this.value, 'ProvinciaDestino');"
                        >
                    <option value=""> - SELECCIONE - </option>
                    <?php foreach ( $a_DptMST_Ubigeo as $i_Key => $o_DptMST_UbigeoBN ){ ?>
                    <option value="<?=$o_DptMST_UbigeoBN->getIdUbigeo()?>" <?php if( "XXX"==$o_DptMST_UbigeoBN->getIdUbigeo() ){ echo "SELECTED"; } ?>> <?=$o_DptMST_UbigeoBN->getDescripcion()?> </option>
                    <?php } ?>
                </select>
            </div>
            <div class="col-md-4 mb-1">
                <label class="col-form-label" for="ProvinciaDestino">Provincia</label>
                <select class="form-control" name="ProvinciaDestino" id="ProvinciaDestino"
                        onchange="$('#DistritoDestino')[0].options.length=1; publicForSelectAjaxJSON('<?php echo buildUrl( 'transporte/request' ) ?>', 'TipoProc=Distrito&Provincia='+this.value, 'DistritoDestino');"
                        >
                    <option value=""> - SELECCIONE - </option>
                </select>
            </div>
            <div class="col-md-4 mb-1">
                <label class="col-form-label" for="DistritoDestino">Distrito</label>
                <select class="form-control" name="DistritoDestino" id="DistritoDestino">
                    <option value=""> - SELECCIONE - </option>
                </select>
            </div>
        </div>
        
        <div class="form-group m-1">
            <label for="DireccionDestino" class="col-form-label">Direcci&oacute;n:</label>
            <textarea class="form-control" id="DireccionDestino" name="DireccionDestino" rows="1" ></textarea>
        </div>
    </fieldset>
    
    <?php if( $s_IdRuta ){ ?>
    <div> <p> <input type="checkbox" name="ParaProvincia" id="ParaProvincia" value="1"> <label for="ParaProvincia">Marque si se env&iacute;a a Provincia. </label> </p> </div>
    <?php  } ?>
    
    <?php if( $f_CantidadControl ){ ?>
    <div class="form-row mx-0" style="padding: 10px;" id="content_buttons">
        <div class="col-md-6 mb-1">
            <!-- <button type="button" class="btn btn-primary btn-lg btn-block" onclick="actualizarDocumentoFiscalGuiaRem();">ACTUALIZAR</button> -->
            <button type="button" class="btn btn-danger btn-lg btn-block" onclick="parent.closeWindow();">CANCELAR</button>
        </div>
        <!-- <div class="col-md-4 mb-1">
            <button type="button" class="btn btn-primary btn-lg btn-block" onclick="crearArchivoParaImprimirGuia();">IMPRIMIR</button>
        </div> -->
        <div class="col-md-6 mb-1">
            <button type="submit" class="btn btn-primary btn-lg btn-block" onclick="">GENERAR GUIA</button>
        </div>
    </div>
    <?php } ?>

</form>

<script type="text/javascript">
configurarDataTable = function()
{
    $( '#example' ).DataTable
    (
        {
            language:       { "url": "//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/Spanish.json" },
            responsive:     false,
            searching:      false,
            info:           false,
            lengthChange:   false,
            paging:         false,
            dom:            'lrtip'/*,
            fixedHeader: 
            {
                header: true,
                footer: true
            }*/
        }
    );
}

setTimeout
(
    function () 
    {
        configurarDataTable();
    }, 
    500
);
</script>

<script type="text/javascript">
calcularPesoTotal();
<?php if( $mensaje_error ){ ?>
showAlertBootStrap( 'content_alert', 'alert-danger', "<?=$mensaje_error?>" );
<?php } ?>
</script>