<!-- https://ourcodeworld.com/articles/read/687/how-to-configure-a-header-and-footer-in-dompdf -->
<?php
function buscar_serie_guia_rem_h( &$a_Data )
{
    $o_GSS_SucursalDocumentoFN = new GSS_SucursalDocumentoFN();
    $o_GSS_SucursalDocumentoFN->setIdCompania( myUser::getUser()->getIdBusiness() );
    $o_GSS_SucursalDocumentoFN->setIdSucursal( myUser::getUser()->getIdSucursal() );
    $o_GSS_SucursalDocumentoFN->setIdTipoDocumento( "GR" );
    $a_GSS_SucursalDocumento = $o_GSS_SucursalDocumentoFN->select();
    
    if( $a_GSS_SucursalDocumento )
    {
        $o_GSS_SucursalDocumentoBN = $a_GSS_SucursalDocumento[0];
        
        $a_Data['Serie']  = $o_GSS_SucursalDocumentoBN->getSerieFormatoFinal();
        $a_Data['Numero'] = $o_GSS_SucursalDocumentoBN->getNumeroActualFormato();
        $a_Data['serie_num'][] = array( "Serie" => $a_Data['Serie'], "Numero" => $a_Data['Numero'] );

        //PARA INCREMENTAR EL CORRELATIVO 
        $o_VTA_DocumentoBN = new VTA_DocumentoBN();
        $o_VTA_DocumentoBN->setIdCompania( myUser::getUser()->getIdBusiness() );
        $o_VTA_DocumentoBN->setIdSucursal( myUser::getUser()->getIdSucursal() );
        $o_VTA_DocumentoBN->setIdTipoDocumento( "GR" );
        $o_VTA_DocumentoBN->setDocumentoSerie( $a_Data['Serie'] );
        $o_VTA_DocumentoBN->setDocumentoNumero( $a_Data['Numero'] );
        $o_VTA_DocumentoBN->setEsGuiaRemision( true );
        
        $o_OrdenVentaBL = new OrdenVentaBL();
        $o_OrdenVentaBL->incrementarDocumentoNumero( $o_VTA_DocumentoBN );
    }
}

function construir_cabecera( &$a_Data )
{
    buscar_serie_guia_rem_h( $a_Data );
    ?>
        <header>

            <table style="width: 100%; font-size:10px; margin-top: 2px;" border="1" cellpadding="10" cellspacing="0" width="100%" >
                <tr>
                    <td style="width:65%;" align="center" rowspan="2">
                        <table style="width: 100%;" border="0" cellpadding="0" cellspacing="0"  >
                            <tr>
                                <td align="center" style=""><img src="web/images/logo/<?=$a_Data['Ruc']?>.jpg" style="width: 200px; height: 55px;" ></td>
                            </tr>
                            <tr>
                                <td colspan="" align="center">
                                    <label><b><?=$a_Data['DireccionComun']?></b></label>
                                </td>
                            </tr>
                            <tr>
                                <td colspan="" align="center">
                                    <label><?=$a_Data['DireccionAdicional']?></label>
                                </td>
                            </tr>
                        </table>
                    </td>
                    <td style="width:35%; background-color: #EDEDED; " align="center">
                        <table style="width: 100%;" border="0" cellpadding="0" cellspacing="0"  >
                            <tr>
                                <td align="center"><label style="font-size: 18px; font-weight: bold;">RUC <?=$a_Data['Ruc']?></label></td>
                            </tr>
                            <tr>
                                <td align="center"><label style="font-size: 22px; font-weight: bold;">GUIA DE REMISION</label></td>
                            </tr>
                            <tr>
                                <td align="center"><label style="font-size: 18px; font-weight: bold;"><?=$a_Data['Serie']?>-<?=str_pad( $a_Data['Numero'], 8, "0", STR_PAD_LEFT )?></label></td>
                            </tr>
                        </table>
                    </td>
                </tr>
                <tr>
                    <td style="" align="center"> 
                        <table style="width: 100%;" border="0" cellpadding="0" cellspacing="0"  >
                            <tr>
                                <td style="font-weight: bold;" width="40%">EMISION</td>
                                <td align="center">:</td>
                                <td width="50%" align="left"><?=date( "Y-m-d" )?></td>
                            </tr>
                            <tr>
                                <td colspan="3"><hr></td>
                            </tr>
                            <tr>
                                <td style="font-weight: bold;">FECHA DE INICIO<br>DE TRASLADO</td>
                                <td style="" align="center">:</td>
                                <td style="" align="left"><?=date( "Y-m-d H:i:s" )?></td>
                            </tr>
                        </table>
                    </td>
                </tr>
            </table>

            <table style="width: 100%; margin-top: 2px;" border="0" cellpadding="0" cellspacing="0"  >
                <tr>
                    <td width="48%" valign="top">
                        <table style="width: 100%; font-size:10px;" border="1" cellpadding="0" cellspacing="0" width="100%" >
                            <tr>
                                <td style="border-bottom: 1px solid #000000;" align="center">DOMICILIO DE PARTIDA</td>
                            </tr>
                            <tr>
                                <td>
                                    <table style="width: 100%; font-size:10px;" border="0" cellpadding="5" cellspacing="0"  >
                                        <tr>
                                            <td>AVENIDA (&nbsp;&nbsp;&nbsp;&nbsp;)</td>
                                            <td>JIRON (&nbsp;&nbsp;&nbsp;&nbsp;)</td>
                                            <td>CALLE (&nbsp;&nbsp;&nbsp;&nbsp;)</td>
                                            <td>OTROS :</td>
                                        </tr>
                                        <tr>
                                            <td > DIRECCION: </td>
                                            <td colspan="3"> <b><?=$a_Data['DireccionOrigen']?></b> </td>
                                        </tr>
                                        <tr>
                                            <td colspan="4">
                                                <table style="width: 100%; font-size:10px;" border="0" cellpadding="0" cellspacing="0"  >
                                                    <tr>
                                                        <td>DISTRITO: <B><?=$a_Data['DistritoOrigen']?></B></td>
                                                        <td>PROV: <B><?=$a_Data['ProvinciaOrigen']?></B></td>
                                                        <td>DEP: <B><?=$a_Data['DepartamentoOrigen']?></B></td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                                    </table>
                                </td>
                            </tr>
                        </table>
                    </td>
                    <td> &nbsp; </td>
                    <td width="48%" valign="top">
                        <table style="width: 100%; font-size:10px;" border="1" cellpadding="0" cellspacing="0" width="100%" >
                            <tr>
                                <td style="border-bottom: 1px solid #000000;" align="center">DOMICILIO DE LLEGADA</td>
                            </tr>
                            <tr>
                                <td>
                                    <table style="width: 100%; font-size:10px;" border="0" cellpadding="5" cellspacing="0"  >
                                        <tr>
                                            <td>AVENIDA (&nbsp;&nbsp;&nbsp;&nbsp;)</td>
                                            <td>JIRON (&nbsp;&nbsp;&nbsp;&nbsp;)</td>
                                            <td>CALLE (&nbsp;&nbsp;&nbsp;&nbsp;)</td>
                                            <td>OTROS :</td>
                                        </tr>
                                        <tr>
                                            <td > DIRECCION : </td>
                                            <td colspan="3"> <b><?=$a_Data['DireccionDestino']?></b> </td>
                                        </tr>
                                        <tr>
                                            <td colspan="4">
                                                <table style="width: 100%; font-size:10px;" border="0" cellpadding="0" cellspacing="0"  >
                                                    <tr>
                                                        <td>DISTRITO: <B><?=$a_Data['DistritoDestino']?></B></td>
                                                        <td>PROV: <B><?=$a_Data['ProvinciaDestino']?></B></td>
                                                        <td>DEP: <B><?=$a_Data['DepartamentoDestino']?></B></td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>
                                    </table>
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
            </table>

            <table style="width: 100%; margin-top: 2px;" border="0" cellpadding="0" cellspacing="0"  >
                <tr>
                    <td width="48%">
                        <table style="width: 100%; font-size:10px;" border="1" cellpadding="0" cellspacing="0" width="100%" >
                            <tr>
                                <td style="border-bottom: 1px solid #000000;" align="center">DESTINATARIO</td>
                            </tr>
                            <tr>
                                <td>
                                    <table style="width: 100%; font-size:10px;" border="0" cellpadding="5" cellspacing="0"  >
                                        <tr>
                                            <td colspan="2"> APELLIDOS Y NOMBRES O RAZON SOCIAL : </td>
                                        </tr>
                                        <tr>
                                            <td colspan="2"> <b> <?=$a_Data['ClienteNombre']?> </b> </td>
                                        </tr>
                                        <tr>
                                            <td > <?=$a_Data['TipoDocumento']?> : </td>
                                            <td > <b> <?=$a_Data['ClienteRUC']?> </b> </td>
                                        </tr>
                                        <!--<tr>
                                            <td colspan="4">
                                                <table style="width: 100%; font-size:10px;" border="0" cellpadding="0" cellspacing="0"  >
                                                    <tr>
                                                        <td>TIPO DE DOCUMENTO DE IDENTIDAD: <B><?=$s_TipoDocumento?></B></td>
                                                        <td>No: <B>SAN ROMAN</B></td>
                                                    </tr>
                                                </table>
                                            </td>
                                        </tr>-->
                                    </table>
                                </td>
                            </tr>
                        </table>
                    </td>
                    <td> &nbsp; </td>
                    <td width="48%">
                        <table style="width: 100%; font-size:10px;" border="1" cellpadding="0" cellspacing="0" width="100%" >
                            <tr>
                                <td style="border-bottom: 1px solid #000000;" align="center">UNIDAD DE TRANSPORTE Y CONDUCTOR</td>
                            </tr>
                            <tr>
                                <td>
                                    <table style="width: 100%; font-size:10px;" border="0" cellpadding="5" cellspacing="0"  >
                                        <tr>
                                            <td>VEHICULO</td>
                                            <td> &nbsp; </td>
                                        </tr>
                                        <tr>
                                            <td > PLACA No : </td>
                                            <td > &nbsp; </td>
                                        </tr>
                                        <tr>
                                            <td > LICENCIA DE CONDUCIR : </td>
                                            <td > &nbsp; </td>
                                        </tr>
                                    </table>
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
            </table>
        </header>
    <?php
}

function construir_pie( &$a_Data )
{
    $f_PesoBruto = 0;
    //$a_VTA_DocumentoDetalle = $a_Data['a_VTA_DocumentoDetalle'];
    foreach ( $a_Data['a_GuiaDetalle'] as $a_GuiaDetalle )
    {
        $f_PesoBruto = $f_PesoBruto + round( $a_GuiaDetalle['PesoGramos'] * $a_GuiaDetalle['CantidadaDescontar'], 2 );
    }
    ?>
        <footer style="margin-top: 2px;">

            <table style="width: 100%;" border="0" cellpadding="0" cellspacing="0"  >
                <tr>
                    <td width="25%" valign="top">
                        <table style="width: 100%; font-size:10px;" border="1" cellpadding="0" cellspacing="0"  >
                            <tr>
                                <td style="border-bottom: 1px solid #000000;" align="center">COMPROBANTE DE PAGO</td>
                            </tr>
                            <tr>
                                <td>
                                    <table style="width: 100%; font-size:10px;" border="0" cellpadding="5" cellspacing="0"  >
                                        <tr>
                                            <td> TIPO : </td>
                                            <td > <b> <?=$a_Data['TipoDocumentoDesc']?> </b> </td>
                                        </tr>
                                        <tr>
                                            <td > No : </td>
                                            <td > <b> <?=$a_Data['TipoSerieNumero']?> </b> </td>
                                        </tr>
                                    </table>
                                </td>
                            </tr>
                        </table>
                        
                        <table style="margin-top: 2px; width: 100%; font-size:10px;" border="1" cellpadding="0" cellspacing="0"  >
                            <tr>
                                <td style="border-bottom: 1px solid #000000;" align="center">PESO BRUTO</td>
                            </tr>
                            <tr>
                                <td>
                                    <table style="width: 100%; font-size:10px;" border="0" cellpadding="5" cellspacing="0"  >
                                        <tr>
                                            <td align="center"> <b> <?=number_format( $f_PesoBruto, 2 )?> </b> </td>
                                        </tr>
                                    </table>
                                </td>
                            </tr>
                        </table>
                    </td>

                    <td>&nbsp;</td>

                    <td width="45%" valign="top">
                        <table style="width: 100%; font-size:10px;" border="1" cellpadding="0" cellspacing="0" >
                            <tr>
                                <td style="border-bottom: 1px solid #000000;" align="center">MOTIVO DE TRASLADO</td>
                            </tr>
                            <tr>
                                <td align="center">
                                    <table style="width: 100%; font-size:6px; padding-left: 5px;" border="0" cellpadding="0" cellspacing="0"  >
                                        <tr>
                                            <td width="40%"> 1. VENTA : </td>
                                            <td  width="5%"> <input type="checkbox" name="" > </td>
                                            <td width="40%"> 8. RECOJO DE BIENES : </td>
                                            <td  width="5%"> <input type="checkbox" name=""> </td>
                                        </tr>
                                        <tr>
                                            <td> 2. VENTA SUJETA A CONFIRMACION : </td><td > <input type="checkbox" name="">
                                            <td> 9. TRASLADO POR BIENES ITINERANTE : </td><td > <input type="checkbox" name=""> </td>
                                        </tr>
                                        <tr>
                                            <td> 3. COMPRA : </td><td > <input type="checkbox" name=""> </td> 
                                            <td> 10. TRASLADO ZONA PRIMARIA : </td><td > <input type="checkbox" name=""> </td>
                                        </tr>
                                        <tr>
                                            <td> 4. CONSIGNACION : </td><td > <input type="checkbox" name=""> </td> 
                                            <td> 11. IMPORTACION : </td><td > <input type="checkbox" name=""> </td>
                                        </tr>
                                        <tr>
                                            <td> 5. DEVOLUCION : </td><td > <input type="checkbox" name=""> </td>
                                            <td> 12. EXPORTACION : </td><td > <input type="checkbox" name=""> </td>
                                        </tr>
                                        <tr>
                                            <td> 6. TRASLADO ENTRE LA MISMA EMPRESA : </td><td > <input type="checkbox" name=""> </td> 
                                            <td> 13. VENTA CON ENTREGA A TERCEROS : </td><td > <input type="checkbox" name=""> </td>
                                        </tr>
                                        <tr>
                                            <td> 7. TRASLADO PARA TRANSFORMACION : </td><td > <input type="checkbox" name="">
                                            <td> 14. OTROS : </td><td > <input type="checkbox" name=""> </td>
                                        </tr>
                                    </table>
                                </td>
                            </tr>
                        </table>
                    </td>

                    <td>&nbsp;</td>

                    <td width="25%" valign="top">
                        <table style="width: 100%; font-size:10px;" border="1" cellpadding="0" cellspacing="0"  >
                            <tr>
                                <td align="center">RECIBI CONFIRME</td>
                            </tr>
                            <tr>
                                <td>
                                    <table style="width: 100%; font-size:10px;" border="0" cellpadding="5" cellspacing="0"  >
                                        <tr><td > &nbsp; </td></tr>
                                        <tr><td > &nbsp; </td></tr>
                                        <tr><td > &nbsp; </td></tr>
                                        <tr>
                                            <td style="border-top: 1px solid #000000;" align="center"> FIRMA, SELLO Y FECHA </td>
                                        </tr>
                                    </table>
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
            </table>
        </footer>
    <?php
}

function construir_cuerpo( &$a_Data, $ini, $b_Control )
{
    ?>

    <?php if( $b_Control ){ ?> <div class="new-page"></div> <?php } ?>

    <?=construir_cabecera( $a_Data )?>

    <main style="margin-top: 2px;">
        <table style="width: 100%; font-size:10px;" border="1" cellpadding="0" cellspacing="0" >
            <tr>
                <td>
                    <table style="width: 100%; font-size:10px; " border="0" cellpadding="5" cellspacing="0" >
                        <tr>
                            <!--<td style="border-bottom: 1px solid #000000; width: 2%; background-color: #EDEDED;" align="center"><b>#</b></td>-->
                            <td style="border-bottom: 1px solid #000000; width: 5%; background-color: #EDEDED;" align="center"><b>Item</b></td>
                            <td style="border-bottom: 1px solid #000000; width: 5%; background-color: #EDEDED;" align="center"><b>Cnt</b></td>
                            <td style="border-bottom: 1px solid #000000; width: 6%; background-color: #EDEDED;" align="center"><b>U.M</b></td>
                            <td style="border-bottom: 1px solid #000000; width: 60%; background-color: #EDEDED;"><b>Descripci&oacute;n</b></td>
                            <td style="border-bottom: 1px solid #000000; width: 10%; background-color: #EDEDED;" align="center"><b>Peso Total</b></td>
                        </tr>

        <?php for ( $i=$ini; $i < $ini+21 ; $i++) { ?>
            <?php if( isset( $a_Data['a_GuiaDetalle'][$i] ) && $a_Data['a_GuiaDetalle'][$i]['CantidadaDescontar'] > 0 ){ ?>
                <tr>
                    <!--<td style="width: 2%;" align="center"><?= $i  ?></td>-->
                    <td style="" align="center"><?= $a_Data['a_GuiaDetalle'][$i]['ItemCodigo'] ?></td>
                    <td style="" align="center"><?= $a_Data['a_GuiaDetalle'][$i]['CantidadaDescontar'] ?></td>
                    <td style="" align="center"><?= $a_Data['a_GuiaDetalle'][$i]['DescripcionUnidad'] ?></td>
                    <td style=""><?= $a_Data['a_GuiaDetalle'][$i]['DescripcionItem'] ?></td>
                    <td style="" align="center"><?= number_format( round( $a_Data['a_GuiaDetalle'][$i]['PesoGramos'] * $a_Data['a_GuiaDetalle'][$i]['CantidadaDescontar'], 2 ), 2 ) ?></td>
                </tr>
            <?php }else{ ?>
                <tr>
                    <!--<td style="width: 2%;" align="center"> &nbsp; </td>-->
                    <td style="" align="center"> &nbsp; </td>
                    <td style="" align="center"> &nbsp; </td>
                    <td style="" align="center"> &nbsp; </td>
                    <td style="" align="center"> &nbsp; </td>
                    <td style=""> &nbsp; </td>
                </tr>
            <?php } ?>
        <?php } ?>

                    </table>
                </td>
            </tr>
        </table>
    </main>
    
    <?=construir_pie( $a_Data )?>

    <?php
}
?>
<html>
    <head>
        <style type="text/css">
            @page 
            {
                size: A4 portrait;
                margin: 0cm 0cm;
            }

            header 
            {
                /*margin-top: 0.5cm;
                margin-left: 0.5cm;
                margin-right: 0.5cm;
                margin-bottom: 2cm;*/

                /*position: fixed;*/
                top: 0cm;
                left: 0cm;
                right: 0cm;
                /*height: 2cm;*/
                
                /*
                background-color: #03a9f4;
                color: white;
                text-align: center;
                line-height: 1.5cm;
                */
            }

            footer 
            {
                /*position: fixed;*/
                bottom: 0cm; 
                left: 0cm; 
                right: 0cm;
                /*
                height: 4.5cm;
                margin-left: 0.5cm;
                margin-right: 0.5cm;
                margin-bottom: 0.5cm;
                */
            }

            /*footer { position: fixed; bottom: -60px; left: 0px; right: 0px; height: 200px; }*/

            body 
            {
                margin : 0.5cm;
                /*margin-top: 0.5cm;
                margin-left: 0.5cm;
                margin-right: 0.5cm;
                margin-bottom: 0.5cm;*/
            }

            input[type=checkbox]:before { font-family: DejaVu Sans; }
            input[type=checkbox] { display: inline; }

            /* una manera de colocar el numero de pagina */
            /*.page-number:after { content: counter( page ); } css*/
            /* <span class="page-number">Page </span>  se coloca en el html*/

            .new-page{ page-break-before: always; }

        </style>
    </head>
    <body>
        
        <?=construir_cuerpo( $a_Data, 0, false )?>
        <?php if( count( $a_Data['a_GuiaDetalle'] ) > 21 ){ ?> <?=construir_cuerpo( $a_Data, 21, true )?> <?php } ?>
        <?php if( count( $a_Data['a_GuiaDetalle'] ) > 42 ){ ?> <?=construir_cuerpo( $a_Data, 42, true )?> <?php } ?>
        <?php if( count( $a_Data['a_GuiaDetalle'] ) > 63 ){ ?> <?=construir_cuerpo( $a_Data, 63, true )?> <?php } ?>
        <?php if( count( $a_Data['a_GuiaDetalle'] ) > 84 ){ ?> <?=construir_cuerpo( $a_Data, 84, true )?> <?php } ?>
        <?php if( count( $a_Data['a_GuiaDetalle'] ) > 106 ){ ?> <?=construir_cuerpo( $a_Data, 106, true )?> <?php } ?>
        <?php if( count( $a_Data['a_GuiaDetalle'] ) > 127 ){ ?> <?=construir_cuerpo( $a_Data, 127, true )?> <?php } ?>
        <?php if( count( $a_Data['a_GuiaDetalle'] ) > 148 ){ ?> <?=construir_cuerpo( $a_Data, 148, true )?> <?php } ?>
    </body>

</html>


