<?php use_helper( 'UrlFunctions' ); ?>
<?php use_helper( 'IncludePartial' ); ?>
<?php use_helper( 'UtilFunctions' ); ?>

<link rel="stylesheet" type="text/css" media="screen" href="https://cdn.datatables.net/responsive/2.2.5/css/responsive.bootstrap4.min.css" />
<link rel="stylesheet" type="text/css" media="screen" href="https://cdn.datatables.net/1.10.21/css/dataTables.bootstrap4.min.css" />
<link rel="stylesheet" type="text/css" media="screen" href="https://cdn.datatables.net/fixedheader/3.1.7/css/fixedHeader.dataTables.min.css" />

<!--<link rel="stylesheet" type="text/css" media="screen" href="https://cdn.datatables.net/1.10.21/css/jquery.dataTables.min.css" />-->

<script type="text/javascript" src="https://cdn.datatables.net/1.10.21/js/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/1.10.21/js/dataTables.bootstrap4.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/responsive/2.2.5/js/dataTables.responsive.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/responsive/2.2.5/js/responsive.bootstrap4.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/fixedheader/3.1.7/js/dataTables.fixedHeader.min.js"></script>

<style type="text/css">
/*
#example_wrapper .row
{
    margin-right: 0;
    margin-left: 0;
}
table.dataTable tbody tr:hover 
{
   background-color: #DAE6FE !important;;
}
*/
.table td, .table th 
{
    /*padding: 8px;*/
    font-size: 13px;
}
th { white-space: nowrap; }

fieldset.scheduler-border 
{
    border: 1px solid #ccc !important;
    padding: 0 0.5em 0.5em 0.5em !important;
    margin: 0 0 0.5em 0 !important;
    -webkit-box-shadow: 0px 0px 0px 0px #000;
    box-shadow: 0px 0px 0px 0px #000;
}

legend.scheduler-border 
{
    font-size: 1em !important;
    font-weight: bold !important;
    text-align: left !important;
    width: auto;
    padding: 0 5px;
    border-bottom: none;
    margin-bottom: 0;    
}

</style>

<script type="text/javascript">
activarBoton = function()
{
	var a_elm = $( "#form1" ).find( "input:checked" );
    /*$.each
    (
    	a_elm, function( index, item )
        {
            
        }
    );*/
    if( a_elm.length == 4 )
    {
    	$( "#btnAprobar" ).prop( 'disabled', false );
    }
    else
    {
    	$( "#btnAprobar" ).prop( 'disabled', true );
    }
}
</script>

<div class="marco">
    <div class="table-responsive">
        <table class="table table-borderless" style="margin-bottom: 0px; line-height: 0.5; padding: .50rem; ">
            <tbody>
                <tr>
                    <th class="text-nowrap" scope="row">Nro Documento:</th>
                    <td class="text-nowrap" style="color: #fc6d00;"><?=$o_VTA_DocumentoBN->getDocumentoTipoSerieNumero()  ?></td>
                    <th class="text-nowrap" scope="row">Fecha:</th>
                    <td class="text-nowrap"><?=str_pad( $o_VTA_DocumentoBN->getFechaDocumento(), 10, "0", STR_PAD_LEFT )?></td>
                    <th class="text-nowrap" scope="row">Cliente:</th>
                    <td class="text-nowrap" ><?=$o_VTA_DocumentoBN->getClienteNombre();?></td>
                    <th class="text-nowrap" scope="row">Cliente Documento:</th>
                    <td class="text-nowrap" ><?=$o_VTA_DocumentoBN->getClienteTipoDoc();?> <?=$o_VTA_DocumentoBN->getClienteRUC();?></td> 
                </tr>
                <tr>
                    <th class="text-nowrap" scope="row">Direcci&oacute;n:</th>
                    <td class="text-nowrap" colspan="5"><?=$o_VTA_DocumentoBN->getClienteDireccion();?></td>
                    <th class="text-nowrap" scope="row">Cotizaci&oacute;n:</th>
                    <td class="text-nowrap" style="color: #fc6d00;"><?=$o_VTA_DocumentoBN->getDocumentoParentCod()  ?></td>
                </tr>
            </tbody>
        </table>
    </div>
</div>

<div class="dropdown-divider"></div>

<div id="content_alert" style=""></div>

<form id="form1" name="form1" method="POST" onsubmit=""  enctype="multipart/form-data">

    <fieldset class="scheduler-border">
        <legend class="scheduler-border">Resumen de Documentos Adjuntos</legend>
        
        <table id="example" class="table table-striped table-bordered" style="width:100%">
            <thead>
                <tr>
                    <th width="2%" style="text-align: center;"> # </th>
                    <th style="text-align: center;">Tipo</th>
                    <th style="text-align: center;">Nombre</th>
                    <th style="text-align: center;">Fecha</th>
                    <th style="text-align: center;">Usuario</th>
                    <th style="text-align: center;">&nbsp;</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ( VTA_OrdenTipoArchivoFN::selectActivosValid() as $i_Key => $o_VTA_OrdenTipoArchivoBN ){ ?>
                    <?php
                    $o_VTA_OrdenArchivosFN = new VTA_OrdenArchivosFN();
                    $o_VTA_OrdenArchivosFN->setOrdenId( $o_VTA_DocumentoBN->getDocumentoParentId() );
                    $o_VTA_OrdenArchivosFN->setTipoArchivoId( $o_VTA_OrdenTipoArchivoBN->getTipoId() );
                    $a_VTA_OrdenArchivos = $o_VTA_OrdenArchivosFN->select();
                    $o_VTA_OrdenArchivosBN = new VTA_OrdenArchivosBN();
                    if( $a_VTA_OrdenArchivos )
                    {
                        $o_VTA_OrdenArchivosBN = $a_VTA_OrdenArchivos[0];
                    }
                    ?>
                <tr>
                    <td align="center">
                        <div class="col-auto my-1">
                      <div class="custom-control custom-checkbox mr-sm-2">
                        <input type="checkbox" class="custom-control-input" id="check_box_<?=$i_Key?>" onclick="activarBoton();">
                        <label class="custom-control-label" for="check_box_<?=$i_Key?>">&nbsp;</label>
                      </div>
                    </div>
                    </td>
                    <td align="center"><?=$o_VTA_OrdenTipoArchivoBN->getDescripcion()?></td>
                    <td align="center" nowrap=""><?=$o_VTA_OrdenArchivosBN->getNombre()?></td>
                    <td align="center"><?=substr( $o_VTA_OrdenArchivosBN->getFechaCreacion(), 0, 10 )?></td>
                    <td align="center"><?=$o_VTA_OrdenArchivosBN->getUsuarioCreacion()?></td>
                    <td align="center">
                        <?php if( $o_VTA_OrdenArchivosBN->getTipoArchivoId() ){ ?>
                        <button class="btn" title="" onclick="window.open( '<?=$o_VTA_OrdenArchivosBN->getUbicacionURL()?>', '_BLANK' ); return false;"> <img src="<?=getUrlImage( "btnDisplay.gif" )?>" title="Ver Documento" style="cursor:pointer"> </button>
                        <?php } ?>
                    </td>
                </tr>
                <?php } ?>
                <?php foreach ( VTA_OrdenArchivosFN::getArrayObjArchhivos( $o_VTA_OrdenBN->getOrdenId(), 5 ) as $i_Key => $o_VTA_OrdenArchivosBN ) { ?>
                <tr>
                    <td align="center"><?=$i_Key+1?></td>
                    <td align="center" nowrap=""><?=$o_VTA_OrdenArchivosBN->getNombre()?></td>
                    <td align="center"><?=$o_VTA_OrdenArchivosBN->getObjectOrdenTipoArchivo()->getDescripcion()?></td>
                    <td align="center"><?=substr( $o_VTA_OrdenArchivosBN->getFechaCreacion(), 0, 10 )?></td>
                    <td align="center"><?=$o_VTA_OrdenArchivosBN->getUsuarioCreacion()?></td>
                    <td align="center">
                        <button class="btn" title="" onclick="window.open( '<?=$o_VTA_OrdenArchivosBN->getUbicacionURL()?>', '_BLANK' ); return false;"> <img src="<?=getUrlImage( "btnDisplay.gif" )?>" title="Ver Documento" style="cursor:pointer"> </button>
                    </td>
                </tr>
                <?php } ?>
            </tbody>
        </table>
        
    </fieldset>
    
    <div class="dropdown-divider"></div>
    
    <fieldset class="scheduler-border">
        <legend class="scheduler-border">Cobranza Realizado</legend>
        
        <div class="table-responsive">
            <table class="table table-sm table-bordered table-hover">
                <thead class="thead-light">
                    <tr>
                        <th width="5%" style="text-align: center;" scope="col">Medio de Pago</th>
                        <th width="10%" style="text-align: center;" scope="col">Nro Operaci&oacute;n</th>
                        <th width="5%" style="text-align: center;" scope="col">Tipo Cambio</th>
                        <th width="5%" style="text-align: center;" scope="col">Moneda Doc</th>
                        <!-- <th width="10%" style="text-align: center;" scope="col">Monto Total</th>
                         -->
                        <th width="10%" style="text-align: center;" scope="col">Monto Cobrado</th>
                        <th width="10%" style="text-align: center;" scope="col">Saldo Doc</th>
                        <th width="5%" style="text-align: center;" scope="col">Fecha Aplicado</th>
                    </tr>
                </thead>
                <tbody>
                <?php foreach ( $a_FCO_Aplicacion as $o_FCO_AplicacionBN ){ ?>
                    <tr id="">
                        <td align="center"><?=$o_FCO_AplicacionBN->getTipoPagoNombre()?></td>
                        <td align="center"><?=$o_FCO_AplicacionBN->getReciboNumero()?></td>
                        <td align="center"><?=$o_FCO_AplicacionBN->getTipoCambio()?></td>
                        <td align="center"><?=$o_FCO_AplicacionBN->getMonedaDes()?></td>
                        <td align="center"><?=number_format( $o_FCO_AplicacionBN->getMontoAplicado(), 2 )?></td>
                        <td align="center"><?=number_format( $o_FCO_AplicacionBN->getSaldoDocRef(), 2 )?></td>
                        <td align="center" nowrap="nowrap"><?=substr( $o_FCO_AplicacionBN->getFechaAplicacion(), 0, 10 )?></td>
                    </tr>
                <?php } ?>
                </tbody>
            </table>
        </div>
        
    </fieldset>
    
    <div class="dropdown-divider"></div>
    
    <fieldset class="scheduler-border">
        <legend class="scheduler-border"> Comentario por Aprobaci&oacute;n </legend>
        
        <div class="form-row mx-0">
            <div class="col-md-8 mb-1">
                <div class="card">
                    <div class="form-row mx-0">
                        <div class="col-md-12 mt-1 mb-1">
                            <label class="col-form-label" for="txt_comentario">Comentario</label>
                            <input type="text" class="form-control" name="txt_comentario" id="txt_comentario" onblur="" onfocus="this.select();" required="required" autocomplete="off">
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-4 mb-1">
                &nbsp;
            </div>
        </div>
    </fieldset>
    
    <div id="content_alert" style=""></div>

<?php
$f_CantidadControl = 0;
?>

    <input type="hidden" name="TipoProceso" value="<?=$s_TipoProceso?>"/>
    <input type="hidden" name="IdRuta" value="<?=$s_IdRuta?>"/>
    <input type="hidden" name="IdRutaLinea" value="<?=$s_IdRutaLinea?>"/>
    <input type="hidden" name="IdMovimientoSerie" value="<?=$s_IdMovimientoSerie?>"/>
    <input type="hidden" name="IdTransferencia" value="<?=$s_IdTransferencia?>"/>
    
    <input type="hidden" name="Control" value="ok"/>
    <input type="hidden" name="TipoSubmit" id="TipoSubmit" value=""/>
    
    <div class="table-responsive">
        <!-- <table class="table table-striped table-bordered" style="width:100%" id="example" > -->
        <table class="table table-sm table-bordered table-hover" id="example">
            <thead id="">
                <tr class="table-primary">
                    <th width="1%"  align="center" ><b>No</b></th>
                    <th width="8%" align="center" ><b>C&oacute;digo</b></th>
                    <th width="35%" align=""       ><b>Descripci&oacute;n</b></th>
                    <th width="8%" align="center" ><b>Stock</b></th>
                    <th width="15%" align="center" ><b>Cantidad Pedida</b></th>
                    <th width="15%" align="center" ><b>Cantidad Entregada</b></th>
                </tr>
            </thead>
            
            <tbody id="content_all_row">
                <?php $f_MontoTotal = 0.00 ?>
                <?php foreach ( $a_VTA_DocumentoDetalle as $i_Key => $o_VTA_DocumentoDetalleBN ){ ?>
                    <?php
                    $s_InputId = "input_".$i_Key;
                    $f_CantidadControl = $f_CantidadControl + ( $o_VTA_DocumentoDetalleBN->getCantidadPedida() - $o_VTA_DocumentoDetalleBN->getCantidadRecibida() );
                    ?>
                <tr class="content_row">
                    <td align="center"><?=( $i_Key + 1 )?></td>
                    <td align="center"><?=$o_VTA_DocumentoDetalleBN->getItemCodigo()?></td>
                    <td align="left"><?=$o_VTA_DocumentoDetalleBN->getDescripcion()?></td>
                    <td align="center"><?=$o_VTA_DocumentoDetalleBN->getAlmcenStockDisponible()?></td>
                    <td align="center"><?=$o_VTA_DocumentoDetalleBN->getCantidadPedida()?></td>
                    <td align="center"><?=$o_VTA_DocumentoDetalleBN->getCantidadRecibida()?></td>
                </tr>
                <?php } ?>
            </tbody>
        </table>
    </div>

    <div class="dropdown-divider"></div>
    
    <div class="form-row mx-0" style="padding: 10px;" id="content_buttons">
        <div class="col-md-6 mb-1">
            <button type="button" class="btn btn-danger btn-lg btn-block" onclick="parent.closeWindow()">CANCELAR</button>
        </div>
        <div class="col-md-6 mb-1">
            <button type="button" class="btn btn-primary btn-lg btn-block" onclick="aprobarDespacho();" disabled="disabled" id="btnAprobar">APROBAR</button>
        </div>
    </div>

</form>

<script type="text/javascript">
aprobarDespacho = function()
{
    x = confirm( "Esta seguro de Aprobar el Despacho?" );
    if( x )
    {
    	$('#TipoSubmit').val('APROBAR');
        $( "#form1" ).submit();
    }
}

configurarDataTable = function()
{
    $( '#example' ).DataTable
    (
        {
            language:       { "url": "//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/Spanish.json" },
            responsive:     false,
            searching:      false,
            info:           false,
            lengthChange:   false,
            paging:         false,
            dom:            'lrtip'/*,
            fixedHeader: 
            {
                header: true,
                footer: true
            }*/
        }
    );
}

setTimeout
(
    function () 
    {
        configurarDataTable();
    }, 
    300
);
</script>

<script type="text/javascript">
<?php if( $b_ControlAprobar ){ ?>
parent.findControl();
parent.closeWindow();
<?php } ?>
<?php if( $mensaje_error ){ ?>
showAlertBootStrap( 'content_alert', 'alert-danger', "<?=$mensaje_error?>" );
<?php } ?>
</script>