<?php
class transporteActions extends wtActions
{
    public function executeList()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
    }
    
    public function executeShowdevol()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        
        $this->s_IdProyecto = $this->getRequestParameter( "IdProyecto" );

        $o_VTA_PrsProyectosFN = new VTA_PrsProyectosFN();
        $this->o_VTA_PrsProyectosBN = $o_VTA_PrsProyectosFN->selectByPK( $this->s_IdProyecto );

        /*$o_VTA_OrdenFN = new VTA_OrdenFN();
        $this->o_VTA_OrdenBN = $o_VTA_OrdenFN->selectByPK( $this->s_OrdenId );*/
        
        $o_SR_DevolucionCabeceraFN = new SR_DevolucionCabeceraFN();
        $o_SR_DevolucionCabeceraFN->setIdProyecto( $this->s_IdProyecto );
        //$o_SR_DevolucionCabeceraFN->setOrdenId( $this->s_OrdenId );
        $this->a_SR_DevolucionCabecera = $o_SR_DevolucionCabeceraFN->select();
    }
    
    public function executeViewTransdevol()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        
        $s_DevolucionCabId = $this->getRequestParameter( 'IdCab' );
        
        $o_SR_DevolucionCabeceraFN = new SR_DevolucionCabeceraFN();
        $this->o_SR_DevolucionCabeceraBN = $o_SR_DevolucionCabeceraFN->selectByPK( $s_DevolucionCabId );

        $o_VTA_PrsProyectosFN = new VTA_PrsProyectosFN();
        $this->o_VTA_PrsProyectosBN = $o_VTA_PrsProyectosFN->selectByPK( $this->o_SR_DevolucionCabeceraBN->getIdProyecto() );

        /*$o_VTA_OrdenFN = new VTA_OrdenFN();
        $this->o_VTA_OrdenBN = $o_VTA_OrdenFN->selectByPK( $this->o_SR_DevolucionCabeceraBN->getOrdenId() );*/
    }

    public function executeListAtte()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        
        try
        {
            myUser::getUser()->validar_session();
        }
        catch ( Exception $o_Exception )
        {
            pr( $o_Exception->getMessage() );
        }
    }
    
    public function executeListAprob()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        
        try
        {
            myUser::getUser()->validar_session();
        }
        catch ( Exception $o_Exception )
        {
            pr( $o_Exception->getMessage() );
        }
    }
    
    public function executeListDevol()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        
        try
        {
            myUser::getUser()->validar_session();
        }
        catch ( Exception $o_Exception )
        {
            pr( $o_Exception->getMessage() );
        }
    }
    
    public function executeGrid()
    {
        set_header_utf8();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $o_GridAction = new GridAction();
        $o_GridAction->setClassFind( new TR_RutaDetalleFN() );
        
        //$o_GridAction->addMethodDefault( "( SELECT IdCompania FROM TR_Ruta WHERE IdRuta=TR_RutaDetalle.IdRuta )", array( 'Condition'=>'=', 'Value'=>myUser::getUser()->getIdBusiness() ) );
        
        $o_GridAction->addAssignFilter( "RutaDetEstado" );
        
        $o_GridAction->addConditionFilter( "DocParentCod", TR_RutaDetalleFN::DocParentCod, "LIKE", "%%s%" );
        $o_GridAction->addConditionFilter( "RutaDocumento", TR_RutaDetalleFN::RutaDocumento, "LIKE", "%%s%" );
        $o_GridAction->addConditionFilter( "RutaDocDespacho", TR_RutaDetalleFN::RutaDocDespacho, "LIKE", "%%s%" );
        $o_GridAction->addConditionFilter( "NumeroDocumentoRef", TR_RutaDetalleFN::NumeroDocumentoRef, "LIKE", "%%s%" );
        $o_GridAction->addConditionFilter( "FechaDocumento1", TR_RutaDetalleFN::FechaCreacion,  ">=", '00:00:00' );
        $o_GridAction->addConditionFilter( "FechaDocumento2", TR_RutaDetalleFN::FechaCreacion,  "<=", '23:59:59' );

        
        $o_GridAction->addOrderDefault( TR_RutaDetalleFN::RutaDocDespacho, true );
        //$o_GridAction->addOrder( "DescripcionCorta", GSS_CompaniaFN::DescripcionCorta );
        //$o_GridAction->addOrder( "Ruc",              GSS_CompaniaFN::Ruc );
    
        //$o_GridAction->addOrderDefault( ALM_TransaccionCabeceraFN::FechaCreacion, false );
    
        $o_GridAction->addRowsToShow
        ( 
            "IdConcat", "RutaDocDespacho", "RutaDocumento", "TurnoDesc", "VehiculoDesc", "ChoferDesc", "EstadoDesc", "RutaDetDir1",
            "IdRuta", "IdRutaLinea", "SerieNumeroGuia", "FechaHoraProgramada", "RutaDetEstado"
        );
    
        $o_GridAction->setNumberRecordsShow( 15 );
    
        $o_GridAction->initialize();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    
        $a_ResultJson['page']    = $o_GridAction->getPage();
        $a_ResultJson['total']   = $o_GridAction->getTotalPage();
        $a_ResultJson['records'] = $o_GridAction->getTotalRecords();
        $a_ResultJson['rows']    = $o_GridAction->getResultArray();
        //pr( $a_ResultJson );
        echo json_encode( $a_ResultJson );
    
        return ViewResponse::NONE;
    }
    
    public function executeGridDocs()
    {
        /*if( $this->getRequestParameter( 'DocumentoNumeroPr' ) )
        {
            $s_NumeroFact = str_pad( $this->getRequestParameter( 'DocumentoNumeroPr' ), 8, "0", STR_PAD_LEFT );
            ParameterWR::getInstance()->setVar( "DocumentoNumero", $s_NumeroFact );
        }*/
        //////////////////////////////////////////////////////////////////////////////////////
        $o_GridAction = new GridAction();
        $o_GridAction->setClassFind( new VTA_DocumentoFN() );
        
        $o_GridAction->addMethodDefault( "IdCompania", myUser::getUser()->getIdBusiness() );
        
        $o_GridAction->addAssignFilter( "DocumentoSerie" );
        $o_GridAction->addAssignFilter( "DocumentoNumero" );
        $o_GridAction->addAssignFilter( "AlmacenDespacho" );
        $o_GridAction->addAssignFilter( "IdTipoDocumento" );
        
        $o_GridAction->addConditionFilter( "ClienteNombre", VTA_DocumentoFN::ClienteNombre, "LIKE", "%%s%" );
        $o_GridAction->addConditionFilter( "NumeroComprobante", VTA_DocumentoFN::NumeroComprobante, "LIKE", "%%s%" );
        $o_GridAction->addConditionFilter( "FechaDocumento", "LEFT(FechaDocumento,10)",  "=" );
        
        $o_GridAction->addOrderDefault( VTA_DocumentoFN::DocumentoNumero, false );
        
        $o_GridAction->addMethodDefault( VTA_DocumentoFN::Estado, array( 'Condition'=>'IN', 'Value'=>"('CE')" ) );
        $o_GridAction->addMethodDefault( VTA_DocumentoFN::IdTipoDocumento, array( 'Condition'=>'NOT IN', 'Value'=>"('NC')" ) );
        
        $o_GridAction->setControlArray( false );
        
        /*$o_GridAction->addRowsToShow(
            "IdConcat", "IdTipoDocumento", "NumeroDocumento", "FechaDocumentoDate", "ClienteNombre", "FechaVencimiento",
            "MontoTotal", "Estado", "DocumentoSerieNumero", "FormaPagoDes", "EstadoDesc", "TipoDocumentoDesc", "ControlTieneDeuda",
            "MontoTotalAlt", "EsUltimoSerieNumero", "IdTipoDocumentoCustom", "TieneNotaCredito", "IdTipoDocumento"
            );
        */
        $o_GridAction->setNumberRecordsShow( 9999 );
        
        $o_GridAction->initialize();
        //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $a_ResultJson['page']    = $o_GridAction->getPage();
        $a_ResultJson['total']   = $o_GridAction->getTotalPage();
        $a_ResultJson['records'] = $o_GridAction->getTotalRecords();
        //$a_ResultJson['rows']    = $o_GridAction->getResultArray();
        $this->a_VTA_Documento = $o_GridAction->getResultSelect();
        
        ViewResponse::getInstance()->setMethodAjax();
    }
    
    public function executeRouting()
    {
        //LayoutTemplate::getInstance()->setUseBootstrap();
        $this->s_Titulo = "MANIFIESTO";
        
        $this->a_Serie = VTA_DocumentoFN::recuperarFiltroSerie();
        
        $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
        $o_ALM_AlmacenMastFN->setIdCompania( myUser::getUser()->getIdBusiness() );
        $o_ALM_AlmacenMastFN->setEstado( "A" );
        $o_ALM_AlmacenMastFN->setIdSucursal( myUser::getUser()->getIdSucursal() );
        $o_ALM_AlmacenMastFN->addOrderBy( ALM_AlmacenMastFN::DescripcionLocal );
        $this->a_ALM_AlmacenMast = $o_ALM_AlmacenMastFN->select();
        
        myUser::getUser()->getIdBusiness();
        myUser::getUser()->getIdSucursal();
        
        $o_GSS_SucursalDocumentoFN = new GSS_SucursalDocumentoFN();
        $o_GSS_SucursalDocumentoFN->setIdCompania(myUser::getUser()->getIdBusiness());
        $o_GSS_SucursalDocumentoFN->setIdSucursal(myUser::getUser()->getIdSucursal());
        $o_GSS_SucursalDocumentoFN->setEstado("A");
        $this->a_GSS_SucursalDocumentoFN = $o_GSS_SucursalDocumentoFN->select();
        //pr($this->a_GSS_SucursalDocumentoFN);
    }
    
    public function executeSaveRouting()
    {
        $FechaProg  = $this->getRequestParameter( 'FechaProg' );
        $IdChofer   = $this->getRequestParameter( 'IdChofer' );
        $IdDoc      = $this->getRequestParameter( 'IdDoc' );
        $IdTurno    = $this->getRequestParameter( 'IdTurno' );
        $IdVehiculo = $this->getRequestParameter( 'IdVehiculo' );
        $IdRuta     = $this->getRequestParameter( 'IdRuta' );
        
        try 
        {
            $a_Ids = explode( "_", $IdDoc );
            $IdTipoDocumento = $a_Ids[0];
            $IdCompania      = $a_Ids[1];
            $NumeroDocumento = $a_Ids[2];
        
            //SE REALIZA UNA TRANSACCION DE SALIDA:
            $o_VTA_DocumentoFN = new VTA_DocumentoFN();
            $o_VTA_DocumentoBN = $o_VTA_DocumentoFN->selectByPK( $IdTipoDocumento, $IdCompania, $NumeroDocumento );

            $o_TR_RutaBN = new TR_RutaBN();
            $o_TR_RutaBN->setObjectoDocumento( $o_VTA_DocumentoBN );
            //$o_TR_RutaBN->setRutaFechaProgramada( $o_TMP_TR_RutaBN->getRutaFechaProgramada() );
            $o_TR_RutaBN->setIdTurno( ( int ) $IdTurno );
            $o_TR_RutaBN->setIdVehiculo( ( int ) $IdVehiculo );
            $o_TR_RutaBN->setIdChofer( ( int ) $IdChofer );
            $o_TR_RutaBN->setIdRuta( ( int ) $IdRuta );
            
            $o_TransporteBL = new TransporteBL();
            $b_Result = $o_TransporteBL->guardarRuta( $o_TR_RutaBN );
            
            $a_Rs['error']   = false;
        }
        catch ( Exception $o_Exception )
        {
            pr( $o_Exception );
            $a_Rs['error']         = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }
        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }
    
    public function executeDeleteRouting()
    {
        $IdRuta      = $this->getRequestParameter( 'IdRuta' );
        $IdRutaLinea = $this->getRequestParameter( 'IdRutaLinea' );
        
        $con = Conexion::getConexion();
        $con->begin();
        try
        {
            
            //PRIMEA OPCION
            $o_TR_RutaFN = new TR_RutaFN();
            $o_TR_RutaBN = $o_TR_RutaFN->selectByPK( $IdRuta );
            
            $o_TR_RutaDetalleFN = new TR_RutaDetalleFN();
            //$o_TR_RutaDetalleFN->setDebug( 1 );
            $o_TR_RutaDetalleBN = $o_TR_RutaDetalleFN->selectByPK( $IdRuta, $IdRutaLinea );

            $o_VTA_DocumentoBN = $o_TR_RutaDetalleBN->getObjectVTADocumento();
            
            if( $o_VTA_DocumentoBN->getDocumentoParentId() )
            {
                $o_VTA_OrdenFN = new VTA_OrdenFN();
                $o_VTA_OrdenBN = $o_VTA_OrdenFN->selectByPK( $o_VTA_DocumentoBN->getDocumentoParentId() );
            }
            
            $SR_GuiaRemisionHFN = new SR_GuiaRemisionHFN();
            //$SR_GuiaRemisionHFN->setReferenciaNumero( $this->s_Documento );
            $SR_GuiaRemisionHFN->setReferenciaParentId( $o_VTA_OrdenBN->getOrdenId() );
            $a_SR_GuiaRemisionH = $SR_GuiaRemisionHFN->select();

            if( $a_SR_GuiaRemisionH );
            {
                foreach ( $a_SR_GuiaRemisionH as $oa_SR_GuiaRemisionHBN )
                {
                    $GuiaRemisionHDP = new SR_GuiaRemisionHDP();
                    $GuiaRemisionHDP->setGuiaRemisionId( $oa_SR_GuiaRemisionHBN->getGuiaRemisionId() );
                    $GuiaRemisionHDP->delete();
                }
            }
            
            $o_TR_RutaDetalleDP = new TR_RutaDetalleDP();
            $o_TR_RutaDetalleDP->setIdRuta( ( int ) $IdRuta );
            $o_TR_RutaDetalleDP->setIdRutaLinea( ( int ) $IdRutaLinea );
            $b_Result = $o_TR_RutaDetalleDP->delete();
        
            $con->commit();
            
            $a_Rs['error']  = false;
        }
        catch ( Exception $o_Exception )
        {
            $con->rollback();
            $a_Rs['error']         = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }
        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }
    
    public function executeListRouting()
    {
        //LayoutTemplate::getInstance()->setUseBootstrap();
    }
    
    public function executeChangeStatusRouting()
    {
        $IdRuta = $this->getRequestParameter( 'IdRuta' );
        $Estado = $this->getRequestParameter( 'Estado' );
        try
        {
            $o_TR_RutaBN = new TR_RutaBN();
            $o_TR_RutaBN->setIdRuta( ( int ) $IdRuta );
            $o_TR_RutaBN->setEstado( $Estado );

            $o_TransporteBL = new TransporteBL();
            $o_TransporteBL->cambiarEstadoRuta( $o_TR_RutaBN );
        
            $a_Rs['error']   = false;
        }
        catch ( Exception $o_Exception )
        {
            $a_Rs['error']         = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }
        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }

    public function executeEliminarRuta()
    {
        $i_Id = $this->getRequestParameter( 'i_Id' );
        
        $a_Rs = array( "error" => false );
        
        try 
        {
            $o_TR_RutaFN = new TR_RutaFN();
            $o_TR_RutaBN = $o_TR_RutaFN->selectByPK( $i_Id );
            
            if( $o_TR_RutaBN )
            {
                //validacion de estado y cantidad de detalles
                if( $o_TR_RutaBN->getCantidadTotalDetalle() > 0 )
                {
                    throw new Exception( "No se puede eliminar la Ruta si tiene detalles." );
                }
                
                $o_TR_RutaDP = new TR_RutaDP();
                $o_TR_RutaDP->setIdRuta(  ( int ) $i_Id );
                $o_TR_RutaDP->setEstado( "A" ); //A ANULADO
                $o_TR_RutaDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $o_TR_RutaDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $o_TR_RutaDP->update();
                //$b_Result = $o_ALM_ItemMastDP->delete();
            }
            else
           {
                throw new Exception( "No se en contro la Ruta." );
            }

            $a_Rs['id']      = $i_Id;
        }
        catch ( Exception $o_Exception )
        {
            $a_Rs['error']   = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
            //$a_Rs['mensaje_error'] = "No se pudo eliminar el registro.";
        }
        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }
}