<?php
class GridAprobAction extends wtActions
{
    public function execute()
    {
        $o_GridAction = new GridAction();
        $o_GridAction->setClassFind( new SR_MovimientoFN() );
        
        $o_GridAction->addAssignFilter( "Estado" );
        $o_GridAction->addAssignFilter( "EstadoAprob" );
        
        $o_GridAction->addConditionFilter( "ReferenciaNumero", SR_MovimientoFN::ReferenciaNumero, "LIKE", "%%s%" );
        $o_GridAction->addConditionFilter( "FechaDocumento1", SR_MovimientoFN::Fecha, ">=", '00:00:00' );
        $o_GridAction->addConditionFilter( "FechaDocumento2", SR_MovimientoFN::Fecha, "<=", '23:59:59' );
        
        $o_GridAction->addMethodDefault( "TipoMovimiento", array( "Condition" => "IN", "Value" => "('VTA')" ) ); //se muestra registros con estado Completados
        
        $o_GridAction->addOrderDefault( SR_MovimientoFN::MovimientoId, false );
        
        $o_GridAction->addRowsToShow
        (
                "MovimientoId", "ReferenciaTipo", "ReferenciaNumeroSecuencia", "ReferenciaFecha", "Estado", "EstadoDesc", "ImpresionEstado", "ImpresionEstadoDesc","NombreCliente", "DocumentoReferencia", "ReferenciaId",
                "DocumentoCliente", "ConcatComercialClasificacion", "AprobacionEstadoDesc"
        );
        
        $o_GridAction->setNumberRecordsShow( 100 );
        
        $o_GridAction->initialize();
        
        $a_ResultJson['page']    = $o_GridAction->getPage();
        $a_ResultJson['total']   = $o_GridAction->getTotalPage();
        $a_ResultJson['records'] = $o_GridAction->getTotalRecords();
        $a_ResultJson['rows']    = $o_GridAction->getResultArray();
        
        echo json_encode( $a_ResultJson );
        
        return ViewResponse::NONE;
    }
}