<?php
class AprobGuiaRemAction extends wtActions
{
    public function execute()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        
        $this->s_TipoProceso       = $this->getRequestParameter( "TipoProceso" ); //POR AHORA SOLO HAY 2 TIPOS -> TR[TRANSFERENCIA] DE[DESPACHO][PARA VENTA]
        $this->s_IdRuta            = $this->getRequestParameter( "IdRuta" );
        $this->s_IdRutaLinea       = $this->getRequestParameter( "IdRutaLinea" );
        $this->s_IdMovimientoSerie = $this->getRequestParameter( "IdMovimientoSerie" );
        $this->s_IdTransferencia   = $this->getRequestParameter( "IdTransferencia" );
        $this->mensaje_error       = "";
        
        if( $this->getRequestParameter( "IdMovimientoSerie" ) )
        {
            $o_SR_MovimientoFN = new SR_MovimientoFN();
            $o_SR_MovimientoBN = $o_SR_MovimientoFN->selectByPK( $this->s_IdMovimientoSerie );
            
            //ahora se recupera la direccion de partida
            $s_AlmacenDespacho = $o_SR_MovimientoBN->getAlmacen();
            $i_IdSucursal = ALM_AlmacenMastFN::recuperarIdSucursal( $s_AlmacenDespacho );
            
            if( $o_SR_MovimientoBN->getTipoMovimiento() == "VTA" && $o_SR_MovimientoBN->getReferenciaTipo() == "OS" )
            {
                $o_DocumentoReferencia = $o_SR_MovimientoBN->getObjectDocumentoReferencia();
                $this->o_VTA_DocumentoBN = $o_DocumentoReferencia->getObjectVTADocumento();
                $this->a_VTA_DocumentoDetalle = $this->o_VTA_DocumentoBN->getArrayObjectDetalles();
            }
        }
        
        //para este sistema se esta trabajando con ordenes, por lo tanto se recupera el parent
        $this->o_VTA_OrdenBN      = new VTA_OrdenBN();
        $this->b_ControlProdFinal = 0;
        if( $this->o_VTA_DocumentoBN->getDocumentoParentId() )
        {
            $o_VTA_OrdenFN = new VTA_OrdenFN();
            $this->o_VTA_OrdenBN = $o_VTA_OrdenFN->selectByPK( $this->o_VTA_DocumentoBN->getDocumentoParentId() );
            
            if( $this->o_VTA_OrdenBN->getOrdenTipoClasificacionId() == VTA_OrdenBN::TIPO_PRODUCTOS_TERMINADOS )
            {
                $this->b_ControlProdFinal = 1;
            }
        }
        
        if( $this->getRequestParameter( "IdRuta" ) )
        {
            $s_IdRuta = $this->getRequestParameter( "IdRuta" );
            $s_IdRutaLinea = $this->getRequestParameter( "IdRutaLinea" );
            
            $o_TR_RutaFN = new TR_RutaFN();
            $o_TR_RutaBN = $o_TR_RutaFN->selectByPK( $s_IdRuta );
            
            $o_TR_RutaDetalleFN = new TR_RutaDetalleFN();
            $o_TR_RutaDetalleBN = $o_TR_RutaDetalleFN->selectByPK( $s_IdRuta, $s_IdRutaLinea );
            
            $o_VTA_DocumentoBN = $o_TR_RutaDetalleBN->getObjectVTADocumento();
            $a_VTA_DocumentoDetalle = $o_VTA_DocumentoBN->getArrayObjectDetalles();
            
            $this->o_VTA_DocumentoBN = $o_VTA_DocumentoBN;
            $this->a_VTA_DocumentoDetalle = $a_VTA_DocumentoDetalle;
        }
        
        $this->b_ControlAprobar = false;
        
        $o_FCO_AplicacionFN = new FCO_AplicacionFN();
        $o_FCO_AplicacionFN->setIdDocNumRef( $this->o_VTA_DocumentoBN->getNumeroDocumento() );
        $this->a_FCO_Aplicacion = $o_FCO_AplicacionFN->select();
        
        if( $this->getRequestParameter( "Control" ) )
        {
            try
            {
                myUser::getUser()->validar_session();
                
                if( $this->getRequestParameter( "TipoSubmit" ) == "APROBAR" )
                {
                    $s_Comentario = $this->getRequestParameter( "txt_comentario" );
                    
                    $o_SR_MovimientoDP = new SR_MovimientoDP();
                    $o_SR_MovimientoDP->setMovimientoId( ( int ) $this->s_IdMovimientoSerie );
                    $o_SR_MovimientoDP->setEstadoAprob( SR_MovimientoBN::APROBACION_COMPLETADO );
                    $o_SR_MovimientoDP->setComentarioAprob( $s_Comentario );
                    $o_SR_MovimientoDP->setUsuarioAprob( myUser::getUser()->getUserId() );
                    $o_SR_MovimientoDP->setFechaAprob( date( "Y-m-d H:i:s" ) );
                    $o_SR_MovimientoDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                    $o_SR_MovimientoDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                    $o_SR_MovimientoDP->update();
                    
                    $this->b_ControlAprobar = true;
                }
            }
            catch ( Exception $o_Exception )
            {
                $this->mensaje_error = $o_Exception->getMessage();
            }
        }
    }
}