<?php
$sDirBase = dirname(__FILE__).'/../../../../../';
require $sDirBase.'plugins/dompdf-master/vendor/autoload.php';

use Dompdf\Dompdf;

class transfActions extends wtActions
{
    public function executePrintPDF()
    {
        ///////////////////////////////////////////////////////////////////////////
        ///PARAMETROS
        $this->block      = $this->getRequestParameter( 'block' );
        $this->i_Id       = $this->getRequestParameter( 'i_Id' );
        $this->s_TipoProc = $this->getRequestParameter( 'TipoProc' );
        
        $o_DefaultFN = new ALM_TransferenciaCabeceraFN();
        $o_DefaultBN = $o_DefaultFN->selectByPK( $this->i_Id );

        $o_GSS_CompaniaFN = new GSS_CompaniaFN();
        $o_GSS_CompaniaOriBN = $o_GSS_CompaniaFN->selectByPK( $o_DefaultBN->getObjectAlmacen()->getIdCompania() );

        $o_GSS_CompaniaFN = new GSS_CompaniaFN();
        $o_GSS_CompaniaDesBN = $o_GSS_CompaniaFN->selectByPK( $o_DefaultBN->getObjectAlmacenDestino()->getIdCompania() );
        ///////////////////////////////////////////////////////////////////////////

        //////////////////////////////////////////////////////////////////////////////////////
        $s_Class  = Parameter::getInstance()->getModule();
        $s_Module = strtolower( $s_Class );
        $s_Action = Parameter::getInstance()->getActions();
        $s_Methods = ucwords( $s_Action );

        $s_FileTemp = SF_ROOT_DIR.DIRECTORY_SEPARATOR.'apps'.DIRECTORY_SEPARATOR.SF_APP.DIRECTORY_SEPARATOR."modules".DIRECTORY_SEPARATOR.$s_Module.DIRECTORY_SEPARATOR."templates".DIRECTORY_SEPARATOR.$s_Action."Success.php";
        
        ob_start();
        require( $s_FileTemp );
        $html = ob_get_contents();
        ob_end_clean();

        //echo $html;         exit;
        
        $dompdf = new Dompdf();
        $dompdf->loadHtml( $html );
        $dompdf->setPaper( 'A4', 'portrait' );
        $dompdf->render();
        $dompdf->stream( 'Transferencia'.date( "Ymd" ), array( "Attachment" => 0 ) );
        
        exit;
        //////////////////////////////////////////////////////////////////////////////////////
    }

    public function executeRequest()
    {
        set_header_utf8();
        $block                  = $this->getRequestParameter( 'block' );
        $IdTransaccionOperacion = $this->getRequestParameter( 'IdTransaccionOperacion' );
        $IdTransaccion          = $this->getRequestParameter( 'IdTransaccion' );
        $TipoProc               = $this->getRequestParameter( 'TipoProc' );
        
        $IdTipoDocumento        = $this->getRequestParameter( 'IdTipoDocumento' );
        
        $a_lst                  = array( "result" => false, "error" => false );
        
        switch ( $TipoProc )
        {
            case "getDetOrdenProduccion":
                
                $s_IdOrdenProd = $this->getRequestParameter( 'IdOrdenProd' );
                
                try 
                {
                    $o_PRD_OrdenCabFN = new PRD_OrdenCabFN();
                    $o_PRD_OrdenCabBN = $o_PRD_OrdenCabFN->selectByPK( $s_IdOrdenProd );
                    if( $o_PRD_OrdenCabBN->getEstado() != PRD_OrdenCabBN::ESTADO_PENDIENTE )
                    {
                        //throw new Exception( "La Orden de Produccion seleccionado, tiene un estado diferente a lo permitido." );
                    }
                    $o_PRD_OrdenDetFN = new PRD_OrdenDetFN();
                    $o_PRD_OrdenDetFN->setIdOrdenCab( $s_IdOrdenProd );
                    $o_PRD_OrdenDetFN->setItemTipo( "PR" );
                    $a_PRD_OrdenDet = $o_PRD_OrdenDetFN->select();
                    $f_CantTrfTot = 0;
                    foreach ( $a_PRD_OrdenDet as $o_PRD_OrdenDetBN )
                    {
                        $f_CantTrf = $o_PRD_OrdenDetBN->getCantidadPedida() - $o_PRD_OrdenDetBN->getCantidadRecibida();
                        if( $f_CantTrf <= 0 )
                        {
                            continue;
                        }
                        $a_lst['ListItem'][] = array( "IdItem" => $o_PRD_OrdenDetBN->getIdItem(), "Descripcion" => $o_PRD_OrdenDetBN->getDescripcionItem(), "Cantidad" => $f_CantTrf );
                        $f_CantTrfTot = $f_CantTrfTot + $f_CantTrf;
                    }
                    if( $f_CantTrfTot <= 0 )
                    {
                        throw new Exception( "Actualmente la Orden seleccionada no tiene nada que producir." );
                    }
                }
                catch ( Exception $o_Exception )
                {
                    $a_lst = array( "error" => true, "mensaje_error" => $o_Exception->getMessage() );
                }
                
            break;
            case "getSerieNumero":
                $o_GSS_SucursalDocumentoFN = new GSS_SucursalDocumentoFN();
                $o_GSS_SucursalDocumentoFN->setIdCompania( myUser::getUser()->getIdBusiness() );
                if( myUser::getUser()->getIdSucursal() )
                {
                    $o_GSS_SucursalDocumentoFN->setIdSucursal( myUser::getUser()->getIdSucursal() );
                }
                $o_GSS_SucursalDocumentoFN->setIdTipoDocumento( $IdTipoDocumento );
                $a_GSS_SucursalDocumento = $o_GSS_SucursalDocumentoFN->select();
                
                if( $a_GSS_SucursalDocumento )
                {
                    $o_GSS_SucursalDocumentoBN = $a_GSS_SucursalDocumento[0];
                    
                    $s_Serie  = $o_GSS_SucursalDocumentoBN->getSerieFormatoFinal();
                    $s_Numero = $o_GSS_SucursalDocumentoBN->getNumeroActualFormato();
                    
                    $a_lst = array( "result" => true, "error" => false, "Serie" => $s_Serie, "Numero" => $s_Numero );
                }
            break;
            case  "DeleteLine":
                $i_IdTransferencia = ( int ) $this->getRequestParameter( 'IdTransferencia' );
                $i_IdSecuencia     = ( int ) $this->getRequestParameter( 'IdSecuencia' );
                
                try 
                {
                    $o_ALM_TransferenciaDetalleDP = new ALM_TransferenciaDetalleDP();
                    $o_ALM_TransferenciaDetalleDP->setIdTransferencia( $i_IdTransferencia );
                    $o_ALM_TransferenciaDetalleDP->setIdSecuencia( $i_IdSecuencia );
                    $o_ALM_TransferenciaDetalleDP->setEstado( "I" );
                    $o_ALM_TransferenciaDetalleDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                    $o_ALM_TransferenciaDetalleDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                    $o_ALM_TransferenciaDetalleDP->update();
                    $s_MensajeError = "";
                    $b_Result = false;
                }
                catch ( Exception $o_Exception )
                {
                    $b_Result = true;
                    $s_MensajeError = $o_Exception->getMessage();
                }
                
                $a_lst = array( "error" => $b_Result, "mensaje_error" => $s_MensajeError );
            break;
            case  "UpdateLineQty":
                $i_IdTransferencia = ( int ) $this->getRequestParameter( 'IdTransferencia' );
                $i_IdSecuencia     = ( int ) $this->getRequestParameter( 'IdSecuencia' );
                $f_Cantidad        = floatval( $this->getRequestParameter( 'Qty' ) );
                
                try 
                {
                    $o_ALM_TransferenciaDetalleDP = new ALM_TransferenciaDetalleDP();
                    $o_ALM_TransferenciaDetalleDP->setIdTransferencia( $i_IdTransferencia );
                    $o_ALM_TransferenciaDetalleDP->setIdSecuencia( $i_IdSecuencia );
                    $o_ALM_TransferenciaDetalleDP->setCantidad( $f_Cantidad );
                    $o_ALM_TransferenciaDetalleDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                    $o_ALM_TransferenciaDetalleDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                    $o_ALM_TransferenciaDetalleDP->update();
                    $s_MensajeError = "";
                    $b_Result = false;
                }
                catch ( Exception $o_Exception )
                {
                    $b_Result = true;
                    $s_MensajeError = $o_Exception->getMessage();
                }
                $a_lst = array( "error" => $b_Result, "mensaje_error" => $s_MensajeError );
            break;
            case "InsertLine":
                $i_IdTransferencia = ( int ) $this->getRequestParameter( 'IdTransferencia' );
                //DETALLES
                $a_Cantidad                 = $this->getRequestParameter( 'Cantidad' ); //
                $a_IdItem                   = $this->getRequestParameter( 'IdItem' ); //
                $a_IdLote                   = $this->getRequestParameter( 'IdLote' ); //
                $a_FechaVencimiento         = $this->getRequestParameter( 'FechaVencimiento' ); //
                $a_IdUnidad                 = $this->getRequestParameter( 'IdUnidad' ); //
                
                try 
                {
                    foreach ( $a_IdItem as $i_Key => $s_Value )
                    {
                        if( $s_Value != "" )
                        {
                            $o_ALM_TransferenciaDetalleDP = new ALM_TransferenciaDetalleDP();
                            $o_ALM_TransferenciaDetalleDP->setIdTransferencia( $i_IdTransferencia );
                            $o_ALM_TransferenciaDetalleDP->setIdItem( $s_Value );
                            $o_ALM_TransferenciaDetalleDP->setDescripcionItem( ALM_ItemMastFN::getStaticDescripcionItem( $s_Value ) );
                            $o_ALM_TransferenciaDetalleDP->setIdLote( $a_IdLote[$i_Key] );
                            $o_ALM_TransferenciaDetalleDP->setFechaVencimiento( $a_FechaVencimiento[$i_Key] );
                            $o_ALM_TransferenciaDetalleDP->setCantidad( floatval( $a_Cantidad[$i_Key] ) );
                            $o_ALM_TransferenciaDetalleDP->setUnidadCodigo( $a_IdUnidad[$i_Key] );
                            
                            $i_IdSecuencia = ALM_TransferenciaDetalleFN::recuperarId( $i_IdTransferencia );
                            $o_ALM_TransferenciaDetalleDP->setIdSecuencia( $i_IdSecuencia );
                            $o_ALM_TransferenciaDetalleDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                            $o_ALM_TransferenciaDetalleDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                            $o_ALM_TransferenciaDetalleDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                            $o_ALM_TransferenciaDetalleDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                            $b_Result = $o_ALM_TransferenciaDetalleDP->save();
                        }
                    }
                    
                    $s_MensajeError = "";
                    $b_Result = false;
                }
                catch ( Exception $o_Exception )
                {
                    $b_Result = true;
                    $s_MensajeError = $o_Exception->getMessage();
                }
                $a_lst = array( "error" => $b_Result, "mensaje_error" => $s_MensajeError );
            break;
            case "seleccionarVehiculo":
                //$s_IdAlmacen = $this->getRequestParameter( 'IdAlmacen' );
                /*
                $i_IdSucursal = null;
                if( $s_IdAlmacen )
                {
                    $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
                    $o_ALM_AlmacenMastBN = $o_ALM_AlmacenMastFN->selectByPK( $s_IdAlmacen );
                    $i_IdSucursal = $o_ALM_AlmacenMastBN->getIdSucursal();
                }
                */
                
                $o_ALM_VehiculoSucursalFN = new ALM_VehiculoSucursalFN();
                $o_ALM_VehiculoSucursalFN->setIdSucursal( myUser::getUser()->getIdSucursal() );
                $o_ALM_VehiculoSucursalFN->setEstado( "A" );
                $a_Result = $o_ALM_VehiculoSucursalFN->select();
                if( !$a_Result )
                {
                    $o_ALM_VehiculoSucursalFN = new ALM_VehiculoSucursalFN();
                    $o_ALM_VehiculoSucursalFN->setEstado( "A" );
                    $a_Result = $o_ALM_VehiculoSucursalFN->select();
                    if( !$a_Result )
                    {
                        $a_Result = array();
                    }
                }
                $s_NameId  = "getIdVehiculoSucursal";
                $s_NameDes = "getMarcaPlaca";
                $a_lst = array();
                foreach ( $a_Result as $i_Key => $o_ObjectBN )
                {
                    $a_lst[$o_ObjectBN->$s_NameId()] = $o_ObjectBN->$s_NameDes();
                }
            break;
            case "cargarAlmacenOrigen":
                $s_IdSucursal = $this->getRequestParameter( 'IdSucursalOrigen' );
                
                $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
                $o_ALM_AlmacenMastFN->setIdCompania( myUser::getUser()->getIdBusiness() );
                $o_ALM_AlmacenMastFN->setIdSucursal( $s_IdSucursal );
                $o_ALM_AlmacenMastFN->addCondition( ALM_AlmacenMastFN::Estado ,"<>", "I" );
                $o_ALM_AlmacenMastFN->addOrderBy( ALM_AlmacenMastFN::DescripcionLocal );
                $a_ALM_AlmacenMast = $o_ALM_AlmacenMastFN->select();
                $s_NameId  = "getIdAlmacen";
                $s_NameDes = "getDescripcionLocal";
                $a_lst = array();
                foreach ( $a_ALM_AlmacenMast as $i_Key => $o_ObjectBN )
                {
                    $a_lst[$o_ObjectBN->$s_NameId()] = $o_ObjectBN->$s_NameDes();
                }
            break;
            case "cargarAlmacenDestino":
                $s_IdSucursal = $this->getRequestParameter( 'IdSucursalDestino' );
                
                $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
                $o_ALM_AlmacenMastFN->setIdCompania( myUser::getUser()->getIdBusiness() );
                $o_ALM_AlmacenMastFN->setIdSucursal( $s_IdSucursal );
                $o_ALM_AlmacenMastFN->addCondition( ALM_AlmacenMastFN::Estado ,"<>", "I" );
                $o_ALM_AlmacenMastFN->addOrderBy( ALM_AlmacenMastFN::DescripcionLocal );
                
                $a_ALM_AlmacenMast = $o_ALM_AlmacenMastFN->select();
                $s_NameId  = "getIdAlmacen";
                $s_NameDes = "getDescripcionLocal";
                $a_lst = array();
                foreach ( $a_ALM_AlmacenMast as $i_Key => $o_ObjectBN )
                {
                    $a_lst[$o_ObjectBN->$s_NameId()] = $o_ObjectBN->$s_NameDes();
                }
            break;
        }
        echo json_encode( $a_lst );
        return ViewResponse::NONE;
    }
    
    public function executeList()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        $this->block = $this->getRequestParameter( 'block' );
        $this->GlobalAccess   = myUser::getUser()->hasGlobalAccess();
        
        $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
        $o_ALM_AlmacenMastFN->setIdSucursal( myUser::getUser()->getIdSucursal() );
        $o_ALM_AlmacenMastFN->setIdCompania( myUser::getUser()->getIdBusiness() );
        $o_ALM_AlmacenMastFN->addOrderBy( ALM_AlmacenMastFN::DescripcionLocal );
        $this->opt_seleccione_or = $this->GlobalAccess;
        $this->opt_seleccione_ds = true;
        if( !$this->GlobalAccess )
        {
            $s_IdAlmacenDefault = GSS_SucursalFN::recuperarIdAlmacen( myUser::getUser()->getIdSucursal() );
            $o_ALM_AlmacenMastFN->setIdAlmacen( $s_IdAlmacenDefault );
        }
        $this->a_ALM_AlmacenMastOrg = $o_ALM_AlmacenMastFN->select();
        

        $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
        $o_ALM_AlmacenMastFN->setIdSucursal( myUser::getUser()->getIdSucursal() );
        $o_ALM_AlmacenMastFN->setIdCompania( myUser::getUser()->getIdBusiness() );
        $s_IdAlmacenDefault = GSS_SucursalFN::recuperarIdAlmacen( myUser::getUser()->getIdSucursal() );
        //$o_ALM_AlmacenMastFN->addCondition( ALM_AlmacenMastFN::IdAlmacen, "NOT IN", "('".$s_IdAlmacenDefault."')", false );

        $o_ALM_AlmacenMastFN->addOrderBy( ALM_AlmacenMastFN::DescripcionLocal );
        $this->a_ALM_AlmacenMastDst = $o_ALM_AlmacenMastFN->select();
        
        $this->a_TipoTransaccion = ALM_TransaccionCabeceraBN::getArrayTipoTransaccion();
        
        $o_ALM_TipoDocumentoFN = new ALM_TipoDocumentoFN(); //PARA DOCUMENTO DE REFENCIA
        $o_ALM_TipoDocumentoFN->setEstado( "A" );
        $this->a_ALM_TipoDocumento = $o_ALM_TipoDocumentoFN->select();
        
        $o_ALM_TransaccionMastFN = new ALM_TransaccionMastFN();
        $o_ALM_TransaccionMastFN->addOrderBy( ALM_TransaccionMastFN::DescripcionLocal );
        $o_ALM_TransaccionMastFN->addCondition( ALM_TransaccionMastFN::IngresoEgresoFlag, "IN", "( 'T' )", false );
        $this->a_ALM_TransaccionMast  = $o_ALM_TransaccionMastFN->select();
        
        $this->a_EstadosTransf = ALM_TransferenciaCabeceraBN::getArrayEstados();
    }
    
    public function executeGrid()
    {
        $block = $this->getRequestParameter( 'block' );
        $page  = $this->getRequestParameter( 'page' );
        
        //*set_header_utf8();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $o_GridAction = new GridAction();
        $o_GridAction->setClassFind( new ALM_TransferenciaCabeceraFN() );
        
        $o_GridAction->addMethodDefault( "IdCompania", myUser::getUser()->getIdBusiness() );

        if( !myUser::getUser()->hasGlobalAccess() )
        {
            $IdAlmacen = GSS_SucursalFN::recuperarIdAlmacen( myUser::getUser()->getIdSucursal() );
            $o_GridAction->addMethodDefault( "IdAlmacen", $IdAlmacen );
        }
        else
        {
            $o_GridAction->addAssignFilter( "IdAlmacen" );
        }
        
        $o_GridAction->addAssignFilter( "IdCompania" );
        //$o_GridAction->addAssignFilter( "IdAlmacen" );
        $o_GridAction->addAssignFilter( "AlmacenTraslado" );
        $o_GridAction->addAssignFilter( "IdTransaccionOperacion" );
        $o_GridAction->addAssignFilter( "IdTransaccion" );
        $o_GridAction->addAssignFilter( "Estado" );
        
        $o_GridAction->addConditionFilter( "FechaDocumento1", ALM_TransferenciaCabeceraFN::FechaDocumento,    ">=" );
        $o_GridAction->addConditionFilter( "FechaDocumento2", ALM_TransferenciaCabeceraFN::FechaDocumento,    "<=" );
        
        //BUSQUEDA POR LA SERIE Y NUMERO - CONCAT
        $o_GridAction->addConditionFilter( "SerieNumero", "CONCAT(ReferenciaSerieDocumento,'-',ReferenciaNumeroDocumento)",  "=" );
        
        $o_GridAction->addOrderDefault( ALM_TransferenciaCabeceraFN::FechaCreacion, false );
        
        $o_GridAction->addRowsToShow( "IdTransferencia", "IdTipoDocumento", "IdNumeroDocumento", "FechaDocumentoPer", "IdTransaccion", "IdAlmacen", "AlmacenTraslado", "DocReferencia", "EstadoDesc", "Estado" );
        
        $o_GridAction->addInnerJoin( new ALM_TransaccionMastFN(), "IdTransaccion", "DescripcionLocal" );
        $o_GridAction->addInnerJoin( new ALM_AlmacenMastFN(), "IdAlmacen", "DescripcionLocal" );
        $o_GridAction->addInnerJoin( new ALM_AlmacenMastFN(), "AlmacenTraslado", "DescripcionLocal" );
        $o_GridAction->addInnerJoin( new ALM_TipoDocumentoFN(), "IdTipoDocumento", "Descripcion" );
              
        $o_GridAction->setNumberRecordsShow( 15 );
        
        $o_GridAction->initialize();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $a_ResultJson['page']    = $o_GridAction->getPage();
        $a_ResultJson['total']   = $o_GridAction->getTotalPage();
        $a_ResultJson['records'] = $o_GridAction->getTotalRecords();
        $a_ResultJson['rows']    = $o_GridAction->getResultArray();

        echo json_encode( $a_ResultJson );

        return ViewResponse::NONE;
    }
    
    public function executeAddedit()
    {
        set_header_utf8();
        
        $this->block      = $this->getRequestParameter( 'block' );
        $this->i_Id       = $this->getRequestParameter( 'i_Id' );
        $this->s_TipoProc = $this->getRequestParameter( 'TipoProc' );
        
        $this->GlobalAccess   = myUser::getUser()->hasGlobalAccess();
        
        $o_GSS_CompaniaFN = new GSS_CompaniaFN();
        $o_GSS_CompaniaFN->setEstado( "A" );
        $o_GSS_CompaniaFN->addOrderBy( GSS_CompaniaFN::DescripcionCorta );
        $this->a_GSS_Compania= $o_GSS_CompaniaFN->select();
        
        $this->a_TipoTransaccion = ALM_TransaccionCabeceraBN::getArrayTipoTransaccion();
        
        $o_VTA_TipoDocumentoFN = new VTA_TipoDocumentoFN();
        $o_VTA_TipoDocumentoFN->setEstado( "A" );
        $o_VTA_TipoDocumentoFN->setIdTipoDocumento( "GR" );
        $this->a_VTA_TipoDocumento = $o_VTA_TipoDocumentoFN->select();
        
        $o_ALM_TipoDocumentoFN = new ALM_TipoDocumentoFN(); //PARA DOCUMENTO DE REFENCIA
        $o_ALM_TipoDocumentoFN->setEstado( "A" );
        $o_ALM_TipoDocumentoFN->addCondition( ALM_TipoDocumentoFN::IdTipoDocumento, "IN", "('GI')", false );
        //$o_ALM_TipoDocumentoFN->setTransaccionSistemaFlag( "N" );
        //$o_ALM_TipoDocumentoFN->setEsFiscalFlag( "N" );
        $this->a_ALM_TipoDocumento = $o_ALM_TipoDocumentoFN->select();
        
        //$this->a_ALM_TransaccionMast = array();
        $o_ALM_TransaccionMastFN = new ALM_TransaccionMastFN();
        $o_ALM_TransaccionMastFN->setIngresoEgresoFlag( "T" );
        $o_ALM_TransaccionMastFN->setAjusteInventarioFlag( "S" );
        $o_ALM_TransaccionMastFN->setDireccionDestinoFlag( "S" );
        $o_ALM_TransaccionMastFN->addOrderBy( ALM_TransaccionMastFN::DescripcionLocal );
        $o_ALM_TransaccionMastFN->setEstado( "A" );
        $this->a_ALM_TransaccionMast  = $o_ALM_TransaccionMastFN->select();
        
        $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
        $o_ALM_AlmacenMastFN->addCondition( ALM_AlmacenMastFN::Estado ,"<>", "I" );
        $o_ALM_AlmacenMastFN->addOrderBy( ALM_AlmacenMastFN::DescripcionLocal );
        $o_ALM_AlmacenMastFN->setIdCompania( myUser::getUser()->getIdBusiness() );
        $this->opt_seleccione = $this->GlobalAccess;
        if( !$this->GlobalAccess )
        {
            //$this->s_IdAlmacenDefault = GSS_SucursalFN::recuperarIdAlmacen( myUser::getUser()->getIdSucursal() );
            //$o_ALM_AlmacenMastFN->setIdAlmacen( $this->s_IdAlmacenDefault );
        }
        $this->a_ALM_AlmacenMastOrg = $o_ALM_AlmacenMastFN->select();
        //pr( $this->a_ALM_AlmacenMastOrg );
        
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
        $o_ALM_AlmacenMastFN->addCondition( ALM_AlmacenMastFN::Estado ,"<>", "I" );
        $o_ALM_AlmacenMastFN->addOrderBy( ALM_AlmacenMastFN::DescripcionLocal );
        //$o_ALM_AlmacenMastFN->setIdCompania( myUser::getUser()->getIdBusiness() );
        //
        $s_IdAlmacenDefault = GSS_SucursalFN::recuperarIdAlmacen( myUser::getUser()->getIdSucursal() );
        $o_ALM_AlmacenMastFN->addCondition( ALM_AlmacenMastFN::IdAlmacen, "NOT IN", "('".$s_IdAlmacenDefault."')", false );

        $this->a_ALM_AlmacenMastDst = $o_ALM_AlmacenMastFN->select();
        //pr( $this->a_ALM_AlmacenMastDst );
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        
        $o_MST_UnidadMastFN = new MST_UnidadMastFN();
        $this->a_MST_UnidadMast = $o_MST_UnidadMastFN->select();
        
        $this->TipodeCambio     = GSS_TipoCambioFN::getStaticTipoCambioCobranza();
        
        $this->s_Titulo = "Nueva Transferencia";
        $this->noedit = "";
        
        $this->o_DefaultBN = new ALM_TransferenciaCabeceraBN();
        $this->o_DefaultBN->setFechaDocumento( date( "Y-m-d" ) );
        $this->o_DefaultBN->setIdTransaccionOperacion( "I" );
        
        $o_ALM_VehiculoSucursalFN = new ALM_VehiculoSucursalFN();
        if( myUser::getUser()->getIdSucursal() )
        {
            $o_ALM_VehiculoSucursalFN->setIdSucursal( myUser::getUser()->getIdSucursal() );
        }
        $o_ALM_VehiculoSucursalFN->addOrderBy( ALM_VehiculoSucursalFN::Marca );
        $o_ALM_VehiculoSucursalFN->setEstado( "A" );
        $this->a_ALM_VehiculoSucursal = $o_ALM_VehiculoSucursalFN->select();
        if( $this->s_TipoProc == "upd" )
        {
            $a_Ids = explode( "_", $this->i_Id );
            $IdCompania      = $a_Ids[0];
            $IdTipoDocumento = $a_Ids[1];
            $NumeroDocumento = $a_Ids[2];
            
            $this->s_Titulo = "Editar Transferencia";
            $o_ALM_TransferenciaCabeceraFN = new ALM_TransferenciaCabeceraFN();
            $this->o_DefaultBN = $o_ALM_TransferenciaCabeceraFN->selectByPK( $this->i_Id );
            //$this->noedit = "noedit=2";
            
            $o_ALM_TransaccionMastFN = new ALM_TransaccionMastFN();
            $o_ALM_TransaccionMastFN->setIngresoEgresoFlag( $this->o_DefaultBN->getIdTransaccionOperacion() );
            $this->a_ALM_TransaccionMast = $o_ALM_TransaccionMastFN->select();
        }
    }
    
    public function executeSaveAddEdit()
    {
        $block      = $this->getRequestParameter( 'block' );
        $i_Id       = $this->getRequestParameter( 'i_Id' );
        $s_TipoProc = $this->getRequestParameter( 'TipoProc' );
        $TypeSub    = $this->getRequestParameter( 'TypeSub' );
        
        $GlobalAccess   = myUser::getUser()->hasGlobalAccess();
        
        //CABECERA
        $IdCompania                 = $this->getRequestParameter( 'IdCompania' );
        $FechaDocumento             = $this->getRequestParameter( 'FechaDocumento' )." ".date( "H:i:s" );
        $IdTransaccionOperacion     = $this->getRequestParameter( 'IdTransaccionOperacion' );
        $IdAlmacen                  = $this->getRequestParameter( 'IdAlmacen' ); //ALMACEN ORIGEN
        $AlmacenTraslado            = $this->getRequestParameter( 'AlmacenTraslado' ); //ALMACEN ORIGEN
        $IdTransaccion              = $this->getRequestParameter( 'IdTransaccion' ); //
        $AlmacenTraslado            = $this->getRequestParameter( 'AlmacenTraslado' ); //ALMACEN DE DESTINO
        $IdOrdenProd                = $this->getRequestParameter( 'IdOrdenProd' ); //
        
        $o_ALM_TransaccionMastFN = new ALM_TransaccionMastFN();
        $o_ALM_TransaccionMastBN = $o_ALM_TransaccionMastFN->selectByPK( $IdTransaccion );
        $IdTipoDocumento         = $o_ALM_TransaccionMastBN->getTipoDocumentoGenerado();
        
        $ReferenciaTipoDocumento    = $this->getRequestParameter( 'ReferenciaTipoDocumento' );
        $ReferenciaSerieDocumento   = $this->getRequestParameter( 'ReferenciaSerieDocumento' ); 
        $ReferenciaNumeroDocumento  = $this->getRequestParameter( 'ReferenciaNumeroDocumento' );
        
        $Comentario                 = $this->getRequestParameter( 'Comentario' ); //
        $TipodeCambio               = GSS_TipoCambioFN::getStaticTipoCambioCobranza();
        
        $s_ImprimirGuia             = is_null( $this->getRequestParameter( 'ImprimirGuia' ) ) ? "NO" : $this->getRequestParameter( 'ImprimirGuia' ); 
        $s_IdChofer                 = $this->getRequestParameter( 'IdChofer' ); //
        $s_IdVehiculo               = $this->getRequestParameter( 'IdVehiculo' ); //
        
        //DETALLES
        $a_IdSecuencia              = $this->getRequestParameter( 'IdSecuencia' ); //
        $a_Cantidad                 = $this->getRequestParameter( 'Cantidad' ); //
        $a_IdItem                   = $this->getRequestParameter( 'IdItem' ); //
        $a_IdLote                   = $this->getRequestParameter( 'IdLote' ); //
        $a_FechaVencimiento         = $this->getRequestParameter( 'FechaVencimiento' ); //
        $a_IdUnidad                 = $this->getRequestParameter( 'IdUnidad' ); //
        
        $con = Conexion::getConexion();
        $con->begin();
        try 
        {
            myUser::getUser()->validar_session();
            //VALIDACION POR EL TIPO DE CAMBIO
            if( !$TipodeCambio )
            {
                //$TipodeCambio = 1;
                throw new Exception( "Debe de registrar el Tipo de Cambio de hoy." );
            }
            //VALIDACION EL PERIODO
            $s_Periodo = UtilDate::getFormatDate( $FechaDocumento, "Ym" );
            $b_FlagPeriodo = PRO_CierreMensualFN::flagPeriodoAbierto( $s_Periodo );
            if( !$b_FlagPeriodo )
            {
                //throw new Exception( "El Periodo se encuentra Cerrado." );
            }
            
            $o_DefaultDP = new ALM_TransferenciaCabeceraDP();
            $o_DefaultDP->setIdCompania( myUser::getUser()->getIdCompania() );
            $o_DefaultDP->setIdSucursal( myUser::getUser()->getIdSucursal() );
            $o_DefaultDP->setIdTransaccion( $IdTransaccion );
            $o_DefaultDP->setAlmacenTraslado( $AlmacenTraslado );
            $o_DefaultDP->setIdAlmacen( $IdAlmacen );
            $o_DefaultDP->setAlmacenTraslado( $AlmacenTraslado );
            $o_DefaultDP->setIdOrdenProd( ( int ) $IdOrdenProd );
            $o_DefaultDP->setIdTransaccionOperacion( $IdTransaccionOperacion );
            $o_DefaultDP->setFechaDocumento( $FechaDocumento );
            $o_DefaultDP->setTipodeCambio( floatval( $TipodeCambio ) );
            $o_DefaultDP->setReferenciaTipoDocumento( $ReferenciaTipoDocumento );
            $o_DefaultDP->setReferenciaSerieDocumento( $ReferenciaSerieDocumento );
            $o_DefaultDP->setReferenciaNumeroDocumento( $ReferenciaNumeroDocumento );
            $o_DefaultDP->setIdTipoDocumento( $IdTipoDocumento );
            $o_DefaultDP->setIdChofer( ( int ) $s_IdChofer );
            $o_DefaultDP->setIdVehiculo( ( int ) $s_IdVehiculo );
            $o_DefaultDP->setComentario( $Comentario );
            $o_DefaultDP->setImprimirGuia( $s_ImprimirGuia );
            
            if( $s_TipoProc == "nvo" )
            {
                //NUEVO
                $i_IdTransferencia = ALM_TransferenciaCabeceraDP::recuperarId();
                
                if( $s_ImprimirGuia == "NO" )
                {
                    $o_utilGenerateId = new utilGenerateId();
                    $o_utilGenerateId->setIdCompania( -1 );
                    $o_utilGenerateId->setTipoCorrelativo( "CTRINT" );
                    $o_utilGenerateId->setSerie( "TIPO" );
                    $i_IdCrtl = $o_utilGenerateId->generateId();
                    
                    $ReferenciaTipoDocumento   = "CT";
                    $ReferenciaSerieDocumento  = "0001";
                    $ReferenciaNumeroDocumento = str_pad( $i_IdCrtl, 10, "0", STR_PAD_LEFT );
                    
                    $o_DefaultDP->setReferenciaTipoDocumento( $ReferenciaTipoDocumento );
                    $o_DefaultDP->setReferenciaSerieDocumento( $ReferenciaSerieDocumento );
                    $o_DefaultDP->setReferenciaNumeroDocumento( $ReferenciaNumeroDocumento );
                }
                
                $o_DefaultDP->setIdTransferencia( $i_IdTransferencia );
                $o_DefaultDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                $o_DefaultDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                $o_DefaultDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $o_DefaultDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $b_Result = $o_DefaultDP->save();
                $i_Id = $i_IdTransferencia;
            }
            else 
            {
                //UPDATE
                $o_DefaultDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $o_DefaultDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $b_Result = $o_DefaultDP->update();
            }
            
            $a_LstValicacion = array();
            foreach ( $a_IdItem as $i_Key => $s_Value )
            {
                if( $s_Value != "" )
                {
                    //VALIDACION POR CANTIDAD
                    $f_CantidadPedida = floatval( $a_Cantidad[$i_Key] );

                    if( $a_IdUnidad[$i_Key] == 59 )
                    {
                        $f_CantidadAsiganada = ALM_ItemMastFN::getItemCantidadMedidaAsignada( $s_Value );
                        $f_CantidadValidar = $f_CantidadAsiganada * $f_CantidadPedida;
                    }
                    else
                    {
                        $f_CantidadValidar = $f_CantidadPedida;
                    }

                    $f_StockActial    = ALM_ItemAlmacenStockFN::recuperarStockActual( myUser::getUser()->getIdBusiness(), $s_Value, $IdAlmacen, $a_IdLote[$i_Key] );

                    if( $f_CantidadValidar > $f_StockActial )
                    {
                        throw new Exception( "La Cantidad solicitada del Item ( ".ALM_ItemMastFN::getStaticDescripcionItem( $s_Value )." ) excede del Stock Actual del Sistema." );
                    }
                    /////////////////////////
                    //item - lote -> debe de haber solo uno
                    if( !isset( $a_LstValicacion[$s_Value."-".$a_IdLote[$i_Key]] ) )
                    {
                        $a_LstValicacion[$s_Value."-".$a_IdLote[$i_Key]] = "1";
                    }
                    else
                    {
                        throw new Exception( "El Item[$s_Value][".ALM_ItemMastFN::getStaticDescripcionItem( $s_Value )."] se encuentra duplicado con el Lote[{$a_IdLote[$i_Key]}]" );
                    }
                    ////////////////////////////////////////
                    ///
                    $o_ALM_TransferenciaDetalleDP = new ALM_TransferenciaDetalleDP();
                    $o_ALM_TransferenciaDetalleDP->setIdTransferencia( $i_IdTransferencia );
                    $o_ALM_TransferenciaDetalleDP->setIdItem( $s_Value );
                    $o_ALM_TransferenciaDetalleDP->setDescripcionItem( ALM_ItemMastFN::getStaticDescripcionItem( $s_Value ) );
                    $o_ALM_TransferenciaDetalleDP->setIdLote( $a_IdLote[$i_Key] );
                    $o_ALM_TransferenciaDetalleDP->setFechaVencimiento( $a_FechaVencimiento[$i_Key] );
                    $o_ALM_TransferenciaDetalleDP->setCantidad( $f_CantidadPedida );
                    $o_ALM_TransferenciaDetalleDP->setUnidadCodigo( $a_IdUnidad[$i_Key] );
                    if( $s_TipoProc == "nvo" )
                    {
                        $i_IdSecuencia = ALM_TransferenciaDetalleFN::recuperarId( $i_IdTransferencia );
                        $o_ALM_TransferenciaDetalleDP->setIdSecuencia( $i_IdSecuencia );
                        $o_ALM_TransferenciaDetalleDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                        $o_ALM_TransferenciaDetalleDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                        $o_ALM_TransferenciaDetalleDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                        $o_ALM_TransferenciaDetalleDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                        $b_Result = $o_ALM_TransferenciaDetalleDP->save();
                    }
                    else 
                    {
                        $o_ALM_TransferenciaDetalleDP->setIdSecuencia( $a_IdSecuencia[$i_Key] );
                        $o_ALM_TransferenciaDetalleDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                        $o_ALM_TransferenciaDetalleDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                        $b_Result = $o_ALM_TransferenciaDetalleDP->update();
                    }
                }
            }
            
            //procedimiento para orden de produccion
            if( $IdTransaccion == "TRP" )
            {
                //ahora validamos el estado
                $o_PRD_OrdenCabFN = new PRD_OrdenCabFN();
                $o_PRD_OrdenCabBN = $o_PRD_OrdenCabFN->selectByPK( $IdOrdenProd );
                if( $o_PRD_OrdenCabBN->getEstado() == PRD_OrdenCabBN::ESTADO_COMPLETADO || $o_PRD_OrdenCabBN->getEstado() == PRD_OrdenCabBN::ESTADO_ANULADO )
                {
                    throw new Exception( "No se puede crear la Transferencia, por que la Orden Seleccionada tiene un estado diferente." );
                }
                
                //se reserva en el almacen de produccion
                if( $AlmacenTraslado == PRD_OrdenCabBN::ALMACEN_PRODUCCION_X_DEFECTO )
                {
                    foreach ( $a_IdItem as $i_Key => $s_Value )
                    {
                        if( $s_Value != "" )
                        {
                            $f_CantidadPedida = floatval( $a_Cantidad[$i_Key] );
                            
                            //se busca la cantidad anterior para acumular, y validar que no sobre pase la cantidad requerida
                            $o_PRD_OrdenDetFN = new PRD_OrdenDetFN();
                            $o_PRD_OrdenDetFN->setIdOrdenCab( $IdOrdenProd );
                            $o_PRD_OrdenDetFN->setIdItem( $s_Value );
                            $a_PRD_OrdenDet = $o_PRD_OrdenDetFN->select();
                            if( $a_PRD_OrdenDet )
                            {
                                $o_PRD_OrdenDetBN = $a_PRD_OrdenDet[0];
                                
                                $f_CantReci = $o_PRD_OrdenDetBN->getCantidadRecibida();
                                $f_CantTrf  = $f_CantidadPedida;
                                $f_CantTot  = $f_CantReci + $f_CantTrf;
                                if( $f_CantTot > $o_PRD_OrdenDetBN->getCantidadPedida() )
                                {
                                    throw new Exception( "La cantidad a transferir mas la cantidad recibida es mayor a la cantidad pedida, para la Orden de Produccion." );
                                }
                            }
                            else
                            {
                                throw new Exception( "El Producto {$s_Value} no se encuentra regsitrado en la Orden de Producion." );
                            }
                        }
                    }
                }
                else
                {
                    //se puede asumir que se quiere regresar los productos para  anular la orden de producion
                    //por procedimiento se designa que para devolucion sea la totalidad del stock recibido, no hay paraciales para devoluciones
                    foreach ( $a_IdItem as $i_Key => $s_Value )
                    {
                        if( $s_Value != "" )
                        {
                            $f_CantidadPedida = floatval( $a_Cantidad[$i_Key] );
                            
                            //se busca la cantidad anterior para acumular, y validar que no sobre pase la cantidad requerida
                            $o_PRD_OrdenDetFN = new PRD_OrdenDetFN();
                            $o_PRD_OrdenDetFN->setIdOrdenCab( $IdOrdenProd );
                            $o_PRD_OrdenDetFN->setIdItem( $s_Value );
                            $a_PRD_OrdenDet = $o_PRD_OrdenDetFN->select();
                            if( $a_PRD_OrdenDet )
                            {
                                $o_PRD_OrdenDetBN = $a_PRD_OrdenDet[0];
                                
                                $f_CantReci = $o_PRD_OrdenDetBN->getCantidadRecibida();
                                $f_CantTrf  = $f_CantidadPedida;
                                
                                if( $f_CantTrf != $f_CantReci )
                                {
                                    throw new Exception( "La cantidad no debe der diferente a lo recibido para la Orden de Produccion." );
                                }
                            }
                            else
                            {
                                throw new Exception( "El Producto {$s_Value} no se encuentra regsitrado en la Orden de Producion." );
                            }
                        }
                    }
                }
            }
            
            if( $s_ImprimirGuia == "SI" )
            {
                //PARA INCREMENTAR EL CORRELATIVO 
                $o_VTA_DocumentoBN = new VTA_DocumentoBN();
                $o_VTA_DocumentoBN->setIdCompania( $IdCompania );
                $o_VTA_DocumentoBN->setIdSucursal( myUser::getUser()->getIdSucursal() );
                $o_VTA_DocumentoBN->setIdTipoDocumento( $ReferenciaTipoDocumento );
                $o_VTA_DocumentoBN->setDocumentoSerie( $ReferenciaSerieDocumento );
                $o_VTA_DocumentoBN->setDocumentoNumero( $ReferenciaNumeroDocumento );
                $o_VTA_DocumentoBN->setEsTransferencia( true );
                
                $o_OrdenVentaBL = new OrdenVentaBL();
                $b_Result = $o_OrdenVentaBL->incrementarDocumentoNumero( $o_VTA_DocumentoBN );
            }
            
            //pr( "exit" ); exit;

            $con->commit();
            
            $a_Rs['type_sub'] = $TypeSub;
            $a_Rs['error']   = false;
            $a_Rs['id']      = $i_Id;
        }
        catch ( Exception $o_Exception )
        {
            $con->rollback();
            $a_Rs['error']        = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }
        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }
    
    public function executeAudi()
    {
        $block          = $this->getRequestParameter( 'block' );
        $i_Id           = $this->getRequestParameter( 'i_Id' );
        $this->s_Topico = "Impuesto";
        $o_DefaultFN = new GSS_ImpuestoFN();
        $this->o_ObjectBN = $o_DefaultFN->selectByPK( $i_Id );
    }
    
    public function executeViewdel()
    {
        $this->block      = $this->getRequestParameter( 'block' );
        $this->i_Id       = $this->getRequestParameter( 'i_Id' );
        $this->s_TipoProc = $this->getRequestParameter( 'TipoProc' );
        
        $o_DefaultFN = new ALM_TransferenciaCabeceraFN();
        $this->o_DefaultBN = $o_DefaultFN->selectByPK( $this->i_Id );
    }
    
    public function executePrintDoc()
    {
        $this->i_Id       = $this->getRequestParameter( 'i_Id' );
        
        $o_DefaultFN = new ALM_TransferenciaCabeceraFN();
        $this->o_DefaultBN = $o_DefaultFN->selectByPK( $this->i_Id );
    }
    
    public function executeDeleteRow()
    {
        $block      = $this->getRequestParameter( 'block' );
        $i_Id       = $this->getRequestParameter( 'i_Id' );
        $s_TipoProc = $this->getRequestParameter( 'TipoProc' );
        try 
        {
            $o_DefaultDP = new ALM_TransferenciaCabeceraDP();
            $o_DefaultDP->setIdCompania( myUser::getUser()->getIdBusiness() );
            $o_DefaultDP->setIdTransferencia( ( int ) $i_Id );
            $o_DefaultDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
            $o_DefaultDP->setEstado( ALM_TransferenciaCabeceraBN::ESTADO_ANULADO );
            //$o_DefaultDP->cambiarEstadoCabacera();
            $o_DefaultDP->update();

            $a_Rs['error']   = false;
            $a_Rs['id']      = $i_Id;
        }
        catch ( Exception $o_Exception )
        {
            $a_Rs['error']   = true;
            $a_Rs['mensaje_error_ex'] = $o_Exception->getMessage();
            $a_Rs['mensaje_error'] = "No se pudo eliminar el registro.";
        }
        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }

    public function executeRefuseTransf()
    {
        $block      = $this->getRequestParameter( 'block' );
        $i_Id       = $this->getRequestParameter( 'i_Id' );
        $s_TipoProc = $this->getRequestParameter( 'TipoProc' );
        try 
        {
            $o_DefaultDP = new ALM_TransferenciaCabeceraDP();
            $o_DefaultDP->setIdCompania( myUser::getUser()->getIdBusiness() );
            $o_DefaultDP->setIdTransferencia( ( int ) $i_Id );
            $o_DefaultDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
            $o_DefaultDP->setEstado( ALM_TransferenciaCabeceraBN::ESTADO_RECHAZADO );
            //$o_DefaultDP->cambiarEstadoCabacera();
            $o_DefaultDP->update();

            $a_Rs['error']   = false;
            $a_Rs['id']      = $i_Id;
        }
        catch ( Exception $o_Exception )
        {
            $a_Rs['error']   = true;
            $a_Rs['mensaje_error_ex'] = $o_Exception->getMessage();
            $a_Rs['mensaje_error'] = "No se pudo rechazar el registro.";
        }
        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }
    
    public function executeApproveRow()
    {
        //$block      = $this->getRequestParameter( 'block' );
        $i_Id       = $this->getRequestParameter( 'i_Id' );
        //$s_TipoProc = $this->getRequestParameter( 'TipoProc' );
        try
        {
            $o_DefaultDP = new ALM_TransferenciaCabeceraDP();
            $o_DefaultDP->setIdCompania( myUser::getUser()->getIdBusiness() );
            $o_DefaultDP->setIdTransferencia( ( int ) $i_Id );
            $o_DefaultDP->setEstado( ALM_TransferenciaCabeceraBN::ESTADO_PREPARACION );
            $o_DefaultDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
            //$o_DefaultDP->cambiarEstadoCabacera();
            $o_DefaultDP->update();
    
            $a_Rs['error']   = false;
            $a_Rs['id']      = $i_Id;
        }
        catch ( Exception $o_Exception )
        {
            $a_Rs['error']   = true;
            $a_Rs['mensaje_error_ex'] = $o_Exception->getMessage();
            $a_Rs['mensaje_error'] = "No se pudo eliminar el registro.";
        }
        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }
    
    public function executeRecepTransf()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        $this->block = $this->getRequestParameter( 'block' );
        $this->GlobalAccess   = myUser::getUser()->hasGlobalAccess();
        
        $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
        $o_ALM_AlmacenMastFN->setIdCompania( myUser::getUser()->getIdBusiness() );
        $o_ALM_AlmacenMastFN->addOrderBy( ALM_AlmacenMastFN::DescripcionLocal );
        $this->a_ALM_AlmacenMastOrg = $o_ALM_AlmacenMastFN->select();
        
        $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
        $o_ALM_AlmacenMastFN->setIdCompania( myUser::getUser()->getIdBusiness() );
        $o_ALM_AlmacenMastFN->addOrderBy( ALM_AlmacenMastFN::DescripcionLocal );
        $this->opt_seleccione_or = true;
        $this->opt_seleccione_ds = $this->GlobalAccess;
        if( !$this->GlobalAccess )
        {
            //$this->s_IdAlmacenDefault = GSS_SucursalFN::recuperarIdAlmacen( myUser::getUser()->getIdSucursal() );
            //$o_ALM_AlmacenMastFN->setIdAlmacen( $this->s_IdAlmacenDefault );
        }
        $this->a_ALM_AlmacenMastDst = $o_ALM_AlmacenMastFN->select();
        
        $this->a_TipoTransaccion = ALM_TransaccionCabeceraBN::getArrayTipoTransaccion();
        
        $o_ALM_TipoDocumentoFN = new ALM_TipoDocumentoFN(); //PARA DOCUMENTO DE REFENCIA
        $o_ALM_TipoDocumentoFN->setEstado( "A" );
        $this->a_ALM_TipoDocumento = $o_ALM_TipoDocumentoFN->select();
        
        $o_ALM_TransaccionMastFN = new ALM_TransaccionMastFN();
        $o_ALM_TransaccionMastFN->addOrderBy( ALM_TransaccionMastFN::DescripcionLocal );
        $o_ALM_TransaccionMastFN->addCondition( ALM_TransaccionMastFN::IngresoEgresoFlag, "IN", "( 'T' )", false );
        $this->a_ALM_TransaccionMast  = $o_ALM_TransaccionMastFN->select();
        
        $this->a_EstadosTransf = array( ALM_TransferenciaCabeceraBN::ESTADO_PREPARACION => "PREPARACION", ALM_TransferenciaCabeceraBN::ESTADO_COMPLETADO => "COMPLETADO" );
    }
    
    public function executeGridRecep()
    {
        $block = $this->getRequestParameter( 'block' );
        $page  = $this->getRequestParameter( 'page' );
        
        //*set_header_utf8();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $o_GridAction = new GridAction();
        $o_GridAction->setClassFind( new ALM_TransferenciaCabeceraFN() );
        
        //ParameterWR::getInstance()->setVar( "Estado", ALM_TransferenciaCabeceraBN::ORDEN_COMPRA_PREPARACION );
        
        //$o_GridAction->addMethodDefault( "IdCompania", myUser::getUser()->getIdBusiness() );
        $o_GridAction->addMethodDefault( "Estado", ALM_TransferenciaCabeceraBN::ESTADO_PREPARACION );
        if( !myUser::getUser()->hasGlobalAccess() )
        {
            //$IdAlmacen = GSS_SucursalFN::recuperarIdAlmacen( myUser::getUser()->getIdSucursal() );
            //$o_GridAction->addMethodDefault( "AlmacenTraslado", $IdAlmacen );
        }
        else
        {
            $o_GridAction->addAssignFilter( "AlmacenTraslado" );
        }
        
        //$o_GridAction->addAssignFilter( "IdCompania" );
        $o_GridAction->addAssignFilter( "IdAlmacen" );
        //$o_GridAction->addAssignFilter( "AlmacenTraslado" );
        $o_GridAction->addAssignFilter( "IdTransaccionOperacion" );
        $o_GridAction->addAssignFilter( "IdTransaccion" );
        $o_GridAction->addAssignFilter( "Estado" );
        
        $o_GridAction->addConditionFilter( "FechaDocumento1", ALM_TransferenciaCabeceraFN::FechaDocumento,    ">=" );
        $o_GridAction->addConditionFilter( "FechaDocumento2", ALM_TransferenciaCabeceraFN::FechaDocumento,    "<=" );
        
        $o_GridAction->addOrderDefault( ALM_TransferenciaCabeceraFN::FechaCreacion, false );
        
        $o_GridAction->addRowsToShow( "IdTransferencia", "IdTipoDocumento", "IdNumeroDocumento", "FechaDocumentoPer", "IdTransaccion", "IdAlmacen", "AlmacenTraslado", "DocReferencia", "EstadoDesc", "Estado" );
        
        $o_GridAction->addInnerJoin( new ALM_TransaccionMastFN(), "IdTransaccion", "DescripcionLocal" );
        $o_GridAction->addInnerJoin( new ALM_AlmacenMastFN(), "IdAlmacen", "DescripcionLocal" );
        $o_GridAction->addInnerJoin( new ALM_AlmacenMastFN(), "AlmacenTraslado", "DescripcionLocal" );
        $o_GridAction->addInnerJoin( new ALM_TipoDocumentoFN(), "IdTipoDocumento", "Descripcion" );
              
        $o_GridAction->setNumberRecordsShow( 15 );
        
        $o_GridAction->initialize();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $a_ResultJson['page']    = $o_GridAction->getPage();
        $a_ResultJson['total']   = $o_GridAction->getTotalPage();
        $a_ResultJson['records'] = $o_GridAction->getTotalRecords();
        $a_ResultJson['rows']    = $o_GridAction->getResultArray();

        echo json_encode( $a_ResultJson );

        return ViewResponse::NONE;
    }
    
    public function executeCompleteTransf()
    {
        $block      = $this->getRequestParameter( 'block' );
        $i_Id       = $this->getRequestParameter( 'i_Id' );
        $s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        $TypeSub    = $this->getRequestParameter( 'TypeSub' );
        
        $this->GlobalAccess   = myUser::getUser()->hasGlobalAccess();
        
        $con = Conexion::getConexion();
        $con->begin();
        try 
        {
            myUser::getUser()->validar_session();

            $o_DefaultFN = new ALM_TransferenciaCabeceraFN();
            $o_DefaultBN = $o_DefaultFN->selectByPK( $i_Id );

            if( $o_DefaultBN->getEstado() == ALM_TransferenciaCabeceraBN::ESTADO_COMPLETADO )
            {
                throw new Exception( "La Transferencia [{$o_DefaultBN->getDocReferencia()}] tiene un estado [{$o_DefaultBN->getEstadoDesc()}]" );
            }
            
            $i_IdProyecto = null;
            if( $o_DefaultBN->getIdTransaccion() == "TRP" )
            {
                if( $o_DefaultBN->getIdOrdenProd() )
                {
                    $o_PRD_OrdenCabFN = new PRD_OrdenCabFN();
                    $o_PRD_OrdenCabBN = $o_PRD_OrdenCabFN->selectByPK( $o_DefaultBN->getIdOrdenProd() );
                    
                    $i_IdProyecto = $o_PRD_OrdenCabBN->getIdProyecto();
                }
            }
            
            $o_ALM_TransaccionCabeceraBN = new ALM_TransaccionCabeceraBN();
            $o_ALM_TransaccionCabeceraBN->setIdTransaccion( $o_DefaultBN->getIdTransaccion() );
            $o_ALM_TransaccionCabeceraBN->setAlmacenTraslado( $o_DefaultBN->getAlmacenTraslado() );
            $o_ALM_TransaccionCabeceraBN->setIdAlmacen( $o_DefaultBN->getIdAlmacen() );
            $o_ALM_TransaccionCabeceraBN->setIdTransaccionOperacion( ALM_TransaccionCabeceraBN::TIPO_TRANSFERENCIA );
            $o_ALM_TransaccionCabeceraBN->setFechaDocumento( $o_DefaultBN->getFechaDocumento()." ".date( "H:i:s" ) );
            $o_ALM_TransaccionCabeceraBN->setTipodeCambio( $o_DefaultBN->getTipodeCambio() );
            $o_ALM_TransaccionCabeceraBN->setMonedaCod( "LO" );
            $o_ALM_TransaccionCabeceraBN->setReferenciaTipoDocumento( $o_DefaultBN->getIdTipoDocumento() );
            $o_ALM_TransaccionCabeceraBN->setReferenciaNumeroDocumento( ( string ) $o_DefaultBN->getIdTransferencia() );
            $o_ALM_TransaccionCabeceraBN->setIdProyecto( $i_IdProyecto );
            $o_ALM_TransaccionCabeceraBN->setIdCompania( myUser::getUser()->getIdBusiness() );
            $o_ALM_TransaccionCabeceraBN->setIdTipoDocumento( $o_DefaultBN->getIdTipoDocumento() );
            $o_ALM_TransaccionCabeceraBN->setComentario( $o_DefaultBN->getComentario() );
            $o_ALM_TransaccionCabeceraBN->setCodigoCliente( GSS_ParametroMastFN::getValorParam( "AL", "PR_ID_COMPANIA" ) );
            
            $o_ALM_TransaccionCabeceraBN->setTipoDocumentoFiscal( $o_DefaultBN->getReferenciaTipoDocumento() );
            $o_ALM_TransaccionCabeceraBN->setSerieDocumentoFiscal( $o_DefaultBN->getReferenciaSerieDocumento() );
            $o_ALM_TransaccionCabeceraBN->setNumeroDocumentoFiscal( $o_DefaultBN->getReferenciaNumeroDocumento() );
            
            $a_ALM_TransferenciaDetalle = $o_DefaultBN->getArrayObjetosDetalles();
            foreach ( $a_ALM_TransferenciaDetalle as $i_Key => $o_ALM_TransferenciaDetalleBN )
            {
                $o_ALM_TransaccionDetalleBN = new ALM_TransaccionDetalleBN();
                $o_ALM_TransaccionDetalleBN->setIdItem( $o_ALM_TransferenciaDetalleBN->getIdItem() );
                $o_ALM_TransaccionDetalleBN->setCantidad( $o_ALM_TransferenciaDetalleBN->getCantidad() );
                $o_ALM_TransaccionDetalleBN->setLote( $o_ALM_TransferenciaDetalleBN->getIdLote() );
                $o_ALM_TransaccionDetalleBN->setFechaVencimiento( $o_ALM_TransferenciaDetalleBN->getFechaVencimiento() );
                $o_ALM_TransaccionDetalleBN->setUnidadCodigo( $o_ALM_TransferenciaDetalleBN->getUnidadCodigo() );
                $o_ALM_TransaccionDetalleBN->setFechaVencimientoLote( $o_ALM_TransferenciaDetalleBN->getFechaVencimiento() );
                $o_ALM_TransaccionDetalleBN->setPrecioUnitario( 0.00 );
                $a_MovientoDetalle[] = $o_ALM_TransaccionDetalleBN;

                $o_ALM_TransferenciaDetalleDP = new ALM_TransferenciaDetalleDP();
                $o_ALM_TransferenciaDetalleDP->setIdTransferencia( ( int ) $o_DefaultBN->getIdTransferencia() );
                $o_ALM_TransferenciaDetalleDP->setIdSecuencia( ( int ) $o_ALM_TransferenciaDetalleBN->getIdSecuencia() );
                $o_ALM_TransferenciaDetalleDP->setCantidadRecepcionada( $o_ALM_TransferenciaDetalleBN->getCantidad() );
                $o_ALM_TransferenciaDetalleDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $o_ALM_TransferenciaDetalleDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $o_ALM_TransferenciaDetalleDP->update();
            }
            
            $o_ALM_TransaccionCabeceraBN->setArrayMovientoDetalle( $a_MovientoDetalle );

            $o_MovimientoBL = new MovimientoBL();
            $o_MovimientoBL->GuardarMovientoTransaccion( $o_ALM_TransaccionCabeceraBN );
            
            $s_IdNumeroDocumento = $o_ALM_TransaccionCabeceraBN->getIdNumeroDocumento();
            
            $o_ALM_TransferenciaCabeceraDP = new ALM_TransferenciaCabeceraDP();
            $o_ALM_TransferenciaCabeceraDP->setIdTransferencia( ( int ) $i_Id );
            $o_ALM_TransferenciaCabeceraDP->setIdNumeroDocumento( $s_IdNumeroDocumento );
            if( $o_DefaultBN->getIdTransaccion() == "TRP" )
            {
                if( $o_DefaultBN->getIdOrdenProd() )
                {
                    //se recupera el id del proyecto
                    $o_PRD_OrdenCabFN = new PRD_OrdenCabFN();
                    $o_PRD_OrdenCabBN = $o_PRD_OrdenCabFN->selectByPK( $o_DefaultBN->getIdOrdenProd() );
                    
                    $o_ALM_TransferenciaCabeceraDP->setIdProyecto( $o_PRD_OrdenCabBN->getIdProyecto() );
                    
                    //para tranferencia especificamente para reserva en producion
                    if( $o_DefaultBN->getAlmacenTraslado() == PRD_OrdenCabBN::ALMACEN_PRODUCCION_X_DEFECTO )
                    {
                        foreach ( $a_ALM_TransferenciaDetalle as $i_Key => $o_ALM_TransferenciaDetalleBN )
                        {
                            //se busca la cantidad anterior para acumular, y validar que no sobre pase la cantidad requerida 
                            $o_PRD_OrdenDetFN = new PRD_OrdenDetFN();
                            $o_PRD_OrdenDetFN->setIdOrdenCab( $o_PRD_OrdenCabBN->getIdOrdenCab() );
                            $o_PRD_OrdenDetFN->setIdItem( $o_ALM_TransferenciaDetalleBN->getIdItem() );
                            $a_PRD_OrdenDet = $o_PRD_OrdenDetFN->select();
                            if( $a_PRD_OrdenDet )
                            {
                                $o_PRD_OrdenDetBN = $a_PRD_OrdenDet[0];
                                
                                $f_CantReci = $o_PRD_OrdenDetBN->getCantidadRecibida();
                                $f_CantTrf  = $o_ALM_TransferenciaDetalleBN->getCantidad();
                                $f_CantTot  = $f_CantReci + $f_CantTrf;
                                if( $f_CantTot > $o_PRD_OrdenDetBN->getCantidadPedida() )
                                {
                                    throw new Exception( "La cantidad a transferir mas la cantidad recibida es mayor a la cantidad pedida." );
                                }
                            
                                $o_PRD_OrdenDetDP = new PRD_OrdenDetDP();
                                $o_PRD_OrdenDetDP->setIdOrdenCab( $o_DefaultBN->getIdOrdenProd() );
                                $o_PRD_OrdenDetDP->setIdOrdenDet( $o_PRD_OrdenDetBN->getIdOrdenDet() );
                                //$o_PRD_OrdenDetDP->setIdItem( $o_ALM_TransferenciaDetalleBN->getIdItem() );
                                $o_PRD_OrdenDetDP->setCantidadRecibida( $f_CantTot );
                                $o_PRD_OrdenDetDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                                $o_PRD_OrdenDetDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                                $o_PRD_OrdenDetDP->update();
                            }
                            else
                            {
                                throw new Exception( "El Producto {$o_ALM_TransferenciaDetalleBN->getIdItem()} no se encuentra en la lista de Orden a Producir." );
                            }
                        }
                        
                        //ahora se actualiza el estado a la orden de produccion
                        $o_PRD_OrdenCabDP = new PRD_OrdenCabDP();
                        $o_PRD_OrdenCabDP->setIdOrdenCab( $o_DefaultBN->getIdOrdenProd() );
                        $o_PRD_OrdenCabDP->setEstado( PRD_OrdenCabBN::ESTADO_RESERVADO );
                        $o_PRD_OrdenCabDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                        $o_PRD_OrdenCabDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                        $o_PRD_OrdenCabDP->update();
                    }
                    else
                    {
                        //se asume para devolucion, por lo tanto solo se espera la totalidad
                        foreach ( $a_ALM_TransferenciaDetalle as $i_Key => $o_ALM_TransferenciaDetalleBN )
                        {
                            //se busca la cantidad anterior para acumular, y validar que no sobre pase la cantidad requerida
                            $o_PRD_OrdenDetFN = new PRD_OrdenDetFN();
                            $o_PRD_OrdenDetFN->setIdOrdenCab( $o_PRD_OrdenCabBN->getIdOrdenCab() );
                            $o_PRD_OrdenDetFN->setIdItem( $o_ALM_TransferenciaDetalleBN->getIdItem() );
                            $a_PRD_OrdenDet = $o_PRD_OrdenDetFN->select();
                            if( $a_PRD_OrdenDet )
                            {
                                $o_PRD_OrdenDetBN = $a_PRD_OrdenDet[0];
                                
                                $f_CantReci = $o_PRD_OrdenDetBN->getCantidadRecibida();
                                $f_CantTrf  = $o_ALM_TransferenciaDetalleBN->getCantidad();
                                $f_CantTot  = $f_CantReci - $f_CantTrf;
                                if( $f_CantTot > 0 )
                                {
                                    throw new Exception( "La cantidad a transferir para devoluciono no debe ser mayor a 0." );
                                }
                                
                                $o_PRD_OrdenDetDP = new PRD_OrdenDetDP();
                                $o_PRD_OrdenDetDP->setIdOrdenCab( $o_DefaultBN->getIdOrdenProd() );
                                $o_PRD_OrdenDetDP->setIdOrdenDet( $o_PRD_OrdenDetBN->getIdOrdenDet() );
                                //$o_PRD_OrdenDetDP->setIdItem( $o_ALM_TransferenciaDetalleBN->getIdItem() );
                                $o_PRD_OrdenDetDP->setCantidadRecibida( $f_CantTot );
                                $o_PRD_OrdenDetDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                                $o_PRD_OrdenDetDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                                $o_PRD_OrdenDetDP->update();
                            }
                            else
                            {
                                throw new Exception( "El Producto {$o_ALM_TransferenciaDetalleBN->getIdItem()} no se encuentra en la lista de Orden a Producir." );
                            }
                        }
                        
                        //ahora se actualiza el estado a la orden de produccion
                        $o_PRD_OrdenCabDP = new PRD_OrdenCabDP();
                        $o_PRD_OrdenCabDP->setIdOrdenCab( $o_DefaultBN->getIdOrdenProd() );
                        $o_PRD_OrdenCabDP->setEstado( PRD_OrdenCabBN::ESTADO_PENDIENTE );
                        $o_PRD_OrdenCabDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                        $o_PRD_OrdenCabDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                        $o_PRD_OrdenCabDP->update();
                    }
                }
                else
                {
                    throw new Exception( "La Tranferencia a Produccion, necesita el Id de Produccion para seguir con el proceso." );
                }
            }
            $o_ALM_TransferenciaCabeceraDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
            $o_ALM_TransferenciaCabeceraDP->setEstado( ALM_TransferenciaCabeceraBN::ESTADO_COMPLETADO );
            $o_ALM_TransferenciaCabeceraDP->update();
            
            $con->commit();
            
            $a_Rs['type_sub'] = $TypeSub;
            $a_Rs['error']   = false;
            $a_Rs['id']      = $i_Id;
        }
        catch ( Exception $o_Exception )
        {
            $con->rollback();
            $a_Rs['error']        = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }
        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }
    
    public function executeEditdetail()
    {
        $this->block      = $this->getRequestParameter( 'block' );
        $this->i_Id       = $this->getRequestParameter( 'i_Id' );
        $this->s_TipoProc = $this->getRequestParameter( 'TipoProc' );
        
        $o_DefaultFN = new ALM_TransferenciaCabeceraFN();
        $this->o_DefaultBN = $o_DefaultFN->selectByPK( $this->i_Id );
    }
}