<?php
class requerimientoActions extends wtActions
{
    public function executeRequest()
    {
        set_header_utf8();
        $block        	= $this->getRequestParameter( 'block' );
        $TipoProc     	= $this->getRequestParameter( 'TipoProc' );
        
        $IdCompania 	= $this->getRequestParameter( 'IdCompania' );
        $IdSucursal    	= $this->getRequestParameter( 'IdSucursal' );
        $IdLinea       	= $this->getRequestParameter( 'IdLinea' );
         
        $b_Control = true;
        switch ( $TipoProc )
        {
            case "GetSucursal":
                $o_GSS_SucursalFN = new GSS_SucursalFN();
                $o_GSS_SucursalFN->setIdCompania( $IdCompania );
                $a_Result = $o_GSS_SucursalFN->select();
                
                $s_NameId  = "getIdSucursal";
                $s_NameDes = "getDescripcion";
            break;
            case "GetAlmacen":
                $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
                $o_ALM_AlmacenMastFN->setIdCompania( $IdCompania );
                $o_ALM_AlmacenMastFN->setIdSucursal( $IdSucursal );
                $a_Result = $o_ALM_AlmacenMastFN->select();
                
                $s_NameId  = "getIdAlmacen";
                $s_NameDes = "getDescripcionLocal";
            break;
            case "GetFamilia":
                $o_MST_ClaseFamiliaFN = new MST_ClaseFamiliaFN();
                $o_MST_ClaseFamiliaFN->setIdLinea( $IdLinea );
                $a_Result = $o_MST_ClaseFamiliaFN->select();
                
                $s_NameId  = "getIdFamilia";
                $s_NameDes = "getDescripcion";
            break;
            case "DeleteDetail":
                $b_Control = false;
                
                $i_Id  = ( int ) $this->getRequestParameter( 'i_Id' );
                $id_tr = $this->getRequestParameter( 'id_tr' );
                
                $o_ALM_RequerimientoDetalleFN = new ALM_RequerimientoDetalleFN();
                $o_ALM_RequerimientoDetalleFN->setIdRequerimiento( $i_Id );
                $o_ALM_RequerimientoDetalleFN->setIdItem( $id_tr );
                $a_ALM_RequerimientoDetalle = $o_ALM_RequerimientoDetalleFN->select();
                if( $a_ALM_RequerimientoDetalle )
                {
                    $o_ALM_RequerimientoDetalleBN = $a_ALM_RequerimientoDetalle[0];
                    $i_IdDet = $o_ALM_RequerimientoDetalleBN->getIdRequerimientoDetalle();
                }
                
                $o_ALM_RequerimientoDetalleDP = new ALM_RequerimientoDetalleDP();
                $o_ALM_RequerimientoDetalleDP->setIdRequerimiento( $i_Id );
                $o_ALM_RequerimientoDetalleDP->setIdRequerimientoDetalle( $i_IdDet );
                $b_Result = $o_ALM_RequerimientoDetalleDP->delete();
                
                $a_lst['error'] = false;
            break;
            case "DeleteEstadoDetail":
                /*
                $b_Control = false;
                
                $i_IdRequerimiento        = ( int ) $this->getRequestParameter( 'IdRequerimiento' );
                $i_IdRequerimientoDetalle = ( int ) $this->getRequestParameter( 'IdRequerimientoDetalle' );
                $f_CantidadPedida         = floatval( $this->getRequestParameter( 'Qty' ) );
                
                $o_ALM_RequerimientoDetalleDP = new ALM_RequerimientoDetalleDP();
                $o_ALM_RequerimientoDetalleDP->setIdRequerimiento( $i_IdRequerimiento );
                $o_ALM_RequerimientoDetalleDP->setIdRequerimientoDetalle( $i_IdRequerimientoDetalle );
                $o_ALM_RequerimientoDetalleDP->setEstado( "I" );
                $o_ALM_RequerimientoDetalleDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $o_ALM_RequerimientoDetalleDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $b_Result = $o_ALM_RequerimientoDetalleDP->update();
                
                $a_lst['error'] = false;
                */
            break;
            case "EnviarCorreo":
                $b_Control = false;
                
                $i_Id    = ( int ) $this->getRequestParameter( 'i_Id' );
                
                $o_ALM_RequerimientoCabeceraFN = new ALM_RequerimientoCabeceraFN();
                $o_ALM_RequerimientoCabeceraBN = $o_ALM_RequerimientoCabeceraFN->selectByPK( $i_Id );
                $s_AlmacenDesc = $o_ALM_RequerimientoCabeceraBN->getAlmacenDesc();

                $o_ALM_RequerimientoCabeceraDP = new ALM_RequerimientoCabeceraDP();
                $o_ALM_RequerimientoCabeceraDP->setIdRequerimiento( $i_Id );
                $o_ALM_RequerimientoCabeceraDP->setEstado( ALM_RequerimientoCabeceraBN::REQUERIMIENTO_APROBADO );
                $o_ALM_RequerimientoCabeceraDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $o_ALM_RequerimientoCabeceraDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $b_Result = $o_ALM_RequerimientoCabeceraDP->update();

                $o_ALM_RequerimientoDetalleFN = new ALM_RequerimientoDetalleFN();
                $o_ALM_RequerimientoDetalleFN->setIdRequerimiento( $i_Id );
                //$o_ALM_RequerimientoDetalleFN->setEstado( "A" );
                $a_ALM_RequerimientoDetalle = $o_ALM_RequerimientoDetalleFN->select();

                foreach( $a_ALM_RequerimientoDetalle as $o_ALM_RequerimientoDetalleBN )
                {
                    $o_ALM_RequerimientoDetalleDP = new ALM_RequerimientoDetalleDP();
                    $o_ALM_RequerimientoDetalleDP->setIdRequerimientoDetalle( $o_ALM_RequerimientoDetalleBN->getIdRequerimientoDetalle() );
                    $o_ALM_RequerimientoDetalleDP->setEstado( ALM_RequerimientoCabeceraBN::REQUERIMIENTO_APROBADO );
                    $o_ALM_RequerimientoDetalleDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                    $o_ALM_RequerimientoDetalleDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                    $o_ALM_RequerimientoDetalleDP->update();
                }

                $o_PHPMailer = new PHPMailer();
                $o_PHPMailer->Mailer = 'smtp';
                $o_PHPMailer->Host='127.0.0.1';
                $o_PHPMailer->From = "willjce@gmail.com";
                $o_PHPMailer->FromName = "William Taype";
                $o_PHPMailer->Subject = "REQUERIMIENTO DE SUCURSAL :: $s_AlmacenDesc";
                
                ob_start();
                $o_iRequrimiento = new iRequrimiento();
                $o_iRequrimiento->setObjetoCabecera( $o_ALM_RequerimientoCabeceraBN );
                $o_iRequrimiento->setArrayDetalles( $a_ALM_RequerimientoDetalle );
                $o_iRequrimiento->EnviarCorreoxEstadoPendiente();
                
                $body = ob_get_contents();
                ob_end_clean();
                
                $o_PHPMailer->Body = $body;
                $o_PHPMailer->IsHTML( true );
                //$o_PHPMailer->AddAddress( "almacen@petcenter.com.pe", "Italo" );
                $o_PHPMailer->AddBCC( "willjce@gmail.com", "William Taype Perez" );
                //$o_PHPMailer->AddBCC( "cbautista@dataexe.com","Cesar Bautista" );
                
                $send = $o_PHPMailer->Send();
                
                $a_lst['error'] = false;
            break;
            case "ActualizarCantidadDet":
                $b_Control = false;
                
                $i_IdRequerimiento        = ( int ) $this->getRequestParameter( 'IdRequerimiento' );
                $i_IdRequerimientoDetalle = ( int ) $this->getRequestParameter( 'IdRequerimientoDetalle' );
                $f_CantidadPedida         = floatval( $this->getRequestParameter( 'Qty' ) );

                $o_ALM_RequerimientoDetalleFN = new ALM_RequerimientoDetalleFN();
                $o_ALM_RequerimientoDetalleBN = $o_ALM_RequerimientoDetalleFN->selectByPK( $i_IdRequerimientoDetalle );

                $o_ALM_ItemMastFN = new ALM_ItemMastFN();
                $o_ALM_ItemMastBN = $o_ALM_ItemMastFN->selectByPK( $o_ALM_RequerimientoDetalleBN->getIdItem() );
                
                $o_ALM_RequerimientoDetalleDP = new ALM_RequerimientoDetalleDP();
                //$o_ALM_RequerimientoDetalleDP->setIdRequerimiento( $i_IdRequerimiento );
                $o_ALM_RequerimientoDetalleDP->setIdRequerimientoDetalle( $i_IdRequerimientoDetalle );
                $o_ALM_RequerimientoDetalleDP->setStockMinimo( $o_ALM_ItemMastBN->getStockMinimo() );
                $o_ALM_RequerimientoDetalleDP->setStockMaximo( $o_ALM_ItemMastBN->getStockMaximo() );
                $o_ALM_RequerimientoDetalleDP->setCantidadSugerida( $f_CantidadPedida );
                //$o_ALM_RequerimientoDetalleDP->setCantidadPedida( 0 );
                $o_ALM_RequerimientoDetalleDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $o_ALM_RequerimientoDetalleDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $b_Result = $o_ALM_RequerimientoDetalleDP->update();
                
                $a_lst['error'] = false;
            break;
            case "ActualizarPrecioDet":
                $b_Control = false;
            
                $i_IdRequerimiento        = ( int ) $this->getRequestParameter( 'IdRequerimiento' );
                $i_IdRequerimientoDetalle = ( int ) $this->getRequestParameter( 'IdRequerimientoDetalle' );
                $f_Precio                 = floatval( $this->getRequestParameter( 'Precio' ) );
                $f_Cantidad               = floatval( $this->getRequestParameter( 'Cantidad' ) );
                $b_ConIGV                 = $this->getRequestParameter( 'ConIGV' )=="true" ? true : false;
            
                $o_ALM_RequerimientoDetalleDP = new ALM_RequerimientoDetalleDP();
                $o_ALM_RequerimientoDetalleDP->setIdRequerimiento( $i_IdRequerimiento );
                $o_ALM_RequerimientoDetalleDP->setIdRequerimientoDetalle( $i_IdRequerimientoDetalle );
                
                //SE PROCEDE CON LOS CALCULOS PARA EL PRECIO
                $f_IGV       = UtilIGV::getValorIGVActual();
                $f_IGVMasUno = $f_IGV + 1;
                if( $b_ConIGV )
                {
                    $f_PrecioUniConIGV   = $f_Precio;
                    $f_PrecioUniSinIGV   = utilMath::fnround( $f_Precio / $f_IGVMasUno, 6 );
                    $f_PrecioTotalFinal  = $f_Precio * $f_Cantidad;
                    $f_IGVMonto          = utilMath::fnround( ( $f_PrecioTotalFinal / $f_IGVMasUno ) * $f_IGV, 6 );
                    $f_PrecioSubTotal    = utilMath::fnround( $f_PrecioTotalFinal / $f_IGVMasUno, 6 );
                }
                else 
                {
                    $f_PrecioUniConIGV   = $f_Precio * $f_IGVMasUno;
                    $f_PrecioUniSinIGV   = $f_Precio;
                    $f_PrecioSubTotal    = utilMath::fnround( $f_PrecioUniSinIGV * $f_Cantidad, 6 );
                    $f_IGVMonto          = utilMath::fnround( $f_PrecioSubTotal * $f_IGV, 6 );
                    $f_PrecioTotalFinal  = $f_PrecioSubTotal + $f_IGVMonto;
                }
                $o_ALM_RequerimientoDetalleDP->setCantidadPedida( $f_Cantidad );
                $o_ALM_RequerimientoDetalleDP->setPrecioUnitario( $f_PrecioUniConIGV );
                $o_ALM_RequerimientoDetalleDP->setPrecioUnitarioIGV( $f_PrecioUniSinIGV );
                $o_ALM_RequerimientoDetalleDP->setPrecioSubTotal( $f_PrecioSubTotal );
                $o_ALM_RequerimientoDetalleDP->setValorIGV( $f_IGVMonto );
                $o_ALM_RequerimientoDetalleDP->setPrecioTotalConIGV( $f_PrecioTotalFinal );
                /////////////////////////////////////////////
                
                $o_ALM_RequerimientoDetalleDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $o_ALM_RequerimientoDetalleDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $b_Result = $o_ALM_RequerimientoDetalleDP->update();
            
                $a_lst['PrecioSubTotal'] = number_format( $f_PrecioSubTotal, 2 );
                $a_lst['error'] = false;
            break;
            case "ActualizarModoIngConIGV":
                $b_Control = false;
                $i_IdRequerimiento        = ( int ) $this->getRequestParameter( 'IdRequerimiento' );
                $s_ModoIngIGV = $this->getRequestParameter( 'ModoIngreso' )=="true" ? "S" : "N";
                
                $o_ALM_RequerimientoCabeceraDP = new ALM_RequerimientoCabeceraDP();
                $o_ALM_RequerimientoCabeceraDP->setIdRequerimiento( $i_IdRequerimiento );
                $o_ALM_RequerimientoCabeceraDP->setModoIngresoConIGVFlag( $s_ModoIngIGV );
                $o_ALM_RequerimientoCabeceraDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $o_ALM_RequerimientoCabeceraDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $b_Result = $o_ALM_RequerimientoCabeceraDP->update();
                
                $a_lst['error'] = false;
            break;
            case "AnularRequerimiento":
                $b_Control = false;
                
                $i_Id    = ( int ) $this->getRequestParameter( 'i_Id' );
                
                $o_ALM_RequerimientoCabeceraDP = new ALM_RequerimientoCabeceraDP();
                $o_ALM_RequerimientoCabeceraDP->setIdRequerimiento( $i_Id );
                $o_ALM_RequerimientoCabeceraDP->setEstado( ALM_RequerimientoCabeceraBN::REQUERIMIENTO_ANULADO );
                $o_ALM_RequerimientoCabeceraDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $o_ALM_RequerimientoCabeceraDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $b_Result = $o_ALM_RequerimientoCabeceraDP->update();
                
                $a_lst['error'] = false;
            break;
        }
        if( $b_Control )
        {
            foreach ( $a_Result as $i_Key => $o_ObjectBN )
            {
                $a_lst[$o_ObjectBN->$s_NameId()] = utf8_encode( $o_ObjectBN->$s_NameDes() );
            }
        }
        echo json_encode( $a_lst );
        return ViewResponse::NONE;
    }
    
    public function executeActualizarTotalesReq()
    {
        $i_Id = $this->getRequestParameter( 'i_Id' );
        
        $this->a_TotalesReq = ALM_RequerimientoDetalleFN::selectTotales( $i_Id );
        
        ViewResponse::getInstance()->setMethodAjax();
    }
    
    public function executeList()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        
        $this->GlobalAccess   = myUser::getUser()->hasGlobalAccess();
        
        $o_GSS_SucursalFN = new GSS_SucursalFN();
        $o_GSS_SucursalFN->setIdCompania( myUser::getUser()->getIdBusiness() );
        $o_GSS_SucursalFN->setEstado( "A" );
        $this->opt_seleccione = $this->GlobalAccess;
        if( myUser::getUser()->getIdSucursal() )
        {
            $o_GSS_SucursalFN->setIdSucursal( myUser::getUser()->getIdSucursal() );
        }
        $this->a_GSS_Sucursal = $o_GSS_SucursalFN->select();
        
        //SE RECUPERA LOS PROVEEDORES
        $o_MST_PersonaMastFN = new MST_PersonaMastFN();
        $o_MST_PersonaMastFN->setEsProveedor( 'SI' );
        $o_MST_PersonaMastFN->setIdCompania( myUser::getUser()->getIdBusiness() );
        $o_MST_PersonaMastFN->setEstado( 'A' );
        $o_MST_PersonaMastFN->addOrderBy( MST_PersonaMastFN::NombreCompleto );
        $this->a_MST_PersonaMast = $o_MST_PersonaMastFN->select();
        
        $this->a_EstadosReq = ALM_RequerimientoCabeceraBN::getArrayEstados();
    }
    
    public function executeListRev()
    {
        $this->GlobalAccess   = myUser::getUser()->hasGlobalAccess();
        
        $o_GSS_SucursalFN = new GSS_SucursalFN();
        $o_GSS_SucursalFN->setIdCompania( myUser::getUser()->getIdBusiness() );
        $this->opt_seleccione = $this->GlobalAccess;
        if( myUser::getUser()->getIdSucursal() )
        {
            $o_GSS_SucursalFN->setIdSucursal( myUser::getUser()->getIdSucursal() );
        }
        $this->a_GSS_Sucursal = $o_GSS_SucursalFN->select();
        
        //SE RECUPERA LOS PROVEEDORES
        $o_MST_PersonaMastFN = new MST_PersonaMastFN();
        $o_MST_PersonaMastFN->setEsProveedor( 'SI' );
        $o_MST_PersonaMastFN->setIdCompania( myUser::getUser()->getIdBusiness() );
        $o_MST_PersonaMastFN->setEstado( 'A' );
        $o_MST_PersonaMastFN->addOrderBy( MST_PersonaMastFN::NombreCompleto );
        $this->a_MST_PersonaMast = $o_MST_PersonaMastFN->select();
        
        $this->a_EstadosReq = array( ALM_RequerimientoCabeceraBN::REQUERIMIENTO_PREPARACION => "PREPARACION" );
    }
    
    public function executeGrid()
    {
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $o_GridAction = new GridAction();
        $o_GridAction->setClassFind( new ALM_RequerimientoCabeceraFN() );

        $o_GridAction->addMethodDefault( "IdCompania", myUser::getUser()->getIdBusiness() );
        $o_GridAction->addMethodDefault( "IdSucursal", myUser::getUser()->getIdSucursal() );
        
        //$o_GridAction->addAssignFilter( "IdCompania" );
        //$o_GridAction->addAssignFilter( "IdPersona" );
        //$o_GridAction->addAssignFilter( "IdSucursal" );
        $o_GridAction->addAssignFilter( "FechaRequerida" );
        $o_GridAction->addAssignFilter( "Estado" );
        //$o_GridAction->addConditionFilter( "Descripcion", GSS_ImpuestoFN::Descripcion, "LIKE", "%%s%" );
        
        //$o_GridAction->addOrder( "Descripcion", GSS_ImpuestoFN::Descripcion );
        //$o_GridAction->addOrder( "Codigo",      GSS_ImpuestoFN::Codigo );
        
        $o_GridAction->addOrderDefault( ALM_RequerimientoCabeceraFN::FechaCreacion, false );
        
        $o_GridAction->addRowsToShow
        ( 
            "IdRequerimiento", "SucursalDesc", "FechaRequerida", "EstadoDesc", "Estado", "ProveedorDes", "FechaCreacion", 
            'UsuarioCreacion', "FechaProgramada", "ResponsableNombre", "Descripcion"
        );
              
        $o_GridAction->setNumberRecordsShow( 15 );
        
        $o_GridAction->initialize();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $a_ResultJson['page']    = $o_GridAction->getPage();
        $a_ResultJson['total']   = $o_GridAction->getTotalPage();
        $a_ResultJson['records'] = $o_GridAction->getTotalRecords();
        $a_ResultJson['rows']    = $o_GridAction->getResultArray();
        //pr( $a_ResultJson );
        echo json_encode( $a_ResultJson );

        return ViewResponse::NONE;
    }
    
    public function executeGridRev()
    {
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $o_GridAction = new GridAction();
        $o_GridAction->setClassFind( new ALM_RequerimientoCabeceraFN() );
        
        $o_GridAction->addMethodDefault( "IdCompania", myUser::getUser()->getIdBusiness() );
        $o_GridAction->addMethodDefault( "Estado", ALM_RequerimientoCabeceraBN::REQUERIMIENTO_PREPARACION );
        
        $o_GridAction->addAssignFilter( "IdCompania" );
        $o_GridAction->addAssignFilter( "IdPersona" );
        $o_GridAction->addAssignFilter( "IdSucursal" );
        $o_GridAction->addAssignFilter( "FechaRequerida" );
        $o_GridAction->addAssignFilter( "Estado" );
        //$o_GridAction->addConditionFilter( "Descripcion", GSS_ImpuestoFN::Descripcion, "LIKE", "%%s%" );
        
        //$o_GridAction->addOrder( "Descripcion", GSS_ImpuestoFN::Descripcion );
        //$o_GridAction->addOrder( "Codigo",      GSS_ImpuestoFN::Codigo );
        
        $o_GridAction->addOrderDefault( ALM_RequerimientoCabeceraFN::FechaCreacion, false );
        
        $o_GridAction->addRowsToShow( "IdRequerimiento", "SucursalDesc", "FechaRequerida", "EstadoDesc", "Estado", "ProveedorDes", "FechaCreacion", 'UsuarioCreacion' );
        
        $o_GridAction->setNumberRecordsShow( 15 );
        
        $o_GridAction->initialize();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $a_ResultJson['page']    = $o_GridAction->getPage();
        $a_ResultJson['total']   = $o_GridAction->getTotalPage();
        $a_ResultJson['records'] = $o_GridAction->getTotalRecords();
        $a_ResultJson['rows']    = $o_GridAction->getResultArray();
        //pr( $a_ResultJson );
        echo json_encode( $a_ResultJson );
        
        return ViewResponse::NONE;
    }
    
    public function executeAddedit()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        
        $this->block      = $this->getRequestParameter( 'block' );
        $this->i_Id       = $this->getRequestParameter( 'i_Id' );
        $this->s_TipoProc = $this->getRequestParameter( 'TipoProc' );
        
        $this->GlobalAccess   = myUser::getUser()->hasGlobalAccess();
        $this->opt_seleccione = $this->GlobalAccess;
        
        $this->s_Titulo = "Nuevo Requerimiento";
        
        /************/
        
        $this->b_GlobalAccess   = myUser::getUser()->hasGlobalAccess();
        
        //SE RECUPERA SUCURSALES
        $o_GSS_SucursalFN = new GSS_SucursalFN();
        $o_GSS_SucursalFN->setIdCompania( myUser::getUser()->getIdBusiness() );
        $o_GSS_SucursalFN->setIdSucursal( myUser::getUser()->getIdSucursal() );
        $this->a_GSS_Sucursal = $o_GSS_SucursalFN->select();
        
        //SE RECUPERA LOS PROVEEDORES
        $o_MST_PersonaMastFN = new MST_PersonaMastFN();
        $o_MST_PersonaMastFN->setEsProveedor( 'SI' );
        $o_MST_PersonaMastFN->setIdCompania( myUser::getUser()->getIdBusiness() );
        $o_MST_PersonaMastFN->setEstado( 'A' );
        $o_MST_PersonaMastFN->addOrderBy( MST_PersonaMastFN::NombreCompleto );
        $this->a_MST_PersonaMast = $o_MST_PersonaMastFN->select();
        
        $o_DefaultBN = new ALM_RequerimientoCabeceraBN();
        $o_DefaultBN->setEstado( 'A' );
        $o_DefaultBN->setFechaRequerida( date( "Y-m-d" ) );
        $this->o_DefaultBN = $o_DefaultBN;
        
        /*************/
        //$this->o_MST_UnidadMastBN = new MST_UnidadMastBN();
        if( $this->s_TipoProc == "upd" )
        {
            $this->s_Titulo = "Editar Requerimiento";
            $o_DefaultFN = new ALM_RequerimientoCabeceraFN();
            $this->o_DefaultBN = $o_DefaultFN->selectByPK( $this->i_Id );
        }
    }
    
    public function executeSaveAddEdit()
    {
        $block      = $this->getRequestParameter( 'block' );
        $i_Id       = $this->getRequestParameter( 'i_Id' );
        $s_TipoProc = $this->getRequestParameter( 'TipoProc' );
        $TypeSub    = $this->getRequestParameter( 'TypeSub' );
        
        $IdCompania      = myUser::getUser()->getIdBusiness();
        $IdSucursal      = myUser::getUser()->getIdSucursal();

        //$IdPersona       = 9999999;
        $ResponsableNom  = SEG_UsuarioFN::StaticSelectByPK( myUser::getUser()->getUserId() )->getUsuarioNombre();
        $IdAlmacen       = $this->getRequestParameter( 'IdAlmacen' );
        $Descripcion     = $this->getRequestParameter( 'Descripcion' );
        $FechaRequerida  = $this->getRequestParameter( 'FechaRequerida' );
        //$FechaProgramada = $this->getRequestParameter( 'FechaProgramada' );
        $Estado          = $this->getRequestParameter( 'Estado' );
        $Comentario      = $this->getRequestParameter( 'Comentario' );
        
        $con = Conexion::getConexion();
        $con->begin();
        try 
        {
            $o_DefaultDP = new ALM_RequerimientoCabeceraDP();
            $o_DefaultDP->setIdCompania( $IdCompania );
            $o_DefaultDP->setIdSucursal( $IdSucursal );
            //$o_DefaultDP->setIdPersona( $IdPersona );
            $o_DefaultDP->setResponsableNombre( $ResponsableNom );
            $o_DefaultDP->setIdAlmacen( $IdAlmacen );
            $o_DefaultDP->setDescripcion( $Descripcion );
            $o_DefaultDP->setFechaRequerida( $FechaRequerida );
            //$o_DefaultDP->setFechaProgramada( $FechaProgramada );
            $o_DefaultDP->setEstado( ALM_RequerimientoCabeceraBN::REQUERIMIENTO_PREPARACION );
            $o_DefaultDP->setComentario( $Comentario );
            if( $s_TipoProc == "nvo" )
            {
                //NUEVO
                $IdCabecera = ALM_RequerimientoCabeceraFN::recuperarId();
                
                $o_DefaultDP->setIdRequerimiento( $IdCabecera );
                $o_DefaultDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                $o_DefaultDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                $o_DefaultDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $o_DefaultDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $b_Result = $o_DefaultDP->save();
                $i_Id = $IdCabecera;
            }
            else 
            {
                //SE TIENE QUE PREGUNTAR SI YA SE ENCUENTRA REGISTRADO
                
                //UPDATE
                $o_DefaultDP->setIdRequerimiento( ( int ) $i_Id );
                $o_DefaultDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $o_DefaultDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $b_Result = $o_DefaultDP->update();
            }
            
            $con->commit();
            
            $a_Rs['type_sub'] = $TypeSub;
            $a_Rs['error']    = false;
            $a_Rs['id']       = $i_Id;
        }
        catch ( Exception $o_Exception )
        {
            $con->rollback();
            $a_Rs['error']         = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }
        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }
    
    public function executeDetail()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        
        //$this->block      = $this->getRequestParameter( 'block' );
        $this->i_Id       = $this->getRequestParameter( 'i_Id' );
        $this->s_TipoProc = $this->getRequestParameter( 'TipoProc' );
        
        $this->IdLinea      = $this->getRequestParameter( 'IdLinea' );
        $this->IdFamilia    = $this->getRequestParameter( 'IdFamilia' );
        $this->CodigoBarras = $this->getRequestParameter( 'CodigoBarras' );
        
        $this->s_Titulo = "Editar Requerimiento";
        
        $o_ALM_RequerimientoCabeceraFN = new ALM_RequerimientoCabeceraFN();
        $this->o_DefaultBN = $o_ALM_RequerimientoCabeceraFN->selectByPK( $this->i_Id );
        
        $this->IdCompania = $this->o_DefaultBN->getIdCompania();
        $this->IdSucursal = $this->o_DefaultBN->getIdSucursal();
        $this->IdAlmacen  = GSS_SucursalFN::recuperarIdAlmacen( $this->o_DefaultBN->getIdSucursal() );
        $this->IdPersona  = $this->o_DefaultBN->getIdPersona();
        
        $o_MST_ClaseLineaFN = new MST_ClaseLineaFN();
        $o_MST_ClaseLineaFN->setEstado( "" );
        //$o_MST_ClaseLineaFN->addCondition( MST_ClaseLineaFN::IdLinea, "IN", "(SELECT IdLinea FROM ALM_ItemMast WHERE IdPersona='{$this->IdPersona}' GROUP BY IdLinea)", false );
        $o_MST_ClaseLineaFN->addOrderBy( MST_ClaseLineaFN::Descripcion );
        $this->a_MST_ClaseLinea = $o_MST_ClaseLineaFN->select();
        
        $this->a_MST_ClaseFamilia = array();
        if( $this->IdLinea )
        {
            $o_MST_ClaseFamiliaFN = new MST_ClaseFamiliaFN();
            $o_MST_ClaseFamiliaFN->setEstado( "A" );
            $o_MST_ClaseFamiliaFN->setIdLinea( $this->IdLinea );
            $this->a_MST_ClaseFamilia = $o_MST_ClaseFamiliaFN->select();
        }
        
        $o_ALM_ItemMastFN = new ALM_ItemMastFN();
        $o_ALM_ItemMastFN->setIdPersona( $this->IdPersona );
        if( $this->IdLinea )
        {
            $o_ALM_ItemMastFN->setIdLinea( $this->IdLinea );
        }
        if( $this->IdFamilia )
        {
            $o_ALM_ItemMastFN->setIdFamilia( $this->IdFamilia );
        }
        if( $this->CodigoBarras )
        {
            $o_ALM_ItemMastFN->setCodigoBarras( $this->CodigoBarras );
        }
        $o_ALM_ItemMastFN->addCondition( ALM_ItemMastFN::IdItem, "NOT IN", "( SELECT IdItem FROM ALM_RequerimientoDetalle WHERE idRequerimiento='{$this->i_Id}' )", false );
        $this->a_ALM_ItemMast = $o_ALM_ItemMastFN->select();
        if( !$this->a_ALM_ItemMast )
        {
            $this->a_ALM_ItemMast = array();
        }
    }
    
    public function executeGridDet()
    {
        //set_header_iso_8859_1();
        set_header_utf8();
        
        $this->i_Id       = $this->getRequestParameter( 'i_Id' );
        
        $o_ALM_RequerimientoCabeceraFN = new ALM_RequerimientoCabeceraFN();
        $o_DefaultBN = $o_ALM_RequerimientoCabeceraFN->selectByPK( $this->i_Id );
        
        $IdCompania = $o_DefaultBN->getIdCompania();
        $IdSucursal = $o_DefaultBN->getIdSucursal();
        $IdAlmacen  = GSS_SucursalFN::recuperarIdAlmacen( $o_DefaultBN->getIdSucursal() );
        $IdPersona  = $o_DefaultBN->getIdPersona();
        
        ALM_ItemMastBN::setStaticIdCompania( $IdCompania );
        ALM_ItemMastBN::setStaticIdSucursal( $IdSucursal );
        ALM_ItemMastBN::setStaticIdAlmacen( $IdAlmacen );
        ALM_ItemMastBN::setStaticIdPersona( $IdPersona );
        ALM_ItemMastBN::setIdRequerimiento( $this->i_Id );
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $o_GridAction = new GridAction();
        $o_GridAction->setClassFind( new ALM_ItemMastFN() );
        
        $o_GridAction->addMethodDefault( "IdPersona", $IdPersona );
        
        $o_GridAction->addAssignFilter( "CodigoBarras" );
        $o_GridAction->addAssignFilter( "IdItemTipo" );
        $o_GridAction->addAssignFilter( "IdLinea" );
        $o_GridAction->addAssignFilter( "IdFamilia" ); 
        
        $o_GridAction->addConditionFilter( "Codigo", ALM_ItemMastFN::IdItem, "LIKE", "%%s%" );
        $o_GridAction->addConditionFilter( "DescripcionCompleta", ALM_ItemMastFN::DescripcionCompleta, "LIKE", "%%s%" );
        if( $this->getRequestParameter( 'IdRequerimientoDetalle' ) )
        {
            $o_GridAction->addConditionFilter( "IdRequerimientoDetalle", ALM_ItemMastFN::IdItem , "IN", "(SELECT IdItem FROM ALM_RequerimientoDetalle WHERE idRequerimiento='{$this->i_Id}' AND Estado='".ALM_RequerimientoDetalleBN::ESTADO_ACTIVO."')"  );
        }
        
        $o_GridAction->addOrder( "IdItem",              ALM_ItemMastFN::IdItem );
        $o_GridAction->addOrder( "DescripcionCompleta", ALM_ItemMastFN::DescripcionCompleta );
        //$o_GridAction->addOrder( "IdItemTipo",          ALM_ItemMastFN::IdItemTipo );
        //$o_GridAction->addOrder( "CodigoInterno",       ALM_ItemMastFN::CodigoInterno  );
        
        $o_GridAction->addOrderDefault( ALM_ItemMastFN::IdItem, true );
        
        $o_GridAction->addRowsToShow
        ( 
            "IdItem", "CodigoInterno", "IdItemTipo", "DescripcionCompleta", "StockAlmacenActual", "RepoStockMinimo", "RepoStockMinimo",
            "ReqCantidadSugerida", "ExisteRequerimientoDet", "CodigoBarras"
        );
        
        //$o_GridAction->addInnerJoin( new ALM_ItemTipoFN(), "IdItemTipo", "DescripcionLocal" );
        //$o_GridAction->addInnerJoin( new MST_ClaseLineaFN(), "IdLinea", "Descripcion" );
        
        $o_GridAction->setNumberRecordsShow( 9999 );
        
        $o_GridAction->initialize();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        
        $a_ResultJson['page']    = $o_GridAction->getPage();
        $a_ResultJson['total']   = $o_GridAction->getTotalPage();
        $a_ResultJson['records'] = $o_GridAction->getTotalRecords();
        $a_ResultJson['rows']    = $o_GridAction->getResultArray();
        //pr( $a_ResultJson );
        echo json_encode( $a_ResultJson );

        return ViewResponse::NONE;
    }

    public function executeDeleteDetail()
    {
        $i_Id       = ( int ) $this->getRequestParameter( 'i_Id' );

        $o_ALM_RequerimientoDetalleDP = new ALM_RequerimientoDetalleDP();
        $o_ALM_RequerimientoDetalleDP->setIdRequerimientoDetalle( $i_Id );
        $o_ALM_RequerimientoDetalleDP->delete();

        $a_ResultJson['error'] = false;

        echo json_encode( $a_ResultJson );

        return ViewResponse::NONE;
    }

    public function executeSaveDetail()
    {
        $i_Id       = ( int ) $this->getRequestParameter( 'Id' );

        $s_IdItem     = $this->getRequestParameter( 'IdItem' );
        $f_StockMax   = floatval( $this->getRequestParameter( 'StockMin' ) );//StockMax
        $f_StockMin   = floatval( $this->getRequestParameter( 'StockMin' ) );
        $f_CantDif    = floatval( $this->getRequestParameter( 'ReqCantidadSugerida' ) );
        
        try
        {
            if( $f_CantDif <= 0 )
            {
                throw new Exception( "El Item ( $s_IdItem ), no puede tener una cantidad menor o igual a cero." );
            }
            
            //SE RECUPERA LA CABECERA
            $o_ALM_RequerimientoCabeceraFN = new ALM_RequerimientoCabeceraFN();
            $o_ALM_RequerimientoCabeceraBN = $o_ALM_RequerimientoCabeceraFN->selectByPK( $i_Id );
            if( !$o_ALM_RequerimientoCabeceraBN )
            {
                throw new Exception( "No se encontro Requerimiento." );
            }

            $o_ALM_ItemMastFN = new ALM_ItemMastFN();
            $o_ALM_ItemMastBN = $o_ALM_ItemMastFN->selectByPK( $s_IdItem );

            //AQUI SE BUSCA EL DETALLE POR EL ITEM.
            $o_ALM_RequerimientoDetalleFN = new ALM_RequerimientoDetalleFN();
            $o_ALM_RequerimientoDetalleFN->setIdRequerimiento( $i_Id );
            $o_ALM_RequerimientoDetalleFN->setIdItem( $s_IdItem );
            $a_ALM_RequerimientoDetalle = $o_ALM_RequerimientoDetalleFN->select();
            
            $o_ALM_RequerimientoDetalleDP = new ALM_RequerimientoDetalleDP();
            $o_ALM_RequerimientoDetalleDP->setIdRequerimiento( $i_Id );
            $o_ALM_RequerimientoDetalleDP->setIdItem( $s_IdItem );
            $o_ALM_RequerimientoDetalleDP->setStockMinimo( $o_ALM_ItemMastBN->getStockMinimo() );
            $o_ALM_RequerimientoDetalleDP->setStockMaximo( $o_ALM_ItemMastBN->getStockMaximo() );
            //$o_ALM_RequerimientoDetalleDP->setCantidadPedida( $f_CantDif );
            $o_ALM_RequerimientoDetalleDP->setCantidadSugerida( $f_CantDif );
            $o_ALM_RequerimientoDetalleDP->setCantidadPedida( 0 );
            $o_ALM_RequerimientoDetalleDP->setEstado( ALM_RequerimientoDetalleBN::ESTADO_ACTIVO );

            //AHORA SE AGREGAR EL PRECIO POR DEFECTO DESDE EL LOG
            $f_PrecioUnitario = 0.00;
            $o_ALM_RequerimientoDetalleLogFN = new ALM_RequerimientoDetalleLogFN();
            $o_ALM_RequerimientoDetalleLogFN->setIdCompania( $o_ALM_RequerimientoCabeceraBN->getIdCompania() );
            $o_ALM_RequerimientoDetalleLogFN->setIdSucursal( $o_ALM_RequerimientoCabeceraBN->getIdSucursal() );
            $o_ALM_RequerimientoDetalleLogFN->setIdPersona( $o_ALM_RequerimientoCabeceraBN->getIdPersona() );
            $o_ALM_RequerimientoDetalleLogFN->setIdItem( $s_IdItem );
            $o_ALM_RequerimientoDetalleLogFN->addOrderBy( ALM_RequerimientoDetalleLogFN::FechaCreacion, false );
            $a_ALM_RequerimientoDetalleLog = $o_ALM_RequerimientoDetalleLogFN->select();
            if( $a_ALM_RequerimientoDetalleLog )
            {
                $o_ALM_RequerimientoDetalleLogBN = $a_ALM_RequerimientoDetalleLog[0];
                $f_PrecioUnitario = $o_ALM_RequerimientoDetalleLogBN->getPrecioUnitario();
            }
            $o_ALM_RequerimientoDetalleDP->setPrecioUnitario( $f_PrecioUnitario );
            $a_Rs['pruni'] = $f_PrecioUnitario;
            
            if( !$a_ALM_RequerimientoDetalle )
            {
                //INSERT
                $i_IdDet = ALM_RequerimientoDetalleFN::recuperarId();
                $o_ALM_RequerimientoDetalleDP->setIdRequerimientoDetalle( $i_IdDet );

                $o_ALM_RequerimientoDetalleDP->setIdMoneda( "LO" );
                $o_ALM_RequerimientoDetalleDP->setEstado( "A" );
                $o_ALM_RequerimientoDetalleDP->setIGVExoneradoFlag( "N" );
                $o_ALM_RequerimientoDetalleDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                $o_ALM_RequerimientoDetalleDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                $o_ALM_RequerimientoDetalleDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $o_ALM_RequerimientoDetalleDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $b_Result = $o_ALM_RequerimientoDetalleDP->save();
            }
            else
            {
                //UPDATE
                $o_ALM_RequerimientoDetalleBN = $a_ALM_RequerimientoDetalle[0];
                $i_IdDet = $o_ALM_RequerimientoDetalleBN->getIdRequerimientoDetalle();
                $o_ALM_RequerimientoDetalleDP->setIdRequerimientoDetalle( $i_IdDet );
                $o_ALM_RequerimientoDetalleDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $o_ALM_RequerimientoDetalleDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $b_Result = $o_ALM_RequerimientoDetalleDP->update();
            }
            
            $a_Rs['error'] = false;
            $a_Rs['id_tr'] = $s_IdItem;
            $a_Rs['td_ti'] = $f_CantDif;
            
        }
        catch ( Exception $o_Exception )
        {
            $a_Rs['error']         = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }
        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }
    
    public function executeExcelexport()
    {
        header( 'Content-type: application/vnd.ms-excel' );
        header( "Content-Disposition: attachment; filename=Requerimiento_Detalle.xls" );
        
        //header( 'Content-Type: application/vnd.ms-excel' );
        //header( 'Content-Disposition: attachment;filename="Requerimiento_Detalle.xls"' );
        //header( 'Cache-Control: max-age=0' );
        
        $i_Id = $this->getRequestParameter( 'i_Id' );
        
        $o_ALM_RequerimientoCabeceraFN = new ALM_RequerimientoCabeceraFN();
        $this->o_DefaultBN = $o_ALM_RequerimientoCabeceraFN->selectByPK( $i_Id );
        
        $this->IdCompania = $this->o_DefaultBN->getIdCompania();
        $this->IdSucursal = $this->o_DefaultBN->getIdSucursal();
        $this->IdAlmacen  = GSS_SucursalFN::recuperarIdAlmacen( $this->o_DefaultBN->getIdSucursal() );
        $this->IdPersona  = $this->o_DefaultBN->getIdPersona();
        
        ALM_ItemMastBN::setStaticIdCompania( $this->IdCompania );
        ALM_ItemMastBN::setStaticIdSucursal( $this->IdSucursal );
        ALM_ItemMastBN::setStaticIdAlmacen( $this->IdAlmacen );
        ALM_ItemMastBN::setStaticIdPersona( $this->IdPersona );
        ALM_ItemMastBN::setIdRequerimiento( $i_Id );
        
        $o_ALM_ItemMastFN = new ALM_ItemMastFN();
        $o_ALM_ItemMastFN->setIdPersona( $this->IdPersona );
        $this->a_ALM_ItemMast = $o_ALM_ItemMastFN->select();
        
        ViewResponse::getInstance()->setMethodAjax();
    }
    
    public function executeViewdel()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        
        $this->i_Id     = $this->getRequestParameter( 'i_Id' );
        $this->s_TipoProc = $this->getRequestParameter( 'TipoProc' );
        
        $o_DefaultFN = new ALM_RequerimientoCabeceraFN();
        $this->o_DefaultBN = $o_DefaultFN->selectByPK( $this->i_Id );
        
        $o_ALM_RequerimientoDetalleFN = new ALM_RequerimientoDetalleFN();
        $o_ALM_RequerimientoDetalleFN->setIdRequerimiento( $this->i_Id );
        //$o_ALM_RequerimientoDetalleFN->setEstado( "A" );
        $this->a_ALM_RequerimientoDetalle = $o_ALM_RequerimientoDetalleFN->select();

    }
    
    public function executeSaveRevisedDetail()
    {
        $i_Id = $this->getRequestParameter( 'i_Id' );
        
        $a_IdItem           = $this->getRequestParameter( 'IdItem' );
        $a_CantidadSugerida = $this->getRequestParameter( 'CantSug' );
        $a_Cantidad         = $this->getRequestParameter( 'Cantidad' );
        $a_FechaVencimiento = $this->getRequestParameter( 'FechaVencimiento' );
        $a_IdLote           = $this->getRequestParameter( 'IdLote' );
        $a_NoExceder        = $this->getRequestParameter( 'NoExceder' );
        
        $d_FechaProgramada  = $this->getRequestParameter( 'FechaProgramada' );
        
        $con = Conexion::getConexion();
        $con->begin();
        try
        {
            //AHORA SE ACTUALIZA EL ID DE LA ORDEN DE COMPRA
            $o_DefaultDP = new ALM_RequerimientoCabeceraDP();
            $o_DefaultDP->setIdRequerimiento( ( int ) $i_Id );
            $o_DefaultDP->setFechaProgramada( $d_FechaProgramada );
            $o_DefaultDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
            $o_DefaultDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
            $b_Result = $o_DefaultDP->update();
            ////////////////////////////////////////////////
        
            foreach ( $a_Cantidad as $s_IdReq => $a_CantData )
            {
                $o_ALM_RequerimientoDetalleBN = new ALM_RequerimientoDetalleBN();
                $o_ALM_RequerimientoDetalleBN->setIdRequerimiento( $i_Id );
                $o_ALM_RequerimientoDetalleBN->setIdRequerimientoDetalle( $s_IdReq );
                $o_ALM_RequerimientoDetalleBN->setIdItem( $a_IdItem[$s_IdReq] );
                $o_ALM_RequerimientoDetalleBN->setCantidadSugerida( floatval( $a_CantidadSugerida[$s_IdReq] ) );
                if( count( $a_CantData ) > 1 )
                {
                    //SE GUARDA REQUERIMIENTO LOTE
                    $a_ArrayObjLote = array();
                    $f_SumaCantidad = 0.00;
                    foreach ( $a_CantData as $i_Key => $s_Cantidad )
                    {
                        $s_IdLote           = $a_IdLote[$s_IdReq][$i_Key];
                        $s_FechaVencimiento = $a_FechaVencimiento[$s_IdReq][$i_Key];
                        $f_Cantidad         = floatval( $s_Cantidad );
                        
                        $o_ALM_RequerimientoDetalleLoteBN = new ALM_RequerimientoDetalleLoteBN();
                        $o_ALM_RequerimientoDetalleLoteBN->setIdRequerimientoDetalle( ( int ) $s_IdReq );
                        $o_ALM_RequerimientoDetalleLoteBN->setIdLote( $s_IdLote );
                        $o_ALM_RequerimientoDetalleLoteBN->setFechaVencimiento( $s_FechaVencimiento );
                        $o_ALM_RequerimientoDetalleLoteBN->setCantidad( $f_Cantidad );
                        
                        //SE SUMA LAS CAMTIDADES
                        $f_SumaCantidad = $f_SumaCantidad + $f_Cantidad;
                        
                        $a_ArrayObjLote[] = $o_ALM_RequerimientoDetalleLoteBN;
                    }
                    $o_ALM_RequerimientoDetalleBN->setCantidadPedida( $f_SumaCantidad );
                    $o_ALM_RequerimientoDetalleBN->setArrayObjectRequerimientoDetalleLote( $a_ArrayObjLote );
                }
                else 
                {
                    //SE GUARDA SOLO EN REQUERIMIENTO
                    $f_CantidadPedida   = floatval( $a_CantData[0] );
                    $s_IdLote           = $a_IdLote[$s_IdReq][0];
                    $s_FechaVencimiento = $a_FechaVencimiento[$s_IdReq][0];
                    
                    $o_ALM_RequerimientoDetalleBN->setCantidadPedida( $f_CantidadPedida );
                    $o_ALM_RequerimientoDetalleBN->setIdLote( $s_IdLote );
                    $o_ALM_RequerimientoDetalleBN->setFechaVencimiento( $s_FechaVencimiento );
                }
                
                $o_RequerimientoDetalleBL = new RequerimientoDetalleBL();
                $b_Result = $o_RequerimientoDetalleBL->ActualizarDetalle( $o_ALM_RequerimientoDetalleBN );
            }
            
            $b_Result = $this->executeRevisarRequerimiento();
            
            $con->commit();
            
            //$a_Rs['type_sub'] = $TypeSub;
            $a_Rs['error']   = false;
            $a_Rs['id']      = $i_Id;
        }
        catch ( Exception $o_Exception )
        {
            $con->rollback();
            $a_Rs['error']         = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }
        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }
    
    public function executeRevisarRequerimiento()
    {
        $i_Id       = ( int ) $this->getRequestParameter( 'i_Id' );
        $b_TipGenOC = ( int ) $this->getRequestParameter( 'GenerarAprobOC' );
        
        $con = Conexion::getConexion();
        $con->begin();
        try 
        {
            //VALIDACIONES ANTES DE GENERAR O/C
            $o_ALM_RequerimientoDetalleFN = new ALM_RequerimientoDetalleFN();
            $o_ALM_RequerimientoDetalleFN->setIdRequerimiento( $i_Id );
            //$o_ALM_RequerimientoDetalleFN->setEstado( "A" );
            $a_ALM_RequerimientoDetalle = $o_ALM_RequerimientoDetalleFN->select();
            if( count( $a_ALM_RequerimientoDetalle ) <= 0 )
            {
                throw new Exception( "No tiene detalles para generar una O/C." );
            }
            foreach ( $a_ALM_RequerimientoDetalle as $i_key => $o_ALM_RequerimientoDetalleBN )
            {
                if( $o_ALM_RequerimientoDetalleBN->getPrecioUnitario() <= 0 )
                {
                    throw new Exception( "No se puede generar una O/C con un detalle sin precio." );
                }
            }
            //////////////
            
            //SE RECUPERA VALOR DE IGV ACTUAL
            $f_ValorIGV = UtilIGV::getValorIGVActual();
            
            //LOS PARAMETROS PARA CABECERA
            $o_ALM_RequerimientoCabeceraFN = new ALM_RequerimientoCabeceraFN();
            $o_ALM_RequerimientoCabeceraBN = $o_ALM_RequerimientoCabeceraFN->selectByPK( $i_Id );
            
            $IdCompania           = ( int ) myUser::getUser()->getIdBusiness();
            $IdProveedor          = $o_ALM_RequerimientoCabeceraBN->getIdPersona();
            $NombreProveedor      = $o_ALM_RequerimientoCabeceraBN->getProveedorDes();
            $NumeroInterno        = "";
            $IdOrdenClasificacion = "CA00001";
            $IdMoneda             = "LO";
            $Observacion          = $o_ALM_RequerimientoCabeceraBN->getComentario();
            $IdAlmacenEntrega     = GSS_SucursalFN::recuperarIdAlmacen( $o_ALM_RequerimientoCabeceraBN->getIdSucursal() );
            $FechaCreacion        = $o_ALM_RequerimientoCabeceraBN->getFechaRequerida(); //
            $FechaEntrega         = $o_ALM_RequerimientoCabeceraBN->getFechaProgramada(); //
            $f_TipoCambio         = GSS_TipoCambioFN::getStaticTipoCambioCobranza();
            $TipoOrden            = "N";
            $EstadoOC             = $b_TipGenOC ? COM_OrdenCompraCabeceraBN::ORDEN_COMPRA_APROBADO : COM_OrdenCompraCabeceraBN::ORDEN_COMPRA_PREPARACION;
            $ModoIngresoConIGVFlag= $o_ALM_RequerimientoCabeceraBN->getModoIngresoConIGVFlag();
            
            $IdRequerimiento      = ( int ) $o_ALM_RequerimientoCabeceraBN->getIdRequerimiento();
            ////////////////
            
            if( !$f_TipoCambio )
            {
                throw new Exception( "Debe de registrar el Tipo de Cambio de hoy." );
            }
            
            //SE GENERA OC CABECERA:
            $o_COM_OrdenCompraCabeceraDP = new COM_OrdenCompraCabeceraDP();
            $o_COM_OrdenCompraCabeceraDP->setIdProveedor( ( int ) $IdProveedor );
            $o_COM_OrdenCompraCabeceraDP->setIdOrdenClasificacion( $IdOrdenClasificacion );
            $o_COM_OrdenCompraCabeceraDP->setNombreProveedor( $NombreProveedor );
            $o_COM_OrdenCompraCabeceraDP->setNumeroInterno( $NumeroInterno );
            $o_COM_OrdenCompraCabeceraDP->setIdMoneda( $IdMoneda );
            $o_COM_OrdenCompraCabeceraDP->setObservacion( $Observacion );
            $o_COM_OrdenCompraCabeceraDP->setIdAlmacenEntrega( $IdAlmacenEntrega );
            $o_COM_OrdenCompraCabeceraDP->setIdAlmacenIngreso( $IdAlmacenEntrega );
            $o_COM_OrdenCompraCabeceraDP->setFechaEntrega( $FechaEntrega );
            $o_COM_OrdenCompraCabeceraDP->setTipoOrden( $TipoOrden );
            
            $o_COM_OrdenCompraCabeceraDP->setMontoAfecto( 0.00 );
            $o_COM_OrdenCompraCabeceraDP->setMontoNoAfecto( 0.00 );
            $o_COM_OrdenCompraCabeceraDP->setMontoIGV( 0.00 );
            $o_COM_OrdenCompraCabeceraDP->setMontoBruto( 0.00 );
            $o_COM_OrdenCompraCabeceraDP->setTipoCambio( $f_TipoCambio );
            $o_COM_OrdenCompraCabeceraDP->setIdCompania( ( int ) $IdCompania );
            $IdOrdenCompra = COM_OrdenCompraCabeceraFN::recuperarId( $IdCompania );
            $o_COM_OrdenCompraCabeceraDP->setIdOrdenCompra( ( int ) $IdOrdenCompra );
            $o_COM_OrdenCompraCabeceraDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
            $o_COM_OrdenCompraCabeceraDP->setFechaCreacion( $FechaCreacion );
            $o_COM_OrdenCompraCabeceraDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
            $o_COM_OrdenCompraCabeceraDP->setFechaModificacion( $FechaCreacion );
            $o_COM_OrdenCompraCabeceraDP->setEstado( COM_OrdenCompraCabeceraBN::ORDEN_COMPRA_PREPARACION );
            $o_COM_OrdenCompraCabeceraDP->setFechaPreparacion( date( "Y-m-d H:i:s" ) );
            $o_COM_OrdenCompraCabeceraDP->setPreparadoPor( myUser::getUser()->getUserId() );
            $o_COM_OrdenCompraCabeceraDP->setFechaRevision( date( "Y-m-d H:i:s" ) );
            $o_COM_OrdenCompraCabeceraDP->setRevisadoPor( myUser::getUser()->getUserId() );
            $o_COM_OrdenCompraCabeceraDP->setIdRequerimiento( $IdRequerimiento );
            $o_COM_OrdenCompraCabeceraDP->setObservacionRechazo( $ModoIngresoConIGVFlag );
            
            $b_Result = $o_COM_OrdenCompraCabeceraDP->save();
            ////////////////////////
            
            //SE GENERA OC DETALLES:
            foreach ( $a_ALM_RequerimientoDetalle as $i_key => $o_ALM_RequerimientoDetalleBN )
            {
                //SE BUSCA DETALLE LOTE
                $b_ControlDetLote = false;
                $a_ALM_RequerimientoDetalleLote = array();
                if( $o_ALM_RequerimientoDetalleBN->getExisteDetalleLote() )
                {
                    $o_ALM_RequerimientoDetalleLoteFN = new ALM_RequerimientoDetalleLoteFN();
                    $o_ALM_RequerimientoDetalleLoteFN->setIdRequerimientoDetalle( $o_ALM_RequerimientoDetalleBN->getIdRequerimientoDetalle() );
                    $a_ALM_RequerimientoDetalleLote = $o_ALM_RequerimientoDetalleLoteFN->select();
                    $b_ControlDetLote = true;
                }
                //PARAMETROS
                $IdItem         = $o_ALM_RequerimientoDetalleBN->getIdItem();
                
                $o_ALM_ItemMastFN = new ALM_ItemMastFN();
                $o_ALM_ItemMastBN = $o_ALM_ItemMastFN->selectByPK( $IdItem );
                
                $IdUnidad           = "58";
                $CantidadPedida     =  $o_ALM_RequerimientoDetalleBN->getCantidadPedida();
                $PrecioUnitario     = $o_ALM_RequerimientoDetalleBN->getPrecioUnitario();
                $PrecioUnitarioIGV  = $o_ALM_RequerimientoDetalleBN->getPrecioUnitarioIGV();
                $PrecioSubTotal     = $o_ALM_RequerimientoDetalleBN->getPrecioSubTotal();
                $ValorIGV           = $o_ALM_RequerimientoDetalleBN->getValorIGV();
                $PrecioTotalConIGV  = $o_ALM_RequerimientoDetalleBN->getPrecioTotalConIGV();
                
                $NoAfecImpuesto = "N";
                ///////////////////////////////////////////////////
                
                //SE GENERA EL DETALLE O/C
                $o_COM_OrdenCompraDetalleDP = new COM_OrdenCompraDetalleDP();
                $o_COM_OrdenCompraDetalleDP->setIdOrdenCompra( ( int ) $IdOrdenCompra );
                $o_COM_OrdenCompraDetalleDP->setIdCompania( ( int ) $IdCompania );
                
                $o_COM_OrdenCompraDetalleDP->setIdItem( $IdItem );
                $o_COM_OrdenCompraDetalleDP->setDescripcionItem( $o_ALM_ItemMastBN->getDescripcionCompleta() );
                $o_COM_OrdenCompraDetalleDP->setCantidadPedida( ( float ) $CantidadPedida );
                $o_COM_OrdenCompraDetalleDP->setCantidadRecibida( 0 );
                $o_COM_OrdenCompraDetalleDP->setIdUnidad( $IdUnidad );
                $o_COM_OrdenCompraDetalleDP->setIdCondicion( ( int ) ALM_TransaccionDetalleBN::CONDICION_POR_DEFECTO );
                
                $o_COM_OrdenCompraDetalleDP->setPrecioUnitarioInicial( $PrecioUnitarioIGV );
                $o_COM_OrdenCompraDetalleDP->setPrecioUnitarioFinal( $PrecioUnitarioIGV );
                $o_COM_OrdenCompraDetalleDP->setPrecioUnitarioIGV( $PrecioUnitarioIGV );
                $o_COM_OrdenCompraDetalleDP->setPrecioUnitario( $PrecioUnitario );
                $o_COM_OrdenCompraDetalleDP->setSubTotal( $PrecioSubTotal );
                $o_COM_OrdenCompraDetalleDP->setValorIGV( $ValorIGV );
                $o_COM_OrdenCompraDetalleDP->setPrecioTotalConIGV( $PrecioTotalConIGV );
                
                $o_COM_OrdenCompraDetalleDP->setIGVExonerado( $NoAfecImpuesto );
                $o_COM_OrdenCompraDetalleDP->setDescuento( 0.00 );
                
                $i_IdDet = COM_OrdenCompraDetalleFN::recuperarId( $IdCompania, $IdOrdenCompra );
                $o_COM_OrdenCompraDetalleDP->setIdSecuencia( ( int ) $i_IdDet );
                $o_COM_OrdenCompraDetalleDP->setIGVExonerado( $o_ALM_ItemMastBN->getNoAfectoImpuestoVentasFlag() );
                $o_COM_OrdenCompraDetalleDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                $o_COM_OrdenCompraDetalleDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                $o_COM_OrdenCompraDetalleDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $o_COM_OrdenCompraDetalleDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $o_COM_OrdenCompraDetalleDP->setEstado( COM_OrdenCompraCabeceraBN::ORDEN_COMPRA_PREPARACION ); //por defecto
                
                if( $b_ControlDetLote )
                {
                	foreach ( $a_ALM_RequerimientoDetalleLote as $i_Key => $o_ALM_RequerimientoDetalleLoteBN )
                	{
                		$CantidadPedida = floatval( $o_ALM_RequerimientoDetalleLoteBN->getCantidad() );
                		
                		$i_IdDet = COM_OrdenCompraDetalleFN::recuperarId( $IdCompania, $IdOrdenCompra );
                		$o_COM_OrdenCompraDetalleDP->setIdSecuencia( ( int ) $i_IdDet );
                		
                		$o_COM_OrdenCompraDetalleDP->setSubTotal( utilMath::fnround( $CantidadPedida * $PrecioUnitarioIGV, 2 ) );
                		
                		$o_COM_OrdenCompraDetalleDP->setCantidadPedida( $CantidadPedida );
                		$o_COM_OrdenCompraDetalleDP->setIdLote( $o_ALM_RequerimientoDetalleLoteBN->getIdLote() );
                		$o_COM_OrdenCompraDetalleDP->setFechaVencimiento( $o_ALM_RequerimientoDetalleLoteBN->getFechaVencimiento() );
                		
                		if( $b_EsAfectoIGV )
		                {
		                    //SE RECUPERA VALOR DE IGV ACTUAL
		                    $ValorIGV = utilMath::fnround( ( ( $CantidadPedida * $PrecioUnitarioIGV ) * $f_ValorIGV ), 2 );
		                    $o_COM_OrdenCompraDetalleDP->setValorIGV( $ValorIGV );
		                }
                		
                		$b_Result = $o_COM_OrdenCompraDetalleDP->save();
                	}
                }
                else 
                {
                	if( $o_ALM_RequerimientoDetalleBN->getIdLote() )
                	{
                		$o_COM_OrdenCompraDetalleDP->setIdLote( $o_ALM_RequerimientoDetalleBN->getIdLote() );
                		$o_COM_OrdenCompraDetalleDP->setFechaVencimiento( $o_ALM_RequerimientoDetalleBN->getFechaVencimiento() );
                	}
                	
                	$b_Result = $o_COM_OrdenCompraDetalleDP->save();
                }
                ///////////////////////////////////////////////////
            }
            COM_OrdenCompraCabeceraDP::actualizarCabaceraMontos( $IdCompania, $IdOrdenCompra );
            ////////////////////////
            
            //AHORA SI ESTA EL CHECK DE ORDEN DE COMPRA APROBADO:
            $o_COM_OrdenCompraCabeceraBN = new COM_OrdenCompraCabeceraBN();
            $o_COM_OrdenCompraCabeceraBN->setIdCompania( ( int ) $IdCompania );
            $o_COM_OrdenCompraCabeceraBN->setIdOrdenCompra( ( int ) $IdOrdenCompra );
            $o_COM_OrdenCompraCabeceraBN->setTipoRequerimientoLog( ALM_RequerimientoCabeceraBN::TIPO_REQUERIMIENTO_LOG );
            
            $o_OrdenCompraBL = new OrdenCompraBL();
            $b_Result = $o_OrdenCompraBL->aprobarOrdenCompra( $o_COM_OrdenCompraCabeceraBN );
            //////////////////////////////////////////////////////
            
            //AHORA SE ACTUALIZA EL ID DE LA ORDEN DE COMPRA
            $o_DefaultDP = new ALM_RequerimientoCabeceraDP();
            $o_DefaultDP->setIdRequerimiento( $IdRequerimiento );
            $o_DefaultDP->setEstado( ALM_RequerimientoCabeceraBN::REQUERIMIENTO_COMPLETADO );            
            $o_DefaultDP->setNumeroOrden( ( int ) $IdOrdenCompra );
            //$o_DefaultDP->setFechaProgramada( $d_FechaProgramada );
            $o_DefaultDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
            $o_DefaultDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
            $b_Result = $o_DefaultDP->update();
            ////////////////////////////////////////////////
            
            $con->commit();
            
            //$a_Rs['error']   = false;
            //$a_Rs['id']      = $i_Id;
        }
        catch ( Exception $o_Exception )
        {
            $con->rollback();
            //$a_Rs['error']        = true;
            //$a_Rs['mensaje_error'] = $o_Exception->getMessage();
            throw new Exception( $o_Exception->getMessage() );
        }
        //echo json_encode( $a_Rs );
        //return ViewResponse::NONE;
        return true;
    }
    
    public function executePrintReq()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();

        $this->i_Id     = $this->getRequestParameter( 'i_Id' );
        $this->s_TipoProc = $this->getRequestParameter( 'TipoProc' );
        
        $o_DefaultFN = new ALM_RequerimientoCabeceraFN();
        $this->o_DefaultBN = $o_DefaultFN->selectByPK( $this->i_Id );
        
        $o_ALM_RequerimientoDetalleFN = new ALM_RequerimientoDetalleFN();
        $o_ALM_RequerimientoDetalleFN->setIdRequerimiento( $this->i_Id );
        //$o_ALM_RequerimientoDetalleFN->setEstado( ALM_RequerimientoCabeceraBN::REQUERIMIENTO_PREPARACION );
        $this->a_ALM_RequerimientoDetalle = $o_ALM_RequerimientoDetalleFN->select();

        $this->a_TotalesReq = ALM_RequerimientoDetalleFN::selectTotales( $this->i_Id );
    }
}