<?php
class recepcionActions extends wtActions
{
    public function executeRequest()
    {
        $s_block    = $this->getRequestParameter( 'block' );
        $s_TipoProc = $this->getRequestParameter( 'TipoProc' );
        $a_lst      = array( "error" => false );
        try 
        {
            myUser::getUser()->validar_session();
            
            switch ( $s_TipoProc )
            {
                case "getStockxLote":
                    $s_IdLote    = $this->getRequestParameter( 'IdLote' );
                    $s_IdAlmacen = $this->getRequestParameter( 'IdAlmacen' );
                    $s_IdItem    = $this->getRequestParameter( 'IdItem' );
                    
                    $s_IdCondicion = ALM_ItemAlmacenStockBN::CONDICION_POR_DEFECTO;
                    $i_IdCompania  = myUser::getUser()->getIdBusiness();
                    
                    $i_StockActual = 0;
                    
                    //se busca la cantidad
                    $o_ALM_ItemAlmacenStockFN = new ALM_ItemAlmacenStockFN();
                    
                    $o_ALM_ItemAlmacenStockBN = $o_ALM_ItemAlmacenStockFN->selectByPK( $i_IdCompania, $s_IdItem, $s_IdAlmacen, $s_IdCondicion, $s_IdLote );
                    if( $o_ALM_ItemAlmacenStockBN )
                    {
                        $i_StockActual = $o_ALM_ItemAlmacenStockBN->getStockActual();
                    }
                    $a_lst["stockactual"] = $i_StockActual;
                    $a_lst["error"] = false;
                break;
                case "UpdateLinePrecio":
                    $i_IdOrdenCompra = ( int ) $this->getRequestParameter( 'IdOrdenCompra' );
                    $i_IdSecuencia   = ( int ) $this->getRequestParameter( 'IdSecuencia' );
                    $f_PrecioFinal   = floatval( $this->getRequestParameter( 'Precio' ) );
                    try
                    {
                        $o_COM_OrdenCompraDetalleDP = new COM_OrdenCompraDetalleDP();
                        $o_COM_OrdenCompraDetalleDP->setIdOrdenCompra( $i_IdOrdenCompra );
                        $o_COM_OrdenCompraDetalleDP->setIdCompania( ( int ) myUser::getUser()->getIdBusiness() );
                        $o_COM_OrdenCompraDetalleDP->setIdSecuencia( $i_IdSecuencia );
                        $o_COM_OrdenCompraDetalleDP->setPrecioUnitarioFinal( $f_PrecioFinal );
                        $o_COM_OrdenCompraDetalleDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                        $o_COM_OrdenCompraDetalleDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                        $o_COM_OrdenCompraDetalleDP->update();
                        $s_MensajeError = "";
                        $b_Result = false;
                    }
                    catch ( Exception $o_Exception )
                    {
                        $b_Result = true;
                        $s_MensajeError = $o_Exception->getMessage();
                    }
                    
                    $a_lst = array( "error" => $b_Result, "mensaje_error" => $s_MensajeError );
                break;
                case "eliminarFacturaxNroGuia":
                    $s_Id = intval( $this->getRequestParameter( 'id' ) );
                    
                    $o_ALM_OrdenGuiaFacturaDP = new ALM_OrdenGuiaFacturaDP();
                    $o_ALM_OrdenGuiaFacturaDP->setIdOrdenGuia( $s_Id );
                    $o_ALM_OrdenGuiaFacturaDP->delete();
                break;
                case "actualizardetalleserie":
                    $i_IdOrdenCompra = ( int ) $this->getRequestParameter( 'id' );
                    $s_ItemCod       = $this->getRequestParameter( 'item_cod' );
                    $s_Almacen       = $this->getRequestParameter( 'almacen' );
                    $s_Fecha         = $this->getRequestParameter( 'fecha' );
                    $i_CantRef       = $this->getRequestParameter( 'cant_ref' );

                    $IdCompania = myUser::getUser()->getIdBusiness();

                    //$o_COM_OrdenCompraCabeceraFN = new COM_OrdenCompraCabeceraFN();
                    //$o_COM_OrdenCompraCabeceraBN = $o_COM_OrdenCompraCabeceraFN->selectByPK( $IdCompania, $i_IdOrdenCompra );

                    $o_SR_MovimientoFN = new SR_MovimientoFN();
                    $o_SR_MovimientoFN->setTipoMovimiento( "ROC" );
                    $o_SR_MovimientoFN->setOperacion( "I" );
                    $o_SR_MovimientoFN->setAlmacen( $s_Almacen );
                    $o_SR_MovimientoFN->setReferenciaTipo( "OC" );
                    $o_SR_MovimientoFN->setReferenciaNumero( $i_IdOrdenCompra );
                    $o_SR_MovimientoFN->setReferenciaFecha( $s_Fecha );
                    $o_SR_MovimientoFN->setEstado( "P" );
                    $a_SR_Movimiento = $o_SR_MovimientoFN->select();
                    if( $a_SR_Movimiento )
                    {
                        $o_SR_MovimientoBN = $a_SR_Movimiento[0];
                        
                        $s_MovimientoId = $o_SR_MovimientoBN->getMovimientoId();
                        
                        //ahora se actualiza la cantidad de referencia
                        $o_SR_MovimientoDetalleFN = new SR_MovimientoDetalleFN();
                        $o_SR_MovimientoDetalleFN->setMovimientoId( $s_MovimientoId );
                        $o_SR_MovimientoDetalleFN->setProductoId( $s_ItemCod );
                        $a_SR_MovimientoDetalle = $o_SR_MovimientoDetalleFN->select();
                        if( $a_SR_MovimientoDetalle )
                        {
                            $o_SR_MovimientoDetalleBN = $a_SR_MovimientoDetalle[0];
                            $i_MovimientoDetalleId = $o_SR_MovimientoDetalleBN->getMovimientoDetalleId();
                            
                            $o_SR_MovimientoDetalleDP = new SR_MovimientoDetalleDP();
                            $o_SR_MovimientoDetalleDP->setMovimientoId( $s_MovimientoId );
                            $o_SR_MovimientoDetalleDP->setMovimientoDetalleId( $i_MovimientoDetalleId );
                            $o_SR_MovimientoDetalleDP->setCantidad( intval( $i_CantRef ) );
                            $o_SR_MovimientoDetalleDP->setUsuarioActualizacion( myUser::getUser()->getUserId() );
                            $o_SR_MovimientoDetalleDP->setFechaActualizacion( date( "Y-m-d H:i:s" ) );
                            $o_SR_MovimientoDetalleDP->update();
                        }
                    }
                break;
                case "BuscarFacturaxNroGuia":
                    $s_IdDet = $this->getRequestParameter( 'IdDet' );
                    
                    $a_IdConcat = explode( "_", $s_IdDet );
                
                    $IdCompania    = myUser::getUser()->getIdCompania();
                    $IdSucursal    = myUser::getUser()->getIdSucursal();
                    $IdAlmacen     = $a_IdConcat[0];
                    $IdOrdenCompra = ( int ) $a_IdConcat[1];
                    $IdPersona     = ( int ) $a_IdConcat[2];
                    $SerieGuia     = $a_IdConcat[3];
                    $NumeroGuia    = $a_IdConcat[4];
                    
                    $o_ALM_OrdenGuiaFacturaFN = new ALM_OrdenGuiaFacturaFN();
                    $o_ALM_OrdenGuiaFacturaFN->setIdCompania( $IdCompania );
                    $o_ALM_OrdenGuiaFacturaFN->setIdOrdenCompra( $IdOrdenCompra );
                    $o_ALM_OrdenGuiaFacturaFN->setIdPersona( $IdPersona );
                    $o_ALM_OrdenGuiaFacturaFN->setSerieGuia( $SerieGuia );
                    $o_ALM_OrdenGuiaFacturaFN->setNumeroGuia( $NumeroGuia );
                    $o_ALM_OrdenGuiaFacturaFN->setEstado( ALM_OrdenGuiaFacturaBN::ESTADO_POR_INGRESAR );
                    $a_ALM_OrdenGuiaFactura = $o_ALM_OrdenGuiaFacturaFN->select();
                    if( $a_ALM_OrdenGuiaFactura )
                    {
                        $o_COM_OrdenCompraCabeceraFN = new COM_OrdenCompraCabeceraFN();
                        $o_COM_OrdenCompraCabeceraBN = $o_COM_OrdenCompraCabeceraFN->selectByPK( $IdCompania, $IdOrdenCompra );
                        
                        $f_SumaTotal = 0.00;
                        ?>
                        <table border="0" cellpadding="0" cellspacing="0">
                        <?php foreach ( $a_ALM_OrdenGuiaFactura as $i_Key => $o_ALM_OrdenGuiaFacturaBN ){ ?>
                            <?php $f_SumaTotal = $o_ALM_OrdenGuiaFacturaBN->getTotalFactura() + $f_SumaTotal; ?>
                            <tr> 
                                <td> <?=$o_ALM_OrdenGuiaFacturaBN->getObjectTipoDocumento()->getTipoDocumentoCod()?> <?=$o_ALM_OrdenGuiaFacturaBN->getSerieFactura()?>-<?=$o_ALM_OrdenGuiaFacturaBN->getNumeroFactura()?> </td>
                                <td>&nbsp;</td>
                                <td>
                                    <?=GSS_MonedaMastFN::getSiglaxId( $o_COM_OrdenCompraCabeceraBN->getIdMoneda() )?>
                                    <?=number_format( $o_ALM_OrdenGuiaFacturaBN->getTotalFactura(), 2 )?>
                                </td> 
                                <td>
                                    <input type="hidden" id="IdOrdenGuia" name="IdOrdenGuia" value="<?=$o_ALM_OrdenGuiaFacturaBN->getIdOrdenGuia()?>">
                                    <span style="cursor:pointer; margin: 0 auto;" class="ui-icon ui-icon-trash" title="Borrar" onclick="eliminarFacturaProv('<?=$o_ALM_OrdenGuiaFacturaBN->getIdOrdenGuia()?>');"></span>
                                </td>
                            </tr>
                        <?php } ?>
                            <tr>
                                <td>&nbsp;</td>
                                <td>&nbsp;</td>
                                <td style="border-top: solid 1px #000000;">
                                    <b><?=GSS_MonedaMastFN::getSiglaxId( $o_COM_OrdenCompraCabeceraBN->getIdMoneda() )?>&nbsp;<?=number_format( $f_SumaTotal, 2 )?></b>
                                </td>
                                <td>&nbsp;</td>
                            </tr>
                        </table>
                        <?php
                    }
                    exit;
                break;
                case "validar_serie":
                    $IdCompania = myUser::getUser()->getIdBusiness();
                    $IdOrdenCompra = $this->getRequestParameter( 'id' );
                    $Secuencia = $this->getRequestParameter( 'secuencia' );
                    
                    $a_Secuencia = explode( "_", $Secuencia );
                    
                    $o_COM_OrdenCompraCabeceraFN = new COM_OrdenCompraCabeceraFN();
                    $o_COM_OrdenCompraCabeceraBN = $o_COM_OrdenCompraCabeceraFN->selectByPK( $IdCompania, $IdOrdenCompra );
    
                    $o_SR_MovimientoBN = new SR_MovimientoBN();
                    $o_SR_MovimientoBN->setTipoMovimiento( "ROC" ); //referencia tabla ALM_TransaccionMast -> ROC, VTA
                    $o_SR_MovimientoBN->setOperacion( "I" );
                    $o_SR_MovimientoBN->setAlmacen( $o_COM_OrdenCompraCabeceraBN->getIdAlmacenEntrega() );
                    $o_SR_MovimientoBN->setReferenciaTipo( "OC" );
                    $o_SR_MovimientoBN->setReferenciaNumero( $IdOrdenCompra );
                    $o_SR_MovimientoBN->setReferenciaFecha( $o_COM_OrdenCompraCabeceraBN->getFechaCreacion() );
                    $o_SR_MovimientoBN->setEstado( "P" );

                    $b_ControSerie = false;
                    $a_SR_MovimientoDetalle = array();
                    foreach ( $a_Secuencia as $i_IdSecuencia )
                    {
                        $o_COM_OrdenCompraDetalleFN = new COM_OrdenCompraDetalleFN();
                        $o_COM_OrdenCompraDetalleBN = $o_COM_OrdenCompraDetalleFN->selectByPK( $IdOrdenCompra, $IdCompania, $i_IdSecuencia );

                        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                        /// PREGUNTA SI UNO DE LOS PRODUCTOS MANEJA SERIE
                        $o_ALM_ItemMastBN = $o_COM_OrdenCompraDetalleBN->getObjectItem();
                        if( $o_ALM_ItemMastBN->SiManejaSerie() )
                        {
                            $b_ControSerie = true;
                        }
                        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                        
                        $o_SR_MovimientoDetalleBN = new SR_MovimientoDetalleBN();
                        $o_SR_MovimientoDetalleBN->setProductoId( $o_COM_OrdenCompraDetalleBN->getIdItem() );
                        $o_SR_MovimientoDetalleBN->setCantidad( intval( $o_COM_OrdenCompraDetalleBN->getCantidadPedida() ) );
                        
                        $a_SR_MovimientoDetalle[] = $o_SR_MovimientoDetalleBN;
                    }
                    $o_SR_MovimientoBN->setMovimientoDetalleArray( $a_SR_MovimientoDetalle );

                    $o_SR_MovimientoBN->setControlEstadoSerie( SR_MovimientoBN::CTRL_ESTADO_SERIE_NOEXISTE );
                    if( $b_ControSerie )
                    {
                        $o_SR_MovimientoBN->setControlEstadoSerie( SR_MovimientoBN::CTRL_ESTADO_SERIE_PENDIENTE );
                    }
                    
                    $o_SerieBL = new SerieBL();
                    $o_SerieBL->validarMovimientoH( $o_SR_MovimientoBN );
                break;
                case "get_cant_serie":
                    $i_IdOrdenCompra = $this->getRequestParameter( 'id_orden' );
                    $i_IdSecuencia   = $this->getRequestParameter( 'id_orden_det' );
                    $i_IdCompania    = myUser::getUser()->getIdBusiness();
                    
                    $a_lst['cantidad'] = 0;
                    
                    $o_COM_OrdenCompraDetalleFN = new COM_OrdenCompraDetalleFN();
                    $o_COM_OrdenCompraDetalleBN = $o_COM_OrdenCompraDetalleFN->selectByPK( $i_IdOrdenCompra, $i_IdCompania, $i_IdSecuencia );
                    if( $o_COM_OrdenCompraDetalleBN )
                    {
                        $a_lst['cantidad'] = $o_COM_OrdenCompraDetalleBN->getCantidadSerieEscaneado();
                    }
                break;
            }
        }
        catch ( Exception $o_Exception )
        {
            $a_lst['error'] = true;
            $a_lst['mensaje_error'] = $o_Exception->getMessage();
        }
        
        echo json_encode( $a_lst );
        return ViewResponse::NONE;
    }
    
    public function executeList()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        
        $this->block = $this->getRequestParameter( 'block' );
        
        $this->a_EstadosOC = array( COM_OrdenCompraCabeceraBN::ORDEN_COMPRA_APROBADO => "APROBADO" );
        
        //SE RECUPERA LOS PROVEEDORES
        $o_MST_PersonaMastFN = new MST_PersonaMastFN();
        $o_MST_PersonaMastFN->setEsProveedor( 'SI' );
        //$o_MST_PersonaMastFN->setIdCompania( myUser::getUser()->getIdBusiness() );
        $o_MST_PersonaMastFN->setEstado( 'A' );
        $o_MST_PersonaMastFN->addOrderBy( MST_PersonaMastFN::NombreCompleto );
        $this->a_MST_PersonaMast = $o_MST_PersonaMastFN->select();
        
        //ALMACEN
        $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
        $o_ALM_AlmacenMastFN->setIdCompania( myUser::getUser()->getIdBusiness() );
        $o_ALM_AlmacenMastFN->setEstado( "A" );
        $this->a_ALM_AlmacenMast = $o_ALM_AlmacenMastFN->select();
    }
    
    public function executeGrid()
    {
        
        set_header_utf8();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $o_GridAction = new GridAction();
        $o_GridAction->setClassFind( new COM_OrdenCompraCabeceraFN() );
        
        $o_GridAction->addMethodDefault( COM_OrdenCompraCabeceraFN::Estado, COM_OrdenCompraCabeceraBN::ORDEN_COMPRA_APROBADO );
        $o_GridAction->addMethodDefault( "IdCompania", myUser::getUser()->getIdBusiness() );
        
        $o_GridAction->addAssignFilter( "IdCompania" );

        if( !myUser::getUser()->hasGlobalAccess() )
        {
            //$IdAlmacen = GSS_SucursalFN::recuperarIdAlmacen( myUser::getUser()->getIdSucursal() );
            //ParameterWR::getInstance()->setVar( "IdAlmacenEntrega", "1" );
            //$o_GridAction->addConditionFilter( "IdAlmacenEntrega", COM_OrdenCompraCabeceraFN::IdAlmacenEntrega, "IN", "(SELECT IdAlmacen FROM ALM_AlmacenMast WHERE IdSucursal='".myUser::getUser()->getIdSucursal()."')"  );
        }
        $o_GridAction->addAssignFilter( "TipoOrden" );
        $o_GridAction->addAssignFilter( "Estado" );
        
        $o_GridAction->addConditionFilter( "IdOrdenCompra", COM_OrdenCompraCabeceraFN::IdOrdenCompra, "LIKE", "%%s%" );
        $o_GridAction->addConditionFilter( "NombreProveedor", COM_OrdenCompraCabeceraFN::NombreProveedor, "LIKE", "%%s%" );
        $o_GridAction->addConditionFilter( "FechaDocumento1", COM_OrdenCompraCabeceraFN::FechaCreacion,    ">=" );
        $o_GridAction->addConditionFilter( "FechaDocumento2", COM_OrdenCompraCabeceraFN::FechaCreacion,    "<=" );
        
        //$o_GridAction->addOrder( "Codigo",           GSS_CompaniaFN::Codigo );
        //$o_GridAction->addOrder( "DescripcionCorta", GSS_CompaniaFN::DescripcionCorta );
        //$o_GridAction->addOrder( "Ruc",              GSS_CompaniaFN::Ruc );
        
        $o_GridAction->addOrderDefault( COM_OrdenCompraCabeceraFN::IdOrdenCompra, false );
        
        $o_GridAction->addRowsToShow
        (
            "IdOrdenCompraConcat", "IdOrdenCompra", "TipoOrden", "IdOrdenClasificacion", "FechaCreacion", "NumeroInterno", 
            "NombreProveedor", "Estado", "FormatMontoBruto", "FormatMontoDolares", "FechaEntrega", "TipoOCDesc"
        );
        
        //$o_GridAction->addInnerJoin( new COM_OrdenItemClasificacionFN(), "IdOrdenClasificacion", "Descripcion" );
        
        $o_GridAction->setNumberRecordsShow( 15 );
        
        $o_GridAction->initialize();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        
        $a_ResultJson['page']    = $o_GridAction->getPage();
        $a_ResultJson['total']   = $o_GridAction->getTotalPage();
        $a_ResultJson['records'] = $o_GridAction->getTotalRecords();
        $a_ResultJson['rows']    = $o_GridAction->getResultArray();
        
        echo json_encode( $a_ResultJson );

        return ViewResponse::NONE;
    }
    
    public function executeProcess()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        
        $this->block      = $this->getRequestParameter( 'block' );
        $this->i_Id       = $this->getRequestParameter( 'i_Id' );
        $this->s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        $this->IdTrans    = $this->getRequestParameter( 'IdTrans' );
        
        $a_Ids = explode( "_", $this->i_Id );
        $IdCompania    = $a_Ids[0];
        $IdOrdenCompra = $a_Ids[1];
        
        $o_COM_OrdenCompraCabeceraFN = new COM_OrdenCompraCabeceraFN();
        $this->o_COM_OrdenCompraCabeceraBN = $o_COM_OrdenCompraCabeceraFN->selectByPK( $IdCompania, $IdOrdenCompra );
        
        $o_GSS_CompaniaFN = new GSS_CompaniaFN();
        $this->o_GSS_CompaniaBN = $o_GSS_CompaniaFN->selectByPK( $this->o_COM_OrdenCompraCabeceraBN->getIdCompania() );
        
        $o_ALM_ItemTipoFN = new ALM_ItemTipoFN();
        $this->o_ALM_ItemTipoBN = $o_ALM_ItemTipoFN->selectByPK( $this->o_COM_OrdenCompraCabeceraBN->getIdOrdenClasificacion() );
        
        $o_GSS_MonedaMastFN = new GSS_MonedaMastFN();
        $this->o_GSS_MonedaMastBN = $o_GSS_MonedaMastFN->selectByPK( $this->o_COM_OrdenCompraCabeceraBN->getIdMoneda() );
        
        $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
        $this->o_ALM_AlmacenMastBN = $o_ALM_AlmacenMastFN->selectByPK( $this->o_COM_OrdenCompraCabeceraBN->getIdAlmacenEntrega() );
        
        $o_COM_OrdenItemClasificacionFN = new COM_OrdenItemClasificacionFN();
        $this->o_COM_OrdenItemClasificacionBN = $o_COM_OrdenItemClasificacionFN->selectByPK( $this->o_COM_OrdenCompraCabeceraBN->getIdOrdenClasificacion() );
        
        $o_COM_OrdenCompraDetalleFN = new COM_OrdenCompraDetalleFN();
        $o_COM_OrdenCompraDetalleFN->setIdOrdenCompra( $IdOrdenCompra );
        $o_COM_OrdenCompraDetalleFN->setIdCompania( $IdCompania );
        $o_COM_OrdenCompraDetalleFN->addOrderBy( COM_OrdenCompraDetalleFN::IdItem );
        $a_Result = $o_COM_OrdenCompraDetalleFN->select();
        $this->a_COM_OrdenCompraDetalle = array();
        if( $a_Result )
        {
            $this->a_COM_OrdenCompraDetalle = $a_Result;
        }
    }
    
    public function executeUpdateStatusOS()
    {
        $i_Id = $this->getRequestParameter( 'i_Id' );
        $a_Rs = array( "error" => false );
        try
        {
            $a_Ids = explode( "_", $i_Id );
            $IdCompania    = $a_Ids[0];
            $IdOrdenCompra = $a_Ids[1];
            
            ob_start();
            $this->executeUpdateStatus();
            ob_end_clean();
        
            //se agrega el procedimiento de actualizar los comprobantes asociados - 2020-01-04
            $o_ALM_OrdenGuiaFacturaFN = new ALM_OrdenGuiaFacturaFN();
            $o_ALM_OrdenGuiaFacturaFN->setIdOrdenCompra( $IdOrdenCompra );
            $o_ALM_OrdenGuiaFacturaFN->setEstado( ALM_OrdenGuiaFacturaBN::ESTADO_POR_INGRESAR );
            $a_ALM_OrdenGuiaFactura = $o_ALM_OrdenGuiaFacturaFN->select();
            foreach ( $a_ALM_OrdenGuiaFactura as $o_ALM_OrdenGuiaFacturaBN )
            {
                $o_ALM_OrdenGuiaFacturaDP = new ALM_OrdenGuiaFacturaDP();
                $o_ALM_OrdenGuiaFacturaDP->setIdOrdenGuia( $o_ALM_OrdenGuiaFacturaBN->getIdOrdenGuia() );
                $o_ALM_OrdenGuiaFacturaDP->setEstado( ALM_OrdenGuiaFacturaBN::ESTADO_ASOCIADO );
                $o_ALM_OrdenGuiaFacturaDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $o_ALM_OrdenGuiaFacturaDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $o_ALM_OrdenGuiaFacturaDP->update();
            }
        }
        catch ( Exception $o_Exception )
        {
            $a_Rs['error']   = true;
            $a_Rs['mensaje_error_ex'] = $o_Exception->getMessage();
            $a_Rs['mensaje_error'] = "No se pudo eliminar el registro.";
        }
        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }
    
    public function executeUpdateStatus()
    {
        $block      = $this->getRequestParameter( 'block' );
        $i_Id       = $this->getRequestParameter( 'i_Id' );
        $s_status   = $this->getRequestParameter( 'status' );
        try 
        {
            $a_Ids = explode( "_", $i_Id );
            $IdCompania    = $a_Ids[0];
            $IdOrdenCompra = $a_Ids[1];
                
            $o_COM_OrdenCompraCabeceraDP = new COM_OrdenCompraCabeceraDP();
            $o_COM_OrdenCompraCabeceraDP->setIdCompania( ( int ) $IdCompania );
            $o_COM_OrdenCompraCabeceraDP->setIdOrdenCompra( ( int ) $IdOrdenCompra );
            $o_COM_OrdenCompraCabeceraDP->setEstado( $s_status );
            $o_COM_OrdenCompraCabeceraDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
            $o_COM_OrdenCompraCabeceraDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
            $o_COM_OrdenCompraCabeceraDP->update();

            $a_Rs['error']   = false;
            $a_Rs['id']      = $i_Id;
        }
        catch ( Exception $o_Exception )
        {
            $a_Rs['error']   = true;
            $a_Rs['mensaje_error_ex'] = $o_Exception->getMessage();
            $a_Rs['mensaje_error'] = "No se pudo eliminar el registro.";
        }
        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }
    
    public function executeReceipt()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        $this->block      = $this->getRequestParameter( 'block' );
        $this->i_Id       = $this->getRequestParameter( 'i_Id' );
        $this->secuencia  = $this->getRequestParameter( 'secuencia' );
        $this->s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        
        $this->ControlSubmit = false;
        $this->error_sistema = false;
        $this->mensaje_error = "";
        if( $this->getRequestParameter( "ControlSubmit" ) )
        {
            $this->ControlSubmit = true;
            $this->executeSaveReceipt();
        }
        
        $this->b_AccesoVista = true;
        
        $a_Ids = explode( "_", $this->i_Id );
        $IdCompania    = $a_Ids[0];
        $IdOrdenCompra = $a_Ids[1];
        
        $this->IdOrdenCompra = $IdOrdenCompra;
        
        $o_COM_OrdenCompraCabeceraFN = new COM_OrdenCompraCabeceraFN();
        $this->o_COM_OrdenCompraCabeceraBN = $o_COM_OrdenCompraCabeceraFN->selectByPK( $IdCompania, $IdOrdenCompra );
        
        $IdAlmacenEntrega = $this->o_COM_OrdenCompraCabeceraBN->getIdAlmacenEntrega();
        $i_IdSucursal     = ALM_AlmacenMastFN::recuperarIdSucursal( $IdAlmacenEntrega );
        $i_IdProveedor    = $this->o_COM_OrdenCompraCabeceraBN->getIdProveedor();
        
        $a_Secuencia = explode( "_", $this->secuencia );
        
        $o_COM_OrdenCompraDetalleFN = new COM_OrdenCompraDetalleFN();
        $o_COM_OrdenCompraDetalleFN->setIdCompania( ( int ) $IdCompania );
        $o_COM_OrdenCompraDetalleFN->setIdOrdenCompra( ( int ) $IdOrdenCompra );
        $o_COM_OrdenCompraDetalleFN->addCondition( COM_OrdenCompraDetalleFN::IdSecuencia, "IN", "( '".implode( "','", $a_Secuencia )."' ) ", false );
        $this->a_COM_OrdenCompraDetalle = $o_COM_OrdenCompraDetalleFN->select();
        
        //AHORA VALIDAMOS SI MOSTRAMOS EL CAMPO SERIE
        $this->b_MostrarColumnLote  = false;
        $this->b_MostrarSerie = false;
        foreach ( $this->a_COM_OrdenCompraDetalle as $o_COM_OrdenCompraDetalleBN )
        {
            if( $o_COM_OrdenCompraDetalleBN->getObjectItem()->SiManejaLote() )
            {
                $this->b_MostrarColumnLote  = true;
            }
            if( $o_COM_OrdenCompraDetalleBN->getObjectItem()->SiManejaSerie() )
            {
                $this->b_MostrarSerie = true;
            }
        }
        //////////////////////////////////////////////////////////////////////////////////
        
        $o_ALM_TransaccionMastFN = new ALM_TransaccionMastFN();
        $o_ALM_TransaccionMastFN->setIngresoEgresoFlag( COM_OrdenCompraCabeceraBN::TIPO_TRANSACCION_X_DEFECTO );
        $this->a_ALM_TransaccionMast = $o_ALM_TransaccionMastFN->select();
        
        /*$IdOrdenClasificacion = $this->o_COM_OrdenCompraCabeceraBN->getIdOrdenClasificacion();
        $o_COM_OrdenItemClasificacionFN = new COM_OrdenItemClasificacionFN();
        $o_COM_OrdenItemClasificacionBN = $o_COM_OrdenItemClasificacionFN->selectByPK( $IdOrdenClasificacion );
        
        $this->o_COM_OrdenItemClasificacionBN = $o_COM_OrdenItemClasificacionBN;*/
        
        $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
        $o_ALM_AlmacenMastFN->setIdCompania( myUser::getUser()->getIdBusiness() );
		$o_ALM_AlmacenMastFN->addCondition( ALM_AlmacenMastFN::Estado ,"<>", "I" );
		$o_ALM_AlmacenMastFN->addOrderBy( ALM_AlmacenMastFN::DescripcionLocal );
        $this->a_ALM_AlmacenMast = $o_ALM_AlmacenMastFN->select();
        
        $o_ALM_TipoDocumentoFN = new ALM_TipoDocumentoFN(); //PARA DOCUMENTO DE REFENCIA
        $o_ALM_TipoDocumentoFN->setEstado( "A" );
        $o_ALM_TipoDocumentoFN->setTransaccionSistemaFlag( "S" );
        $this->a_ALM_TipoDocumento = $o_ALM_TipoDocumentoFN->select();
        
        $this->s_IdConcat = $IdAlmacenEntrega."_".$IdOrdenCompra."_".$i_IdProveedor;
    }
    
    public function executeReceiptDet()
    {
        $this->i_Concat  = $this->getRequestParameter( 'id_concat' );
        $this->secuencia = $this->getRequestParameter( 'secuencia' );
        
        $a_Ids = explode( "_", $this->i_Concat );
        $IdCompania    = $a_Ids[0];
        $IdOrdenCompra = $a_Ids[1];
        
        $o_COM_OrdenCompraCabeceraFN = new COM_OrdenCompraCabeceraFN();
        $this->o_COM_OrdenCompraCabeceraBN = $o_COM_OrdenCompraCabeceraFN->selectByPK( $IdCompania, $IdOrdenCompra );
        
        $a_Secuencia = explode( "_", $this->secuencia );
        
        $o_COM_OrdenCompraDetalleFN = new COM_OrdenCompraDetalleFN();
        $o_COM_OrdenCompraDetalleFN->setIdCompania( ( int ) $IdCompania );
        $o_COM_OrdenCompraDetalleFN->setIdOrdenCompra( ( int ) $IdOrdenCompra );
        $o_COM_OrdenCompraDetalleFN->addCondition( COM_OrdenCompraDetalleFN::IdSecuencia, "IN", "( '".implode( "','", $a_Secuencia )."' ) ", false );
        $this->a_COM_OrdenCompraDetalle = $o_COM_OrdenCompraDetalleFN->select();
        
        //AHORA VALIDAMOS SI MOSTRAMOS EL CAMPO SERIE
        $this->b_MostrarColumnLote  = false;
        $this->b_MostrarSerie = false;
        foreach ( $this->a_COM_OrdenCompraDetalle as $o_COM_OrdenCompraDetalleBN )
        {
            if( $o_COM_OrdenCompraDetalleBN->getObjectItem()->SiManejaLote() )
            {
                $this->b_MostrarColumnLote  = true;
            }
            if( $o_COM_OrdenCompraDetalleBN->getObjectItem()->SiManejaSerie() )
            {
                $this->b_MostrarSerie = true;
            }
        }
        //////////////////////////////////////////////////////////////////////////////////
        
        ViewResponse::getInstance()->setMethodAjax();
    }
    
    public function executeSaveReceipt()
    {
        set_memory_max_time();
        
        $block      = $this->getRequestParameter( 'block' );
        $i_Id       = $this->getRequestParameter( 'i_Id' );
        $s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        $TypeSub    = $this->getRequestParameter( 'TypeSub' );
        
        $a_Ids = explode( "_", $i_Id );
        $IdCompania    = $a_Ids[0];
        $IdOrdenCompra = $a_Ids[1];
        
        $o_COM_OrdenCompraCabeceraFN     = new COM_OrdenCompraCabeceraFN();
        $o_TMP_COM_OrdenCompraCabeceraBN = $o_COM_OrdenCompraCabeceraFN->selectByPK( $IdCompania, $IdOrdenCompra );
        //$IdOrdenClasificacion            = $o_TMP_COM_OrdenCompraCabeceraBN->getIdOrdenClasificacion();
        
        //CABECERA
        //$IdCompania                 = $this->getRequestParameter( 'IdCompania' );
        $FechaDocumento             = $this->getRequestParameter( 'FechaDocumento' );
        $IdTransaccionOperacion     = COM_OrdenCompraCabeceraBN::TIPO_TRANSACCION_X_DEFECTO;
        $IdAlmacen                  = $this->getRequestParameter( 'IdAlmacen' ); //ALMACEN ORIGEN
        $IdTransaccion              = $this->getRequestParameter( 'IdTransaccion' ); //
        $AlmacenTraslado            = ""; //ALMACEN DE DESTINO
        $IdTipoDocumento            = COM_OrdenCompraCabeceraBN::TIPO_DOCUMENTO;
        $ReferenciaTipoDocumento    = $this->getRequestParameter( 'ReferenciaTipoDocumento' );
        $ReferenciaNumeroDocumento  = $this->getRequestParameter( 'ReferenciaNumeroDocumento' ); //
        //$GuiaProveedor              = $this->getRequestParameter( 'GuiaProveedor' ); //
        $GuiaProveedor              = str_pad( $this->getRequestParameter( 'SerieDocumentoFiscal' ), 4, "0", STR_PAD_LEFT )."-".str_pad( $this->getRequestParameter( 'NumeroDocumentoFiscal' ), 10, "0", STR_PAD_LEFT ); //
        $Comentario                 = $this->getRequestParameter( 'Comentario' ); //

        $TipodeCambio               = $o_TMP_COM_OrdenCompraCabeceraBN->getTipoCambio();
        if( !$o_TMP_COM_OrdenCompraCabeceraBN->getTipoCambio() )
        {
            $TipodeCambio = GSS_TipoCambioFN::getStaticTipoCambioCobranza();
            //$TipodeCambio = GSS_TipoCambioFN::getStaticTipoCambioVenta();
        }
        $MonedaCod                  = $o_TMP_COM_OrdenCompraCabeceraBN->getIdMoneda();
        
        //PARAMETROS PARA LA GUIA DE REMISION - en este caso solo se permite una guia por proveedor
        $TipoDocumentoFiscal    = $this->getRequestParameter( 'TipoDocumentoFiscal' ); //
        $SerieDocumentoFiscal   = str_pad( $this->getRequestParameter( 'SerieDocumentoFiscal' ), 4, "0", STR_PAD_LEFT ); //
        $NumeroDocumentoFiscal  = str_pad( $this->getRequestParameter( 'NumeroDocumentoFiscal' ), 10, "0", STR_PAD_LEFT ); //
        $CodigoProveedor        = $this->getRequestParameter( 'CodigoProveedor' ); //
        $IdOrdenGuia            = $this->getRequestParameter( 'IdOrdenGuia' ); //
        
        //DETALLES
        //$a_CantidadPedida           = $this->getRequestParameter( 'CantidadPedida' ); //
        //$a_CantidadRecibida         = $this->getRequestParameter( 'CantidadRecibida' ); //
        $a_Cantidad                 = $this->getRequestParameter( 'Cantidad' ); //
        $a_IdItem                   = $this->getRequestParameter( 'IdItem' ); //
        $a_IdUnidad                 = $this->getRequestParameter( 'IdUnidad' ); //
        
        $a_Secuencia                = $this->getRequestParameter( 'Secuencia' ); //
        $a_PrecioUnitarioFinal      = $this->getRequestParameter( 'PrecioUnitarioFinal' ); //

        //POR LO DE LOTE
        $a_NumeroLote               = $this->getRequestParameter( 'NumeroLote' ); //
        $a_FecVenciLote             = $this->getRequestParameter( 'FechaVencimiento' ); //
        
        //PARAMETROS PARA LA FACTURA
        $SecuenciaSerieNum          = $this->getRequestParameter( 'SecuenciaSerieNum' ); //
        $SerieNumeroFactura         = null;
        if( $this->getRequestParameter( 'SerieFacturaRef' ) )
        {
            $SerieFacturaRef            = $this->getRequestParameter( 'SerieFacturaRef' ); //
            $NumeroFacturaRef           = $this->getRequestParameter( 'NumeroFacturaRef' ); //
            $SerieNumeroFactura         = "Factura Proveedor: FP ".str_pad( $this->getRequestParameter( 'SerieFacturaRef' ), 4, "0", STR_PAD_LEFT )."-".str_pad( $this->getRequestParameter( 'NumeroFacturaRef' ), 10, "0", STR_PAD_LEFT );
        }
        
        try 
        {
            //se agrega un procedimiento para recuperar 
            if( $IdOrdenGuia )
            {
                $o_ALM_OrdenGuiaFacturaFN = new ALM_OrdenGuiaFacturaFN();
                $o_ALM_OrdenGuiaFacturaBN = $o_ALM_OrdenGuiaFacturaFN->selectByPK( $IdOrdenGuia );
                if( $o_ALM_OrdenGuiaFacturaBN )
                {
                    $TipoDocumentoFiscal    = $o_ALM_OrdenGuiaFacturaBN->getTipoDoc();
                    $SerieDocumentoFiscal   = $o_ALM_OrdenGuiaFacturaBN->getSerieFactura();
                    $NumeroDocumentoFiscal  = $o_ALM_OrdenGuiaFacturaBN->getNumeroFactura();
                }
            }   
            
            $o_ALM_TransaccionCabeceraBN = new ALM_TransaccionCabeceraBN();
            $o_ALM_TransaccionCabeceraBN->setIdTransaccion( $IdTransaccion );
            $o_ALM_TransaccionCabeceraBN->setAlmacenTraslado( $AlmacenTraslado );
            $o_ALM_TransaccionCabeceraBN->setIdAlmacen( $IdAlmacen );
            $o_ALM_TransaccionCabeceraBN->setIdTransaccionOperacion( $IdTransaccionOperacion );
            $o_ALM_TransaccionCabeceraBN->setFechaDocumento( utilTimestamp::getTimestamp( substr( $FechaDocumento, 0, 10 )." ".date( "H:i:s" ), "Y-m-d H:i:s" ) );
            $o_ALM_TransaccionCabeceraBN->setMonedaCod( $MonedaCod );
            $o_ALM_TransaccionCabeceraBN->setTipodeCambio( floatval( $TipodeCambio ) );
            $o_ALM_TransaccionCabeceraBN->setReferenciaTipoDocumento( $ReferenciaTipoDocumento );
            $o_ALM_TransaccionCabeceraBN->setReferenciaNumeroDocumento( $ReferenciaNumeroDocumento );
            $o_ALM_TransaccionCabeceraBN->setGuiaProveedor( $GuiaProveedor );
            $o_ALM_TransaccionCabeceraBN->setReferenciaNumeroInterno( $IdOrdenGuia ); //se implementa para asociar el documento fiscal 2021-01-04
            $o_ALM_TransaccionCabeceraBN->setIdCompania( ( int ) $IdCompania );
            $o_ALM_TransaccionCabeceraBN->setIdTipoDocumento( $IdTipoDocumento );
            $o_ALM_TransaccionCabeceraBN->setComentario( $Comentario );
            
            $o_ALM_TransaccionCabeceraBN->setTipoDocumentoFiscal( $TipoDocumentoFiscal );
            $o_ALM_TransaccionCabeceraBN->setSerieDocumentoFiscal( $SerieDocumentoFiscal );
            $o_ALM_TransaccionCabeceraBN->setNumeroDocumentoFiscal( $NumeroDocumentoFiscal );
            $o_ALM_TransaccionCabeceraBN->setCodigoProveedor( $CodigoProveedor );
            
            $a_MovientoDetalle = array();
            $a_ArrayOrdenCompraDetalle = array();
            foreach ( $a_IdItem as $i_Key => $s_Value )
            {
                //$o_COM_OrdenCompraDetalleFN = new COM_OrdenCompraDetalleFN();
                //$o_COM_OrdenCompraDetalleBN = $o_COM_OrdenCompraDetalleFN->selectByPK( $IdCompania, $IdOrdenCompra, $a_Secuencia[$i_Key] );
                
                $o_ALM_TransaccionDetalleBN = new ALM_TransaccionDetalleBN();
                $o_ALM_TransaccionDetalleBN->setIdItem( $s_Value );
                
                //SI MANEJA LOTE:
                $b_ManejaLote = ALM_ItemMastFN::SiManejaLoteFlag( $s_Value );
                if( $b_ManejaLote )
                {
                    //VALIDAR FECHA DE VENCIMIENTO:
                    $b_Control = UtilDate::validar_fecha( $a_FecVenciLote[$i_Key] );
                    if( !$b_Control )
                    {
                        throw new Exception( "La Fecha Ingresada asociado al Item( $s_Value ) no tiene el formato correcto;" );
                    }
                    $o_ALM_TransaccionDetalleBN->setLote( trim( $a_NumeroLote[$i_Key] ) );
                    $o_ALM_TransaccionDetalleBN->setFechaVencimientoLote( trim( $a_FecVenciLote[$i_Key] ) );
                    $o_ALM_TransaccionDetalleBN->setFechaVencimiento( trim( $a_FecVenciLote[$i_Key] ) );
                }
                
                //$KilogramoCalculado = floatval( $a_CantidadKgr[$i_Key] );
                $f_CantidadIng    = floatval( $a_Cantidad[$i_Key] );
                $f_PrecioFinal    = floatval( $a_PrecioUnitarioFinal[$i_Key] ); //ya esta incluido IGV
                $f_PreFinalSinIgv = round( ( $f_PrecioFinal / 1.18 ), 2 ); //se quita el IGV

                $o_ALM_TransaccionDetalleBN->setUnidadCodigo( $a_IdUnidad[$i_Key] ); //UNIDAD DE MEDIDA
                $o_ALM_TransaccionDetalleBN->setReferenciaSecuencia( ( int ) $a_Secuencia[$i_Key] );
                $o_ALM_TransaccionDetalleBN->setReferenciaTipoDocumento( COM_OrdenCompraCabeceraBN::REF_TIPO_DOCUMENTO_DEFECTO );
                $o_ALM_TransaccionDetalleBN->setReferenciaNumeroDocumento( $IdOrdenCompra );
                
                $o_ALM_TransaccionDetalleBN->setCantidad( $f_CantidadIng );
                //$o_ALM_TransaccionDetalleBN->setCantidadDoble( $KilogramoCalculado );
                
                if( $MonedaCod == "EX" )
                {
                    $o_ALM_TransaccionDetalleBN->setPrecioUnitario( round( $f_PreFinalSinIgv * $TipodeCambio, 2 ) );
                    $o_ALM_TransaccionDetalleBN->setPrecioUnitarioDolares( $f_PreFinalSinIgv );
                    
                    $o_ALM_TransaccionDetalleBN->setMontoTotal( round( $f_PrecioFinal * $TipodeCambio, 2 ) );
                    $o_ALM_TransaccionDetalleBN->setMontoTotalDolares( $f_PrecioFinal );
                }
                if( $MonedaCod == "LO" )
                {
                    $o_ALM_TransaccionDetalleBN->setPrecioUnitario( $f_PreFinalSinIgv );
                    $o_ALM_TransaccionDetalleBN->setPrecioUnitarioDolares( round( $f_PreFinalSinIgv / $TipodeCambio, 2 ) );
                    
                    $o_ALM_TransaccionDetalleBN->setMontoTotal( $f_PrecioFinal );
                    $o_ALM_TransaccionDetalleBN->setMontoTotalDolares( round( $f_PrecioFinal / $TipodeCambio, 2 ) );
                }
                
                $a_MovientoDetalle[] = $o_ALM_TransaccionDetalleBN;
                
                $o_COM_OrdenCompraDetalleBN = new COM_OrdenCompraDetalleBN();
                $o_COM_OrdenCompraDetalleBN->setIdOrdenCompra( ( int ) $IdOrdenCompra );
                $o_COM_OrdenCompraDetalleBN->setIdCompania( ( int ) $IdCompania );
                $o_COM_OrdenCompraDetalleBN->setIdSecuencia( ( int ) $a_Secuencia[$i_Key] );
                $o_COM_OrdenCompraDetalleBN->setIdUnidad( $a_IdUnidad[$i_Key] );
                $o_COM_OrdenCompraDetalleBN->setPrecioUnitarioFinal( $f_PrecioFinal );
                
                $o_COM_OrdenCompraDetalleBN->setCantidadRecibida( $f_CantidadIng );
                ///////////////////////////////////////////////////////
                $o_COM_OrdenCompraDetalleBN->setComentario( "Almacen a Recepcionar: ".$IdAlmacen." - Unidades: ".$a_Cantidad[$i_Key] );
                $a_ArrayOrdenCompraDetalle[] = $o_COM_OrdenCompraDetalleBN;
            }
            $o_ALM_TransaccionCabeceraBN->setArrayMovientoDetalle( $a_MovientoDetalle );
            
            //OBJETO ORDEN DE COMPRA
            $o_COM_OrdenCompraCabeceraBN = new COM_OrdenCompraCabeceraBN();
            $o_COM_OrdenCompraCabeceraBN->setIdCompania( myUser::getUser()->getIdCompania() );
            $o_COM_OrdenCompraCabeceraBN->setIdSucursal( myUser::getUser()->getIdSucursal() );
            $o_COM_OrdenCompraCabeceraBN->setIdProveedor( ( int ) $CodigoProveedor );
            $o_COM_OrdenCompraCabeceraBN->setIdOrdenCompra( ( int ) $IdOrdenCompra );
            $o_COM_OrdenCompraCabeceraBN->setObjectTransaccion( $o_ALM_TransaccionCabeceraBN );
            $o_COM_OrdenCompraCabeceraBN->setArrayOrdenCompraDetalle( $a_ArrayOrdenCompraDetalle );
            $o_COM_OrdenCompraCabeceraBN->setIdAlmacenEntrega( $IdAlmacen );
            $o_COM_OrdenCompraCabeceraBN->setObservacion( $Comentario );
            $o_COM_OrdenCompraCabeceraBN->setObservacionEntrega( $SerieNumeroFactura );
            
            $o_COM_OrdenCompraCabeceraBN->setSecuenciaSerieNumero( ( int ) $SecuenciaSerieNum );
            $o_COM_OrdenCompraCabeceraBN->setSerieDocumentoFiscal( $SerieDocumentoFiscal );
            $o_COM_OrdenCompraCabeceraBN->setNumeroDocumentoFiscal( $NumeroDocumentoFiscal );
            
            $o_OrdenCompraBL = new OrdenCompraBL();
            $o_OrdenCompraBL->realizarProcesoRecepcionOrdenCompra( $o_COM_OrdenCompraCabeceraBN );
            
            $i_Id = $o_ALM_TransaccionCabeceraBN->getIdTransaccionCabeceraConcat();
            
            $this->id_trans = $i_Id;
            $this->error_sistema = false;
            $this->mensaje_error = "";
        }
        catch ( Exception $o_Exception )
        {
            $this->error_sistema = true;
            $this->mensaje_error = $o_Exception->getMessage();
        }
        //echo json_encode( $a_Rs );
        //return ViewResponse::NONE;
    }
}