<?php
class ocActions extends wtActions
{
    public function executeList()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        
        $this->block = $this->getRequestParameter( 'block' );
        
        $this->a_EstadosOC = COM_OrdenCompraCabeceraBN::getArrayOrdenEstados();
        //pr( $this->a_EstadosOC );
        
        $o_COM_OrdenItemClasificacionFN = new COM_OrdenItemClasificacionFN();
        //$o_COM_OrdenItemClasificacionFN->setIdCompania( myUser::getUser()->getIdBusiness() );
        $this->a_COM_OrdenItemClasificacion = $o_COM_OrdenItemClasificacionFN->select();
        
        //SE RECUPERA LOS PROVEEDORES
        $o_MST_PersonaMastFN = new MST_PersonaMastFN();
        $o_MST_PersonaMastFN->setEsProveedor( 'SI' );
        //$o_MST_PersonaMastFN->setIdCompania( myUser::getUser()->getIdBusiness() );
        $o_MST_PersonaMastFN->setEstado( 'A' );
        $o_MST_PersonaMastFN->addOrderBy( MST_PersonaMastFN::NombreCompleto );
        $this->a_MST_PersonaMast = $o_MST_PersonaMastFN->select();
        //pr( $this->a_MST_PersonaMast );
        
        //ALMACEN
        $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
        $o_ALM_AlmacenMastFN->setIdCompania( myUser::getUser()->getIdBusiness() );
        $o_ALM_AlmacenMastFN->setEstado( "A" );
        $o_ALM_AlmacenMastFN->addOrderBy( ALM_AlmacenMastFN::DescripcionLocal );
        $this->a_ALM_AlmacenMast = $o_ALM_AlmacenMastFN->select();
    }
    
    public function executeGrid()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        
        set_header_utf8();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $o_GridAction = new GridAction();
        $o_GridAction->setClassFind( new COM_OrdenCompraCabeceraFN() );
        
        $o_GridAction->addMethodDefault( "IdCompania", myUser::getUser()->getIdBusiness() );
        //$o_GridAction->addMethodDefault( COM_OrdenCompraCabeceraFN::IdOrdenClasificacion, "CA00001" );
        
        $o_GridAction->addAssignFilter( "IdCompania" );
        //$o_GridAction->addAssignFilter( "IdAlmacenEntrega" );
        $o_GridAction->addAssignFilter( "TipoOrden" );
        $o_GridAction->addAssignFilter( "Estado" );
        $o_GridAction->addAssignFilter( "IdOrdenClasificacion" );
        //$o_GridAction->addAssignFilter( "IdProveedor" );
        
        $o_GridAction->addConditionFilter( "NombreProveedor", COM_OrdenCompraCabeceraFN::NombreProveedor, "LIKE", "%%s%" );
        $o_GridAction->addConditionFilter( "IdOrdenCompra", COM_OrdenCompraCabeceraFN::IdOrdenCompra, "LIKE", "%%s%" );
        //$o_GridAction->addConditionFilter( "NombreProveedor", COM_OrdenCompraCabeceraFN::NombreProveedor, "LIKE", "%%s%" );
        $o_GridAction->addConditionFilter( "FechaDocumento1", "LEFT(".COM_OrdenCompraCabeceraFN::FechaCreacion.",10)", ">=" );
        $o_GridAction->addConditionFilter( "FechaDocumento2", "LEFT(".COM_OrdenCompraCabeceraFN::FechaCreacion.",10)", "<=" );

        if( $this->getRequestParameter( 'receipt' ) )
        {
            //$o_GridAction->addMethodDefault( COM_OrdenCompraCabeceraFN::TipoOrden, array( 'Condition'=>'=', 'Value' => COM_OrdenCompraCabeceraBN::TIPO_OC_LOCAL ) );
            //$o_GridAction->addMethodDefault( COM_OrdenCompraCabeceraFN::TipoOrden, COM_OrdenCompraCabeceraBN::TIPO_OC_LOCAL );
        }
        
        $o_GridAction->addOrderDefault( COM_OrdenCompraCabeceraFN::IdOrdenCompra, false );
        
        $o_GridAction->addRowsToShow
        ( 
            "IdOrdenCompraConcat", "IdOrdenCompra", "TipoOrden", "IdOrdenClasificacion", "FechaCreacion", "NumeroInterno", "MonedaDesc", "OrdenClasificacionDesc",
            "NombreProveedor", "Estado", "FormatMontoBruto", "FormatMontoDolares", "FechaEntrega", "AlmacenDesc", "EstadoDesc", "TipoOCDesc", "Descripcion"
        );
        
        $o_GridAction->setNumberRecordsShow( 100 );
        
        $o_GridAction->initialize();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        
        $a_ResultJson['page']    = $o_GridAction->getPage();
        $a_ResultJson['total']   = $o_GridAction->getTotalPage();
        $a_ResultJson['records'] = $o_GridAction->getTotalRecords();
        $a_ResultJson['rows']    = $o_GridAction->getResultArray();
        
        echo json_encode( $a_ResultJson );

        return ViewResponse::NONE;
    }
    
    public function executeAddedit()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        
        $this->block      = $this->getRequestParameter( 'block' );
        $this->i_Id       = $this->getRequestParameter( 'i_Id' );
        $this->s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        /*
        $o_GSS_CompaniaFN = new GSS_CompaniaFN();
		$o_GSS_CompaniaFN->addCondition(GSS_CompaniaFN::Estado ,"<>","I");
        $o_GSS_CompaniaFN->addOrderBy( GSS_CompaniaFN::DescripcionCorta );
        $this->a_GSS_Compania = $o_GSS_CompaniaFN->select();
        */
        $o_COM_OrdenItemClasificacionFN = new COM_OrdenItemClasificacionFN();
        $o_COM_OrdenItemClasificacionFN->setEstado( "A" );
        $o_COM_OrdenItemClasificacionFN->setIdCompania( myUser::getUser()->getIdBusiness() );
        $o_COM_OrdenItemClasificacionFN->addCondition( COM_OrdenItemClasificacionFN::IdItemTipo, "IN", "('01')", false );
        $this->a_COM_OrdenItemClasificacion = $o_COM_OrdenItemClasificacionFN->select();
        
        $this->o_ALM_AlmacenMastBN = null;
        
        $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
        $o_ALM_AlmacenMastFN->addCondition( ALM_AlmacenMastFN::Estado ,"<>", "I" );
        //$o_ALM_AlmacenMastFN->addCondition( ALM_AlmacenMastFN::IdAlmacen , "IN", "( SELECT IdAlmacen FROM ALM_ItemAlmacenStock S LEFT JOIN ALM_ItemMast I ON I.IdItem=S.IdItem WHERE I.IdItemTipo=\"02\" AND S.StockActual>0 )", false );
        $o_ALM_AlmacenMastFN->addOrderBy( ALM_AlmacenMastFN::IdCompania );
        $o_ALM_AlmacenMastFN->setIdCompania( myUser::getUser()->getIdBusiness() );
        $this->a_ALM_AlmacenMast = $o_ALM_AlmacenMastFN->select();
        
        $o_GSS_MonedaMastFN = new GSS_MonedaMastFN();
        $o_GSS_MonedaMastFN->setEstado( "A" );
        $this->a_GSS_MonedaMast = $o_GSS_MonedaMastFN->select();
        //pr( $this->a_GSS_MonedaMast );
        $this->s_Titulo = "Nuevo O/C";
        $this->noedit = "";
        $this->o_COM_OrdenCompraCabeceraBN = new COM_OrdenCompraCabeceraBN();
        $this->o_COM_OrdenCompraCabeceraBN->setFechaEntrega( date( "Y-m-d" ) );
        //$this->o_COM_OrdenCompraCabeceraBN->setIdOrdenClasificacion( "TOC005" );
        $this->o_COM_OrdenCompraCabeceraBN->setTipoCambio( GSS_TipoCambioFN::getStaticTipoCambioVenta() );
        if( $this->s_TipoProc == "upd" )
        {
            $this->s_Titulo = "Editar O/C";
            
            $a_Ids = explode( "_", $this->i_Id );
            $IdCompania    = $a_Ids[0];
            $IdOrdenCompra = $a_Ids[1];
            
            $o_COM_OrdenCompraCabeceraFN = new COM_OrdenCompraCabeceraFN();
            $this->o_COM_OrdenCompraCabeceraBN = $o_COM_OrdenCompraCabeceraFN->selectByPK( $IdCompania, $IdOrdenCompra );
            //pr( $this->o_COM_OrdenCompraCabeceraBN->getIdProveedor() );
            if( $this->o_COM_OrdenCompraCabeceraBN->getEstado() != COM_OrdenCompraCabeceraBN::ORDEN_COMPRA_PREPARACION )
            {
                $this->noedit = "noedit=2";
            }
            //pr( $this->o_COM_OrdenCompraCabeceraBN );
            $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
            $this->o_ALM_AlmacenMastBN = $o_ALM_AlmacenMastFN->selectByPK( $this->o_COM_OrdenCompraCabeceraBN->getIdAlmacenEntrega() );
            //pr( $this->o_ALM_AlmacenMastBN );
        }
    }
    
    public function executeRequest()
    {
        
        set_header_utf8();
        $block                  = $this->getRequestParameter( 'block' );
        $IdTransaccionOperacion = $this->getRequestParameter( 'IdTransaccionOperacion' );
        $IdCompania             = myUser::getUser()->getIdBusiness();
        $TipoProc               = $this->getRequestParameter( 'TipoProc' );
        $IdUnidadProduccion     = $this->getRequestParameter( 'IdUnidadProduccion' );
        $IdOrdenClasificacion   = $this->getRequestParameter( 'IdOrdenClasificacion' );
        
        switch ( $TipoProc )
        {
            case "BuscarRequerimiento":

                $a_Result = array();
                $o_ALM_RequerimientoCabeceraFN = new ALM_RequerimientoCabeceraFN();
                //$o_ALM_RequerimientoCabeceraFN->setEstado( ALM_RequerimientoCabeceraBN::REQUERIMIENTO_APROBADO );
                $a_ALM_RequerimientoCabecera = $o_ALM_RequerimientoCabeceraFN->select();

                foreach( $a_ALM_RequerimientoCabecera as $o_ALM_RequerimientoCabeceraBN )
                {
                    $a_lst['data'][] = array
                    (
                        "IdRequerimiento"   => $o_ALM_RequerimientoCabeceraBN->getIdRequerimiento(),
                        "FechaRequerida"    => $o_ALM_RequerimientoCabeceraBN->getFechaRequerida(),
                        "Descripcion"       => $o_ALM_RequerimientoCabeceraBN->getDescripcion(),
                        "FechaCreacion"     => substr( $o_ALM_RequerimientoCabeceraBN->getFechaCreacion(), 0, 10 ),
                        "EstadoDesc"        => $o_ALM_RequerimientoCabeceraBN->getEstadoDesc(),
                        "UsuarioCreacion"   => $o_ALM_RequerimientoCabeceraBN->getUsuarioCreacion(),
                        "ResponsableNombre" => $o_ALM_RequerimientoCabeceraBN->getResponsableNombre(),
                        "SucursalDesc"      => $o_ALM_RequerimientoCabeceraBN->getSucursalDesc(),
                        //"ClasificacionDesc" => $o_ALM_RequerimientoCabeceraBN->getOrdenClasificacionDesc(),
                        "option" => ""
                    );
                }

            break;
            case "BuscarRequerimientoDet":

                $IdReqDet = $this->getRequestParameter( 'IdReqDet' );

                $a_Result = array();
                $o_ALM_RequerimientoDetalleFN = new ALM_RequerimientoDetalleFN();
                $o_ALM_RequerimientoDetalleFN->setIdRequerimiento( $IdReqDet );
                //$o_ALM_RequerimientoDetalleFN->setEstado( ALM_RequerimientoCabeceraBN::REQUERIMIENTO_PREPARACION );
                $a_ALM_RequerimientoDetalle = $o_ALM_RequerimientoDetalleFN->select();

                foreach( $a_ALM_RequerimientoDetalle as $o_ALM_RequerimientoDetalleBN )
                {
                    $a_lst['data'][] = array
                    (
                        "IdRequerimientoDet"    => $o_ALM_RequerimientoDetalleBN->getIdRequerimientoDetalle(),
                        "IdItem"                => $o_ALM_RequerimientoDetalleBN->getIdItem(),
                        "DescripcionItem"       => $o_ALM_RequerimientoDetalleBN->getDescripcionItem(),
                        "StockAlmacenActual"    => $o_ALM_RequerimientoDetalleBN->getStockAlmacenActual(),
                        "StockMinimo"           => $o_ALM_RequerimientoDetalleBN->getStockMinimo(),
                        "CantidadSugerida"      => $o_ALM_RequerimientoDetalleBN->getCantidadSugerida(),
                        "option" => ""
                    );
                }

            break;

            /*case "IdAlmacenEntrega":
                $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
                $o_ALM_AlmacenMastFN->setIdCompania( $IdCompania );
                $a_Result = $o_ALM_AlmacenMastFN->select();
                $s_NameId  = "getIdAlmacen";
                $s_NameDes = "getDescripcionLocal";
            break;*/
            case "IdOrdenClasificacion":
                $o_COM_OrdenItemClasificacionFN = new COM_OrdenItemClasificacionFN();
                //$o_COM_OrdenItemClasificacionFN->setIdCompania( $IdCompania );
                $a_Result = $o_COM_OrdenItemClasificacionFN->select();
                $s_NameId  = "getIdOrdenClasificacion";
                $s_NameDes = "getDescripcion";
            break;
            case "IdAlmacenEntrega":
                $o_COM_OrdenItemClasificacionFN = new COM_OrdenItemClasificacionFN();
                $o_COM_OrdenItemClasificacionBN = $o_COM_OrdenItemClasificacionFN->selectByPK( $IdOrdenClasificacion );
                
                $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
                $o_ALM_AlmacenMastFN->setIdCompania( myUser::getUser()->getIdBusiness() );
                $o_ALM_AlmacenMastFN->addCondition( ALM_AlmacenMastFN::Estado ,"=", "A" );
                if( myUser::getUser()->getIdSucursal() )
                {
                    $o_ALM_AlmacenMastFN->setIdSucursal( myUser::getUser()->getIdSucursal() );
                }
                $a_ALM_AlmacenMast = $o_ALM_AlmacenMastFN->select();
                $a_Result = null;
                foreach ( $a_ALM_AlmacenMast as $i_Key => $o_ALM_AlmacenMastBN )
                {
                    $IdAlmacen = $o_ALM_AlmacenMastBN->getIdAlmacen();
                    $a_lst[$IdAlmacen] = $o_ALM_AlmacenMastBN->getDescripcionLocal();
                }
            break;
            case "ActualizarModoIngConIGV":
                $a_Result = null;
                
                $i_IdOrdenCompra  = ( int ) $this->getRequestParameter( 'IdOrdenCompra' );
                $s_ModoIngIGV     = $this->getRequestParameter( 'ModoIngreso' )=="true" ? "S" : "N";
            
                $o_COM_OrdenCompraCabeceraDP = new COM_OrdenCompraCabeceraDP();
                $o_COM_OrdenCompraCabeceraDP->setIdCompania( $IdCompania );
                $o_COM_OrdenCompraCabeceraDP->setIdOrdenCompra( $i_IdOrdenCompra );
                $o_COM_OrdenCompraCabeceraDP->setObservacionRechazo( $s_ModoIngIGV );
                $o_COM_OrdenCompraCabeceraDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $o_COM_OrdenCompraCabeceraDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $b_Result = $o_COM_OrdenCompraCabeceraDP->update();
            
                $a_lst['error'] = false;
                $a_lst['result'] = $b_Result;
            break;
            case "ver_pdf":
                
                $i_Id          = $this->getRequestParameter( 'Id' );
                
                $a_Ids         = explode( "_", $i_Id );
                $IdCompania    = $a_Ids[0];
                $i_IdOrdenCompra = $a_Ids[1];

                $s_HostName = "localhost";
                if( $_SERVER['HTTP_HOST'] )
                {
                    $s_HostName = $_SERVER['HTTP_HOST'];
                }
                
                $s_URL = "http://".$s_HostName."/hardsoft/alm.php/oc/printPDF/";

                $postdata = http_build_query( array
                    ( 
                        'i_Id'           => $IdCompania."_".$i_IdOrdenCompra, 
                        'u_usuario_name' => myUser::getUser()->getName(),
                        'host_name'      => $s_HostName
                    ) );
                $opts = array
                (
                    'http' => array
                    (
                        'method'  => 'POST',
                        'header'  => 'Content-type: application/x-www-form-urlencoded',
                        'content' => $postdata
                    )
                );
                $context = stream_context_create( $opts );
                $content = file_get_contents( $s_URL, false, $context );
                
                $i_IdOrdenCompraFormat = str_pad( $i_IdOrdenCompra, 10, "0", STR_PAD_LEFT );
                
                try
                {
                    $html2pdf = new HTML2PDF( 'P', 'A4', 'fr' );
                    //      $html2pdf->setModeDebug();
                    $html2pdf->setDefaultFont('Arial');
                    $html2pdf->writeHTML( $content, false );
                    $html2pdf->Output( 'OC_'.$i_IdOrdenCompraFormat."_".date( "Ymd" ).".pdf" );
                }
                catch(HTML2PDF_exception $e) {
                    echo $e;
                    exit;
                }
                
                exit;
            break;
        }
        
        if( $a_Result )
        {
            $a_lst = array();
            foreach ( $a_Result as $i_Key => $o_ObjectBN )
            {
                $a_lst[$o_ObjectBN->$s_NameId()] =  ( $o_ObjectBN->$s_NameDes() ) ;
            }
        }
        
        echo json_encode( $a_lst );
        return ViewResponse::NONE;
    }
    
    public function executeProv()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        $this->block = $this->getRequestParameter( 'block' );
        $this->IdTransaccion = $this->getRequestParameter( 'IdTransaccion' );
        $this->TipoBusqueda  = $this->getRequestParameter( 'tipobus' );
        $this->TipoOrdenCom  = $this->getRequestParameter( 'tipooc' );
    }
    
    public function executeProvGrid()
    {
        set_header_utf8();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

        //el tipo de transaccion, se piensa utilizar el parametro para el control de resultado para la grilla
        //puede Proveedores o Empleados, por el tipo de Transaccion
        $s_IdTransaccion = $this->getRequestParameter( 'IdTransaccion' ); 
        $s_TipoBusqueda  = $this->getRequestParameter( 'TipoBusqueda' ); 

        $o_GridAction = new GridAction();
        $o_GridAction->setClassFind( new MST_PersonaMastFN() );
        
        //ParameterWR::getInstance()->setVar( "IdCompania", $IdCompania );
        if( $s_TipoBusqueda == "prov" )
        {
            $o_GridAction->addMethodDefault( "EsProveedor", "SI" );
        }
        else
        {
            $o_GridAction->addMethodDefault( "EsEmpleado", "SI" );
        }
        //$o_GridAction->addMethodDefault( "IdCompania", myUser::getUser()->getIdBusiness() );
        
        $o_GridAction->addAssignFilter( "Nacionalidad" );
        $o_GridAction->addConditionFilter( "IdPersona", MST_PersonaMastFN::IdPersona, "LIKE", "%%s%" );
        $o_GridAction->addConditionFilter( "NombreCompleto", MST_PersonaMastFN::NombreCompleto, "LIKE", "%%s%" );
        
        //$o_GridAction->addOrder( "Codigo",           GSS_CompaniaFN::Codigo );
        //$o_GridAction->addOrder( "DescripcionCorta", GSS_CompaniaFN::DescripcionCorta );
        //$o_GridAction->addOrder( "Ruc",              GSS_CompaniaFN::Ruc );
        
        $o_GridAction->addOrderDefault( MST_PersonaMastFN::NombreCompleto, true );
        
        $o_GridAction->addRowsToShow( "IdPersona", "NombreCompleto", "Contacto", "NombreCompletoLLeno", "NacionalidadDesc" );
        
        //$o_GridAction->addInnerJoin( new ALM_ItemTipoFN(), "IdOrdenClasificacion", "DescripcionLocal" );
        
        $o_GridAction->setNumberRecordsShow( 100 );
        
        $o_GridAction->initialize();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        
        $a_ResultJson['page']    = $o_GridAction->getPage();
        $a_ResultJson['total']   = $o_GridAction->getTotalPage();
        $a_ResultJson['records'] = $o_GridAction->getTotalRecords();
        $a_ResultJson['rows']    = $o_GridAction->getResultArray();
        //pr( $a_ResultJson );
        echo json_encode( $a_ResultJson );

        return ViewResponse::NONE;
    }
    
    public function executeListItem()
    {
        $this->block = $this->getRequestParameter( 'block' );
        $this->type = $this->getRequestParameter( 'type' );
        
        $o_ALM_ItemTipoFN = new ALM_ItemTipoFN();
        $this->a_ALM_ItemTipo = $o_ALM_ItemTipoFN->select();
        
        $o_ALM_MarcaFN = new ALM_MarcaFN();
        $this->a_ALM_Marca = $o_ALM_MarcaFN->select();
        
        $o_MST_ClaseLineaFN = new MST_ClaseLineaFN();
        $this->a_MST_ClaseLinea = $o_MST_ClaseLineaFN->select();
    }
    
    public function executeItemGrid()
    {
        set_header_utf8();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $type = $this->getRequestParameter( 'type' );
        
        $o_GridAction = new GridAction();
        $o_GridAction->setClassFind( new ALM_ItemMastFN() );
        
        //ParameterWR::getInstance()->setVar( "IdCompania", $IdCompania );
        
        $o_GridAction->addMethodDefault( "IdItemTipo", $type );
        
        $o_GridAction->addAssignFilter( "IdItem" );
        
        $o_GridAction->addConditionFilter( "DescripcionCompleta", ALM_ItemMastFN::DescripcionCompleta, "LIKE", "%%s%" );
        
        //$o_GridAction->addOrder( "Codigo",           GSS_CompaniaFN::Codigo );
        //$o_GridAction->addOrder( "DescripcionCorta", GSS_CompaniaFN::DescripcionCorta );
        //$o_GridAction->addOrder( "Ruc",              GSS_CompaniaFN::Ruc );
        
        $o_GridAction->addOrderDefault( ALM_ItemMastFN::IdItem, true );
        
        $o_GridAction->addRowsToShow( "IdItem", "DescripcionCompleta" );
        
        //$o_GridAction->addInnerJoin( new ALM_ItemTipoFN(), "IdOrdenClasificacion", "DescripcionLocal" );
        
        $o_GridAction->setNumberRecordsShow( 100 );
        
        $o_GridAction->initialize();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        
        $a_ResultJson['page']    = $o_GridAction->getPage();
        $a_ResultJson['total']   = $o_GridAction->getTotalPage();
        $a_ResultJson['records'] = $o_GridAction->getTotalRecords();
        $a_ResultJson['rows']    = $o_GridAction->getResultArray();
        //pr( $a_ResultJson );
        echo json_encode( $a_ResultJson );

        return ViewResponse::NONE;
    }
    
    public function executeFindItem()
    {
        $block    = $this->getRequestParameter( 'block' );
        $s_IdItem = $this->getRequestParameter( 's_ItemId' );
        $type     = $this->getRequestParameter( 'type' );
        
        $b_ModoIngIGV     = $this->getRequestParameter( 'ModoIngreso' )=="true" ? true : false;
        
        $o_ALM_ItemMastFN = new ALM_ItemMastFN();
        $o_ALM_ItemMastBN = $o_ALM_ItemMastFN->selectByPK( $s_IdItem );
        
        $a_ResultJson['result'] = 0;
        $a_ResultJson['IdItem'] = "";
        $a_ResultJson['DescripcionCompleta'] = "";
        $a_ResultJson['NoAfectoImpuestoVentasFlag'] = "";

        if( $o_ALM_ItemMastBN )
        {
            if( $o_ALM_ItemMastBN->getIdItemTipo() == $type )
            {
                $a_ResultJson['result']              = 1;
                $a_ResultJson['IdItem']              = $o_ALM_ItemMastBN->getIdItem();
                $a_ResultJson['CodigoBarras']        = $o_ALM_ItemMastBN->getCodigoBarras();
                $a_ResultJson['DescripcionCompleta'] = $o_ALM_ItemMastBN->getDescripcionCompleta();
                $a_ResultJson['UnidadCompra']        = $o_ALM_ItemMastBN->getUnidadCompra();
                $a_ResultJson['UnidadCompraDesc']    = $o_ALM_ItemMastBN->getObjectUnidad()->getDescripcionCorta();

                //ahora se busca unidades equivalente
                $a_Unidad[] = array( "IdUnidad" => $a_ResultJson['UnidadCompra'], "UnidadDesc" => $a_ResultJson['UnidadCompraDesc'] );

                $a_MST_UnidadConversionMast = MST_UnidadMastFN::find_uni_eq( $a_ResultJson['UnidadCompra'] );
                if( $a_MST_UnidadConversionMast )
                {
                    foreach ( $a_MST_UnidadConversionMast as $key => $o_MST_UnidadConversionMastBN ) 
                    {
                        $o_MST_UnidadMastBN = $o_MST_UnidadConversionMastBN->getObjectUnidadMedidaEq();
                        $a_Unidad[] = array( "IdUnidad" => $o_MST_UnidadMastBN->getIdUnidad(), "UnidadDesc" => $o_MST_UnidadMastBN->getDescripcionCorta() );
                    }
                }
                $a_ResultJson['a_Unidad'] = $a_Unidad;

                $b_ManejaLote = $o_ALM_ItemMastBN->SiManejaLote();
                $a_ResultJson['SiManejaLote'] = $b_ManejaLote;
                
                //AHORA SE AGREGAR EL PRECIO POR DEFECTO DESDE EL LOG
                $i_Id = $this->getRequestParameter( 'i_Id' );
                
                $a_Ids = explode( "_", $i_Id );
                $i_IdCompania    = $a_Ids[0];
                $i_IdOrdenCompra = $a_Ids[1];
                
                $f_PrecioUnitario = 0.00;
                
                $o_COM_OrdenCompraCabeceraFN = new COM_OrdenCompraCabeceraFN();
                $o_COM_OrdenCompraCabeceraBN = $o_COM_OrdenCompraCabeceraFN->selectByPK( $i_IdCompania, $i_IdOrdenCompra );

                $s_IdMoneda   = $o_COM_OrdenCompraCabeceraBN->getIdMoneda();
                $f_TipoCambio = $o_COM_OrdenCompraCabeceraBN->getTipoCambio();
                
                $i_IdSucursal = ALM_AlmacenMastFN::recuperarIdSucursal( $o_COM_OrdenCompraCabeceraBN->getIdAlmacenEntrega() );
                $i_IdPersona  = $o_COM_OrdenCompraCabeceraBN->getIdProveedor();
                
                //buscamos referencia de precio por la moneda de la OC
                $o_ALM_RequerimientoDetalleLogBN = ALM_RequerimientoDetalleLogFN::buscar_log_ref( $s_IdItem, $o_COM_OrdenCompraCabeceraBN->getIdMoneda() );

                if( $o_ALM_RequerimientoDetalleLogBN->getPrecioUnitario() && $o_ALM_RequerimientoDetalleLogBN->getPrecioUnitarioIGV() )
                {
                    if( !$o_COM_OrdenCompraCabeceraBN->esAfectoAIGV() )
                    {
                        if( $s_IdMoneda == "LO" ) $f_PrecioUnitario = $o_ALM_RequerimientoDetalleLogBN->getPrecioUnitarioMN();
                        if( $s_IdMoneda == "EX" ) $f_PrecioUnitario = $o_ALM_RequerimientoDetalleLogBN->getPrecioUnitarioME();
                    }
                    else
                    {
                        if( $b_ModoIngIGV )
                        {
                            if( $s_IdMoneda == "LO" )  $f_PrecioUnitario = $o_ALM_RequerimientoDetalleLogBN->getPrecioUnitarioIGVMN();
                            if( $s_IdMoneda == "EX" )  $f_PrecioUnitario = $o_ALM_RequerimientoDetalleLogBN->getPrecioUnitarioIGVME();
                        }
                        else
                        {
                            if( $s_IdMoneda == "LO" ) $f_PrecioUnitario = $o_ALM_RequerimientoDetalleLogBN->getPrecioUnitarioMN();
                            if( $s_IdMoneda == "EX" ) $f_PrecioUnitario = $o_ALM_RequerimientoDetalleLogBN->getPrecioUnitarioME();
                        }
                    }
                    $f_PrecioUnitario = round( $f_PrecioUnitario, 2 );
                }
                else
                {
                    $o_MST_ListaPrecioDetalleBN = MST_ListaPrecioDetalleFN::buscarPrecioGeneral( $s_IdItem, 1 );
                    if( !$o_COM_OrdenCompraCabeceraBN->esAfectoAIGV() )
                    {
                        if( $o_MST_ListaPrecioDetalleBN )
                        {
                            if( $s_IdMoneda == "LO" ) $f_PrecioUnitario = $o_MST_ListaPrecioDetalleBN->getPrecioCosto();
                            if( $s_IdMoneda == "EX" ) $f_PrecioUnitario = round( $o_MST_ListaPrecioDetalleBN->getPrecioCosto() / $f_TipoCambio, 2 );
                        }
                    }
                    else
                    {
                        if( $o_MST_ListaPrecioDetalleBN )
                        {
                            if( $b_ModoIngIGV )
                            {
                                if( $s_IdMoneda == "LO" ) $f_PrecioUnitario = $o_MST_ListaPrecioDetalleBN->getPrecioCostoIGV();
                                if( $s_IdMoneda == "EX" ) $f_PrecioUnitario = round( $o_MST_ListaPrecioDetalleBN->getPrecioCostoIGV() / $f_TipoCambio, 2 );
                            }
                            else
                            {
                                if( $s_IdMoneda == "LO" ) $f_PrecioUnitario = $o_MST_ListaPrecioDetalleBN->getPrecioCosto();
                                if( $s_IdMoneda == "EX" ) $f_PrecioUnitario = round( $o_MST_ListaPrecioDetalleBN->getPrecioCosto() / $f_TipoCambio, 2 );
                            }
                        }
                    }
                }

                if( !$o_COM_OrdenCompraCabeceraBN->esAfectoAIGV() )
                {
                    $s_DescImpuesto = "N";
                }
                else
                {
                    $s_DescImpuesto = "S";
                }
                $a_ResultJson['NoAfectoImpuestoVentasFlag'] = $s_DescImpuesto;

                //ahora se prepara para encontrar un costo real
                /*if( $o_ALM_ItemMastBN->getUnidadCompra() != $o_ALM_ItemMastBN->getUnidadVenta() )
                {
                    $o_Com_MST_UnidadMastBN = MST_UnidadMastFN::select_one( $o_ALM_ItemMastBN->getUnidadCompra() ); //unidad de compra
                    $o_Ven_MST_UnidadMastBN = MST_UnidadMastFN::select_one( $o_ALM_ItemMastBN->getUnidadVenta() ); //unidad de venta

                    //se recupera el costo por la minima
                    $f_CostoUniMinimo = 0;
                    $f_CantidadUnidadVenta = 0;
                    if( $o_Ven_MST_UnidadMastBN->getEsUnidadMinimaFlag() )
                    {
                        $f_CantidadUnidadVenta = 1;
                    }
                    elseif ( $o_Ven_MST_UnidadMastBN->getUnidadEquivalenteFlag() && $o_Ven_MST_UnidadMastBN->getUsoFraccionFlag() ) 
                    {
                        $f_CantidadUnidadVenta = $o_ALM_ItemMastBN->getCantidadUnidad();
                    }
                    elseif ( $o_Ven_MST_UnidadMastBN->getUnidadEquivalenteFlag() && !$o_Ven_MST_UnidadMastBN->getUsoFraccionFlag() && !$o_Ven_MST_UnidadMastBN->getEsUnidadMinimaFlag() ) 
                    {
                        $a_MST_UnidadConversionMast = MST_UnidadMastFN::find_uni_eq( $o_ALM_ItemMastBN->getUnidadVenta() );
                        $f_CantidadUnidadVenta = $a_MST_UnidadConversionMast[0]->getCantidadEquivalente();
                    }

                    $f_CostoUniMinimo = round( $f_PrecioUnitario / $f_CantidadUnidadVenta, 2 );

                    if( $o_Com_MST_UnidadMastBN->getEsUnidadMinimaFlag() )
                    {
                        $f_CantidadUnidadCompra = 1;
                    }
                    elseif ( $o_Com_MST_UnidadMastBN->getUnidadEquivalenteFlag() && $o_Com_MST_UnidadMastBN->getUsoFraccionFlag() ) 
                    {
                        $f_CantidadUnidadCompra = $o_ALM_ItemMastBN->getCantidadUnidadCompra();
                    }
                    elseif ( $o_Com_MST_UnidadMastBN->getUnidadEquivalenteFlag() && !$o_Com_MST_UnidadMastBN->getUsoFraccionFlag() && !$o_Com_MST_UnidadMastBN->getEsUnidadMinimaFlag() ) 
                    {
                        $a_MST_UnidadConversionMast = MST_UnidadMastFN::find_uni_eq( $o_ALM_ItemMastBN->getUnidadVenta() );
                        $f_CantidadUnidadCompra = $a_MST_UnidadConversionMast[0]->getCantidadEquivalente();
                    }

                    $f_PrecioUnitario = $f_CostoUniMinimo * $f_CantidadUnidadCompra;
                }*/

                $a_ResultJson['PrecioUnitario'] = $f_PrecioUnitario;
            }
        }
        
        echo json_encode( $a_ResultJson );
        
        return ViewResponse::NONE;
    }
    
    public function executeSaveAddEdit()
    {
        $block      = $this->getRequestParameter( 'block' );
        $i_Id       = $this->getRequestParameter( 'i_Id' );
        $s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        $TypeSub    = $this->getRequestParameter( 'TypeSub' );
        
        $IdCompania           = $this->getRequestParameter( 'IdCompania' );
        $IdProveedor          = $this->getRequestParameter( 'IdProveedor' );
        $NombreProveedor      = $this->getRequestParameter( 'NombreProveedor' );
        $NumeroInterno        = $this->getRequestParameter( 'NumeroInterno' );
        $IdOrdenClasificacion = $this->getRequestParameter( 'IdOrdenClasificacion' ); //
        $IdMoneda             = $this->getRequestParameter( 'IdMoneda' );
        $Observacion          = $this->getRequestParameter( 'Observacion' );
        $IdAlmacenEntrega     = $this->getRequestParameter( 'IdAlmacenEntrega' );
        $FechaEntrega         = $this->getRequestParameter( 'FechaEntrega' ); //

        $TerminoId            = $this->getRequestParameter( 'TerminoId' ); //
        $IdMonedaPago         = $this->getRequestParameter( 'IdMonedaPago' ); //
        $Descripcion          = $this->getRequestParameter( 'Descripcion' ); //
        $ObservacionEntrega   = $this->getRequestParameter( 'ObservacionEntrega' ); //

        //$f_TipoCambio         = GSS_TipoCambioFN::getTipoCambioValor();
        $f_TipoCambio         = floatval( $this->getRequestParameter( 'TipoCambio' ) ); //
        
        $TipoOrden            = $this->getRequestParameter( 'TipoOrden' );

        $s_IdProyecto         = $this->getRequestParameter( 'IdProyecto' );
        $s_ProyectoNombre     = $this->getRequestParameter( 'ProyectoNombre' );

        $i_AfectoIGV          = 1;
        try 
        {
            myUser::getUser()->validar_session();
            
            /*if( $IdMoneda == "LO" )
            {
                $f_TipoCambio = 1;
            }*/
            
            if( !$f_TipoCambio )
            {
                throw new Exception( "Debe de registrar el Tipo de Cambio de hoy." );
            }
            
            if( !$IdProveedor )
            {
                throw new Exception( "Se necesita el Proveedor." );
            }

            if( !$IdAlmacenEntrega )
            {
                throw new Exception( "Debe de seleccionar el Almacen." );
            }

            $o_MST_PersonaMastFN = new MST_PersonaMastFN();
            $o_MST_PersonaMastBN = $o_MST_PersonaMastFN->selectByPK( $IdProveedor );

            //AHORA VALIDACIONES POR EL TIPO DE ORDEN
            if( $TipoOrden == COM_OrdenCompraCabeceraBN::TIPO_OC_IMPORTACION )
            {
                //ORDEN X IMPORTANCION
                if( $o_MST_PersonaMastBN->esNacionalidadLocal() )
                {
                    throw new Exception( "El tipo de O/C no permite Proveedores de Nacionalidad Local." );
                }
                $i_AfectoIGV = 0;
            }
            else
            {
                //ORDEN LOCAL
                if( !$o_MST_PersonaMastBN->esNacionalidadLocal() )
                {
                    throw new Exception( "El tipo de O/C no permite Proveedores de Nacionalidad Extrangero." );
                }
            }
            
            $o_COM_OrdenCompraCabeceraDP = new COM_OrdenCompraCabeceraDP();
            $o_COM_OrdenCompraCabeceraDP->setIdProveedor( ( int ) $IdProveedor );
            $o_COM_OrdenCompraCabeceraDP->setIdOrdenClasificacion( $IdOrdenClasificacion );
            $o_COM_OrdenCompraCabeceraDP->setNombreProveedor( $NombreProveedor );
            $o_COM_OrdenCompraCabeceraDP->setNumeroInterno( $NumeroInterno );
            $o_COM_OrdenCompraCabeceraDP->setIdMoneda( $IdMoneda );
            $o_COM_OrdenCompraCabeceraDP->setObservacion( $Observacion );
            $o_COM_OrdenCompraCabeceraDP->setIdAlmacenEntrega( $IdAlmacenEntrega );
            $o_COM_OrdenCompraCabeceraDP->setIdAlmacenIngreso( $IdAlmacenEntrega );
            $o_COM_OrdenCompraCabeceraDP->setFechaEntrega( $FechaEntrega );
            $o_COM_OrdenCompraCabeceraDP->setTipoOrden( $TipoOrden );
            $o_COM_OrdenCompraCabeceraDP->setIdProyecto( ( int ) $s_IdProyecto );
            $o_COM_OrdenCompraCabeceraDP->setProyectoNombre( $s_ProyectoNombre );

            $o_COM_OrdenCompraCabeceraDP->setTerminoId( ( int ) $TerminoId );
            $o_COM_OrdenCompraCabeceraDP->setIdMonedaPago( $IdMonedaPago );
            $o_COM_OrdenCompraCabeceraDP->setDescripcion( $Descripcion );
            $o_COM_OrdenCompraCabeceraDP->setObservacionEntrega( $ObservacionEntrega );
            
            $o_COM_OrdenCompraCabeceraDP->setTipoCambio( $f_TipoCambio );
            $o_COM_OrdenCompraCabeceraDP->setAfectoIGV( $i_AfectoIGV );
            
            if( $s_TipoProc == "nvo" )
            {
                //INSERT
                //$o_COM_OrdenCompraCabeceraDP->setObservacionRechazo( "S" );
                $o_COM_OrdenCompraCabeceraDP->setMontoAfecto( 0.00 );
                $o_COM_OrdenCompraCabeceraDP->setMontoNoAfecto( 0.00 );
                $o_COM_OrdenCompraCabeceraDP->setMontoIGV( 0.00 );
                $o_COM_OrdenCompraCabeceraDP->setMontoBruto( 0.00 );
                
                $o_COM_OrdenCompraCabeceraDP->setIdCompania( ( int ) $IdCompania );
                $o_COM_OrdenCompraCabeceraDP->setIdSucursal( myUser::getUser()->getIdSucursal() );
                $i_Id = COM_OrdenCompraCabeceraDP::recuperarId();
                $o_COM_OrdenCompraCabeceraDP->setIdOrdenCompra( ( int ) $i_Id );
                $o_COM_OrdenCompraCabeceraDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                $o_COM_OrdenCompraCabeceraDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                $o_COM_OrdenCompraCabeceraDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $o_COM_OrdenCompraCabeceraDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $o_COM_OrdenCompraCabeceraDP->setFechaPreparacion( date( "Y-m-d H:i:s" ) );
                $o_COM_OrdenCompraCabeceraDP->setPreparadoPor( myUser::getUser()->getUserId() );
                $o_COM_OrdenCompraCabeceraDP->setEstado( COM_OrdenCompraCabeceraBN::ORDEN_COMPRA_PREPARACION ); //por defecto
                $b_Result = $o_COM_OrdenCompraCabeceraDP->save();
                $i_Id = $IdCompania."_".$i_Id;
            }
            else 
            {
                //UPDATE
                $i_Id = $this->getRequestParameter( 'i_Id' );
                
                $a_Ids = explode( "_", $i_Id );
                $IdCompania    = $a_Ids[0];
                $IdOrdenCompra = $a_Ids[1];
                
                $o_COM_OrdenCompraCabeceraDP->setIdCompania( ( int ) $IdCompania );
                $o_COM_OrdenCompraCabeceraDP->setIdOrdenCompra( ( int ) $IdOrdenCompra );
                $o_COM_OrdenCompraCabeceraDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $o_COM_OrdenCompraCabeceraDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $b_Result = $o_COM_OrdenCompraCabeceraDP->update();
            }
            $a_Rs['type_sub'] = $TypeSub;
            $a_Rs['error']   = false;
            $a_Rs['id']      = $i_Id;
        }
        catch ( Exception $o_Exception )
        {
            $a_Rs['error']        = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }
        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }
    
    public function executeAudi()
    {
        $block      = $this->getRequestParameter( 'block' );
        $i_Id       = $this->getRequestParameter( 'i_Id' );
        
        $a_Ids = explode( "_", $i_Id );
        $IdCompania    = $a_Ids[0];
        $IdOrdenCompra = $a_Ids[1];
        
        $this->s_Topico = "Orden de Compra";
        $o_COM_OrdenCompraCabeceraFN = new COM_OrdenCompraCabeceraFN();
        $this->o_ObjectBN = $o_COM_OrdenCompraCabeceraFN->selectByPK( $IdCompania, $IdOrdenCompra );
    }
    
    public function executeViewdel()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        $this->block      = $this->getRequestParameter( 'block' );
        $this->i_Id       = $this->getRequestParameter( 'i_Id' );
        $this->s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        
        $o_GSS_CompaniaFN = new GSS_CompaniaFN();
        $this->a_GSS_Compania= $o_GSS_CompaniaFN->select();
        
        $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
        $this->a_ALM_AlmacenMast = $o_ALM_AlmacenMastFN->select();
        
        $o_GSS_MonedaMastFN = new GSS_MonedaMastFN();
        $this->a_GSS_MonedaMast = $o_GSS_MonedaMastFN->select();
        
        $a_Ids = explode( "_", $this->i_Id );
        $IdCompania    = $a_Ids[0];
        $IdOrdenCompra = $a_Ids[1];
        
        $o_COM_OrdenCompraCabeceraFN = new COM_OrdenCompraCabeceraFN();
        $this->o_COM_OrdenCompraCabeceraBN = $o_COM_OrdenCompraCabeceraFN->selectByPK( $IdCompania, $IdOrdenCompra );
        
        $this->a_ModuloOrden = array( "Module" => "oc" );
        if( $this->o_COM_OrdenCompraCabeceraBN->getIdOrdenClasificacion() == "CA00002" )
        {
            $this->a_ModuloOrden = array( "Module" => "os" );
        }
        
        $o_COM_OrdenItemClasificacionFN = new COM_OrdenItemClasificacionFN();
        //$o_COM_OrdenItemClasificacionFN->setIdCompania( $this->o_COM_OrdenCompraCabeceraBN->getIdCompania() );
        $this->a_COM_OrdenItemClasificacion = $o_COM_OrdenItemClasificacionFN->select();
        
        $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
        $this->o_ALM_AlmacenMastBN = $o_ALM_AlmacenMastFN->selectByPK( $this->o_COM_OrdenCompraCabeceraBN->getIdAlmacenEntrega() );
        
    }
    
    public function executeDeleteRow()
    {
        $block      = $this->getRequestParameter( 'block' );
        $i_Id       = $this->getRequestParameter( 'i_Id' );
        $s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        try 
        {
            $a_Ids = explode( "_", $i_Id );
            $IdCompania    = $a_Ids[0];
            $IdOrdenCompra = $a_Ids[1];
                
            $o_COM_OrdenCompraCabeceraDP = new COM_OrdenCompraCabeceraDP();
            $o_COM_OrdenCompraCabeceraDP->setIdCompania( ( int ) $IdCompania );
            $o_COM_OrdenCompraCabeceraDP->setIdOrdenCompra( ( int ) $IdOrdenCompra );
            $o_COM_OrdenCompraCabeceraDP->setEstado( COM_OrdenCompraCabeceraBN::ORDEN_COMPRA_ANULADO );
            $o_COM_OrdenCompraCabeceraDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
            $o_COM_OrdenCompraCabeceraDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
            $b_Result = $o_COM_OrdenCompraCabeceraDP->update();
            
            if( $b_Result )
            {
                $o_COM_OrdenCompraDetalleDP = new COM_OrdenCompraDetalleDP();
                $o_COM_OrdenCompraDetalleDP->setIdCompania( ( int ) $IdCompania );
                $o_COM_OrdenCompraDetalleDP->setIdOrdenCompra( ( int ) $IdOrdenCompra );
                $o_COM_OrdenCompraDetalleDP->setEstado( COM_OrdenCompraCabeceraBN::ORDEN_COMPRA_ANULADO );
                $b_Result = $o_COM_OrdenCompraDetalleDP->deleteDetail();
            }

            $a_Rs['result']  = $b_Result;
            $a_Rs['error']   = false;
            $a_Rs['id']      = $i_Id;
        }
        catch ( Exception $o_Exception )
        {
            $a_Rs['error']   = true;
            $a_Rs['mensaje_error_ex'] = $o_Exception->getMessage();
            $a_Rs['mensaje_error'] = "No se pudo eliminar el registro.";
        }
        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }
    
    public function executeReporte()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        $block      = $this->getRequestParameter( 'block' );
        $i_Id       = $this->getRequestParameter( 'i_Id' );
        $s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        
        $a_Ids = explode( "_", $i_Id );
        $IdCompania    = $a_Ids[0];
        $IdOrdenCompra = $a_Ids[1];
        
        $o_COM_OrdenCompraCabeceraFN = new COM_OrdenCompraCabeceraFN();
        $this->o_COM_OrdenCompraCabeceraBN = $o_COM_OrdenCompraCabeceraFN->selectByPK( $IdCompania, $IdOrdenCompra );
        
        $o_COM_OrdenItemClasificacionFN = new COM_OrdenItemClasificacionFN();
        $this->o_COM_OrdenItemClasificacionBN = $o_COM_OrdenItemClasificacionFN->selectByPK( $this->o_COM_OrdenCompraCabeceraBN->getIdOrdenClasificacion() );
        
        $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
        $this->o_ALM_AlmacenMastBN = $o_ALM_AlmacenMastFN->selectByPK( $this->o_COM_OrdenCompraCabeceraBN->getIdAlmacenEntrega() );
        
        $o_MST_PersonaMastFN = new MST_PersonaMastFN();
        $this->o_MST_PersonaMastBN = $o_MST_PersonaMastFN->selectByPK( $this->o_COM_OrdenCompraCabeceraBN->getIdProveedor() );
        
        $o_COM_OrdenCompraDetalleFN = new COM_OrdenCompraDetalleFN();
        $o_COM_OrdenCompraDetalleFN->setIdOrdenCompra( $IdOrdenCompra );
        $o_COM_OrdenCompraDetalleFN->setIdCompania( $IdCompania );
        $this->a_COM_OrdenCompraDetalle = $o_COM_OrdenCompraDetalleFN->select();
        
        $this->u_usuario_name = myUser::getUser()->getName();

        $this->o_GSS_CompaniaBN = GSS_CompaniaFN::buscarCompania();
        
        $this->s_Moneda = GSS_MonedaMastFN::getDescripcionxId( $this->o_COM_OrdenCompraCabeceraBN->getIdMoneda() );
    }
    
    public function executeRevertirOC()
    {
        $i_Id       = $this->getRequestParameter( 'i_Id' );
        
        $con = Conexion::getConexion();
        $con->begin();
        try
        {
            $a_Ids = explode( "_", $i_Id );
            $IdCompania    = $a_Ids[0];
            $IdOrdenCompra = $a_Ids[1];
            
            $o_COM_OrdenCompraCabeceraBN = new COM_OrdenCompraCabeceraBN();
            $o_COM_OrdenCompraCabeceraBN->setIdCompania( ( int ) $IdCompania );
            $o_COM_OrdenCompraCabeceraBN->setIdOrdenCompra( ( int ) $IdOrdenCompra );
            
            $o_OrdenCompraBL = new OrdenCompraBL();
            $b_Result = $o_OrdenCompraBL->iniciarProcesoReversionOC( $o_COM_OrdenCompraCabeceraBN );
            
            $con->commit();
            
            $a_Rs['error']   = false;
            $a_Rs['id']      = $i_Id;
            
        }
        catch ( Exception $o_Exception )
        {
            $con->rollback();
            $a_Rs['error']   = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }
        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }
    
    public function executeCambiarEstadoOC()
    {
        $i_Id       = $this->getRequestParameter( 'IdOrdenCompra' );
        try
        {
            $a_Ids = explode( "_", $i_Id );
            $IdCompania    = $a_Ids[0];
            $IdOrdenCompra = $a_Ids[1];
        
            $o_COM_OrdenCompraCabeceraDP = new COM_OrdenCompraCabeceraDP();
            $o_COM_OrdenCompraCabeceraDP->setIdCompania( ( int ) $IdCompania );
            $o_COM_OrdenCompraCabeceraDP->setIdOrdenCompra( ( int ) $IdOrdenCompra );
            $o_COM_OrdenCompraCabeceraDP->setEstado( COM_OrdenCompraCabeceraBN::ORDEN_COMPRA_APROBADO );
            $o_COM_OrdenCompraCabeceraDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
            $o_COM_OrdenCompraCabeceraDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
            $b_Result = $o_COM_OrdenCompraCabeceraDP->update();
        
            $a_Rs['result']  = $b_Result;
            $a_Rs['error']   = false;
            $a_Rs['id']      = $i_Id;
        }
        catch ( Exception $o_Exception )
        {
            $a_Rs['error']   = true;
            $a_Rs['mensaje_error_ex'] = $o_Exception->getMessage();
            $a_Rs['mensaje_error'] = "No se pudo eliminar el registro.";
        }
        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }

    public function executePlnEnvCorreo()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        
        $o_GSS_CompaniaFN = new GSS_CompaniaFN();
        $this->o_GSS_CompaniaBN = $o_GSS_CompaniaFN->selectByPK( myUser::getUser()->getIdCompania() );
        
        $this->Id       = $this->getRequestParameter( 'Id' );
        $this->Subject  = $this->getRequestParameter( 'subject' );

        $a_Ids = explode( "_", $this->Id );
        $IdCompania    = $a_Ids[0];
        $IdOrdenCompra = $a_Ids[1];

        $o_COM_OrdenCompraCabeceraFN = new COM_OrdenCompraCabeceraFN();
        $o_COM_OrdenCompraCabeceraBN = $o_COM_OrdenCompraCabeceraFN->selectByPK( $IdCompania, $IdOrdenCompra );
        //pr( $o_COM_OrdenCompraCabeceraBN->getIdProveedor() );

        $o_MST_PersonaMastFN = new MST_PersonaMastFN();
        $o_MST_PersonaMastBN = $o_MST_PersonaMastFN->selectByPK( $o_COM_OrdenCompraCabeceraBN->getIdProveedor() );
        //pr( $o_MST_PersonaMastBN->getEmail() );

        $this->s_CorreoProv = $o_MST_PersonaMastBN->getEmail();
    }

    public function executeReporteEmail()
    {
        $block      = $this->getRequestParameter( 'block' );
        $i_Id       = $this->getRequestParameter( 'i_Id' );
        $s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        
        $a_Ids = explode( "_", $i_Id );
        $IdCompania    = $a_Ids[0];
        $IdOrdenCompra = $a_Ids[1];
        
        $o_COM_OrdenCompraCabeceraFN = new COM_OrdenCompraCabeceraFN();
        $this->o_COM_OrdenCompraCabeceraBN = $o_COM_OrdenCompraCabeceraFN->selectByPK( $IdCompania, $IdOrdenCompra );
        
        $o_COM_OrdenItemClasificacionFN = new COM_OrdenItemClasificacionFN();
        $this->o_COM_OrdenItemClasificacionBN = $o_COM_OrdenItemClasificacionFN->selectByPK( $this->o_COM_OrdenCompraCabeceraBN->getIdOrdenClasificacion() );
        
        $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
        $this->o_ALM_AlmacenMastBN = $o_ALM_AlmacenMastFN->selectByPK( $this->o_COM_OrdenCompraCabeceraBN->getIdAlmacenEntrega() );
        
        $o_MST_PersonaMastFN = new MST_PersonaMastFN();
        $this->o_MST_PersonaMastBN = $o_MST_PersonaMastFN->selectByPK( $this->o_COM_OrdenCompraCabeceraBN->getIdProveedor() );
        
        $this->s_Moneda = GSS_MonedaMastFN::getDescripcionxId( $this->o_COM_OrdenCompraCabeceraBN->getIdMoneda() );
        
        $o_COM_OrdenCompraDetalleFN = new COM_OrdenCompraDetalleFN();
        $o_COM_OrdenCompraDetalleFN->setIdOrdenCompra( $IdOrdenCompra );
        $o_COM_OrdenCompraDetalleFN->setIdCompania( $IdCompania );
        $this->a_COM_OrdenCompraDetalle = $o_COM_OrdenCompraDetalleFN->select();

        $this->o_GSS_CompaniaBN = GSS_CompaniaFN::buscarCompania();
    }
}