<?php
class SaveDetailFrReqAction extends wtActions
{
    public function execute()
    {
        $a_Rs = array();

        $s_Id       = $this->getRequestParameter( 'IdOC' );
        $s_IdReq    = $this->getRequestParameter( 'IdReq' );
        $a_IdReqDet = $this->getRequestParameter( 'IdReqDet' );
        $b_ModoIngIGV     = $this->getRequestParameter( 'ModoIngreso' )=="true" ? true : false;

        $con = Conexion::getConexion();
        $con->begin();
        try
        {
            $a_Ids = explode( "_", $s_Id );
            $IdCompania    = $a_Ids[0];
            $IdOrdenCompra = $a_Ids[1];

            $o_COM_OrdenCompraCabeceraFN = new COM_OrdenCompraCabeceraFN();
            $o_COM_OrdenCompraCabeceraBN = $o_COM_OrdenCompraCabeceraFN->selectByPK( $IdCompania, $IdOrdenCompra );

            foreach( $a_IdReqDet as $i_Cnt => $s_IdReqDet )
            {
                $o_ALM_RequerimientoDetalleFN = new ALM_RequerimientoDetalleFN();
                $o_ALM_RequerimientoDetalleBN = $o_ALM_RequerimientoDetalleFN->selectByPK( $s_IdReqDet );

                //PARAMETROS
                $IdItem         = $o_ALM_RequerimientoDetalleBN->getIdItem();
                $s_IdItem         = $IdItem;

                $o_ALM_ItemMastFN = new ALM_ItemMastFN();
                $o_ALM_ItemMastBN = $o_ALM_ItemMastFN->selectByPK( $IdItem );

                $IdUnidad           = "58";
                $CantidadPedida     = $o_ALM_RequerimientoDetalleBN->getCantidadSugerida(); // - $o_ALM_RequerimientoDetalleBN->getCantidadPedida();
                //$PrecioUnitario     = $o_ALM_RequerimientoDetalleBN->getPrecioUnitario();
                //$PrecioUnitarioIGV  = $o_ALM_RequerimientoDetalleBN->getPrecioUnitarioIGV();
                //$PrecioSubTotal     = $o_ALM_RequerimientoDetalleBN->getPrecioSubTotal();
                //$ValorIGV           = $o_ALM_RequerimientoDetalleBN->getValorIGV();
                //$PrecioTotalConIGV  = $o_ALM_RequerimientoDetalleBN->getPrecioTotalConIGV();
                $NoAfecImpuesto = "N";



                //buscamos referencia de precio por la moneda de la OC
                $o_ALM_RequerimientoDetalleLogBN = ALM_RequerimientoDetalleLogFN::buscar_log_ref( $s_IdItem, $o_COM_OrdenCompraCabeceraBN->getIdMoneda() );

                if( $o_ALM_RequerimientoDetalleLogBN->getPrecioUnitario() && $o_ALM_RequerimientoDetalleLogBN->getPrecioUnitarioIGV() )
                {
                    if( !$o_COM_OrdenCompraCabeceraBN->esAfectoAIGV() )
                    {
                        $f_PrecioUnitario = $o_ALM_RequerimientoDetalleLogBN->getPrecioUnitario();
                    }
                    else
                    {
                        if( $b_ModoIngIGV )
                        {
                            $f_PrecioUnitario = $o_ALM_RequerimientoDetalleLogBN->getPrecioUnitarioIGV();
                        }
                        else
                        {
                            $f_PrecioUnitario = $o_ALM_RequerimientoDetalleLogBN->getPrecioUnitario();
                        }
                    }
                    $f_PrecioUnitario = round( $f_PrecioUnitario, 2 );
                }
                else
                {
                    $o_MST_ListaPrecioDetalleBN = MST_ListaPrecioDetalleFN::buscarPrecioGeneral( $s_IdItem, 1 );
                    if( !$o_COM_OrdenCompraCabeceraBN->esAfectoAIGV() )
                    {
                        if( $o_MST_ListaPrecioDetalleBN )
                        {
                            $f_PrecioUnitario = $o_MST_ListaPrecioDetalleBN->getPrecioCosto();
                        }
                    }
                    else
                    {
                        if( $o_MST_ListaPrecioDetalleBN )
                        {
                            if( $b_ModoIngIGV )
                            {
                                $f_PrecioUnitario = $o_MST_ListaPrecioDetalleBN->getPrecioCostoIGV();
                            }
                            else
                            {
                                $f_PrecioUnitario = $o_MST_ListaPrecioDetalleBN->getPrecioCosto();
                            }
                        }
                    }
                }


                ///////////////////////////////////////////////////


                $PrecioUnitario = $f_PrecioUnitario;
                if( $o_COM_OrdenCompraCabeceraBN->esAfectoAIGV() )
                {
                    $NoAfecImpuesto = "S";
                    //SE RECUPERA VALOR DE IGV ACTUAL
                    $f_IGV       = UtilIGV::getValorIGVActual();
                    $f_IGVMasUno = $f_IGV + 1;

                    $f_Precio   = $PrecioUnitario;
                    $f_Cantidad = $CantidadPedida;
                    if( $b_ModoIngIGV )
                    {
                        $f_PrecioUniConIGV = $f_Precio;
                        $f_PrecioUnitario  = round( $f_PrecioUniConIGV / $f_IGVMasUno, 13 );
                    }
                    else
                    {
                        $f_PrecioUniConIGV = round( $f_Precio * $f_IGVMasUno, 2 );
                        $f_PrecioUnitario  = $f_Precio;
                    }

                    $f_PrecioUniSinIGV     = round( $f_PrecioUnitario, 2 );

                    $f_PrecioTotalFinal      = round( $f_PrecioUniConIGV * $f_Cantidad, 2 );
                    $f_PrecioSubTotal        = round( $f_PrecioUniSinIGV * $f_Cantidad, 2 );
                    $f_MontoSubTotalImpuesto = round( $f_PrecioTotalFinal - $f_PrecioSubTotal, 2 );
                }
                else
                {
                    $NoAfecImpuesto = "N";

                    $f_PrecioUniConIGV = $PrecioUnitario;
                    $f_PrecioUniSinIGV = $PrecioUnitario;
                    $f_Cantidad = $CantidadPedida;

                    $f_PrecioTotalFinal      = round( $f_PrecioUniConIGV * $f_Cantidad, 2 );
                    $f_PrecioSubTotal        = round( $f_PrecioUniSinIGV * $f_Cantidad, 2 );
                    $f_MontoSubTotalImpuesto = 0;
                }


                //SE GENERA EL DETALLE O/C
                $o_COM_OrdenCompraDetalleDP = new COM_OrdenCompraDetalleDP();
                $o_COM_OrdenCompraDetalleDP->setIdOrdenCompra( ( int ) $IdOrdenCompra );
                $o_COM_OrdenCompraDetalleDP->setIdCompania( ( int ) $IdCompania );

                $o_COM_OrdenCompraDetalleDP->setIdRequerimientoDetalle( ( int ) $s_IdReqDet );
                $o_COM_OrdenCompraDetalleDP->setIdItem( $IdItem );
                $o_COM_OrdenCompraDetalleDP->setDescripcion( $o_ALM_ItemMastBN->getDescripcionCompleta() );
                $o_COM_OrdenCompraDetalleDP->setCantidadPedida( $CantidadPedida );
                //$o_COM_OrdenCompraDetalleDP->setCantidadRecibida( 0 );

                $o_COM_OrdenCompraDetalleDP->setIdCondicion( ( int ) ALM_TransaccionDetalleBN::CONDICION_POR_DEFECTO );

                $o_COM_OrdenCompraDetalleDP->setPrecioUnitarioInicial( $f_PrecioUniConIGV );   //SET DEL PRECIO CON IGV
                $o_COM_OrdenCompraDetalleDP->setPrecioUnitarioFinal( $f_PrecioUniConIGV );     //SET DEL PRECIO CON IGV
                $o_COM_OrdenCompraDetalleDP->setPrecioUnitarioIGV( $f_PrecioUniConIGV );       //SET DEL PRECIO CON IGV
                $o_COM_OrdenCompraDetalleDP->setPrecioUnitario( $f_PrecioUniSinIGV );          //SET DEL PRECIO SIN IGV

                if( $o_COM_OrdenCompraCabeceraBN->getIdMoneda() == "LO" )
                {
                    $o_COM_OrdenCompraDetalleDP->setCostoFinalSoles( $f_PrecioUniSinIGV );
                    $o_COM_OrdenCompraDetalleDP->setCostoFinalDolares( round( $f_PrecioUniSinIGV / $o_COM_OrdenCompraCabeceraBN->getTipoCambio(), 2 ) );
                }
                else
                {
                    $o_COM_OrdenCompraDetalleDP->setCostoFinalSoles( round( $f_PrecioUniSinIGV * $o_COM_OrdenCompraCabeceraBN->getTipoCambio(), 2 ) );
                    $o_COM_OrdenCompraDetalleDP->setCostoFinalDolares( $f_PrecioUniSinIGV );
                }

                $o_COM_OrdenCompraDetalleDP->setSubTotal( $f_PrecioSubTotal );              //SET DEL PRECIO SIN IGV
                $o_COM_OrdenCompraDetalleDP->setValorIGV( $f_MontoSubTotalImpuesto );
                $o_COM_OrdenCompraDetalleDP->setPrecioTotalConIGV( $f_PrecioTotalFinal );
                $o_COM_OrdenCompraDetalleDP->setDescuento( 0.00 );

                if( $this->getRequestParameter( 'IdLote' ) )
                {
                    $o_COM_OrdenCompraDetalleDP->setIdLote( $IdLote );
                }
                else
                {
                    $o_COM_OrdenCompraDetalleDP->setIdLote( "" );
                }
                if( $this->getRequestParameter( 'FechaVencimiento' ) )
                {
                    $o_COM_OrdenCompraDetalleDP->setFechaVencimiento( $FechaVencimiento );
                }

                //VALIDACION DE ITEM DUPLICADO
                $o_COM_OrdenCompraDetalleFN = new COM_OrdenCompraDetalleFN();
                $o_COM_OrdenCompraDetalleFN->setIdCompania( $IdCompania );
                $o_COM_OrdenCompraDetalleFN->setIdOrdenCompra( $IdOrdenCompra );
                $o_COM_OrdenCompraDetalleFN->setIdItem( $IdItem );
                //$o_COM_OrdenCompraDetalleFN->setIdLote( ALM_ItemAlmacenStockBN::LOTE_POR_DEFECTO );
                $a_COM_OrdenCompraDetalle = $o_COM_OrdenCompraDetalleFN->select();
                if( $a_COM_OrdenCompraDetalle )
                {
                    throw new Exception( "El Item ya se encuentra registrado." );
                }
                //////////////////////////////
                //INSERT
                $o_COM_OrdenCompraDetalleDP->setIdUnidad( $IdUnidad );
                $o_COM_OrdenCompraDetalleDP->setIGVExonerado( $NoAfecImpuesto );

                $i_Id = COM_OrdenCompraDetalleFN::recuperarId( $IdCompania, $IdOrdenCompra );
                $o_COM_OrdenCompraDetalleDP->setIdSecuencia( ( int ) $i_Id );
                //$o_COM_OrdenCompraDetalleDP->setIGVExonerado( $o_ALM_ItemMastBN->getNoAfectoImpuestoVentasFlag() );

                $o_COM_OrdenCompraDetalleDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                $o_COM_OrdenCompraDetalleDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                $o_COM_OrdenCompraDetalleDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $o_COM_OrdenCompraDetalleDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $o_COM_OrdenCompraDetalleDP->setEstado( COM_OrdenCompraCabeceraBN::ORDEN_COMPRA_PREPARACION ); //por defecto
                $b_Result = $o_COM_OrdenCompraDetalleDP->save();
                $i_Id = $IdCompania."_".$IdOrdenCompra."_".$i_Id;


            }

            COM_OrdenCompraCabeceraDP::actualizarCabaceraMontos( $IdCompania, $IdOrdenCompra );

            $con->commit();

            $a_Rs['error']   = false;
            $a_Rs['id']      = $i_Id;

        }
        catch ( Exception $o_Exception )
        {
            $con->rollback();
            $a_Rs['error']   = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }

        header( 'Content-Type: application/json' );
        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }
}
