<?php
$sDirBase = dirname(__FILE__).'/../../../../../';
require $sDirBase.'plugins/dompdf-master/vendor/autoload.php';

use Dompdf\Dompdf;
use Dompdf\Options;

class cajachicaActions extends wtActions
{

    public function executeCajaChicaResumenPDF()
    {
        $s_IdCaja   = $this->getRequestParameter( 'id_caja' );

        $s_Title = "Resumen de Caja Chica";
        $o_ALM_CajaChicaCabFN = new ALM_CajaChicaCabFN();
        $o_ALM_CajaChicaCabBN = $o_ALM_CajaChicaCabFN->selectByPK( $s_IdCaja );

        $f_MontoSumaDetalles = $o_ALM_CajaChicaCabBN->getMontoTotalDetalles();
        $f_MontoSaldoActual  = $o_ALM_CajaChicaCabBN->getMontoFondo() - $f_MontoSumaDetalles;

        $o_ALM_CajaChicaCabBN->setMontoSaldoAct( $f_MontoSaldoActual );

        $s_Class   = Parameter::getInstance()->getModule();
        $s_Module  = strtolower( $s_Class );
        $s_Action  = Parameter::getInstance()->getActions();
        $s_Methods = ucwords( $s_Action );

        $s_FileTemp = SF_ROOT_DIR.DIRECTORY_SEPARATOR.'apps'.DIRECTORY_SEPARATOR.SF_APP.DIRECTORY_SEPARATOR."modules".DIRECTORY_SEPARATOR.$s_Module.DIRECTORY_SEPARATOR."templates".DIRECTORY_SEPARATOR.$s_Action."Success.php";
        
        ob_start();
        require( $s_FileTemp );
        $html = ob_get_contents();
        ob_end_clean();

        //echo $html;         exit;

        $options = new Options();
        //$options->set( 'isRemoteEnabled', TRUE );
        $options->setIsPhpEnabled( true );

        //$dompdf = new Dompdf();
        $dompdf = new Dompdf( $options );
        $dompdf->loadHtml( $html );
        $dompdf->setPaper( 'A4', 'portrait' );
        $dompdf->render();

        //For Footer
        $canvas = $dompdf->get_canvas();
        $footer = $canvas->open_object();
        $font = "";
        $font_metrics = $dompdf->getFontMetrics();
        $font = $font_metrics->getFont( "helvetica", "bold" );
        //$canvas->page_text(35, 823, "HiveDesk Screenshot Report", $font, 8, array( 0, 0, 0 ) );
        $canvas->page_text( 250, 823, "Pagina:  {PAGE_NUM} of {PAGE_COUNT}", $font, 8, array( 0, 0, 0 ) );
        $canvas->page_text( 500, 823, date( "Y-m-d H:i:s" ), $font, 8, array( 0, 0, 0 ) );
        $canvas->close_object();
        $canvas->add_object( $footer, "all" );

        $dompdf->stream( 'Documento_', array( "Attachment" => 0 ) );
        
        exit;
    }

    public function executeList()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();

        $this->o_TMP_ALM_CajaChicaCabBN = ALM_CajaChicaCabFN::getActivoActual();
    }

    public function executeGrid()
    {
        $block = $this->getRequestParameter( 'block' );
        $page  = $this->getRequestParameter( 'page' );
        
        set_header_utf8();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $o_GridAction = new GridAction();
        $o_GridAction->setClassFind( new ALM_CajaChicaCabFN() );
        
        //$o_GridAction->addConditionFilter( "Nombre", ALM_CajaChicaCabFN::NomProv, "LIKE", "%%s%" );


        //$o_GridAction->addOrder( "Estado", MST_UbicacionFN::Estado );
        $o_GridAction->addOrderDefault( ALM_CajaChicaCabFN::IdCaja, false );

        /*if( $o_TMP_ALM_CajaChicaCabBN )
        {
            $o_GridAction->addMethodDefault( ALM_CajaChicaDetFN::IdCaja, array( 'Condition'=>'=', 'Value'=>$o_TMP_ALM_CajaChicaCabBN->getIdCaja() ) );
        }
        else
        {
            $o_GridAction->addMethodDefault( ALM_CajaChicaDetFN::IdCaja, array( 'Condition'=>'=', 'Value'=>0 ) );
        }*/
        
        $o_GridAction->addRowsToShow( "IdCaja", "FechaCaja", "FechaCierreCaja", "MontoFondo", "MontoSaldoAnt", "MontoIngreso", "Estado", "UsuarioCreacion" );
              
        $o_GridAction->setNumberRecordsShow( 100 );
        
        $o_GridAction->initialize();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $a_ResultJson['page']    = $o_GridAction->getPage();
        $a_ResultJson['total']   = $o_GridAction->getTotalPage();
        $a_ResultJson['records'] = $o_GridAction->getTotalRecords();
        $a_ResultJson['rows']    = $o_GridAction->getResultArray();
        //pr( $a_ResultJson );
        echo json_encode( $a_ResultJson );

        return ViewResponse::NONE;
    }

    public function executeCerrarCajaChica()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();

        $this->Error = false;
        $this->MensajeError = "";

        $this->s_Titulo = "Cierre Caja Chica";

        $this->s_IdCaja = $this->getRequestParameter( 'IdCaja' );

        //ahora culculamos el saldo actual
        $this->f_MontoTotalDetalles = 0;
        $this->f_MontoSaldoActual   = 0;

        $this->o_TMP_ALM_CajaChicaCabBN = ALM_CajaChicaCabFN::getActivoActual();
        if( !$this->o_TMP_ALM_CajaChicaCabBN )
        {
            $this->o_TMP_ALM_CajaChicaCabBN = new ALM_CajaChicaCabBN();
            $this->Error = true;
            $this->MensajeError = "No se puede cerrar Caja Chica, no se encontro Caja Activa.";
        }
        else
        {
            if( $this->s_IdCaja != $this->o_TMP_ALM_CajaChicaCabBN->getIdCaja() )
            {
                $this->Error = true;
                $this->MensajeError = "No se puede cerrar Caja Chica, al parecer no concuerdan los IDs";
            }

            $this->f_MontoTotalDetalles = $this->o_TMP_ALM_CajaChicaCabBN->getMontoTotalDetalles();
            $this->f_MontoSaldoActual   = $this->o_TMP_ALM_CajaChicaCabBN->getMontoFondo() - $this->f_MontoTotalDetalles;
        }
    }

    public function executeEjecutarCierreCaja()
    {
        $s_IdCaja = $this->getRequestParameter( 'IdCaja' );

        $a_Rs  = array( "error" => false );

        $s_FechaCierreCaja = date( "Y-m-d H:i:s" );        
        $f_MontoSaldoAct   = floatval( $this->getRequestParameter( 'MontoSaldoAct' ) );
        $s_Estado          = $this->getRequestParameter( 'Estado' );        

        try 
        {
            myUser::getUser()->validar_session();

            $o_TMP_ALM_CajaChicaCabBN = ALM_CajaChicaCabFN::getActivoActual();

            if( $s_IdCaja != $o_TMP_ALM_CajaChicaCabBN->getIdCaja() )
            {
                throw new Exception( "No se puede cerrar Caja Chica, al parecer no concuerdan los IDs" );
            }

            $o_ObjectDP = new ALM_CajaChicaCabDP();
            $o_ObjectDP->setIdCaja( ( int ) $s_IdCaja );
            $o_ObjectDP->setFechaCierreCaja( $s_FechaCierreCaja );
            $o_ObjectDP->setMontoSaldoAct( $f_MontoSaldoAct );
            $o_ObjectDP->setEnUsoFlag( "N" );
            $o_ObjectDP->setEstado( $s_Estado );
            $o_ObjectDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
            $o_ObjectDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
            $o_ObjectDP->update();

            $i_Id = ( int ) $s_IdCaja;

            $a_Rs['error']    = false;
            $a_Rs['id']       = $i_Id;
        }
        catch ( Exception $o_Exception )
        {
            $a_Rs['error']         = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }
        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }

    public function executeAddedit()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();

        $this->i_Id       = $this->getRequestParameter( 'i_Id' );
        $this->s_TipoProc = $this->getRequestParameter( 's_TipoProc' );

        $this->Error = false;
        $this->MensajeError = "";
        
        $this->s_Titulo = "Aperturar Caja Chica";

        $this->o_ALM_CajaChicaCabBN = new ALM_CajaChicaCabBN();

        if( $this->s_TipoProc == "upd" )
        {
            $this->s_Titulo = "Editar Caja";
            $o_ALM_CajaChicaCabFN = new ALM_CajaChicaCabFN();
            $this->o_ALM_CajaChicaCabBN = $o_ALM_CajaChicaCabFN->selectByPK( $this->i_Id );
            //aqui validamos que no tenga detalles
            if( $this->o_ALM_CajaChicaCabBN->getCantRegCajaChicaDetalle() )
            {
                $this->Error = true;
                $this->MensajeError = "Actualmente Existe Detalles asignados.";
            }

            $o_TMP_ALM_CajaChicaCabBN = ALM_CajaChicaCabFN::getActivoActual();
            if( !$o_TMP_ALM_CajaChicaCabBN )
            {
                $this->Error = true;
                $this->MensajeError = "No se encontro una caja chica abierto.";
            }
        }

        if( $this->s_TipoProc == "nvo" )
        {
            $this->o_ALM_CajaChicaCabBN->setFechaCaja( date( "Y-m-d" ) );
            $o_TMP_ALM_CajaChicaCabBN = ALM_CajaChicaCabFN::getActivoActual();
            if( $o_TMP_ALM_CajaChicaCabBN )
            {
                $this->Error = true;
                $this->MensajeError = "Actualmente Existe una Caja Abierta";
            }

            //ahora se busca el ultimo registro para recuperar su saldo anterior
            $o_ALM_CajaChicaCabBN = ALM_CajaChicaCabFN::getObjectCajaChicaCabFinal();
            if( $o_ALM_CajaChicaCabBN )
            {
                $this->o_ALM_CajaChicaCabBN->setMontoSaldoAnt( $o_ALM_CajaChicaCabBN->getMontoSaldoAct() );
            }
        }
    }

    public function executeSaveAddEdit()
    {
        $i_Id       = $this->getRequestParameter( 'i_Id' );
        $s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        $TypeSub    = $this->getRequestParameter( 'TypeSub' );

        $a_Rs  = array( "error" => false );

        $s_FechaCaja    = $this->getRequestParameter( 'FechaCaja' );
        $f_MontoFondo   = floatval( $this->getRequestParameter( 'MontoFondo' ) );
        $f_MontoSaldo   = floatval( $this->getRequestParameter( 'MontoSaldo' ) );
        $f_MontoIngreso = floatval( $this->getRequestParameter( 'MontoIngreso' ) );
        $s_Estado       = $this->getRequestParameter( 'Estado' );
        //$s_Descripcion     = $this->getRequestParameter( 'Descripcion' );
        //$s_IdTipoUbicacion = $this->getRequestParameter( 'IdTipoUbicacion' );

        $f_MontoFondo = $f_MontoIngreso + $f_MontoSaldo;

        $con = Conexion::getConexion();
        $con->begin();
        try 
        {
            myUser::getUser()->validar_session();

            $o_TMP_ALM_CajaChicaCabBN = ALM_CajaChicaCabFN::getActivoActual();

            $o_ObjectDP = new ALM_CajaChicaCabDP();
            $o_ObjectDP->setIdCompania( myUser::getUser()->getIdBusiness() );
            $o_ObjectDP->setIdSucursal( myUser::getUser()->getIdSucursal() );
            $o_ObjectDP->setFechaCaja( $s_FechaCaja." ".date( "H:i:s" ) );

            $o_ObjectDP->setMontoFondo( $f_MontoFondo );
            $o_ObjectDP->setMontoIngreso( $f_MontoIngreso );
            $o_ObjectDP->setMontoSaldoAnt( $f_MontoSaldo );
            $o_ObjectDP->setMontoSaldoAct( 0 );

            $s_ValorAnterior = "";
            $s_ValorNuevo    = $f_MontoFondo;
            $b_ControlLog    = true;

            if( $s_TipoProc == "nvo" )
            {
                $o_ObjectDP->setEstado( $s_Estado );
                //cuando es nuevo se considera apertura de caja
                //primero se cambia el flag
                if( $o_TMP_ALM_CajaChicaCabBN )
                {
                    $s_ValorAnterior = $o_TMP_ALM_CajaChicaCabBN->getMontoFondo();

                    $o_ALM_CajaChicaCabDP = new ALM_CajaChicaCabDP();
                    $o_ALM_CajaChicaCabDP->setIdCaja( $o_TMP_ALM_CajaChicaCabBN->getIdCaja() );
                    $o_ALM_CajaChicaCabDP->setEnUsoFlag( "N" );
                    $o_ALM_CajaChicaCabDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                    $o_ALM_CajaChicaCabDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                    $o_ALM_CajaChicaCabDP->update();
                }

                //nuevo
                $i_IdTabla = ALM_CajaChicaCabDP::recuperarId();
                $o_ObjectDP->setIdCaja( $i_IdTabla );
                $o_ObjectDP->setEnUsoFlag( "S" );
                $o_ObjectDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                $o_ObjectDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                $o_ObjectDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $o_ObjectDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $b_Result = $o_ObjectDP->save();
                $i_Id = $i_IdTabla;
            }
            else
            {
                //pr( "entra" );
                $o_TMP_ALM_CajaChicaCabFN = new ALM_CajaChicaCabFN();
                $o_TMP_ALM_CajaChicaCabBN = $o_TMP_ALM_CajaChicaCabFN->selectByPK( $i_Id );
                //pr( $o_TMP_ALM_CajaChicaCabBN );
                if( $o_TMP_ALM_CajaChicaCabBN->getMontoFondo() != $f_MontoFondo )
                {
                    //si los montos son diferentes se registra el log
                    $s_ValorAnterior = $o_TMP_ALM_CajaChicaCabBN->getMontoFondo();
                }
                else
                {
                    //pero si no hay cambios en los montos, no se registra el log
                    $b_ControlLog = false;
                }

                //actualizar
                $o_ObjectDP->setIdCaja( intval( $i_Id ) );
                $o_ObjectDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $o_ObjectDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $b_Result = $o_ObjectDP->update();
            }

            if( $b_ControlLog )
            {
                //pr( "entra2" );
                //ahora se registra en el Log
                $o_ALM_CajaChicaLogDP = new ALM_CajaChicaLogDP();
                $o_ALM_CajaChicaLogDP->setIdCajaLog( ALM_CajaChicaLogDP::recuperarId() );
                $o_ALM_CajaChicaLogDP->setIdCaja( ( int ) $i_Id );
                $o_ALM_CajaChicaLogDP->setTipoLog( 1 );
                $o_ALM_CajaChicaLogDP->setValorAnterior( ( string ) $s_ValorAnterior );
                $o_ALM_CajaChicaLogDP->setValorNuevo( ( string ) $s_ValorNuevo );
                $o_ALM_CajaChicaLogDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                $o_ALM_CajaChicaLogDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                $o_ALM_CajaChicaLogDP->save();
            }

            /*
            $o_ALM_CajaChicaLogDP = new ALM_CajaChicaLogDP();
            $o_ALM_CajaChicaLogDP->setIdCajaLog( ALM_CajaChicaLogDP::recuperarId() );
            $o_ALM_CajaChicaLogDP->setIdCaja( $i_Id );
            $o_ALM_CajaChicaLogDP->setTipoLog( 2 );
            $o_ALM_CajaChicaLogDP->setValorAnterior(  );
            $o_ALM_CajaChicaLogDP->setValorNuevo(  );
            $o_ALM_CajaChicaLogDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
            $o_ALM_CajaChicaLogDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
            $o_ALM_CajaChicaLogDP->save();
            */

            $con->commit();

            $a_Rs['type_sub'] = $TypeSub;
            $a_Rs['error']    = false;
            $a_Rs['id']       = $i_Id;
        }
        catch ( Exception $o_Exception )
        {
            $con->rollback();
            $a_Rs['error']         = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }
        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }

    public function executeListDetalles()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();

        $this->o_TMP_ALM_CajaChicaCabBN = ALM_CajaChicaCabFN::getActivoActual();
    }

    public function executeRegCajaDet()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();

        $this->i_Id       = $this->getRequestParameter( 'i_Id' );
        $this->s_TipoProc = $this->getRequestParameter( 's_TipoProc' );

        $this->o_ObjectBN = new ALM_CajaChicaDetBN();
        $this->o_ObjectBN->setFechaDocumento( date( "Y-m-d" ) );

        $this->s_Titulo = "Registrar Caja Chica Detalles";
        if( $this->s_TipoProc == "upd" )
        {

        }
        if( $this->s_TipoProc == "shw" )
        {
            $this->s_Titulo = "Caja Chica Detalles";

            $o_ALM_CajaChicaDetFN = new ALM_CajaChicaDetFN();
            $this->o_ObjectBN = $o_ALM_CajaChicaDetFN->selectByPK( $this->i_Id );
        }

        $o_ALM_TipoDocumentoFN = new ALM_TipoDocumentoFN(); //PARA DOCUMENTO DE REFENCIA
        $o_ALM_TipoDocumentoFN->setEstado( "A" );
        $o_ALM_TipoDocumentoFN->setTransaccionSistemaFlag( "S" );
        $this->a_ALM_TipoDocumento = $o_ALM_TipoDocumentoFN->select();
    }

    public function executeGridDetalles()
    {
        $block = $this->getRequestParameter( 'block' );
        $page  = $this->getRequestParameter( 'page' );
        
        set_header_utf8();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $o_GridAction = new GridAction();
        $o_GridAction->setClassFind( new ALM_CajaChicaDetFN() );
        
        $o_GridAction->addConditionFilter( "Nombre", ALM_CajaChicaDetFN::NomProv, "LIKE", "%%s%" );

        $o_TMP_ALM_CajaChicaCabBN = ALM_CajaChicaCabFN::getActivoActual();

        //$o_GridAction->addOrder( "Estado", MST_UbicacionFN::Estado );
        //$o_GridAction->addOrderDefault( MST_UbicacionFN::IdUbicacion, true );

        if( $o_TMP_ALM_CajaChicaCabBN )
        {
            $o_GridAction->addMethodDefault( ALM_CajaChicaDetFN::IdCaja, array( 'Condition'=>'=', 'Value'=>$o_TMP_ALM_CajaChicaCabBN->getIdCaja() ) );
        }
        else
        {
            $o_GridAction->addMethodDefault( ALM_CajaChicaDetFN::IdCaja, array( 'Condition'=>'=', 'Value'=>0 ) );
        }

        $o_GridAction->addOrderDefault( ALM_CajaChicaDetFN::IdCajaDet, false );
        
        $o_GridAction->addRowsToShow( "IdCajaDet", "NumDocProv", "NomProv", "MontoTotal", "ConcatReferenciaDoc" );
              
        $o_GridAction->setNumberRecordsShow( 100 );
        
        $o_GridAction->initialize();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $a_ResultJson['page']    = $o_GridAction->getPage();
        $a_ResultJson['total']   = $o_GridAction->getTotalPage();
        $a_ResultJson['records'] = $o_GridAction->getTotalRecords();
        $a_ResultJson['rows']    = $o_GridAction->getResultArray();
        //pr( $a_ResultJson );
        echo json_encode( $a_ResultJson );

        return ViewResponse::NONE;
    }


}