<?php
class asoguiasActions extends wtActions
{
    public function executeDocrefList()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        
        $o_MST_PersonaMastFN = new MST_PersonaMastFN();
        $o_MST_PersonaMastFN->setEsProveedor( "SI" );
        $o_MST_PersonaMastFN->addOrderBy( MST_PersonaMastFN::NombreCompleto );
        $this->a_MST_PersonaMast = $o_MST_PersonaMastFN->select();
        
        $this->IdProveedor = $this->getRequestParameter( 'IdProveedor' );
    }
    
    public function executeDocrefGrid()
    {
        $o_GridAction = new GridAction();
        $o_GridAction->setClassFind( new CP_ObligacionesFN() );
        
        $o_GridAction->addAssignFilter( "ProveedorId" );
        $o_GridAction->addAssignFilter( "IdTipoDocumento" );
        
        $o_GridAction->addConditionFilter( "FechaDocumento1", CP_ObligacionesFN::FechaEmision,    "=" );
        $o_GridAction->addConditionFilter( "NumeroFactura", CP_ObligacionesFN::DocumentoSerieNumero, "LIKE", "%%s%" );
        
        $o_GridAction->addOrderDefault( CP_ObligacionesFN::ObligacionesId, true );
        
        $o_GridAction->addRowsToShow( "ObligacionesId", "ProveedorId", "FechaEmision", "MontoAfecto", "MontoIGV", "MontoTotal", "ProveedorNombre", "TipoDocumentoDesc", "DocumentoSerieNumero" );
        
        $o_GridAction->setNumberRecordsShow( 100 );
        
        $o_GridAction->initialize();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        
        $a_ResultJson['page']    = $o_GridAction->getPage();
        $a_ResultJson['total']   = $o_GridAction->getTotalPage();
        $a_ResultJson['records'] = $o_GridAction->getTotalRecords();
        $a_ResultJson['rows']    = $o_GridAction->getResultArray();
        //pr( $a_ResultJson );
        echo json_encode( $a_ResultJson );
        
        return ViewResponse::NONE;
    }
    
    public function executeList()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        
        $o_MST_PersonaMastFN = new MST_PersonaMastFN();
        $o_MST_PersonaMastFN->setEsProveedor( "SI" );
        $o_MST_PersonaMastFN->addOrderBy( MST_PersonaMastFN::NombreCompleto );
        $this->a_MST_PersonaMast = $o_MST_PersonaMastFN->select();
        
        //ALMACEN
        $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
        $o_ALM_AlmacenMastFN->setEstado( "A" );
        $o_ALM_AlmacenMastFN->addOrderBy( ALM_AlmacenMastFN::DescripcionLocal );
        $this->a_ALM_AlmacenMast = $o_ALM_AlmacenMastFN->select();
        
        $this->a_Estados = ALM_OrdenGuiaFacturaBN::getArrayEstados();
        
        $this->a_Series = ALM_OrdenGuiaFacturaFN::recuperarFiltroSerie();
    }
    
    public function executeGrid()
    {
        $this->IdPersona    = $this->getRequestParameter( 'IdPersona' );
        $this->i_IdCompania = myUser::getUser()->getIdBusiness();
        
        $o_GridAction = new GridAction();
        $o_GridAction->setClassFind( new ALM_OrdenGuiaFacturaFN() );
        
        //parametros
        if( $this->getRequestParameter( 'NumeroFact' ) )
        {
            $s_NumeroFact = $this->getRequestParameter( 'NumeroFact' );
            $s_NumeroFact = str_pad( $this->getRequestParameter( 'NumeroFact' ), 10, "0", STR_PAD_LEFT );
            ParameterWR::getInstance()->setVar( "NumeroFactura", $s_NumeroFact );
        }
        $o_GridAction->addAssignFilter( "SerieFactura" );
        $o_GridAction->addAssignFilter( "NumeroFactura" );
        
        if( $this->getRequestParameter( 'NumeroGuiaPer' ) )
        {
            $s_NumeroGuia = $this->getRequestParameter( 'NumeroGuiaPer' );
            $s_NumeroGuia = str_pad( $this->getRequestParameter( 'NumeroGuiaPer' ), 10, "0", STR_PAD_LEFT );
            ParameterWR::getInstance()->setVar( "NumeroGuia", $s_NumeroGuia );
        }
        $o_GridAction->addAssignFilter( "SerieGuia" );
        $o_GridAction->addAssignFilter( "NumeroGuia" );
        
        ///////
        $o_GridAction->addMethodDefault( "IdCompania", myUser::getUser()->getIdBusiness() );
        
        $o_GridAction->addAssignFilter( "IdOrdenCompra" );
        $o_GridAction->addAssignFilter( "IdPersona" );
        $o_GridAction->addAssignFilter( "IdAlmacen" );
        
        $o_GridAction->addAssignFilter( "Estado" );
        //$o_GridAction->addConditionFilter( "Estado", "IN", "( 'A', 'P' )", false );
        //$o_GridAction->addMethodDefault( ALM_OrdenGuiaFacturaFN::Estado, ALM_OrdenGuiaFacturaBN::ESTADO_ASOCIADO );
        //ParameterWR::getInstance()->setVar( "Estado", "1" );
        //$o_GridAction->addConditionFilter( "Estado", ALM_OrdenGuiaFacturaFN::Estado, "IN", "('A','P')"  );
        
        
        //$o_GridAction->addConditionFilter( "FechaDocumento1", ALM_OrdenGuiaFacturaFN::FechaFactura,    ">=" );
        $o_GridAction->addConditionFilter( "FechaDocumento1", ALM_OrdenGuiaFacturaFN::FechaGuia,    ">=" );
        //$o_GridAction->addConditionFilter( "FechaDocumento2", ALM_OrdenGuiaFacturaFN::FechaFactura,    "<=" );
        $o_GridAction->addConditionFilter( "FechaDocumento2", ALM_OrdenGuiaFacturaFN::FechaGuia,    "<=" );
        
        //$o_GridAction->addConditionFilter( "NumeroGuia", "CONCAT(SerieGuia,'-',NumeroGuia)",  "=" );
        
        //$o_GridAction->addOrderDefault( ALM_OrdenGuiaFacturaFN::IdOrdenCompra, true );
        //$o_GridAction->addOrderDefault( "CONCAT(SerieFactura,'-',NumeroFactura)", false );
        
        $o_GridAction->addOrderDefault( ALM_OrdenGuiaFacturaFN::IdOrdenGuia, true );  //solo para ordenamientos por la cabecera de la grilla
        
        $o_GridAction->setControlArray( false );
        
        //$o_GridAction->addRowsToShow( "IdCompania" );
        
        $o_GridAction->setNumberRecordsShow( 300 );
        
        $o_GridAction->initialize();
        
        $a_ResultJson['page']    = $o_GridAction->getPage();
        $a_ResultJson['total']   = $o_GridAction->getTotalPage();
        $a_ResultJson['records'] = $o_GridAction->getTotalRecords();
        //$a_ResultJson['rows']    = $o_GridAction->getResultArray();
        $a_ALM_OrdenGuiaFactura = $o_GridAction->getResultSelect();
        
        $a_Grid = array();
        foreach ( $a_ALM_OrdenGuiaFactura as $i_Key => $o_ALM_OrdenGuiaFacturaBN )
        {
            /*if( $o_ALM_OrdenGuiaFacturaBN->getEstado() != ALM_OrdenGuiaFacturaBN::ESTADO_POR_INGRESAR )
            {*/
                /*$a_Grid[] = array
                            (
                                "IdConcat"           => array( "valor" => $o_ALM_OrdenGuiaFacturaBN->getIdConcat(), "rowspan" => 1 ),
                                "SucursalDesc"       => array( "valor" => $o_ALM_OrdenGuiaFacturaBN->getSucursalDesc(), "rowspan" => 1 ),
                                "ProveedorDes"       => array( "valor" => $o_ALM_OrdenGuiaFacturaBN->getProveedorDes(), "rowspan" => 1 ),
                                "IdCompania"         => array( "valor" => $o_ALM_OrdenGuiaFacturaBN->getIdCompania(), "rowspan" => 1 ),
                                "IdOrdenCompra"      => array( "valor" => $o_ALM_OrdenGuiaFacturaBN->getIdOrdenCompra(), "rowspan" => 1 ),
                                "FechaOrdenCompra"   => array( "valor" => substr( $o_ALM_OrdenGuiaFacturaBN->getFechaOrdenCompra(), 0, 10 ), "rowspan" => 1 ),
                                "SerieGuiaConcat"    => array( "valor" => $o_ALM_OrdenGuiaFacturaBN->getSerieGuiaConcat(), "rowspan" => 1 ),
                                "EstadoDesc"         => array( "valor" => $o_ALM_OrdenGuiaFacturaBN->getEstadoDesc(), "rowspan" => 1 ),
                                "Estado"             => array( "valor" => $o_ALM_OrdenGuiaFacturaBN->getEstado(), "rowspan" => 1 ),
                                "SerieFacturaConcat" => array( "valor" => $o_ALM_OrdenGuiaFacturaBN->getSerieFacturaConcat(), "rowspan" => 1 ),
                                "FechaFactura"       => array( "valor" => $o_ALM_OrdenGuiaFacturaBN->getFechaFactura(), "rowspan" => 1 ),
                                "MontoFactura"       => array( "valor" => $o_ALM_OrdenGuiaFacturaBN->getMontoFactura(), "rowspan" => 1 ),
                                "IGVFactura"         => array( "valor" => $o_ALM_OrdenGuiaFacturaBN->getIGVFactura(), "rowspan" => 1 ),
                                "TotalFactura"       => array( "valor" => $o_ALM_OrdenGuiaFacturaBN->getTotalFactura(), "rowspan" => 1 ),
                                "Button"             => array( "valor" => false, "rowspan" => 0 )
                            );*/
                $a_Grid[] = array
                            (
                                    "IdConcat"           => $o_ALM_OrdenGuiaFacturaBN->getIdConcat(),
                                    "SucursalDesc"       => $o_ALM_OrdenGuiaFacturaBN->getSucursalDesc(),
                                    "ProveedorDes"       => $o_ALM_OrdenGuiaFacturaBN->getProveedorDes(),
                                    "IdCompania"         => $o_ALM_OrdenGuiaFacturaBN->getIdCompania(),
                                    "IdOrdenCompra"      => $o_ALM_OrdenGuiaFacturaBN->getIdOrdenCompra(),
                                    "FechaOrdenCompra"   => substr( $o_ALM_OrdenGuiaFacturaBN->getFechaOrdenCompra(), 0, 10 ),
                                    "SerieGuiaConcat"    => $o_ALM_OrdenGuiaFacturaBN->getSerieGuiaConcat(),
                                    "EstadoDesc"         => $o_ALM_OrdenGuiaFacturaBN->getEstadoDesc(),
                                    "Estado"             => $o_ALM_OrdenGuiaFacturaBN->getEstado(),
                                    "SerieFacturaConcat" => $o_ALM_OrdenGuiaFacturaBN->getSerieFacturaConcat(),
                                    "FechaFactura"       => $o_ALM_OrdenGuiaFacturaBN->getFechaFactura(),
                                    "MontoFactura"       => $o_ALM_OrdenGuiaFacturaBN->getMontoFactura(),
                                    "IGVFactura"         => $o_ALM_OrdenGuiaFacturaBN->getIGVFactura(),
                                    "TotalFactura"       => $o_ALM_OrdenGuiaFacturaBN->getTotalFactura(),
                                    "OrdenClasificacion" => $o_ALM_OrdenGuiaFacturaBN->getObjectOrdenCompra()->getOrdenClasificacionDesc(),
                                    
                                    "TipoDoc"               => $o_ALM_OrdenGuiaFacturaBN->getTipoDoc(),
                                    "IdOrdenGuiaReferencia" => $o_ALM_OrdenGuiaFacturaBN->getIdOrdenGuiaReferencia(),
                                    "DocRefxNCR"            => $o_ALM_OrdenGuiaFacturaBN->getTipoDoc()=="NC" ? $o_ALM_OrdenGuiaFacturaBN->getObjectOrdenGuiaReferencia()->getSerieFacturaConcat() : "",
                                    "IdTipoDocumentoRef"    => $o_ALM_OrdenGuiaFacturaBN->getIdTipoDocumentoRef(),
                                    "IdNumeroDocumentoRef"  => $o_ALM_OrdenGuiaFacturaBN->getIdNumeroDocumentoRef(),
                            );
            /*}*/
        }
        
        //$this->buscarRowspanGrid( $a_Grid, "SerieFacturaConcat" );
        //$this->buscarRowspanGrid( $a_Grid, "FechaFactura" );
        //$this->buscarRowspanGrid( $a_Grid, "MontoFactura" );
        //$this->buscarRowspanGrid( $a_Grid, "IGVFactura" );
        //$this->buscarRowspanGrid( $a_Grid, "TotalFactura" );
        
        $this->a_ALM_OrdenGuiaFactura = $a_Grid;
        //pr( $a_Grid );
        
        ViewResponse::getInstance()->setMethodAjax();
    }
    
    private function buscarRowspanGrid( &$a_Grid, $NombreCampo )
    {
        $a_EnLista = array( $NombreCampo => array() );
        foreach ( $a_Grid as $i_Key => &$a_Valores )
        {
            if( $a_Valores['Estado']['valor'] == "A" )
            {
                //COLUMNA -> IdOrdenCompra
                $i_CntRowspan = $this->contarRowspanxColumna( $a_Grid, $NombreCampo, $a_Valores[$NombreCampo]['valor'], $i_Key );
                if( $i_CntRowspan > 1 )
                {
                    if( !in_array( $a_Valores[$NombreCampo]['valor'], $a_EnLista[$NombreCampo] ) )
                    {
                        $a_EnLista[$NombreCampo][] = $a_Valores[$NombreCampo]['valor'];
                        $a_Valores[$NombreCampo]['rowspan'] = $i_CntRowspan;
                        $a_Valores["Button"]['rowspan'] = $i_CntRowspan;
                        $a_Valores["Button"]['valor'] = true;
                    }
                    else 
                    {
                        $a_Valores[$NombreCampo]['rowspan'] = 0;
                    }
                }
                ////////////////////////////////////////////////////////
            }
        }
    }
    
    private function contarRowspanxColumna( $a_Grid, $s_Key, $s_ValorFnd, $i_NotKey )
    {
        $i_Rowspan = 1;
        foreach ( $a_Grid as $i_Key => $a_Valores )
        {
            if( $i_NotKey != $i_Key )
            {
                $s_Valor = $a_Valores[$s_Key]['valor'];
                if( $s_ValorFnd == $s_Valor )
                {
                    $i_Rowspan++;
                }
            }
        }
        return $i_Rowspan;
    }
    
    public function executeAsociarFact()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        
        $this->s_IdDet    = $this->getRequestParameter( 'IdDet' );
        $this->s_TipoProc = $this->getRequestParameter( 'TipoProc' );
        $b_FlagFactura    = $this->getRequestParameter( 'FlagFactura' );
        
        $f_Inafecto   = 0;
        $f_SubTotal   = 0;
        $f_IgvTotal   = 0;
        $f_BrutoTotal = 0;
        
        $this->s_SerieFactura  = "";
        $this->s_NumeroFactura = "";
        $this->d_FechaFactura  = "";
        $this->s_Comentario    = "";
        
        if( $this->s_IdDet )
        {
            $a_Ids = explode( ",", $this->s_IdDet );
            foreach ( $a_Ids as $i_Key => $s_IdDetalle )
            {
                $a_IdConcat = explode( "_", $s_IdDetalle );
            
                $IdCompania    = myUser::getUser()->getIdCompania();
                $IdSucursal    = myUser::getUser()->getIdSucursal();
                $IdAlmacen     = $a_IdConcat[0];
                $IdOrdenCompra = ( int ) $a_IdConcat[1];
                $IdPersona     = ( int ) $a_IdConcat[2];
                $SerieGuia     = $a_IdConcat[3];
                $NumeroGuia    = $a_IdConcat[4];
                
                $o_COM_OrdenCompraCabeceraFN = new COM_OrdenCompraCabeceraFN();
                $o_COM_OrdenCompraCabeceraBN = $o_COM_OrdenCompraCabeceraFN->selectByPK( $IdCompania, $IdOrdenCompra );
                if( $o_COM_OrdenCompraCabeceraBN )
                {
                    $f_MontoAfectoNoAfecto = $o_COM_OrdenCompraCabeceraBN->getMontoAfecto() + $o_COM_OrdenCompraCabeceraBN->getMontoNoAfecto();
                    $f_MontoIGV            = $o_COM_OrdenCompraCabeceraBN->getMontoIGV();
                    $f_MontoBruto          = $o_COM_OrdenCompraCabeceraBN->getMontoBruto();
                    
                    $f_SubTotal   = $f_SubTotal   + $f_MontoAfectoNoAfecto;
                    $f_IgvTotal   = $f_IgvTotal   + $f_MontoIGV;
                    $f_BrutoTotal = $f_BrutoTotal + $f_MontoBruto;
                }
                if( $b_FlagFactura ) //AQUI ENTRA, SI SE LLAMADA DESDE RECEPCION
                {
                    $s_Secuencias = $this->getRequestParameter( 'secuencia' );
                    $a_IdSecuencias = explode( "_", $s_Secuencias );
                    
                    $f_SumaSubTotal = 0.00;
                    $f_SumaMontoIGV = 0.00;
                    $f_SumaMontoTotal = 0.00;
                    
                    foreach ( $a_IdSecuencias as $i_Key => $i_IdSecuencia )
                    {
                        $o_COM_OrdenCompraDetalleFN = new COM_OrdenCompraDetalleFN();
                        $o_COM_OrdenCompraDetalleBN = $o_COM_OrdenCompraDetalleFN->selectByPK( $IdOrdenCompra, $IdCompania, $i_IdSecuencia );
                        if( $o_COM_OrdenCompraDetalleBN )
                        {
                            //pr( $o_COM_OrdenCompraDetalleBN );
                            $f_SumaSubTotal = $f_SumaSubTotal + $o_COM_OrdenCompraDetalleBN->getSubTotal();
                            $f_SumaMontoIGV = $f_SumaMontoIGV + $o_COM_OrdenCompraDetalleBN->getValorIGV();
                            $f_SumaMontoTotal = $f_SumaMontoTotal + $o_COM_OrdenCompraDetalleBN->getPrecioTotalConIGV();
                        }
                    }
                    
                    $f_SubTotal   = utilMath::fnround( $f_SumaSubTotal, 2   );
                    $f_IgvTotal   = utilMath::fnround( $f_SumaMontoIGV, 2   );
                    $f_BrutoTotal = utilMath::fnround( $f_SumaMontoTotal, 2   );
                }
            }
        }
        
        $this->f_Inafecto   = $f_Inafecto;
        $this->f_SubTotal   = $f_SubTotal;
        $this->f_IgvTotal   = $f_IgvTotal;
        $this->f_BrutoTotal = $f_BrutoTotal;
    }
    
    public function executeDesasociarFact()
    {
        $s_SerieNumFact = $this->getRequestParameter( 'SerieNumFact' );
        
        $o_ALM_OrdenGuiaFacturaFN = new ALM_OrdenGuiaFacturaFN();
        $o_ALM_OrdenGuiaFacturaFN->addCondition( "CONCAT( TipoDoc,' ',SerieFactura,'-',NumeroFactura)", "=", $s_SerieNumFact );
        $this->a_ALM_OrdenGuiaFactura = $o_ALM_OrdenGuiaFacturaFN->select();
        if( !$this->a_ALM_OrdenGuiaFactura )
        {
            $this->a_ALM_OrdenGuiaFactura = array();
        }
        //pr( $this->a_ALM_OrdenGuiaFactura );
    }
    
    public function executeSaveAssoc()
    {
        $block      = $this->getRequestParameter( 'block' );
        $i_Id       = $this->getRequestParameter( 'id' );
        $s_IdDet    = $this->getRequestParameter( 'IdDet' );
        $s_TipoProc = $this->getRequestParameter( 'TipoProc' );
        $TypeSub    = $this->getRequestParameter( 'TypeSub' );
        
        $SerieFactura  = str_pad( $this->getRequestParameter( 'SerieFactura' ), 4, "0", STR_PAD_LEFT );
        $NumeroFactura = str_pad( $this->getRequestParameter( 'NumeroFactura' ), 10, "0", STR_PAD_LEFT );
        $FechaFactura  = $this->getRequestParameter( 'FechaFactura' );
        $Inafecto      = floatval( $this->getRequestParameter( 'MontoFacturaInafecto' ) );
        $MontoFactura  = floatval( $this->getRequestParameter( 'MontoFactura' ) );
        $IGVFactura    = floatval( $this->getRequestParameter( 'IGVFactura' ) );
        $TotalFactura  = floatval( $this->getRequestParameter( 'TotalFactura' ) );
        $Comentario    = $this->getRequestParameter( 'Comentario' );
        
        $TipoDoc       = $this->getRequestParameter( 'TipoDoc' );
        
        $Secuencia     = $this->getRequestParameter( 'Secuencia' );

        $a_Rs = array();
        
        $con = Conexion::getConexion();
        $con->begin();
        try
        {
            myUser::getUser()->validar_session();
            
            //VALIDACION DE FECHA
            $b_FechaValid = UtilDate::validar_fecha( $FechaFactura );
            if( !$b_FechaValid )
            {
                throw new Exception( "Por favor ingrese una fecha Valida." );
            }
            /////////////////////
            $a_Ids = explode( ",", $s_IdDet );
            foreach ( $a_Ids as $s_IdDetalle )
            {
                $a_IdConcat = explode( "_", $s_IdDetalle );
                
                $IdCompania    = myUser::getUser()->getIdCompania();
                $IdSucursal    = myUser::getUser()->getIdSucursal();
                $IdAlmacen     = $a_IdConcat[0];
                $IdOrdenCompra = ( int ) $a_IdConcat[1];
                $IdPersona     = ( int ) $a_IdConcat[2];
                $SerieGuia     = $a_IdConcat[3];
                $NumeroGuia    = $a_IdConcat[4];
                $Secuencia     = isset( $a_IdConcat[5] ) ? $a_IdConcat[5] : 1;
                
                //SE BUSCA LA OC COMO REFERENCIA
                //$o_COM_OrdenCompraCabeceraFN = new COM_OrdenCompraCabeceraFN();
                //$o_COM_OrdenCompraCabeceraBN = $o_COM_OrdenCompraCabeceraFN->selectByPK( $IdCompania, $IdOrdenCompra );
                
                $o_ALM_OrdenGuiaFacturaDP = new ALM_OrdenGuiaFacturaDP();
                $o_ALM_OrdenGuiaFacturaDP->setIdCompania( $IdCompania );
                $o_ALM_OrdenGuiaFacturaDP->setIdSucursal( $IdSucursal );
                $o_ALM_OrdenGuiaFacturaDP->setIdAlmacen( $IdAlmacen );
                $o_ALM_OrdenGuiaFacturaDP->setIdOrdenCompra( $IdOrdenCompra );
                $o_ALM_OrdenGuiaFacturaDP->setIdPersona( $IdPersona );
                $o_ALM_OrdenGuiaFacturaDP->setSerieGuia( $SerieGuia );
                $o_ALM_OrdenGuiaFacturaDP->setFechaGuia( date( "Y-m-d" ) );
                $o_ALM_OrdenGuiaFacturaDP->setNumeroGuia( $NumeroGuia );
                
                $o_ALM_OrdenGuiaFacturaDP->setTipoDoc( $TipoDoc );
                $o_ALM_OrdenGuiaFacturaDP->setSerieFactura( $SerieFactura );
                $o_ALM_OrdenGuiaFacturaDP->setNumeroFactura( $NumeroFactura );
                $o_ALM_OrdenGuiaFacturaDP->setFechaFactura( $FechaFactura );
                $o_ALM_OrdenGuiaFacturaDP->setMontoFacturaInafecto( $Inafecto );
                $o_ALM_OrdenGuiaFacturaDP->setMontoFactura( $MontoFactura );
                $o_ALM_OrdenGuiaFacturaDP->setIGVFactura( $IGVFactura );
                $o_ALM_OrdenGuiaFacturaDP->setTotalFactura( $TotalFactura );
                $o_ALM_OrdenGuiaFacturaDP->setComentario( $Comentario );
                if( $s_TipoProc == "nvo" )
                {
                    $i_Id = ALM_OrdenGuiaFacturaDP::generarId();
	            	
                    $o_ALM_OrdenGuiaFacturaDP->setIdOrdenGuia( $i_Id );
                	$o_ALM_OrdenGuiaFacturaDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                	$o_ALM_OrdenGuiaFacturaDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                	$o_ALM_OrdenGuiaFacturaDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                	$o_ALM_OrdenGuiaFacturaDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                	$o_ALM_OrdenGuiaFacturaDP->setEstado( "X" );
                	$o_ALM_OrdenGuiaFacturaDP->save();
                }
                else 
                {
                    $o_ALM_OrdenGuiaFacturaDP->setIdOrdenGuia( intval( $i_Id ) );
                    $o_ALM_OrdenGuiaFacturaDP->setSecuencia( ( int ) $Secuencia );
                    $o_ALM_OrdenGuiaFacturaDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                	$o_ALM_OrdenGuiaFacturaDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                	$o_ALM_OrdenGuiaFacturaDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
	                $o_ALM_OrdenGuiaFacturaDP->setEstado( "A" );
	                $o_ALM_OrdenGuiaFacturaDP->update();
                }
            }
            
            $con->commit();
            
            //$a_Rs['secuencia']   = $Secuencia;
            $a_Rs['id']          = $i_Id;
            $a_Rs['fact_serie']  = $SerieFactura;
            $a_Rs['fact_numero'] = $NumeroFactura;
            $a_Rs['type_sub']    = $TypeSub;
            $a_Rs['error']       = false;
        }
        catch ( Exception $o_Exception )
        {
            $con->rollback();
            $a_Rs['error']        = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }
        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }
    
    public function executeSaveDeAssoc()
    {
        $s_IdConcat    = $this->getRequestParameter( 'IdConcat' );
        
        $con = Conexion::getConexion();
        $con->begin();
        try
        {
            $o_ALM_OrdenGuiaFacturaDP = new ALM_OrdenGuiaFacturaDP();
            $o_ALM_OrdenGuiaFacturaDP->setIdOrdenGuia( ( int ) $s_IdConcat );
            
            $b_Result = $o_ALM_OrdenGuiaFacturaDP->actualizarDesasociacionFactura();
            
            $con->commit();
            
            $a_Rs['error']    = false;
            $a_Rs['mensaje_error'] = "";
        }
        catch ( Exception $o_Exception )
        {
            $con->rollback();
            $a_Rs['error']        = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }
        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }
    
    public function executeView()
    {
        $s_Print    = $this->getRequestParameter( 'print' );
        $s_IdConcat = $this->getRequestParameter( 'IdConcat' );
        $this->s_IdConcat = $s_IdConcat;
        
        $this->b_Imprimir = false;
        if( $s_Print )
        {
            $this->b_Imprimir = true;
        }
        
        $a_IdConcat = explode( "_", $s_IdConcat );
        
        $i_IdCompania    = ( int ) $a_IdConcat[0];
        $i_IdSucursal    = ( int ) $a_IdConcat[1];
        $s_IdAlmacen     = $a_IdConcat[2];
        $i_IdOrdenCompra = ( int ) $a_IdConcat[3];
        $i_IdPersona     = ( int ) $a_IdConcat[4];
        $s_SerieGuia     = $a_IdConcat[5];
        $s_NumeroGuia    = $a_IdConcat[6];
        
        //SE BUSCA LA ASOCIACION GUIA-FACTURA
        $o_ALM_OrdenGuiaFacturaFN = new ALM_OrdenGuiaFacturaFN();
        $o_ALM_OrdenGuiaFacturaBN = $o_ALM_OrdenGuiaFacturaFN->selectByPK( $i_IdCompania, $i_IdSucursal, $s_IdAlmacen, $i_IdOrdenCompra, $i_IdPersona, $s_SerieGuia, $s_NumeroGuia );
        if( !$o_ALM_OrdenGuiaFacturaBN )
        {
            $o_ALM_OrdenGuiaFacturaBN = new ALM_OrdenGuiaFacturaBN();
        }
        $this->o_ALM_OrdenGuiaFacturaBN = $o_ALM_OrdenGuiaFacturaBN;
        //pr( $o_ALM_OrdenGuiaFacturaBN );
        
        //AHORA SE BUSCA LA CABECERA DE LA TRANSACCION
        $o_ALM_TransaccionCabeceraBN = new ALM_TransaccionCabeceraBN();
        
        $o_ALM_TransaccionCabeceraFN = new ALM_TransaccionCabeceraFN();
        $o_ALM_TransaccionCabeceraFN->setIdCompania( $i_IdCompania );
        $o_ALM_TransaccionCabeceraFN->setIdTipoDocumento( COM_OrdenCompraCabeceraBN::TIPO_DOCUMENTO );
        $o_ALM_TransaccionCabeceraFN->setIdTransaccion( COM_OrdenCompraCabeceraBN::TRANSACCION_X_DEFECTO );
        $o_ALM_TransaccionCabeceraFN->setIdAlmacen( $s_IdAlmacen );
        $o_ALM_TransaccionCabeceraFN->setIdTransaccionOperacion( COM_OrdenCompraCabeceraBN::TIPO_TRANSACCION_X_DEFECTO );
        $o_ALM_TransaccionCabeceraFN->setReferenciaTipoDocumento( COM_OrdenCompraCabeceraBN::REF_TIPO_DOCUMENTO_DEFECTO );
        $o_ALM_TransaccionCabeceraFN->setReferenciaNumeroDocumento( $i_IdOrdenCompra );
        $o_ALM_TransaccionCabeceraFN->setCodigoProveedor( $i_IdPersona );
        $o_ALM_TransaccionCabeceraFN->setTipoDocumentoFiscal( ALM_OrdenGuiaFacturaBN::TIPO_DOCUMENTO_GUIA );
        $o_ALM_TransaccionCabeceraFN->setSerieDocumentoFiscal( $s_SerieGuia );
        $o_ALM_TransaccionCabeceraFN->setNumeroDocumentoFiscal( $s_NumeroGuia );
        $a_ALM_TransaccionCabecera = $o_ALM_TransaccionCabeceraFN->select();
        if( $a_ALM_TransaccionCabecera )
        {
            $o_ALM_TransaccionCabeceraBN = $a_ALM_TransaccionCabecera[0];
            //pr( $o_ALM_TransaccionCabeceraBN );
        }
        $this->o_ALM_TransaccionCabeceraBN = $o_ALM_TransaccionCabeceraBN;
        
        //AHORA SE BUSCA LOS DETALLES DE LA TRANSACCION - MONTOS
        $this->f_SumaSubTotal = 0.00;
        $this->f_SumaIGV      = 0.00;
        $this->f_SumaTotal    = 0.00;
        
        $f_IGV       = UtilIGV::getValorIGVActual();
        
        $this->a_COM_OrdenCompraDetalle = array();
        $o_ALM_TransaccionDetalleFN = new ALM_TransaccionDetalleFN();
        $o_ALM_TransaccionDetalleFN->setIdCompania( $o_ALM_TransaccionCabeceraBN->getIdCompania() );
        $o_ALM_TransaccionDetalleFN->setIdTipoDocumento( $o_ALM_TransaccionCabeceraBN->getIdTipoDocumento() );
        $o_ALM_TransaccionDetalleFN->setIdNumeroDocumento( $o_ALM_TransaccionCabeceraBN->getIdNumeroDocumento() );
        $a_ALM_TransaccionDetalle = $o_ALM_TransaccionDetalleFN->select();
        if( $a_ALM_TransaccionDetalle )
        {
            foreach ( $a_ALM_TransaccionDetalle as $i_key => $o_ALM_TransaccionDetalleBN )
            {
                //AHORA SE BUSCA LOS MONTOS EN LAS ORDENES DE COMPRA DETALLE
                $i_IdSecuencia = $o_ALM_TransaccionDetalleBN->getReferenciaSecuencia();
                $o_COM_OrdenCompraDetalleFN = new COM_OrdenCompraDetalleFN();
                $o_COM_OrdenCompraDetalleBN = $o_COM_OrdenCompraDetalleFN->selectByPK( $i_IdOrdenCompra, $i_IdCompania, $i_IdSecuencia );
                
                $f_Cantidad = $o_ALM_TransaccionDetalleBN->getCantidad();
                $f_Precio   = $o_COM_OrdenCompraDetalleBN->getPrecioUnitarioIGV();
                
                //$f_PrecioUniConIGV   = $f_Precio * $f_IGVMasUno;
                $f_PrecioUniSinIGV   = $f_Precio;
                $f_PrecioSubTotal    = utilMath::fnround( $f_PrecioUniSinIGV * $f_Cantidad, 6 );
                $f_IGVMonto          = utilMath::fnround( $f_PrecioSubTotal * $f_IGV, 6 );
                $f_PrecioTotalFinal  = $f_PrecioSubTotal + $f_IGVMonto;
                
                $o_COM_OrdenCompraDetalleBN->setCantidadRecibida( $f_Cantidad );
                $o_COM_OrdenCompraDetalleBN->setSubTotal( $f_PrecioSubTotal );
                
                $this->a_COM_OrdenCompraDetalle[] = $o_COM_OrdenCompraDetalleBN;
                
                $this->f_SumaSubTotal = $this->f_SumaSubTotal + $o_COM_OrdenCompraDetalleBN->getSubTotal();
                $this->f_SumaIGV      = $this->f_SumaIGV + $f_IGVMonto;
                $this->f_SumaTotal    = $this->f_SumaTotal + $f_PrecioTotalFinal;
            }
        }
    }
}